<?php
class CardModelClass extends ModelClassEx {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $cards						= null;			// ユーザデータ
	private $cardHolderId				= NO_STRING;	// カードホルダーID
	private $currency					= NO_STRING;	// 通貨
	private $transferType				= NO_COUNT;		// 送金タイプ
	private $amount						= NO_COUNT;		// 入力金額
	private $debitCurrency				= NO_STRING;	// 出金通貨
	private $debitAmount				= NO_STRING;	// 出金金額
	private $rate						= NO_STRING;	// レート
	private $fee						= NO_STRING;	// 手数料
	private $toAmount					= NO_STRING;	// 送金金額
	private $date						= NO_STRING;	// 検索日付
	private $msg						= NO_STRING;	// 検索日付
	private $balance					= NO_STRING;	// 口座バランス
	private $transactionNumber			= NO_STRING;	// 取引番号
	private $code						= NO_STRING;	// カードチャージコード
	private $data						= NO_STRING;	// カードチャージデータ

	/*-------------------------------------------------------------------------
	* @function_name: コントロールパネルシステムindexモデルクラスコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		// スーパークラスコンストラクタ呼び出し
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: 初期設定関数
	* @parameter	: なし
	* @return		: 成功:success、失敗:error
	-------------------------------------------------------------------------*/
	public function init() {

		try {

			// パラメータの設定
			$this -> setParameter();

			// チェック
			$this -> validate();

		} catch (Exception $e) {
			throw $e;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: パラメータの設定
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function setParameter() {
		$this -> cardHolderId	= $this -> getDataPost(PARAM_CARD_HOLDER_ID, true);	// カードホルダーID
		$this -> transferType	= $this -> getDataPost(PARAM_TRANSFER_TYPE, true);	// 送金タイプ
		$this -> amount			= $this -> getDataPost(PARAM_AMOUNT, true);			// 入力金額
		$this -> debitCurrency	= $this -> getDataPost(PARAM_DEBIT_CURRENCY, true);	// 出金通貨
		$this -> debitAmount	= $this -> getDataPost(PARAM_DEBIT_AMOUNT, true);		// 出金金額
		$this -> toAmount		= $this -> getDataPost(PARAM_TO_AMOUNT, true);		// 送金金額
		$this -> setFeeEx($this -> getDataPost(PARAM_FEE), true);						// 手数料
		$this -> setRateEx($this -> getDataPost(PARAM_RATE), true);					// レート
		$this -> date			= $this -> getDataPost(PARAM_DATE, true);				// 検索日付
		$this -> currency		= VAR_CARD_CURRENCY;							// カード入金通貨

		// 顧客の所持カード情報
		$this -> setCards($this -> getCardsCommon($this -> getUserData(PARAM_USER_ACCOUNT)));
	}

	/*-------------------------------------------------------------------------
	* @function_name: パラメータの再設定
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	public function restore() {}

	/*-------------------------------------------------------------------------
	* @function_name: パラメータを設定し直す
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	public function setData() {

		// 変数宣言部
		$exchange	= null;
		$fee		= null;

		// バランスの取得
		$this -> balance = $this -> getBalanceCommon($this -> getUserData(PARAM_USER_ACCOUNT), $this -> debitCurrency);

		// 手数料の取得
		$fee		= $this -> getFeeCommon(VAR_CARD_DEPOSIT
											, $this -> amount
											, $this -> debitCurrency
											, $this -> getUserData(PARAM_USER_ACCOUNT));
		$this -> setFeeEx($this -> getColumnData($fee, USD . VAL_INT_1));

		// タイプによって変更パラメータ
		if($this -> debitCurrency == USD) {				// 通貨が一緒だった場合
			$this -> debitAmount	= $this -> amount;
			$this -> toAmount		= $this -> amount;
			$this -> setRateEx(VAL_INT_1);

		} else if($this -> transferType == NO_COUNT) {	// 出金額指定

			// 出金額の両替

			$exchange	= $this -> getExchangeCommon($this -> amount
													, $this -> debitCurrency
													, USD);

			// 手数料の両替
			$fee		= $this -> getExchangeCommon($this -> getFeeEx()
													, USD
													, $this -> debitCurrency
													, false
													, true);

			$this -> debitAmount	= $this -> amount;
			$this -> toAmount		= $this -> getColumnData($exchange, PARAM_AMOUNT);
			$this -> setRateEx($this -> getColumnData($exchange, PARAM_RATE));
			$this -> setFeeEx($this -> getColumnData($fee, PARAM_AMOUNT));

		} else {										// 送金通貨指定

			// 出金額の両替
			$exchange = $this -> getExchangeCommon($this -> amount
													, USD
													, $this -> debitCurrency
													, false
													, true);

			// 手数料の両替
			$fee		= $this -> getExchangeCommon($this -> getFeeEx()
													, USD
													, $this -> debitCurrency
													, false
													, true);


			$this -> debitAmount	= $this -> getColumnData($exchange, PARAM_AMOUNT);
			$this -> toAmount		= $this -> amount;
			$this -> setRateEx($this -> getColumnData($exchange, PARAM_RATE));
			$this -> setFeeEx($this -> getColumnData($fee, PARAM_AMOUNT));
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: サーバ側データチェック
	* @parameter	: なし
	* @return		: TRUE:成功、FALSE:失敗
	-------------------------------------------------------------------------*/
	public function validate() {

		// 変数宣言部
		$rtn = true;

		// ログインチェック
		if(!$this -> checkSiteUserLogin()) {
			throw new Exception(NO_STRING);
		}

		// 口座ステータスチェック
		if(!$this -> checkAccountStatus($this -> getUserData(PARAM_USER_ACCOUNT), VAR_TRANSACTION_WITHDRAW)) {
			throw new Exception(VAL_INT_99);
		}

		// カード所持確認
		if(!$this -> isLoopData($this -> cards)) {
			$this -> popMessageCommon(ERROR, 'E_DONT_HOLD_CARD', array());
			$this -> setType(TYPE_FAIL);
			return;
		}

		// 確認タイプの場合
		if($this -> getType()		== TYPE_CONFIRM
			|| $this -> getType()	== TYPE_COMPLETE) {

			// 制限口座のチェック(出金確認時)
			if(!$this -> checkWithdrawLimit($this -> getUserData(PARAM_USER_ACCOUNT)
											, $this -> debitCurrency
											, $this -> currencyToInt(floatval($this -> amount), $this -> debitCurrency))) {
				$this -> popUpSessionMessage(ERROR, 'E_LIMIT_WITHDRAW', array());
				$this -> setType(TYPE_BACK);
				return;
			}

			// 金額のチェック
			if(!$this -> checkNull($this -> amount)) {
				$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_AMOUNT));
				$rtn = false;
			}

			// 必須項目
			// debit口座のチェック
			if(!$this -> checkNull($this -> debitCurrency)) {
				$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_DEBIT_ACCOUNT));
				$rtn = false;
			}

			// 金額の正規表現チェック
			if(!$this -> checkStringNumber($this -> amount)) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_REGULAR_NUMBER', array(VAL_STR_AMOUNT));
				$rtn = false;
			}

			// タイプを戻す
			if(!$rtn) {

				if($this -> getType()			== TYPE_CONFIRM) {
					$this -> setType(TYPE_INPUT);
				} else if($this -> getType()	== TYPE_COMPLETE) {
					$this -> setType(TYPE_CONFIRM);
				}

				return;
			}

			// チェックが通ったら各種項目を設定する
			$this -> setData();

			// 金額リミットチェック
			if(!$this -> checkRange($this -> toAmount, VAL_INT_1, (VAL_INT_500 * 10))) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_AMOUNT', array(VAL_STR_AMOUNT));
				$rtn = false;
			}

			// 口座残高チェック
			if($this -> balance < ($this -> debitAmount + $this -> getFeeEx())) {
				$this -> popUpSessionMessage(ERROR, 'E_INSUFFICIENT_FUNDS', array($this -> debitCurrency, $this -> formatCurrency(($this -> debitAmount + $this -> getFeeEx()), $this -> debitCurrency)));
				$rtn = false;
			}

			// タイプを戻す
			if(!$rtn) {

				if($this -> getType()			== TYPE_CONFIRM) {
					$this -> setType(TYPE_INPUT);
				} else if($this -> getType()	== TYPE_COMPLETE) {
					$this -> setType(TYPE_CONFIRM);
				}

				return;
			}
		} else if($this -> getType() == TYPE_INPUT) {

			// 制限口座のチェック
			if(!$this -> checkWithdrawLimit($this -> getUserData(PARAM_USER_ACCOUNT))) {
				$this -> popUpSessionMessage(ERROR, 'E_LIMIT_WITHDRAW', array());
				$this -> setType(NO_STRING);
				return;
			}
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座番号の取得
	* @parameter	: なし
	* @return		: 口座番号
	-------------------------------------------------------------------------*/
	function echoUserAccount() {
		echo $this -> getUserData(PARAM_USER_ACCOUNT);
	}

	/*-------------------------------------------------------------------------
	* @function_name: カードホルダーIDの取得
	* @parameter	: なし
	* @return		: カードホルダーID
	-------------------------------------------------------------------------*/
	function getCardHolderId() {
		return $this -> cardHolderId;
	}

	/*-------------------------------------------------------------------------
	* @function_name: カードホルダーIDの取得
	* @parameter	: なし
	* @return		: カードホルダーID
	-------------------------------------------------------------------------*/
	function echoCardHolderId() {
		echo $this -> cardHolderId;
	}

	/*-------------------------------------------------------------------------
	* @function_name: カード番号の取得
	* @parameter	: なし
	* @return		: カード番号
	-------------------------------------------------------------------------*/
	function echoCardNumber() {
		echo $this -> getCardNumberCommon($this -> cardHolderId);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 出金通貨の取得
	* @parameter	: なし
	* @return		: 出金通貨
	-------------------------------------------------------------------------*/
	function echoDebitCurrency() {
		echo $this -> debitCurrency;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 出金通貨の取得
	* @parameter	: なし
	* @return		: 出金通貨
	-------------------------------------------------------------------------*/
	function getDebitCurrency() {
		return $this -> debitCurrency;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 出金金額の取得
	* @parameter	: なし
	* @return		: 出金金額
	-------------------------------------------------------------------------*/
	function getDebitAmount() {
		return $this -> debitAmount;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 出金金額の取得
	* @parameter	: なし
	* @return		: 出金金額
	-------------------------------------------------------------------------*/
	function echoDebitAmount() {
		echo $this -> debitAmount;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 出金金額の取得
	* @parameter	: なし
	* @return		: 出金金額
	-------------------------------------------------------------------------*/
	function dispDebitAmount() {
		echo $this -> formatCurrency($this -> debitAmount, $this -> debitCurrency);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 換金レートの取得
	* @parameter	: なし
	* @return		: 換金レート
	-------------------------------------------------------------------------*/
	function echoRate() {
		echo $this -> getRateEx();
	}

	/*-------------------------------------------------------------------------
	* @function_name: 手数料金額の取得
	* @parameter	: なし
	* @return		: 手数料金額
	-------------------------------------------------------------------------*/
	function echoFeeAmount() {
		echo $this -> getFeeEx();
	}

	/*-------------------------------------------------------------------------
	* @function_name: 手数料金額の取得
	* @parameter	: なし
	* @return		: 手数料金額
	-------------------------------------------------------------------------*/
	function dispFeeAmount() {
		echo $this -> formatCurrency($this -> getFeeEx(), $this -> debitCurrency);
	}

	/*-------------------------------------------------------------------------
	* @function_name: デポジット額の取得
	* @parameter	: なし
	* @return		: デポジット額
	-------------------------------------------------------------------------*/
	function getToAmount() {
		return $this -> toAmount;
	}

	/*-------------------------------------------------------------------------
	* @function_name: デポジット額の取得
	* @parameter	: なし
	* @return		: デポジット額
	-------------------------------------------------------------------------*/
	function echoToAmount() {
		echo $this -> toAmount;
	}

	/*-------------------------------------------------------------------------
	* @function_name: デポジット額の取得
	* @parameter	: なし
	* @return		: デポジット額
	-------------------------------------------------------------------------*/
	function dispToAmount() {
		echo $this -> formatCurrency($this -> toAmount, USD);
	}

	/*-------------------------------------------------------------------------
	* @function_name: ユーザの入力額の取得
	* @parameter	: なし
	* @return		: ユーザの入力額
	-------------------------------------------------------------------------*/
	function echoAmount() {
		echo $this -> amount;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 完了メッセージの取得
	* @parameter	: なし
	* @return		: 完了メッセージ
	-------------------------------------------------------------------------*/
	function echoMsg() {
		echo $this -> msg;
	}

	/*-------------------------------------------------------------------------
	* @function_name: カード返却コードの設定
	* @parameter	: カード返却コード
	* @return		: なし
	-------------------------------------------------------------------------*/
	function setCode($code) {
		$this -> code = $code;
	}

	/*-------------------------------------------------------------------------
	* @function_name: カードチャージデータの設定
	* @parameter	: カードチャージデータ
	* @return		: なし
	-------------------------------------------------------------------------*/
	function setReturnData($data) {
		$this -> data = $data;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 所持カード一覧の取得
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	public function dispCards() {

		// 変数宣言部
		$rtn 	= NO_STRING;
		$lists	= array();

		// データを入れ替える
		if($this -> isLoopData($this -> cards)) {

			foreach($this -> cards as $row) {

				$cardDigit	=  $this -> getColumnData($row, COLUMN_CARD_NUMBER);
				$len 		= strlen($cardDigit);

				if($len > VAL_INT_4) {
					$cardDigit = substr($cardDigit, ($len - VAL_INT_4));
				}

				$lists[] = array(PARAM_DATA_KEY		=>  $this -> getColumnData($row, COLUMN_CARD_HOLDER_ID)
								, PARAM_DATA_VALUE	=>  '**** **** **** ' . $cardDigit);
			}
		} else {
			$lists[] = array(PARAM_DATA_KEY		=>  NO_STRING
							, PARAM_DATA_VALUE	=>  $this -> getMessage(INFO, 'I_NO_SUCHE_SEARCH_CARD_DATA', array()));
		}

		$rtn = $this -> dispListOption($lists, $this -> cardHolderId);

		echo $rtn;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: カードの有効期限の取得
	 * @parameter	: なし
	 * @return		: カードの有効期限
	 -------------------------------------------------------------------------*/
	public function echoExpireDate() {}

	/*-------------------------------------------------------------------------
	* @function_name: 検索月の取得
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	public function dispSearchDate() {

		// 変数宣言部
		$rtn			= NO_STRING;
		$cnt			= NO_COUNT;
		$currentDate	= NO_STRING;
		$lists			= array();

		// 月数のループ（とりあえず1年）
		for($cnt = NO_COUNT; $cnt < VAL_INT_12; $cnt++) {

			$date = date('Y-m', strtotime('-' . $cnt  . ' month'));

			$lists[] = array(PARAM_DATA_KEY			=> date('Y-m', strtotime('-' . $cnt  . ' month'))
								, PARAM_DATA_VALUE	=> date('Y-m', strtotime('-' . $cnt  . ' month')));
		}

		echo $this -> dispListOption($lists, $this -> date);
	}

	/*-------------------------------------------------------------------------
	* @function_name: ステートメントの取得
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function dispStatementList() {

		// 変数宣言部
		$rtn	= NO_STRING;
		$from	= $this -> date . '-01';
		$to		= date('Y-m-d', strtotime(date('Y-m-d', strtotime($from . ' + 1 month')) . ' - 1 days'));
		$status	= NO_STRING;
		$datas	= array();

		///////// 表示用 /////////
		$discription 	= NO_STRING;
		$location	 	= NO_STRING;
		$country	 	= NO_STRING;
		$amount		 	= NO_STRING;
		$fee		 	= NO_STRING;
		$source		 	= NO_STRING;
		$description	= NO_STRING;

		// カードステートメントデータの取得
		$params = array(PARAM_CARD_HOLDER_ID	=> $this -> cardHolderId
						, PARAM_FROM			=> $from
						, PARAM_TO				=> $to);

		$options = array('http'		=> array('method' => 'POST'
											, 'header'  => implode("\r\n", array('Content-Type: application/x-www-form-urlencoded'))
											, 'content'	=> http_build_query($params)));

		$data	= file_get_contents('https://'.SITE_DOMAIN.'/api/GetPlatinumCardHistory'
									, false
									, stream_context_create($options));

		$rs		= json_decode($data, true);
		$rs		= $this -> getColumnData($rs, PARAM_RESULT);

		if($this -> isLoopData($rs)) {

			$datas = $rs;
			foreach($datas as $row) {

				// 「source」が返却されている場合は、「source」を表示
				if($this -> getColumnData($row, 'source') != NO_STRING) {
					$source = $this -> getColumnData($row, 'source');
				} else {
					$source = $this -> getColumnData($row, 'txnType');
				}

				//  [description] => Value Load （または [txnType] => Load ）の時は、「merchantName」を表示しない
				if($this -> getColumnData($row, 'source')		== 'Value Load'
					|| $this -> getColumnData($row, 'txnType')	== 'Load') {
					$description = NO_STRING;
				} else {
					$description = $this -> getColumnData($row, 'merchantName');
				}

				$rtn .=	'<tr>'
						. '<td>' . $this -> getColumnData($row, 'tranDate') . '</td>'
						. '<td>' . $this -> getColumnData($row, 'transactionId') . '</td>'
						. '<td class="l">'	. $source . '</td>'
						. '<td class="l">' . $description . '</td>'
						. '<td class="r">' . USD . DELIMIT_SPACE . $this -> intToCurrency($this -> getColumnData($row, 'authAmt'), USD) . '</td>'
						. '<td>' . $this -> getColumnData($row, 'status') . '</td>'
						. '</tr>';
			}

		} else {
			$rtn =	'<tr>'
					. '<td colspan="6">' . $this -> getMessage(INFO, 'I_NO_SUCHE_SEARCH_DATA', array()) . '</td>'
					. '</tr>';
		}

		echo $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 通貨リストの取得
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispCurrency() {
		echo $this -> dispListOption($this -> getCurrencyList(), $this -> debitCurrency) ;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 送金種別の取得
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function getTransferType() {
		return $this -> transferType;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 送金種別の取得
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function echoTransferType() {
		echo $this -> transferType;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 送金種別の取得
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispTransferType() {

		// 変数宣言部
		$rtn = NO_STRING;

		$rtn .= '<label>'
				. $this -> makeRadioOne(PARAM_TRANSFER_TYPE . NO_COUNT
										, PARAM_TRANSFER_TYPE
										, NO_COUNT
										, $this -> transferType)
				. ' ' . VAL_STR_DEBIT_CURRENCY . '</label>&emsp;';

		$rtn .= '<label>'
				. $this -> makeRadioOne(PARAM_TRANSFER_TYPE . VAL_INT_1
										, PARAM_TRANSFER_TYPE
										, VAL_INT_1
										, $this -> transferType)
				. ' USD</label>';

		echo $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 交易号の取得
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function getTransactionNumber() {
		return $this -> transactionNumber;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 通貨のの設定
	* @parameter	: 結果セット
	* @return		: なし
	-------------------------------------------------------------------------*/
	function setCards($rs) {
		$this -> cards = $rs;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 通貨のの設定
	* @parameter	: 結果セット
	* @return		: なし
	-------------------------------------------------------------------------*/
	function setMsg($msg) {
		$this -> msg = $msg;
	}


	/*-------------------------------------------------------------------------
	* @function_name: HTML表示用のデータ取得関数
	* @parameter	: なし
	* @return		: HTML表示用データ配列
	-------------------------------------------------------------------------*/
	public function dispHTML() {
		return array();
	}

	/*-------------------------------------------------------------------------
	* @function_name: 登録用のデータ取得関数
	* @parameter	: なし
	* @return		: 登録用データ配列
	-------------------------------------------------------------------------*/
	public function getRegistData() {

		// 変数宣言部
		$rtn = array();

		// 変数宣言部
		$rtn = array();

		$this -> transactionNumber = $this -> getTransactionNumberCommon(VAR_TRANSACTION_WITHDRAW);

		$rtn[] = $this -> getUserData(PARAM_USER_ACCOUNT);								// 口座番号
		$rtn[] = USD;																	// 通貨
		$rtn[] = $this -> currencyToInt($this -> toAmount, USD);						// 金額
		$rtn[] = USD;																	// 通貨
		$rtn[] = $this -> cardHolderId;													// CHID
		$rtn[] = $this -> getUserData(PARAM_USER_ACCOUNT);								// 口座名義
		$rtn[] = $this -> debitCurrency;												// 引落口座通貨
		$rtn[] = $this -> currencyToInt($this -> debitAmount, $this -> debitCurrency);	// 引落口座金額
		$rtn[] = floatval($this -> getRateEx());										// レート
		$rtn[] = $this -> currencyToInt($this -> getFeeEx(), $this -> debitCurrency);	// 手数料
		$rtn[] = $this -> transactionNumber;											// 取引番号
		$rtn[] = VAL_INT_3;																// ステータス（3：不備確認中）
		$rtn[] = VAL_INT_3;																// タイプ（3：カード入金）
		$rtn[] = 'Card Loading';														// 送金先銀行
		$rtn[] = $this -> code;															// カードチャージコード
		$rtn[] = $this -> data;															// 備考

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: メール送信用のデータを取得
	* @parameter	: なし
	* @return		: メール送信用データ
	-------------------------------------------------------------------------*/
	public function getSendData() {

		// 変数宣言部
		$rtn	= array();
		$data	= $this -> getAccountCommon($this -> getUserData(PARAM_USER_ACCOUNT));
		$row	= $this -> getRowData($data);

		$rtn[] = $this -> getUserData(PARAM_USER_ACCOUNT);								// ユーザ口座番号
		$rtn[] = $this -> getColumnData($row, COLUMN_FIRST_NAME)
				. DELIMIT_SPACE . $this -> getColumnData($row, COLUMN_LAST_NAME);		// ユーザ名
		$rtn[] = $this -> getCurrentTimeCommon();										// 現在時刻
		$rtn[] = $this -> currency;														// 通貨
		$rtn[] = $this -> formatCurrency($this -> toAmount, $this -> currency);			// 金額
		$rtn[] = $this -> getColumnData($row, COLUMN_MAIL);								// メールアドレス
		$rtn[] = $this -> debitCurrency;												// 引落口座通貨
		$rtn[] = $this -> formatCurrency($this -> debitAmount, $this -> debitCurrency);	// 引落口座金額
		$rtn[] = $this -> formatCurrency($this -> getFeeEx(), $this -> debitCurrency);	// 手数料
		$rtn[] = $this -> transactionNumber;											// 取引番号

		return $rtn;
	}
}
?>