<?php
$page_title = "Card Information Entry";
include_once('site_config.php');
include_once('template/base_site_head.php');
?>
	<!-- メインエリア -->
	<div id="main" class="container">
		<ol class="breadcrumb">
			<li><a href="<?php echo $home_url; ?>">Home</a></li>
			<li class="active"><?php echo $page_title; ?></li>
		</ol>
		<div class="progress">
			<div class="progress-bar progress-bar-striped active w80p" role="progressbar" aria-valuenow="20" aria-valuemin="0" aria-valuemax="100"><span class="visible-xs">STEP1</span><span class="hidden-xs">Card Information Entry</span></div>
		</div>
		<h2><?php echo $page_title; ?></h2>
		<form id="acForm" action="" method="post" class="pleft40">
			<?php $this -> dispMessagesCommon(); ?>
			<table class="table ml00 col bdr default odd w50p fontM mb25 mt25 ma90sp">
				<colgroup>
					<col class="w35p">
					<col class="w65p">
				</colgroup>
				<tbody>
					<tr>
						<th>Date of Birth</th>
						<td>
							<select name="year" class="select">
								<?php $this -> dispYear(); ?>
							</select>
							<span class="spcr-br">Year</span>
							<select name="month" class="select">
								<?php $this -> dispMonth(); ?>
							</select>
							<span class="spcr-br">Month</span>
							<select name="day" class="select">
								<?php $this -> dispDay(); ?>
							</select>
							<span>Date</span>
						</td>
					</tr>
					<tr>
						<th>Card Number</th>
						<td><input type="text" id="card_number" name="card_number" value="<?php $this -> echoCardNumber(); ?>" /></td>
					</tr>
				</tbody>
			</table>
			<p class="red font12 mb20">
				Notes<br/>
				※Please keep your PIN safe and never let anyone else know it.<br/>
				※Please note that your card will be locked if you enter an incorrect PIN code three times in a row.
			</p>
			<p class="mb40 mt40 w50pButton"><input type="button" id="btnConfirm" value="Please enter the information to get your PIN." class="btn bg-grad px350"></p>
			<input type="hidden" id="type" name="type" value="" />
		</form>
	</div>
	<script src="../js/card_pin.js"></script>
     <!-- /メインエリア -->
<?php
	include_once('template/base_site_foot.php');
	echo $endscripts;
?>
</body>
</html>