<?php
require_once(SYSTEM_LOGICS . 'agent/model.php');

class LogicAgent extends AgentModelClass {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $htmlStr = NO_STRING;	// 表示用HTML文字列

	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: ロジック（各クラス共通）
	* @parameter	: なし
	* @return		: TRUE:ロジック成功、FALSE:ロジック失敗
	-------------------------------------------------------------------------*/
	function logic() {

		try {

			// 初期データ処理
			if($this -> init()) {

				if($this -> getType() == TYPE_COMPLETE) {				// エージェントの登録
					$this -> insertActivity();
					$this -> regist();
					$this -> lists();
				} else if($this -> getType() == TYPE_INPUT
							|| $this -> getType() == TYPE_CONFIRM) {	// 入力・確認

					// データの再表示
					$this -> selectAccount();

				} else if($this -> getType() == TYPE_DETAIL) {			// 詳細の取得
					$this -> select();
					$this -> listChildren();

				} else if($this -> getType() == TYPE_COMMISSION) {		// コミッションの取得

					$this -> selectCommision();

				} else if($this -> getType() == TYPE_UPDATE) {			// コミッションの更新

					$this -> remove();
					$this -> update();
					$this -> selectCommision();

				} else if($this -> getType() == TYPE_SAVE) {			// 詳細情報の保存
					$this -> insertActivity();
					// データの保存
					$this -> save();
					// データの再表示
					$this -> select();
					$this -> listChildren();
				} else {
					$this -> lists();
				}

			} else {	// チェック失敗

				if($this -> getType() == TYPE_SAVE) {	// 詳細情報チェック失敗時
					$this -> defaultCommision();
				}
			}

		} catch (Exception $e) {
			throw $e;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: エージェントリストの取得
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function lists() {

		// エージェントデータ
		$this -> setResult($this -> accessSelect('LIST_AGENT', array($this -> getWhere())));
	}

	/*-------------------------------------------------------------------------
	* @function_name: 子エージェントリストの取得
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function listChildren() {
		$this -> setChirdren($this -> accessSelect('LIST_AGENT_CHILDREN', array($this -> getAgentCode(), $this -> getDId())));
	}

	/*-------------------------------------------------------------------------
	* @function_name: エージェントの取得
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function select() {

		// エージェントデータ
		$this -> setAgent($this -> accessSelect('SELECT_AGENT', array($this -> getDId())));

		$this -> restoreAgent();

		/**
		 *
		 * 2019/04/11
		 * anton
		 */
		$qkey = ($this -> lang == "en" ? 'LIST_AGENT_COMMISION_EN' : 'LIST_AGENT_COMMISION');
		
		// コミッションデータ
		$this -> setCommision($this -> accessSelect($qkey, array($this -> getAgentCode(), $this -> getParent())));

		// 為替手数料パターンの取得
		$this -> listPatterns();
	}

	/*-------------------------------------------------------------------------
	* @function_name: パターンリストの取得
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function listPatterns() {
		$this -> setPatterns($this -> accessSelect('LIST_EXCHANGE_FEE_PATTERNS', array(VAL_STR_DEFAULT_EXCHANGE_SETTING)));
	}

	/*-------------------------------------------------------------------------
	* @function_name: コミッションの取得
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function selectCommision() {

		// エージェントデータ
		$this -> setResult($this -> accessSelect('SELECT_AGENT_COMMISION_BY_AGENT_CODE', $this -> getSelectData()));

		// カードコミッションデータ
		$this -> setCardCommissions($this -> accessSelect('SELECT_AGENT_CARD_COMMISION', array($this -> getAgentCode()
																								, $this -> getYear()
																								, $this -> getMonth())));
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座情報の取得
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function selectAccount() {

		// データの設定
		$this -> setAccount($this -> getAccountCommon($this -> getUserAccount()));

		$this -> restoreAccount();
	}

	/*-------------------------------------------------------------------------
	 * @function_name: エージェントの取得
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function defaultCommision() {

		$this -> setCommision($this -> getCommisionDataCommon($this -> getParent()));

		$this -> restoreCommision();
	}

	/*-------------------------------------------------------------------------
	* @function_name: エージェントの登録
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function regist() {

		// 口座番号の作成
// 		$account	= $this -> createAccount();

		// UIDの作成
// 		$uId		= $this -> createUId();

		// エージェントコードの作成
		$agentCode	= $this -> createAgentCode();

		// 変数宣言部
		$params = array();

		// パラメータの設定
		$params[] = $this -> getUserAccount();		// 口座番号
// 		$params[] = $this -> getEMail();			// ログインID
		$params[] = $this -> createAgentCode();		// エージェントコード
		$params[] 	= $this -> getParent();			// 親エージェントコード
		$params[] 	= VAL_INT_1;					// エージェントフラグ
		
		// ログインデータの登録
// 		$this -> accessModify('INSERT_LOGIN', $params);

		// パラメータの設定
// 		$params		= array();
// 		$params[]	= $uId;							// UID
// 		$params[] 	= $this -> getEMail();			// メルアド
// 		$params[] 	= $this -> getAccountType();	// 口座種別
// 		$params[] 	= $account;						// 口座番号
// 		$params[] 	= $this -> getTel();			// 電話番号
// 		$params[] 	= $this -> getLastName();		// 姓
// 		$params[] 	= $this -> getFirstName();		// 名
// 		$params[] 	= $this -> getBirthYear();		// 生年月日（年）
// 		$params[] 	= $this -> getBirthMonth();		// 生年月日（月）
// 		$params[] 	= $this -> getBirthDay();		// 生年月日（日）
// 		$params[] 	= $this -> getCountry();		// 国
// 		$params[] 	= $this -> getState();			// 都道府県
// 		$params[] 	= $this -> getCity();			// 市
// 		$params[] 	= $this -> getZipCode();		// 郵便番号
// 		$params[] 	= $this -> getAddress1();		// 番地
// 		$params[] 	= $this -> getAddress2();		// 番地2
// 		$params[] 	= $agentCode;					// エージェントコード
//
// 		$params[] 	= $this -> getParent();			// 親エージェントコード

// 		$params[] 	= NO_STRING;					// 登録時IP（ダミー）
// 		$params[] 	= NO_COUNT;						// ステータス（ダミー）
// 		$params[] 	= NO_STRING;					// CRM ID（ダミー）

		// ログインデータの登録
		$this -> accessModify('UPDATE_AGENT_USER', $params);
		$StatusArr  = $this -> accessSelect('SELECT_USER_STATUS', array($this -> getUserAccount()));
		$userStatus = $this -> getColumnData($this -> getColumnData($StatusArr,0),'status');
		if($userStatus != 3){
			// 強制アクティベート
			$params		= array();
			$params[] 	= $this -> getUserAccount();
			$params[] 	= VAR_USER_ACTIVE;
			$this -> accessModify('UPDATE_USER_STATUS', $params);
		}

		$this -> popUpSessionMessage(INFO, 'I_COMPLATE_REGIST', array());
	}

	/*-------------------------------------------------------------------------
	* @function_name: エージェントの更新
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function save() {

		// 変数宣言部
		$defaultCommision	= array();
		$mFId				= NO_STRING;
		$type				= NO_STRING;
		$exchangeFee		= null;

		// エージェントデータの更新
		$this -> accessModify('UPDATE_AGENT', $this -> getUpdateDatas());

		// まずは削除
		$this -> accessModify('DELETE_AGENT_COMMISION', array($this -> getAgentCode()));

		$defaultCommision = $this -> getDefaultCommisionData();

		// コミッションデータの存在確認
		if($this -> isLoopData($defaultCommision)) {

			// デフォルト分だけループを回す
			foreach($defaultCommision as $row) {

				$mFId = $this -> getColumnData($row, COLUMN_M_F_ID);
				$type = $this -> getColumnData($row, COLUMN_WALLET_TYPE);

				// 登録
				$this -> accessModify('INSERT_AGENT_COMMISION', $this -> getRegistAgentCommisionDatas($mFId, $type), false);
			}
		}

		// 為替手数料のデータを設定
		$exchangeFee = $this -> getExchangeFeeCommon($this -> getExchangeFeeId());

		// データの存在確認
		if($this -> isLoopData($exchangeFee)) {

			// 為替手数料データの削除
			$this -> accessModify('DELETE_COMMISION_EXCHANGE', array($this -> getAgentCode()), false);

			// 各通貨のレートを設定する
			foreach($exchangeFee as $key => $val) {

				// From通貨
				$from = $key;

				foreach($val as $keySub => $valSub){

					// From通貨
					$to = $keySub;


					// 為替手数料データの登録
					$this -> accessModify('INSERT_COMMISION_EXCHANGE', $this -> getRegistExchangeCommisionDatas($from, $to), false);
				}
			}
		}

		$this -> popUpSessionMessage(INFO, 'I_COMPLATE_REGIST', array());
	}

	/*-------------------------------------------------------------------------
	* @function_name: カードコミッションの更新
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function update() {
		$this -> accessModify('INSERT_COMMISSION_CARD', $this -> getRegistCardCommissionDatas(), false);
	}

	/*-------------------------------------------------------------------------
	* @function_name: カードコミッションの更新
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function remove() {
		$this -> accessModify('DELETE_COMMISSION_CARD', array($this -> getAgentCode()
																, $this -> getYear()
																, $this -> getMonth()), false);
	}

	/*-------------------------------------------------------------------------
	* @function_name: insertActivity
	* @parameter	:
	* @return		: 
	-------------------------------------------------------------------------*/
	function insertActivity(){
		$this -> accessModify('INSERT_ACTIVITY', $this -> getActivity(), false);
	}
}
?>