<?php
require_once(SYSTEM_LOGICS . 'deposit/logic.php');

class ControlDeposit extends LogicDeposit {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/

	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: コントロールパネルシステム動画データ編集ロジック（各クラス共通）
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function action() {

		try {

			// アクション実行
			$this -> logic();

			if($this -> getType() == TYPE_IMPORT) {				// CSVインポート
				require_once($this -> getSystemHTML('TEMPLATE_DEPOSIT_IMPORT_INPUT_PATH', $this -> dispHTML()));

			} else if($this -> getType() == TYPE_CONFIRM) {		// CSVデータの確認
				require_once($this -> getSystemHTML('TEMPLATE_DEPOSIT_IMPORT_CONFIRM_PATH', $this -> dispHTML()));

			} else if($this -> getType() == TYPE_DETAIL) {		// データの詳細表示
				require_once($this -> getSystemHTML('TEMPLATE_DEPOSIT_DETAIL_PATH', $this -> dispHTML()));

			} else if($this -> getType() == TYPE_EXPORT) {		// ファイルダウンロード
				header('Content-Type: application/octet-stream');
				header('Content-Disposition: attachment; filename=' . $this -> getOldFilename());
				header('Content-Transfer-Encoding: binary');
				readfile(SYSTEM_DOCUMENT_DOPOSIT . $this -> getNewFilename() . '.csv');
			} else if($this -> getType() == TYPE_EXPORT_ERROR) {		// ファイルダウンロード（エラー）
				header('Content-Type: application/octet-stream');
				header('Content-Disposition: attachment; filename=' . $this -> getOldFilename());
				header('Content-Transfer-Encoding: binary');
				readfile(SYSTEM_DOCUMENT_DOPOSIT_ERROR . $this -> getNewFilename() . '_err.csv');
			} else if($this -> getType() == TYPE_UPDATE) {		// データの詳細表示
				require_once($this -> getSystemHTML('TEMPLATE_DEPOSIT_DETAIL_PATH', $this -> dispHTML()));

			} else {											// 画面の表示（一覧）
				require_once($this -> getSystemHTML('TEMPLATE_DEPOSIT_LIST_PATH', $this -> dispHTML()));
			}

		} catch (Exception $e) {
			header('Location: /');
		}
	}
}
?>