<?php
require_once(SYSTEM_LOGICS . 'account_list/logic.php');

class ControlAccountList extends LogicAccountList {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/

	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: コントロールパネルシステム動画データ編集ロジック（各クラス共通）
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function action() {

		try {

			// アクション実行
			$this -> logic();

			if($this -> getType() == TYPE_EXPORT) {				// エクスポート

				header('Content-Type: application/octet-stream');
				header('Content-Disposition: attachment; filename=' . $this -> getFail() . '_fail.csv');
				header('Content-Transfer-Encoding: binary');

				// 対象ファイルを出力する。
				readfile(SYSTEM_DOCUMENT_ACCOUNT . $this -> getFail() . '_fail.csv');

			} else if($this -> getType() == TYPE_EXPORT_COMMON) {	// 共通エクスポート

				header('Content-Type: application/octet-stream');
				header('Content-Disposition: attachment; filename=Account_List_' . date('YmdHis') . '.csv');
				header('Content-Transfer-Encoding: binary');
				echo "\xEF\xBB\xBF";
				echo $this -> getExportDataCommon();

			} else if($this -> getType() == TYPE_EDIT) {		// エクスポート
				require_once($this -> getSystemHTML('TEMPLATE_ACCOUNT_EDIT_PATH', $this -> dispHTML()));

			} else if($this -> getType() == TYPE_IMPORT) {		// インポート
				require_once($this -> getSystemHTML('TEMPLATE_ACCOUNT_IMPORT_PATH', $this -> dispHTML()));

			} else if($this -> getType() == TYPE_UPLOAD) {		// インポート（確認画面）
				require_once($this -> getSystemHTML('TEMPLATE_ACCOUNT_IMPORT_CONFIRM_PATH', $this -> dispHTML()));

			} else if($this -> getType() == TYPE_COMPLETE) {	// インポート（完了画面）
				require_once($this -> getSystemHTML('TEMPLATE_ACCOUNT_IMPORT_COMPLETE_PATH', $this -> dispHTML()));

			} else {											// 画面の表示（ユーザ一覧）
				require_once($this -> getSystemHTML('TEMPLATE_ACCOUNT_LIST_PATH', $this -> dispHTML()));
			}

		} catch (Exception $e) {
			header('Location: /');
		}
	}
}
?>