<?php
require_once(SITE_LOGICS . 'card_pin/logic.php');

class ControlCardPin extends LogicCardPin {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/

	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: コントロールパネルシステム動画データ編集ロジック（各クラス共通）
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function action() {

		// 変数宣言部
		$result = NO_STRING;

		try {

			// アクション実行
			$result = $this -> logic();

			// 画面の表示
			if($this -> getType() == TYPE_INPUT) {			// PIN情報入力画面
				require_once($this -> getUserHTML('TEMPLATE_CARD_PIN_INPUT_PATH', $this -> dispHTML()));

			} else if($this -> getType() == TYPE_SEND) {	// メール送信完了画面
				require_once($this -> getUserHTML('TEMPLATE_CARD_PIN_SEND_COMPLETE_PATH', $this -> dispHTML()));

			} else if($this -> getType() == TYPE_CONFIRM) {	// PIN確認画面
				require_once($this -> getUserHTML('TEMPLATE_CARD_PIN_CONFIRM_PATH', $this -> dispHTML()));

			} else if($this -> getType() == TYPE_FAIL) {	// メール失敗画面
				require_once($this -> getUserHTML('TEMPLATE_CARD_PIN_SEND_FAIL_PATH', $this -> dispHTML()));

			} else if($this -> getType() == TYPE_ERROR) {	// 有効期限切れ
				require_once($this -> getUserHTML('TEMPLATE_CARD_PIN_ERROR_PATH', $this -> dispHTML()));

			} else {										// その他
				require_once($this -> getUserHTML('TEMPLATE_CARD_PIN_SEND_PATH', $this -> dispHTML()));
			}

		} catch (Exception $e) {

			if($e -> getMessage() != NO_STRING) {
				require_once($this -> getUserHTML('TEMPLATE_CARD_PIN_SEND_FAIL_PATH', $this -> dispHTML()));
			} else {
				header('Location: /' . $this ->  getLangage() . '/login');
			}
		}
	}
}
?>