<?php
error_reporting(E_ALL);
ini_set('display_errors', '1');
date_default_timezone_set('Asia/Tokyo');
include_once('../system/lib/config.php');

$_GET['IPAddress'] = $_SERVER['REMOTE_ADDR'];
error_log(date("[Y-m-d H:i:s]")." SAPAY\r\n" . print_r($_GET,true)."\r\n", 3, 'Logs'.DIRECTORY_SEPARATOR.'SAPAY'.DIRECTORY_SEPARATOR.'Log_'.date("Y-m-d").'.log');

$ipList = array(
	'153.126.141.202',
	'116.228.139.34',
	'118.243.129.247',
	'153.126.183.251',
	'160.16.221.180',
	'160.16.127.47',
	'153.126.199.34',
	'153.126.192.157',
	'121.58.255.131',
	'122.49.220.26',
	'121.58.194.162',
	'52.220.92.7'
);

if(@!isset($_SERVER['REMOTE_ADDR'])){
	echo "IP not set";
	error_log(date("[Y-m-d H:i:s]")." SAPAY\r\n" . print_r($_GET,true)."\r\n IP not set \r\n\r\n\r\n\r\n", 3, 'Logs'.DIRECTORY_SEPARATOR.'SAPAY'.DIRECTORY_SEPARATOR.'Error'.DIRECTORY_SEPARATOR.'Log_'.date("Y-m-d").'.log');
	exit();
}elseif(!in_array($_SERVER['REMOTE_ADDR'], $ipList)){
	echo "Not in AllowList";
	error_log(date("[Y-m-d H:i:s]")." SAPAY\r\n" . print_r($_GET,true)."\r\n". $_SERVER['REMOTE_ADDR'] ."\r\nNot in AllowList\r\n\r\n\r\n\r\n", 3, 'Logs'.DIRECTORY_SEPARATOR.'SAPAY'.DIRECTORY_SEPARATOR.'Error'.DIRECTORY_SEPARATOR.'Log_'.date("Y-m-d").'.log');
	exit();
}



$system = new System();
$get = $_GET;
$sqlObject = new mysql($system->getConfigValue(SECTION_DB,HOST_NAME),$system->getConfigValue(SECTION_DB,USER_NAME),$system->getConfigValue(SECTION_DB,LOGIN_PASS),$system->getConfigValue(SECTION_DB,TARGET_DB_NAME),'','UTF8');
$currency = JPY;
$date = date("Y-m-d H:i:s");

//处理返回数据
$ReturnResponse = explode('__',$system -> getColumnData($get,'data'));
$arrDeposit = array();
foreach($ReturnResponse as $key=>$val){
	$arrTmp = array();
	$arrExplodeTmp1 = explode('/',$val);
	$arrExplodeTmp2 = explode('@',$arrExplodeTmp1[1]);
	$arrTmp['TransactionID'] = $arrExplodeTmp1[0];
	$arrTmp['DepositAmount'] = $arrExplodeTmp2[0];
	$arrTmp['UserID'] = $arrExplodeTmp2[1];
	$arrDeposit[] = $arrTmp;
}
//数据处理完毕

//Deposit表与array数组对应模型
$DepositModel = array(
	'transaction_number'=>'TransactionID',
	'user_account'=>'UserID',
	'amount'=>'Amount',
	'currency'=>'Currency',
	'method'=>'Method',
	'deposit_bank'=>'Bank',
	'deposit_date'=>'Date',
	'fee'=>'Fee',
	'message'=>'Message',
	'comment'=>'Comment',
	'create_time'=>'Date',
	'process_user'=>'User',
	'type'=>'Type',
	'err_flg'=>'Err_flg',
	'flat3_transaction_id'=>'F3ID',
);

//array数组默认数据
$arrDepositTmp = array(
	'Currency' => $currency,
	'deposit_date' => $date,
	'create_time'=> $date,
	'Bank'=> 'JP Voucher',
	'Method' => 'JPV',
	'User' => '9999',
	'Type' => '0',
	'Err_flg' => '0',
);

foreach($arrDeposit as $key=>$val){

	if(strpos($val['UserID'],'G')!==FALSE){
		$ch = curl_init(VAL_STR_GAPI_FLAT3.$val['TransactionID'].'/'.$val['DepositAmount'].'@'.$val['UserID']);
		curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

		$data = curl_exec($ch);

		$error = 'No error';
		if(curl_errno($ch)) {
		  $error = curl_error($ch);
		}
		curl_close($ch);

		error_log(date("[Y-m-d H:i:s]")." FLAT3-GAPI\r\n" . print_r($_GET,true)."\r\n GAPI Response: ".$data."\r\n Error:".$error."\r\n\r\n\r\n", 3, 'Logs'.DIRECTORY_SEPARATOR.'SAPAY'.DIRECTORY_SEPARATOR.'GAPI'.DIRECTORY_SEPARATOR.'Log_'.date("Y-m-d").'.log');

		if($data != 'OK'){
			echo 'NG';
			exit();
		}
	}else{
		//需要先查询有没有相同ID号订单
		$sqlFlat3 = 'select flat3_transaction_id from t_deposit where flat3_transaction_id = "'.$val['TransactionID'].'"';
		$resultFlat3 = $sqlObject -> query($sqlFlat3);
		$rowFlat3 = $sqlObject -> fetch_assoc($resultFlat3);

		//$rowFlat3 = '';
		if(empty($rowFlat3)){
			//没有结果，说明不是重复添加，可以进数据库
			$arrTmp = array();
			//根据内置方法取番号
			$arrDepositTmp['TransactionID'] = $system-> getTransactionNumberCommon(VAR_TRANSACTION_DEPOSIT);
			//$arrDepositTmp['TransactionID'] = trim(trim(date('YmdHis',time())).mt_rand(10000,99999));
			$arrDepositTmp['F3ID'] = $val['TransactionID'];
			$arrDepositTmp['UserID'] = $val['UserID'];
			$arrDepositTmp['Amount'] = floor($val['DepositAmount'] / 1.05);
			$arrDepositTmp['Fee'] = '0';
			$arrDepositTmp['Comment'] = $val['TransactionID'].'/'.$val['DepositAmount'].'@'.$val['UserID'];
			$arrDepositTmp['Date'] = $date;
			foreach($DepositModel as $key=>$value){
				if(isset($arrDepositTmp[$value])){
					$arrTmp[$key] = $arrDepositTmp[$value];
				}
			}
			$sql = 'insert into t_deposit '.$sqlObject -> InsertSql($arrTmp);

			$sqlObject->query($sql);
			//数据插入结束，发送邮件
			$Params = array();			//设置参数
			$Params[] = $val['UserID'];
			$Params[] = $system -> getNameCommon($val['UserID']);
			$Params[] = $arrDepositTmp['TransactionID'];
			$Params[] = $date;
			$Params[] = JPY;
			$Params[] = ltrim($val['DepositAmount'],'0');
			$Params[] = JPY;
			$Params[] = $arrDepositTmp['Amount'];

			//发送邮件
			sendFlat3CompleteMail($system,$val['UserID'],$Params);
		}else{
			error_log(date("[Y-m-d H:i:s]")." SAPAY\r\n" . print_r($_GET,true)."\r\n Duplicate Transaction: ".$val['TransactionID']." \r\n\r\n\r\n\r\n", 3, 'Logs'.DIRECTORY_SEPARATOR.'SAPAY'.DIRECTORY_SEPARATOR.'Error'.DIRECTORY_SEPARATOR.'Log_'.date("Y-m-d").'.log');
			echo "NG";
			exit();
		}
	}
}



echo "OK";



/*-------------------------------------------------------------------------
	 * @function_name: CUP支付成功時邮件送信
	 * @parameter	: 无
	 * @return		: 无
	 -------------------------------------------------------------------------*/
function sendFlat3CompleteMail($system,$account,$params){
	// 変数宣言部
	$row = $system -> getRowData($system -> getAccountCommon($account));
	$system -> sendMailByTmp('deposit_jpv_complete.xml'
							, $params
							, $system -> getColumnData($row, COLUMN_MAIL)
							, VAR_CS_MAIL_ADDRESS);
}
 ?>
