<?php 
include_once $_SERVER['DOCUMENT_ROOT'].DIRECTORY_SEPARATOR.'config.php';

class CpsApi{

	/*-------------------------------------------------------------------------
     * @function_name: createChannel
     * "@description : creates channel and generates bitcoin address
     * @parameter    : $nonce, $signature, $data
     * @return       : array response data ; bool - false (if creation is successful, returns response data else returns false)
    -------------------------------------------------------------------------*/
    public function createWalletAddress($data){

		$http_header = array(
            'Authorization: '. CPS_BEARER,
            'Accept: application/json'
        );

        //set curl parameters
        $ch = curl_init('https://api.andexpay.com/api/v1/merchant/payments/invoice'); //请求的URL地址
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);//$data JSON类型字符串
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $http_header);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

        //execute curl command
        $responseData = curl_exec($ch);

        //check if curl failed
        if($errno = curl_errno($ch)) {
        	$error_message = curl_strerror($errno);
        	echo "cURL error ({$errno}):\n {$error_message}";
            return false;
	    }
        curl_close($ch);

        $responseData = json_decode($responseData,true);

        if(count($responseData) > 0) {
            return $responseData;
        } else {
            return false;
        }
    }

    /*-------------------------------------------------------------------------
     * @function_name: insertCPSTemporary
     * "@description : inserts data into cubits database
     * @parameter    : $array - array containing the values to be inserted
     * @return       :
    -------------------------------------------------------------------------*/
    public function insertCPSTemporary($array){
        //instantiate system class to be able to call functions from library
        $system = new System();

        //insert to database
        $system -> accessModifyCommon('INSERT_TEMP_DEPOSIT_CPS', $array);
    }


}

 ?>