<?php
require_once('config.php');

class APIGetHistory extends System {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $signature		= NO_STRING;
	private $account		= NO_STRING;
	private $currency		= NO_STRING;
	private $from			= NO_STRING;
	private $to				= NO_STRING;

	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: パスワードの更新
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function action() {

		// 変数宣言部
		$rtn		= array();
		$base		= null;

		try {

			// パラメータの設定
			$this -> signature		= $this -> getDataPost(PARAM_SIGNATURE);
			$this -> account		= $this -> getDataPost(PARAM_USER_ACCOUNT);
			$this -> currency		= $this -> getDataPost(PARAM_CURRENCY);
			$this -> from			= $this -> getDataPost(PARAM_FROM);
			$this -> to				= $this -> getDataPost(PARAM_TO);

			// シグネチャのチェック（デバッグの場合は処理しない）
			if($this -> getDataPost('debug') == NO_STRING) {
				$this -> checkSignature($this -> signature, 'H' . $this -> account);
			}

			// エラーチェック
			$this -> validate();

			// 変数宣言部
			$params		= array();
			$rtn		= NO_STRING;
			$history	= null;
			$ago		= null;
			$from		= NO_STRING;

			// 通貨指定
			if($this -> currency != NO_STRING) {
				$params[] = ' (trans.deposit_currency = (\')' . $this -> currency . '(\') OR trans.withdraw_currency = (\')' . $this -> currency . '(\') OR trans.transfer_currency = (\')' . $this -> currency . '(\'))';
			}

			// 日付指定(from)
			if($this -> from != NO_STRING) {
				$params[] = ' transaction_time >= (\')' . $this -> from . '(\')';
			}

			// 日付指定(to)
			if($this -> to != NO_STRING) {
				$params[] = ' transaction_time < DATE_ADD((\')' . $this -> to . '(\'), INTERVAL 1 DAY)';
			}

			// データが存在した場合
			if($this -> isLoopData($params)) {
				$rtn = DELIMIT_AND . implode(DELIMIT_AND, $params);
			}

			// 履歴の取得
			$history = $this -> accessSelect('LIST_USER_TRANSACTION', array($this -> account, $rtn));

			if($this -> from == NO_STRING) {
				$from = $this -> getCurrentTimeCommon();
			} else {
				$from = $this -> from;
			}

			// 検索条件以前のデータの取得
			$ago = $this -> accessSelect('LIST_USER_BALANCE_FROM_CURRENCY_DATE', array($this -> account, $this -> currency, $from));

			// 以前のデータがあった場合
			if($this -> isLoopData($ago)) {
				$ago = $ago[NO_COUNT];
			}

			echo json_encode(array('result'		=> 'OK'
								, 'messages'	=> 'I_COMPLETE_PROCESS'
								, 'history'		=> $history
								, 'before'		=> $ago));

		} catch (Exception $e) {
			$rtn = array('result'		=> 'NG'
						, 'messages'	=> $e -> getMessage());

			echo json_encode($rtn);
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: エラーチェック
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function validate() {
	}
}

$api = new APIGetHistory();
$api -> action();
?>