<?php
class MstFeeModelClass extends ModelClassEx {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/

	private $fees								= null;			// 手数料リスト

	private $fId								= NO_STRING;	// 手数料ID
	private $name								= NO_STRING;	// 手数料名
	private $feeType							= NO_STRING;	// 手数料種別

	private $monthlyPerson						= NO_STRING;	// 月額維持フラグ（個人）
	private $monthlyPersonFixValue				= NO_STRING;	// 月額維持（個人）（固定値）
	private $monthlyPersonPercentValue			= NO_STRING;	// 月額維持（個人）（パーセンテージ）
	private $monthlyPersonPercentMax			= NO_STRING;	// 月額維持（個人）（最高値）

	private $monthlyCorp						= NO_STRING;	// 月額維持フラグ（法人）
	private $monthlyCorpFixValue				= NO_STRING;	// 月額維持（法人）（固定値）
	private $monthlyCorpPercentValue			= NO_STRING;	// 月額維持（法人）（パーセンテージ）
	private $monthlyCorpPercentMax				= NO_STRING;	// 月額維持（法人）（最高値）

	private $depositPerson						= NO_STRING;	// 入金フラグ（個人）
	private $depositPersonFixValue				= NO_STRING;	// 入金（個人）（固定値）
	private $depositPersonPercentValue			= NO_STRING;	// 入金（個人）（パーセンテージ）
	private $depositPersonPercentMax			= NO_STRING;	// 入金（個人）（最高値）

	private $depositCorp						= NO_STRING;	// 入金フラグ（法人）
	private $depositCorpFixValue				= NO_STRING;	// 入金（法人）（固定値）
	private $depositCorpPercentValue			= NO_STRING;	// 入金（法人）（パーセンテージ）
	private $depositCorpPercentMax				= NO_STRING;	// 入金フラグ（法人）（最高値）

	private $withdrawSuccessPerson				= NO_STRING;	// 出金フラグ（成功時）（個人）
	private $withdrawSuccessPerson1				= NO_STRING;	// 出金フラグ（成功時）（個人）
	private $withdrawSuccessPerson2				= NO_STRING;	// 出金フラグ（成功時）（個人）
	private $withdrawSuccessPersonFixValue		= NO_STRING;	// 出金（成功時）（個人）（固定値）
	private $withdrawSuccessPersonPercentValue	= NO_STRING;	// 出金（成功時）（個人）（パーセンテージ）
	private $withdrawSuccessPersonPercentMin	= NO_STRING;	// 出金（成功時）（個人）（最低値）
	private $withdrawSuccessPersonPercentMax	= NO_STRING;	// 出金（成功時）（個人）（最高値）

	private $withdrawSuccessCorp				= NO_STRING;	// 出金フラグ（成功時）（法人）
	private $withdrawSuccessCorp1				= NO_STRING;	// 出金フラグ（成功時）（法人）
	private $withdrawSuccessCorp2				= NO_STRING;	// 出金フラグ（成功時）（法人）
	private $withdrawSuccessCorpFixValue		= NO_STRING;	// 出金（成功時）（法人）（固定値）
	private $withdrawSuccessCorpPercentValue	= NO_STRING;	// 出金（成功時）（法人）（パーセンテージ）
	private $withdrawSuccessCorpPercentMin		= NO_STRING;	// 出金（成功時）（法人）（最低値）
	private $withdrawSuccessCorpPercentMax		= NO_STRING;	// 出金（成功時）（法人）（最高値）

	private $withdrawRefundPerson				= NO_STRING;	// 出金フラグ（失敗時）（個人）
	private $withdrawRefundPerson1				= NO_STRING;	// 出金フラグ（失敗時）（個人）
	private $withdrawRefundPerson2				= NO_STRING;	// 出金フラグ（失敗時）（個人）
	private $withdrawRefundPersonFixValue		= NO_STRING;	// 出金（失敗時）（個人）（固定値）
	private $withdrawRefundPersonPercentValue	= NO_STRING;	// 出金（失敗時）（個人）（パーセンテージ）
	private $withdrawRefundPersonPercentMin		= NO_STRING;	// 出金（失敗時）（個人）（最低値）
	private $withdrawRefundPersonPercentMax		= NO_STRING;	// 出金（失敗時）（個人）（最高値）

	private $withdrawRefundCorp					= NO_STRING;	// 出金フラグ（失敗時）（法人）
	private $withdrawRefundCorp1				= NO_STRING;	// 出金フラグ（失敗時）（法人）
	private $withdrawRefundCorp2				= NO_STRING;	// 出金フラグ（失敗時）（法人）
	private $withdrawRefundCorpFixValue			= NO_STRING;	// 出金（失敗時）（法人）（固定値）
	private $withdrawRefundCorpPercentValue		= NO_STRING;	// 出金（失敗時）（法人）（パーセンテージ）
	private $withdrawRefundCorpPercentMin		= NO_STRING;	// 出金（失敗時）（法人）（最低値）
	private $withdrawRefundCorpPercentMax		= NO_STRING;	// 出金（失敗時）（法人）（最高値）

	private $transferCToB						= NO_STRING;	// 口座振替フラグ（個人→法人）
	private $transferCToBAppFlg					= NO_STRING;	// 口座振替（個人→法人）（適用フラグ）
	private $transferCToBFixValue				= NO_STRING;	// 口座振替（個人→法人）（固定値）
	private $transferCToBPercentValue			= NO_STRING;	// 口座振替（個人→法人）（パーセンテージ）
	private $transferCtoBPercentMax				= NO_STRING;	// 口座振替（個人→法人）（最高値）

	private $transferCToC						= NO_STRING;	// 口座振替フラグ（個人→個人）
	private $transferCToCAppFlg					= NO_STRING;	// 口座振替（個人→法人）（適用フラグ）
	private $transferCToCFixValue				= NO_STRING;	// 口座振替（個人→個人）（固定値）
	private $transferCToCPercentValue			= NO_STRING;	// 口座振替（個人→個人）（パーセンテージ）
	private $transferCToCPercentMax				= NO_STRING;	// 口座振替（個人→個人）（最高値）

	private $transferBToC						= NO_STRING;	// 口座振替フラグ（法人→個人）
	private $transferBToCAppFlg					= NO_STRING;	// 口座振替（個人→法人）（適用フラグ）
	private $transferBToCFixValue				= NO_STRING;	// 口座振替（法人→個人）（固定値）
	private $transferBToCPercentValue			= NO_STRING;	// 口座振替（法人→個人）（パーセンテージ）
	private $transferBToCPercentMax				= NO_STRING;	// 口座振替（法人→個人）（最高値）

	private $transferBToB						= NO_STRING;	// 口座振替フラグ（法人→法人）
	private $transferBToBAppFlg					= NO_STRING;	// 口座振替（個人→法人）（適用フラグ）
	private $transferBToBFixValue				= NO_STRING;	// 口座振替フラグ（法人→法人）（固定値）
	private $transferBToBPercentValue			= NO_STRING;	// 口座振替フラグ（法人→法人）（パーセンテージ）
	private $transferBToBPercentMax				= NO_STRING;	// 口座振替フラグ（法人→法人）（最高値）

	private $domantPerson						= NO_STRING;	// 休止フラグ（個人）
	private $domantPersonFixValue				= NO_STRING;	// 休止（個人）（固定値）
	private $domantPersonPercentValue			= NO_STRING;	// 休止（個人）（パーセンテージ）
	private $domantPersonPercentMax				= NO_STRING;	// 休止（個人）（最高値）

	private $domantCorp							= NO_STRING;	// 休止フラグ（法人）
	private $domantCorpFixValue					= NO_STRING;	// 休止（法人）（固定値）
	private $domantCorpPercentValue				= NO_STRING;	// 休止（法人）（パーセンテージ）
	private $domantCorpPercentMax				= NO_STRING;	// 休止（法人）（最高値）

	private $deletePerson						= NO_STRING;	// 削除フラグ（個人）
	private $deletePersonFixValue				= NO_STRING;	// 削除（個人）（固定値）
	private $deletePersonPercentValue			= NO_STRING;	// 削除（個人）（パーセンテージ）
	private $deletePersonPercentMax				= NO_STRING;	// 削除（個人）（最高値）

	private $deleteCorp							= NO_STRING;	// 削除フラグ（法人）
	private $deleteCorpFixValue					= NO_STRING;	// 削除（法人）（固定値）
	private $deleteCorpPercentValue				= NO_STRING;	// 削除（法人）（パーセンテージ）
	private $deleteCorpPercentMax				= NO_STRING;	// 削除（法人）（最高値）

	private $cardDepositPerson					= NO_STRING;	// カード入金フラグ（個人）
	private $cardDepositPersonFixValue			= NO_STRING;	// カード入金（個人）（固定値）
	private $cardDepositPersonPercentValue		= NO_STRING;	// カード入金（個人）（パーセンテージ）
	private $cardDepositPersonPercentMax		= NO_STRING;	// カード入金（個人）（最高値）

	private $cardDepositCorp					= NO_STRING;	// カード入金フラグ（法人）
	private $cardDepositCorpFixValue			= NO_STRING;	// カード入金（法人）（固定値）
	private $cardDepositCorpPercentValue		= NO_STRING;	// カード入金（法人）（パーセンテージ）
	private $cardDepositCorpPercentMax			= NO_STRING;	// カード入金（法人）（最高値）
	
	/**
	 *
	 * anton
	 *
	 */
	private $lang								= NO_STRING;
	
	/*-------------------------------------------------------------------------
	* @function_name: コントロールパネルシステムindexモデルクラスコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		// スーパークラスコンストラクタ呼び出し
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: 初期設定関数
	* @parameter	: なし
	* @return		: 成功:success、失敗:error
	-------------------------------------------------------------------------*/
	public function init() {

		try {

			// パラメータの設定
			$this -> setParameter();

			// チェック
			$this -> validate();

		} catch (Exception $e) {
			throw new Exception(NO_STRING);
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: パラメータの設定
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function setParameter() {

		$this -> fId								= $this -> getDataPost(PARAM_F_ID);										// 手数料ID
		$this -> name								= $this -> getDataPost(PARAM_NAME);										// 手数料名
		$this -> feeType							= $this -> getDataPost(PARAM_FEE_TYPE);									// 手数料種別

		$this -> monthlyPerson						= $this -> getDataPost(PARAM_MONTHLY_PERSON);							// 月額維持フラグ（個人）
		$this -> monthlyPersonFixValue				= $this -> getDataPost(PARAM_MONTHLY_PERSON_FIX_VALUE);					// 月額維持（個人）（固定値）
		$this -> monthlyPersonPercentValue			= $this -> getDataPost(PARAM_MONTHLY_PERSON_PERCENT_VALUE);				// 月額維持（個人）（パーセンテージ）
		$this -> monthlyPersonPercentMax			= $this -> getDataPost(PARAM_MONTHLY_PERSON_PERCENT_MAX);				// 月額維持（個人）（最高値）

		$this -> monthlyCorp						= $this -> getDataPost(PARAM_MONTHLY_CORP);								// 月額維持フラグ（法人）
		$this -> monthlyCorpFixValue				= $this -> getDataPost(PARAM_MONTHLY_CORP_FIX_VALUE);					// 月額維持（法人）（固定値）
		$this -> monthlyCorpPercentValue			= $this -> getDataPost(PARAM_MONTHLY_CORP_PERCENT_VALUE);				// 月額維持（法人）（パーセンテージ）
		$this -> monthlyCorpPercentMax				= $this -> getDataPost(PARAM_MONTHLY_CORP_PERCENT_MAX);					// 月額維持（法人）（最高値）

		$this -> depositPerson						= $this -> getDataPost(PARAM_DEPOSIT_PERSON);							// 入金フラグ（個人）
		$this -> depositPersonFixValue				= $this -> getDataPost(PARAM_DEPOSIT_PERSON_FIX_VALUE);					// 入金（個人）（固定値）
		$this -> depositPersonPercentValue			= $this -> getDataPost(PARAM_DEPOSIT_PERSON_PERCENT_VALUE);				// 入金（個人）（パーセンテージ）
		$this -> depositPersonPercentMax			= $this -> getDataPost(PARAM_DEPOSIT_PERSON_PERCENT_MAX);				// 入金（個人）（最高値）

		$this -> depositCorp						= $this -> getDataPost(PARAM_DEPOSIT_CORP);								// 入金フラグ（法人）
		$this -> depositCorpFixValue				= $this -> getDataPost(PARAM_DEPOSIT_CORP_FIX_VALUE);					// 入金（法人）（固定値）
		$this -> depositCorpPercentValue			= $this -> getDataPost(PARAM_DEPOSIT_CORP_PERCENT_VALUE);				// 入金（法人）（パーセンテージ）
		$this -> depositCorpPercentMax				= $this -> getDataPost(PARAM_DEPOSIT_CORP_PERCENT_MAX);					// 入金フラグ（法人）（最高値）

		$this -> withdrawSuccessPerson				= $this -> getDataPost(PARAM_WITHDRAW_SUCCESS_PERSON);					// 出金フラグ（成功時）（個人）
		$this -> withdrawSuccessPerson1				= $this -> getDataPost(PARAM_WITHDRAW_SUCCESS_PERSON . VAL_INT_1);		// 出金フラグ（成功時）（個人）
		$this -> withdrawSuccessPerson2				= $this -> getDataPost(PARAM_WITHDRAW_SUCCESS_PERSON . VAL_INT_2);		// 出金フラグ（成功時）（個人）
		$this -> withdrawSuccessPersonFixValue		= $this -> getDataPost(PARAM_WITHDRAW_SUCCESS_PERSON_FIX_VALUE);		// 出金（成功時）（個人）（固定値）
		$this -> withdrawSuccessPersonPercentValue	= $this -> getDataPost(PARAM_WITHDRAW_SUCCESS_PERSON_PERCENT_VALUE);	// 出金（成功時）（個人）（パーセンテージ）
		$this -> withdrawSuccessPersonPercentMin	= $this -> getDataPost(PARAM_WITHDRAW_SUCCESS_PERSON_PERCENT_MIN);		// 出金（成功時）（個人）（最低値）
		$this -> withdrawSuccessPersonPercentMax	= $this -> getDataPost(PARAM_WITHDRAW_SUCCESS_PERSON_PERCENT_MAX);		// 出金（成功時）（個人）（最高値）

		$this -> withdrawSuccessCorp				= $this -> getDataPost(PARAM_WITHDRAW_SUCCESS_CORP);					// 出金フラグ（成功時）（法人）
		$this -> withdrawSuccessCorp1				= $this -> getDataPost(PARAM_WITHDRAW_SUCCESS_CORP . VAL_INT_1);		// 出金フラグ（成功時）（法人）
		$this -> withdrawSuccessCorp2				= $this -> getDataPost(PARAM_WITHDRAW_SUCCESS_CORP . VAL_INT_2);		// 出金フラグ（成功時）（法人）
		$this -> withdrawSuccessCorpFixValue		= $this -> getDataPost(PARAM_WITHDRAW_SUCCESS_CORP_FIX_VALUE);			// 出金（成功時）（法人）（固定値）
		$this -> withdrawSuccessCorpPercentValue	= $this -> getDataPost(PARAM_WITHDRAW_SUCCESS_CORP_PERCENT_VALUE);		// 出金（成功時）（法人）（パーセンテージ）
		$this -> withdrawSuccessCorpPercentMin		= $this -> getDataPost(PARAM_WITHDRAW_SUCCESS_CORP_PERCENT_MIN);		// 出金（成功時）（法人）（最低値）
		$this -> withdrawSuccessCorpPercentMax		= $this -> getDataPost(PARAM_WITHDRAW_SUCCESS_CORP_PERCENT_MAX);		// 出金（成功時）（法人）（最高値）

		$this -> withdrawRefundPerson				= $this -> getDataPost(PARAM_WITHDRAW_REFUND_PERSON);					// 出金フラグ（失敗時）（個人）
		$this -> withdrawRefundPerson1				= $this -> getDataPost(PARAM_WITHDRAW_REFUND_PERSON . VAL_INT_1);		// 出金フラグ（失敗時）（個人）
		$this -> withdrawRefundPerson2				= $this -> getDataPost(PARAM_WITHDRAW_REFUND_PERSON . VAL_INT_2);		// 出金フラグ（失敗時）（個人）
		$this -> withdrawRefundPersonFixValue		= $this -> getDataPost(PARAM_WITHDRAW_REFUND_PERSON_FIX_VALUE);			// 出金（失敗時）（個人）（固定値）
		$this -> withdrawRefundPersonPercentValue	= $this -> getDataPost(PARAM_WITHDRAW_REFUND_PERSON_PERCENT_VALUE);		// 出金（失敗時）（個人）（パーセンテージ）
		$this -> withdrawRefundPersonPercentMin		= $this -> getDataPost(PARAM_WITHDRAW_REFUND_PERSON_PERCENT_MIN);		// 出金（失敗時）（個人）（最低値）
		$this -> withdrawRefundPersonPercentMax		= $this -> getDataPost(PARAM_WITHDRAW_REFUND_PERSON_PERCENT_MAX);		// 出金（失敗時）（個人）（最高値）

		$this -> withdrawRefundCorp					= $this -> getDataPost(PARAM_WITHDRAW_REFUND_CORP);						// 出金フラグ（失敗時）（法人）
		$this -> withdrawRefundCorp1				= $this -> getDataPost(PARAM_WITHDRAW_REFUND_CORP . VAL_INT_1);			// 出金フラグ（失敗時）（法人）
		$this -> withdrawRefundCorp2				= $this -> getDataPost(PARAM_WITHDRAW_REFUND_CORP . VAL_INT_2);			// 出金フラグ（失敗時）（法人）
		$this -> withdrawRefundCorpFixValue			= $this -> getDataPost(PARAM_WITHDRAW_REFUND_CORP_FIX_VALUE);			// 出金（失敗時）（法人）（固定値）
		$this -> withdrawRefundCorpPercentValue		= $this -> getDataPost(PARAM_WITHDRAW_REFUND_CORP_PERCENT_VALUE);		// 出金（失敗時）（法人）（パーセンテージ）
		$this -> withdrawRefundCorpPercentMin		= $this -> getDataPost(PARAM_WITHDRAW_REFUND_CORP_PERCENT_MIN);			// 出金（失敗時）（法人）（最低値）
		$this -> withdrawRefundCorpPercentMax		= $this -> getDataPost(PARAM_WITHDRAW_REFUND_CORP_PERCENT_MAX);			// 出金（失敗時）（法人）（最高値）

		$this -> transferCToB						= $this -> getDataPost(PARAM_TRANSFER_C_TO_B);							// 口座振替フラグ（個人→法人）
		$this -> transferCToBAppFlg					= $this -> getDataPost(PARAM_TRANSFER_C_TO_B_APP_FLG);					// 口座振替（個人→法人）（適用フラグ）
		$this -> transferCToBFixValue				= $this -> getDataPost(PARAM_TRANSFER_C_TO_B_FIX_VALUE);				// 口座振替（個人→法人）（固定値）
		$this -> transferCToBPercentValue			= $this -> getDataPost(PARAM_TRANSFER_C_TO_B_PERCENT_VALUE);			// 口座振替（個人→法人）（パーセンテージ）
		$this -> transferCtoBPercentMax				= $this -> getDataPost(PARAM_C_TO_BSFER_C_TO_B_PERCENT_MAX);			// 口座振替（個人→法人）（最高値）

		$this -> transferCToC						= $this -> getDataPost(PARAM_TRANSFER_C_TO_C);							// 口座振替フラグ（個人→個人）
		$this -> transferCToCAppFlg					= $this -> getDataPost(PARAM_TRANSFER_C_TO_C_APP_FLG);					// 口座振替（個人→法人）（適用フラグ）
		$this -> transferCToCFixValue				= $this -> getDataPost(PARAM_TRANSFER_C_TO_C_FIX_VALUE);				// 口座振替（個人→個人）（固定値）
		$this -> transferCToCPercentValue			= $this -> getDataPost(PARAM_TRANSFER_C_TO_C_PERCENT_VALUE);			// 口座振替（個人→個人）（パーセンテージ）
		$this -> transferCToCPercentMax				= $this -> getDataPost(PARAM_TRANSFER_C_TO_C_PERCENT_MAX);				// 口座振替（個人→個人）（最高値）

		$this -> transferBToC						= $this -> getDataPost(PARAM_TRANSFER_B_TO_C);							// 口座振替フラグ（法人→個人）
		$this -> transferBToCAppFlg					= $this -> getDataPost(PARAM_TRANSFER_B_TO_C_APP_FLG);					// 口座振替（個人→法人）（適用フラグ）
		$this -> transferBToCFixValue				= $this -> getDataPost(PARAM_TRANSFER_B_TO_C_FIX_VALUE);				// 口座振替（法人→個人）（固定値）
		$this -> transferBToCPercentValue			= $this -> getDataPost(PARAM_TRANSFER_B_TO_C_PERCENT_VALUE);			// 口座振替（法人→個人）（パーセンテージ）
		$this -> transferBToCPercentMax				= $this -> getDataPost(PARAM_TRANSFER_B_TO_C_PERCENT_MAX);				// 口座振替（法人→個人）（最高値）

		$this -> transferBToB						= $this -> getDataPost(PARAM_TRANSFER_B_TO_B);							// 口座振替フラグ（法人→法人）
		$this -> transferBToBAppFlg					= $this -> getDataPost(PARAM_TRANSFER_B_TO_B_APP_FLG);					// 口座振替（個人→法人）（適用フラグ）
		$this -> transferBToBFixValue				= $this -> getDataPost(PARAM_TRANSFER_B_TO_B_FIX_VALUE);				// 口座振替フラグ（法人→法人）（固定値）
		$this -> transferBToBPercentValue			= $this -> getDataPost(PARAM_TRANSFER_B_TO_B_PERCENT_VALUE);			// 口座振替フラグ（法人→法人）（パーセンテージ）
		$this -> transferBToBPercentMax				= $this -> getDataPost(PARAM_TRANSFER_B_TO_B_PERCENT_MAX);				// 口座振替フラグ（法人→法人）（最高値）

		$this -> domantPerson						= $this -> getDataPost(PARAM_DOMANT_PERSON);							// 休止フラグ（個人）
		$this -> domantPersonFixValue				= $this -> getDataPost(PARAM_DOMANT_PERSON_FIX_VALUE);					// 休止（個人）（固定値）
		$this -> domantPersonPercentValue			= $this -> getDataPost(PARAM_DOMANT_PERSON_PERCENT_VALUE);				// 休止（個人）（パーセンテージ）
		$this -> domantPersonPercentMax				= $this -> getDataPost(PARAM_DOMANT_PERSON_PERCENT_MAX);				// 休止（個人）（最高値）

		$this -> domantCorp							= $this -> getDataPost(PARAM_DOMANT_CORP);								// 休止フラグ（法人）
		$this -> domantCorpFixValue					= $this -> getDataPost(PARAM_DOMANT_CORP_FIX_VALUE);					// 休止（法人）（固定値）
		$this -> domantCorpPercentValue				= $this -> getDataPost(PARAM_DOMANT_CORP_PERCENT_VALUE);				// 休止（法人）（パーセンテージ）
		$this -> domantCorpPercentMax				= $this -> getDataPost(PARAM_DOMANT_CORP_PERCENT_MAX);					// 休止（法人）（最高値）

		$this -> deletePerson						= $this -> getDataPost(PARAM_DELETE_PERSON);							// 削除フラグ（個人）
		$this -> deletePersonFixValue				= $this -> getDataPost(PARAM_DELETE_PERSON_FIX_VALUE);					// 削除（個人）（固定値）
		$this -> deletePersonPercentValue			= $this -> getDataPost(PARAM_DELETE_PERSON_PERCENT_VALUE);				// 削除（個人）（パーセンテージ）
		$this -> deletePersonPercentMax				= $this -> getDataPost(PARAM_DELETE_PERSON_PERCENT_MAX);				// 削除（個人）（最高値）

		$this -> deleteCorp							= $this -> getDataPost(PARAM_DELETE_CORP);								// 削除フラグ（法人）
		$this -> deleteCorpFixValue					= $this -> getDataPost(PARAM_DELETE_CORP_FIX_VALUE);					// 削除（法人）（固定値）
		$this -> deleteCorpPercentValue				= $this -> getDataPost(PARAM_DELETE_CORP_PERCENT_VALUE);				// 削除（法人）（パーセンテージ）
		$this -> deleteCorpPercentMax				= $this -> getDataPost(PARAM_DELETE_CORP_PERCENT_MAX);					// 削除（法人）（最高値）

		$this -> cardDepositPerson					= $this -> getDataPost(PARAM_CARD_DEPOSIT_PERSON);						// カード入金フラグ（個人）
		$this -> cardDepositPersonFixValue			= $this -> getDataPost(PARAM_CARD_DEPOSIT_PERSON_FIX_VALUE);			// カード入金（個人）（固定値）
		$this -> cardDepositPersonPercentValue		= $this -> getDataPost(PARAM_CARD_DEPOSIT_PERSON_PERCENT_VALUE);		// カード入金（個人）（パーセンテージ）
		$this -> cardDepositPersonPercentMax		= $this -> getDataPost(PARAM_CARD_DEPOSIT_PERSON_PERCENT_MAX);			// カード入金（個人）（最高値）

		$this -> cardDepositCorp					= $this -> getDataPost(PARAM_CARD_DEPOSIT_CORP);						// カード入金フラグ（法人）
		$this -> cardDepositCorpFixValue			= $this -> getDataPost(PARAM_CARD_DEPOSIT_CORP_FIX_VALUE);				// カード入金（法人）（固定値）
		$this -> cardDepositCorpPercentValue		= $this -> getDataPost(PARAM_CARD_DEPOSIT_CORP_PERCENT_VALUE);			// カード入金（法人）（パーセンテージ）
		$this -> cardDepositCorpPercentMax			= $this -> getDataPost(PARAM_CARD_DEPOSIT_CORP_PERCENT_MAX);			// カード入金（法人）（最高値）

		$this -> lang								= $this -> getLangage();
	}

	/*-------------------------------------------------------------------------
	* @function_name: サーバ側データチェック
	* @parameter	: なし
	* @return		: TRUE:成功、FALSE:失敗
	-------------------------------------------------------------------------*/
	public function validate() {

		// 変数宣言部
		$rtn = true;

		// ログインチェック
		if(!$this -> checkAdminUserLogin()) {
			throw new Exception(NO_STRING);
		}

		/**
		 *
		 * -- anton --
		 * 04/22/2019
		 *
		 */
		$redirect = ($this -> lang != "en" ? "" : "{$this -> lang}/");
		
		//check access
		if(!$this -> checkAdminUserAccess('CSET', array(''))){
			$this -> popUpSessionMessage(ERROR, 'E_ERROR_NO_PAGE_ACCESS', array());
			header('Location: /'.$redirect.'menu');
			exit();
		}

		if($this -> getType() == TYPE_CREATE || $this -> getType()	== TYPE_INPUT || $this -> getType()	== TYPE_EDIT) {
			//check access
			if(!$this -> checkAdminUserAccess('CSET', array('','1'))){
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_NO_FUNCTION_ACCESS', array());
				header('Location: /'.$redirect.'menu');
				exit();
			}
		}

		if($this -> getType() == TYPE_DELETE) {
			//check access
			if(!$this -> checkAdminUserAccess('CSET', array('','2'))){
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_NO_FUNCTION_ACCESS', array());
				header('Location: /'.$redirect.'menu');
				exit();
			}
		}

		if($this -> getType() == TYPE_REGITS
			|| $this -> getType() == TYPE_UPDATE) {		// 編集時にチェックを行う

			// 必須項目のチェック
			if(!$this -> checkNull($this -> name)) {	// 手数料名
				$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_PATTERN_NAME));
				$rtn = false;
			}

			if($this -> monthlyPerson == NO_COUNT) {												// 月額維持フラグ（個人）が固定額の場合

				if(!$this -> checkNull($this -> monthlyPersonFixValue)) {							// 月額維持（個人）（固定値）
					$this -> popUpSessionMessage(ERROR, 'E_DO_NOT_INPUT', array(VAL_STR_MONTHLY_PERSON_FIX_VALUE));
					$rtn = false;
				}
			} else {																				// その他

				if(!$this -> checkNull($this -> monthlyPersonPercentValue)) {						// 月額維持（個人）（パーセンテージ）
					$this -> popUpSessionMessage(ERROR, 'E_DO_NOT_INPUT', array(VAL_STR_MONTHLY_PERSON_PERCENT_VALUE));
					$rtn = false;
				}

				if(!$this -> checkNull($this -> monthlyPersonPercentMax)) {							// 月額維持（個人）（最高値）
					$this -> popUpSessionMessage(ERROR, 'E_DO_NOT_INPUT', array(VAL_STR_MONTHLY_PERSON_PERCENT_MAX));
					$rtn = false;
				}
			}

			if($this -> monthlyCorp == NO_COUNT) {													// 月額維持フラグ（法人）が固定額の場合

				if(!$this -> checkNull($this -> monthlyCorpFixValue)) {								// 月額維持（法人）（固定値）
					$this -> popUpSessionMessage(ERROR, 'E_DO_NOT_INPUT', array(VAL_STR_MONTHLY_CORP_FIX_VALUE));
					$rtn = false;
				}
			} else {																				// その他

				if(!$this -> checkNull($this -> monthlyCorpPercentValue)) {							// 月額維持（法人）（パーセンテージ）
					$this -> popUpSessionMessage(ERROR, 'E_DO_NOT_INPUT', array(VAL_STR_MONTHLY_CORP_PERCENT_VALUE));
					$rtn = false;
				}

				if(!$this -> checkNull($this -> monthlyCorpPercentMax)) {							// 月額維持（法人）（最高値）
					$this -> popUpSessionMessage(ERROR, 'E_DO_NOT_INPUT', array(VAL_STR_MONTHLY_CORP_PERCENT_MAX));
					$rtn = false;
				}
			}

			if($this -> depositPerson == NO_COUNT) {												// 入金フラグ（個人）が固定額の場合

				if(!$this -> checkNull($this -> depositPersonFixValue)) {							// 入金（個人）（固定値）
					$this -> popUpSessionMessage(ERROR, 'E_DO_NOT_INPUT', array(VAL_STR_DEPOSIT_PERSON_FIX_VALUE));
					$rtn = false;
				}
			} else {																				// その他

				if(!$this -> checkNull($this -> depositPersonPercentValue)) {						// 入金（個人）（パーセンテージ）
					$this -> popUpSessionMessage(ERROR, 'E_DO_NOT_INPUT', array(VAL_STR_DEPOSIT_PERSON_PERCENT_VALUE));
					$rtn = false;
				}

				if(!$this -> checkNull($this -> depositPersonPercentMax)) {							// 入金（個人）（最高値）
					$this -> popUpSessionMessage(ERROR, 'E_DO_NOT_INPUT', array(VAL_STR_DEPOSIT_PERSON_PERCENT_MAX));
					$rtn = false;
				}
			}

			if($this -> depositCorp == NO_COUNT) {													// 入金フラグ（法人）が固定額の場合

				if(!$this -> checkNull($this -> depositCorpFixValue)) {								// 入金（法人）（固定値）
					$this -> popUpSessionMessage(ERROR, 'E_DO_NOT_INPUT', array(VAL_STR_DEPOSIT_CORP_FIX_VALUE));
					$rtn = false;
				}
			} else {																				// その他

				if(!$this -> checkNull($this -> depositCorpPercentValue)) {							// 入金（法人）（パーセンテージ）
					$this -> popUpSessionMessage(ERROR, 'E_DO_NOT_INPUT', array(VAL_STR_DEPOSIT_CORP_PERCENT_VALUE));
					$rtn = false;
				}

				if(!$this -> checkNull($this -> depositCorpPercentMax)) {							// 入金フラグ（法人）（最高値）
					$this -> popUpSessionMessage(ERROR, 'E_DO_NOT_INPUT', array(VAL_STR_DEPOSIT_CORP_PERCENT_MAX));
					$rtn = false;
				}
			}

			if($this -> withdrawSuccessPerson == NO_COUNT) {										// 出金フラグ（成功時）（個人）が固定額の場合

				if(!$this -> checkNull($this -> withdrawSuccessPersonFixValue)) {					// 出金（成功時）（個人）（固定値）
					$this -> popUpSessionMessage(ERROR, 'E_DO_NOT_INPUT', array(VAL_STR_WITHDRAW_SUCCESS_PERSON_FIX_VALUE));
					$rtn = false;
				}
			} else {																				// その他

				if(!$this -> checkNull($this -> withdrawSuccessPersonPercentValue)) {				// 出金（成功時）（個人）（パーセンテージ）
					$this -> popUpSessionMessage(ERROR, 'E_DO_NOT_INPUT', array(VAL_STR_WITHDRAW_SUCCESS_PERSON_PERCENT_VALUE));
					$rtn = false;
				}

				if(!$this -> checkNull($this -> withdrawSuccessPersonPercentMax)) {					// 出金（成功時）（個人）（最高値）
					$this -> popUpSessionMessage(ERROR, 'E_DO_NOT_INPUT', array(VAL_STR_WITHDRAW_SUCCESS_PERSON_PERCENT_MAX));
					$rtn = false;
				}
			}

			if($this -> withdrawSuccessCorp == NO_COUNT) {											// 出金フラグ（成功時）（法人）が固定額の場合

				if(!$this -> checkNull($this -> withdrawSuccessCorpFixValue)) {						// 出金（成功時）（法人）（固定値）
					$this -> popUpSessionMessage(ERROR, 'E_DO_NOT_INPUT', array(VAL_STR_WITHDRAW_SUCCESS_CORP_FIX_VALUE));
					$rtn = false;
				}
			} else {																				// その他

				if(!$this -> checkNull($this -> withdrawSuccessCorpPercentValue)) {					// 出金（成功時）（法人）（パーセンテージ）
					$this -> popUpSessionMessage(ERROR, 'E_DO_NOT_INPUT', array(VAL_STR_WITHDRAW_SUCCESS_CORP_PERCENT_VALUE));
					$rtn = false;
				}

				if(!$this -> checkNull($this -> withdrawSuccessCorpPercentMax)) {					// 出金（成功時）（法人）（最高値）
					$this -> popUpSessionMessage(ERROR, 'E_DO_NOT_INPUT', array(VAL_STR_WITHDRAW_SUCCESS_CORP_PERCENT_MAX));
					$rtn = false;
				}
			}

			if($this -> withdrawRefundPerson == NO_COUNT) {											// 出金フラグ（失敗時）（個人）が固定額の場合

				if(!$this -> checkNull($this -> withdrawRefundPersonFixValue)) {					// 出金（失敗時）（個人）（固定値）
					$this -> popUpSessionMessage(ERROR, 'E_DO_NOT_INPUT', array(VAL_STR_WITHDRAW_REFUND_PERSON_FIX_VALUE));
					$rtn = false;
				}
			} else {																				// その他

				if(!$this -> checkNull($this -> withdrawRefundPersonPercentValue)) {				// 出金（失敗時）（個人）（パーセンテージ）
					$this -> popUpSessionMessage(ERROR, 'E_DO_NOT_INPUT', array(VAL_STR_WITHDRAW_REFUND_PERSON_PERCENT_VALUE));
					$rtn = false;
				}

				if(!$this -> checkNull($this -> withdrawRefundPersonPercentMax)) {					// 出金（失敗時）（個人）（最高値）
					$this -> popUpSessionMessage(ERROR, 'E_DO_NOT_INPUT', array(VAL_STR_WITHDRAW_REFUND_PERSON_PERCENT_MAX));
					$rtn = false;
				}
			}

			if($this -> withdrawRefundCorp == NO_COUNT) {											// 出金フラグ（失敗時）（法人）が固定額の場合

				if(!$this -> checkNull($this -> withdrawRefundCorpFixValue)) {						// 出金（失敗時）（法人）（固定値）
					$this -> popUpSessionMessage(ERROR, 'E_DO_NOT_INPUT', array(VAL_STR_WITHDRAW_REFUND_CORP_FIX_VALUE));
					$rtn = false;
				}
			} else {																				// その他

				if(!$this -> checkNull($this -> withdrawRefundCorpPercentValue)) {					// 出金（失敗時）（法人）（パーセンテージ）
					$this -> popUpSessionMessage(ERROR, 'E_DO_NOT_INPUT', array(VAL_STR_WITHDRAW_REFUND_CORP_PERCENT_VALUE));
					$rtn = false;
				}

				if(!$this -> checkNull($this -> withdrawRefundCorpPercentMax)) {					// 出金（失敗時）（法人）（最高値）
					$this -> popUpSessionMessage(ERROR, 'E_DO_NOT_INPUT', array(VAL_STR_WITHDRAW_REFUND_CORP_PERCENT_MAX));
					$rtn = false;
				}
			}

			if($this -> transferCToB == NO_COUNT) {													// 口座振替フラグ（個人→法人）が固定額の場合

				if(!$this -> checkNull($this -> transferCToBFixValue)) {							// 口座振替（個人→法人）（固定値）
					$this -> popUpSessionMessage(ERROR, 'E_DO_NOT_INPUT', array(VAL_STR_TRANSFER_C_TO_B_FIX_VALUE));
					$rtn = false;
				}
			} else {																				// その他

				if(!$this -> checkNull($this -> transferCToBPercentValue)) {						// 口座振替（個人→法人）（パーセンテージ）
					$this -> popUpSessionMessage(ERROR, 'E_DO_NOT_INPUT', array(VAL_STR_TRANSFER_C_TO_B_PERCENT_VALUE));
					$rtn = false;
				}

				if(!$this -> checkNull($this -> transferCtoBPercentMax)) {							// 口座振替（個人→法人）（最高値）
					$this -> popUpSessionMessage(ERROR, 'E_DO_NOT_INPUT', array(VAL_STR_C_TO_BSFER_C_TO_B_PERCENT_MAX));
					$rtn = false;
				}
			}

			if($this -> transferCToC == NO_COUNT) {													// 口座振替フラグ（個人→個人）が固定額の場合

				if(!$this -> checkNull($this -> transferCToCFixValue)) {							// 口座振替（個人→個人）（固定値）
					$this -> popUpSessionMessage(ERROR, 'E_DO_NOT_INPUT', array(VAL_STR_TRANSFER_C_TO_C_FIX_VALUE));
					$rtn = false;
				}
			} else {																				// その他

				if(!$this -> checkNull($this -> transferCToCPercentValue)) {						// 口座振替（個人→個人）（パーセンテージ）
					$this -> popUpSessionMessage(ERROR, 'E_DO_NOT_INPUT', array(VAL_STR_TRANSFER_C_TO_C_PERCENT_VALUE));
					$rtn = false;
				}

				if(!$this -> checkNull($this -> transferCToCPercentMax)) {							// 口座振替（個人→個人）（最高値）
					$this -> popUpSessionMessage(ERROR, 'E_DO_NOT_INPUT', array(VAL_STR_TRANSFER_C_TO_C_PERCENT_MAX));
					$rtn = false;
				}
			}

			if($this -> transferBToC == NO_COUNT) {													// 口座振替フラグ（法人→個人）が固定額の場合

				if(!$this -> checkNull($this -> transferBToCFixValue)) {							// 口座振替（法人→個人）（固定値）
					$this -> popUpSessionMessage(ERROR, 'E_DO_NOT_INPUT', array(VAL_STR_TRANSFER_B_TO_C_FIX_VALUE));
					$rtn = false;
				}
			} else {																				// その他

				if(!$this -> checkNull($this -> transferBToCPercentValue)) {						// 口座振替（法人→個人）（パーセンテージ）
					$this -> popUpSessionMessage(ERROR, 'E_DO_NOT_INPUT', array(VAL_STR_TRANSFER_B_TO_C_PERCENT_VALUE));
					$rtn = false;
				}

				if(!$this -> checkNull($this -> transferBToCPercentMax)) {							// 口座振替（法人→個人）（最高値）
					$this -> popUpSessionMessage(ERROR, 'E_DO_NOT_INPUT', array(VAL_STR_TRANSFER_B_TO_C_PERCENT_MAX));
					$rtn = false;
				}
			}

			if($this -> transferBToB == NO_COUNT) {													// 口座振替フラグ（法人→法人）が固定額の場合

				if(!$this -> checkNull($this -> transferBToBFixValue)) {							// 口座振替（法人→法人）（固定値）
					$this -> popUpSessionMessage(ERROR, 'E_DO_NOT_INPUT', array(VAL_STR_TRANSFER_B_TO_B_FIX_VALUE));
					$rtn = false;
				}
			} else {																				// その他

				if(!$this -> checkNull($this -> transferBToBPercentValue)) {						// 口座振替（法人→法人）（パーセンテージ）
					$this -> popUpSessionMessage(ERROR, 'E_DO_NOT_INPUT', array(VAL_STR_TRANSFER_B_TO_B_PERCENT_VALUE));
					$rtn = false;
				}

				if(!$this -> checkNull($this -> transferBToBPercentMax)) {							// 口座振替（法人→法人）（最高値）
					$this -> popUpSessionMessage(ERROR, 'E_DO_NOT_INPUT', array(VAL_STR_TRANSFER_B_TO_B_PERCENT_MAX));
					$rtn = false;
				}
			}

			if($this -> domantPerson == NO_COUNT) {													// 休止フラグ（個人）が固定額の場合

				if(!$this -> checkNull($this -> domantPersonFixValue)) {							// 休止（個人）（固定値）
					$this -> popUpSessionMessage(ERROR, 'E_DO_NOT_INPUT', array(VAL_STR_DOMANT_PERSON_FIX_VALUE));
					$rtn = false;
				}
			} else {																				// その他

				if(!$this -> checkNull($this -> domantPersonPercentValue)) {						// 休止（個人）（パーセンテージ）
					$this -> popUpSessionMessage(ERROR, 'E_DO_NOT_INPUT', array(VAL_STR_DOMANT_PERSON_PERCENT_VALUE));
					$rtn = false;
				}

				if(!$this -> checkNull($this -> domantPersonPercentMax)) {							// 休止（個人）（最高値）
					$this -> popUpSessionMessage(ERROR, 'E_DO_NOT_INPUT', array(VAL_STR_DOMANT_PERSON_PERCENT_MAX));
					$rtn = false;
				}
			}

			if($this -> domantCorp == NO_COUNT) {													// 休止フラグ（法人）が固定額の場合

				if(!$this -> checkNull($this -> domantCorpFixValue)) {								// 休止（法人）（固定値）
					$this -> popUpSessionMessage(ERROR, 'E_DO_NOT_INPUT', array(VAL_STR_DOMANT_CORP_FIX_VALUE));
					$rtn = false;
				}
			} else {																				// その他

				if(!$this -> checkNull($this -> domantCorpPercentValue)) {							// 休止（法人）（パーセンテージ）
					$this -> popUpSessionMessage(ERROR, 'E_DO_NOT_INPUT', array(VAL_STR_DOMANT_CORP_PERCENT_VALUE));
					$rtn = false;
				}

				if(!$this -> checkNull($this -> domantCorpPercentMax)) {							// 休止（法人）（最高値）
					$this -> popUpSessionMessage(ERROR, 'E_DO_NOT_INPUT', array(VAL_STR_DOMANT_CORP_PERCENT_MAX));
					$rtn = false;
				}
			}

			if($this -> deletePerson == NO_COUNT) {													// 削除フラグ（個人）が固定額の場合

				if(!$this -> checkNull($this -> deletePersonFixValue)) {							// 削除（個人）（固定値）
					$this -> popUpSessionMessage(ERROR, 'E_DO_NOT_INPUT', array(VAL_STR_DELETE_PERSON_FIX_VALUE));
					$rtn = false;
				}
			} else {																				// その他

				if(!$this -> checkNull($this -> deletePersonPercentValue)) {						// 削除（個人）（パーセンテージ）
					$this -> popUpSessionMessage(ERROR, 'E_DO_NOT_INPUT', array(VAL_STR_DELETE_PERSON_PERCENT_VALUE));
					$rtn = false;
				}

				if(!$this -> checkNull($this -> deletePersonPercentMax)) {							// 削除（個人）（最高値）
					$this -> popUpSessionMessage(ERROR, 'E_DO_NOT_INPUT', array(VAL_STR_DELETE_PERSON_PERCENT_MAX));
					$rtn = false;
				}
			}

			if($this -> deleteCorp == NO_COUNT) {													// 削除フラグ（法人）が固定額の場合

				if(!$this -> checkNull($this -> deleteCorpFixValue)) {								// 削除（法人）（固定値）
					$this -> popUpSessionMessage(ERROR, 'E_DO_NOT_INPUT', array(VAL_STR_DELETE_CORP_FIX_VALUE));
					$rtn = false;
				}
			} else {																				// その他

				if(!$this -> checkNull($this -> deleteCorpPercentValue)) {							// 削除（法人）（パーセンテージ）
					$this -> popUpSessionMessage(ERROR, 'E_DO_NOT_INPUT', array(VAL_STR_DELETE_CORP_PERCENT_VALUE));
					$rtn = false;
				}

				if(!$this -> checkNull($this -> deleteCorpPercentMax)) {							// 削除（法人）（最高値）
					$this -> popUpSessionMessage(ERROR, 'E_DO_NOT_INPUT', array(VAL_STR_DELETE_CORP_PERCENT_MAX));
					$rtn = false;
				}
			}

			if(!$rtn) {
				$this -> setType(TYPE_INPUT);
				return;
			}

			// 正規表現のチェック
			if($this -> monthlyPerson == NO_COUNT) {												// 月額維持フラグ（個人）が固定額の場合

				if(!$this -> checkStringNumber($this -> monthlyPersonFixValue)) {					// 月額維持（個人）（固定値）
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_VALUE_PREG', array(VAL_STR_MONTHLY_PERSON_FIX_VALUE));
					$rtn = false;
				}
			} else {																				// その他

				if(!$this -> checkStringNumber($this -> monthlyPersonPercentValue)) {				// 月額維持（個人）（パーセンテージ）
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_VALUE_PREG', array(VAL_STR_MONTHLY_PERSON_PERCENT_VALUE));
					$rtn = false;
				}

				if(!$this -> checkStringNumber($this -> monthlyPersonPercentMax)) {					// 月額維持（個人）（最高値）
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_VALUE_PREG', array(VAL_STR_MONTHLY_PERSON_PERCENT_MAX));
					$rtn = false;
				}
			}

			if($this -> monthlyCorp == NO_COUNT) {													// 月額維持フラグ（法人）が固定額の場合

				if(!$this -> checkStringNumber($this -> monthlyCorpFixValue)) {								// 月額維持（法人）（固定値）
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_VALUE_PREG', array(VAL_STR_MONTHLY_CORP_FIX_VALUE));
					$rtn = false;
				}
			} else {																				// その他

				if(!$this -> checkStringNumber($this -> monthlyCorpPercentValue)) {							// 月額維持（法人）（パーセンテージ）
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_VALUE_PREG', array(VAL_STR_MONTHLY_CORP_PERCENT_VALUE));
					$rtn = false;
				}

				if(!$this -> checkStringNumber($this -> monthlyCorpPercentMax)) {							// 月額維持（法人）（最高値）
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_VALUE_PREG', array(VAL_STR_MONTHLY_CORP_PERCENT_MAX));
					$rtn = false;
				}
			}

			if($this -> depositPerson == NO_COUNT) {												// 入金フラグ（個人）が固定額の場合

				if(!$this -> checkStringNumber($this -> depositPersonFixValue)) {							// 入金（個人）（固定値）
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_VALUE_PREG', array(VAL_STR_DEPOSIT_PERSON_FIX_VALUE));
					$rtn = false;
				}
			} else {																				// その他

				if(!$this -> checkStringNumber($this -> depositPersonPercentValue)) {						// 入金（個人）（パーセンテージ）
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_VALUE_PREG', array(VAL_STR_DEPOSIT_PERSON_PERCENT_VALUE));
					$rtn = false;
				}

				if(!$this -> checkStringNumber($this -> depositPersonPercentMax)) {							// 入金（個人）（最高値）
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_VALUE_PREG', array(VAL_STR_DEPOSIT_PERSON_PERCENT_MAX));
					$rtn = false;
				}
			}

			if($this -> depositCorp == NO_COUNT) {													// 入金フラグ（法人）が固定額の場合

				if(!$this -> checkStringNumber($this -> depositCorpFixValue)) {								// 入金（法人）（固定値）
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_VALUE_PREG', array(VAL_STR_DEPOSIT_CORP_FIX_VALUE));
					$rtn = false;
				}
			} else {																				// その他

				if(!$this -> checkStringNumber($this -> depositCorpPercentValue)) {							// 入金（法人）（パーセンテージ）
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_VALUE_PREG', array(VAL_STR_DEPOSIT_CORP_PERCENT_VALUE));
					$rtn = false;
				}

				if(!$this -> checkStringNumber($this -> depositCorpPercentMax)) {							// 入金フラグ（法人）（最高値）
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_VALUE_PREG', array(VAL_STR_DEPOSIT_CORP_PERCENT_MAX));
					$rtn = false;
				}
			}

			if($this -> withdrawSuccessPerson == NO_COUNT) {										// 出金フラグ（成功時）（個人）が固定額の場合

				if(!$this -> checkStringNumber($this -> withdrawSuccessPersonFixValue)) {					// 出金（成功時）（個人）（固定値）
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_VALUE_PREG', array(VAL_STR_WITHDRAW_SUCCESS_PERSON_FIX_VALUE));
					$rtn = false;
				}
			} else {																				// その他

				if(!$this -> checkStringNumber($this -> withdrawSuccessPersonPercentValue)) {				// 出金（成功時）（個人）（パーセンテージ）
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_VALUE_PREG', array(VAL_STR_WITHDRAW_SUCCESS_PERSON_PERCENT_VALUE));
					$rtn = false;
				}

				if(!$this -> checkStringNumber($this -> withdrawSuccessPersonPercentMax)) {					// 出金（成功時）（個人）（最高値）
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_VALUE_PREG', array(VAL_STR_WITHDRAW_SUCCESS_PERSON_PERCENT_MAX));
					$rtn = false;
				}
			}

			if($this -> withdrawSuccessCorp == NO_COUNT) {											// 出金フラグ（成功時）（法人）が固定額の場合

				if(!$this -> checkStringNumber($this -> withdrawSuccessCorpFixValue)) {						// 出金（成功時）（法人）（固定値）
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_VALUE_PREG', array(VAL_STR_WITHDRAW_SUCCESS_CORP_FIX_VALUE));
					$rtn = false;
				}
			} else {																				// その他

				if(!$this -> checkStringNumber($this -> withdrawSuccessCorpPercentValue)) {					// 出金（成功時）（法人）（パーセンテージ）
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_VALUE_PREG', array(VAL_STR_WITHDRAW_SUCCESS_CORP_PERCENT_VALUE));
					$rtn = false;
				}

				if(!$this -> checkStringNumber($this -> withdrawSuccessCorpPercentMax)) {					// 出金（成功時）（法人）（最高値）
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_VALUE_PREG', array(VAL_STR_WITHDRAW_SUCCESS_CORP_PERCENT_MAX));
					$rtn = false;
				}
			}

			if($this -> withdrawRefundPerson == NO_COUNT) {											// 出金フラグ（失敗時）（個人）が固定額の場合

				if(!$this -> checkStringNumber($this -> withdrawRefundPersonFixValue)) {					// 出金（失敗時）（個人）（固定値）
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_VALUE_PREG', array(VAL_STR_WITHDRAW_REFUND_PERSON_FIX_VALUE));
					$rtn = false;
				}
			} else {																				// その他

				if(!$this -> checkStringNumber($this -> withdrawRefundPersonPercentValue)) {				// 出金（失敗時）（個人）（パーセンテージ）
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_VALUE_PREG', array(VAL_STR_WITHDRAW_REFUND_PERSON_PERCENT_VALUE));
					$rtn = false;
				}

				if(!$this -> checkStringNumber($this -> withdrawRefundPersonPercentMax)) {					// 出金（失敗時）（個人）（最高値）
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_VALUE_PREG', array(VAL_STR_WITHDRAW_REFUND_PERSON_PERCENT_MAX));
					$rtn = false;
				}
			}

			if($this -> withdrawRefundCorp == NO_COUNT) {											// 出金フラグ（失敗時）（法人）が固定額の場合

				if(!$this -> checkStringNumber($this -> withdrawRefundCorpFixValue)) {						// 出金（失敗時）（法人）（固定値）
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_VALUE_PREG', array(VAL_STR_WITHDRAW_REFUND_CORP_FIX_VALUE));
					$rtn = false;
				}
			} else {																				// その他

				if(!$this -> checkStringNumber($this -> withdrawRefundCorpPercentValue)) {					// 出金（失敗時）（法人）（パーセンテージ）
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_VALUE_PREG', array(VAL_STR_WITHDRAW_REFUND_CORP_PERCENT_VALUE));
					$rtn = false;
				}

				if(!$this -> checkStringNumber($this -> withdrawRefundCorpPercentMax)) {					// 出金（失敗時）（法人）（最高値）
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_VALUE_PREG', array(VAL_STR_WITHDRAW_REFUND_CORP_PERCENT_MAX));
					$rtn = false;
				}
			}

			if($this -> transferCToB == NO_COUNT) {													// 口座振替フラグ（個人→法人）が固定額の場合

				if(!$this -> checkStringNumber($this -> transferCToBFixValue)) {							// 口座振替（個人→法人）（固定値）
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_VALUE_PREG', array(VAL_STR_TRANSFER_C_TO_B_FIX_VALUE));
					$rtn = false;
				}
			} else {																				// その他

				if(!$this -> checkStringNumber($this -> transferCToBPercentValue)) {						// 口座振替（個人→法人）（パーセンテージ）
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_VALUE_PREG', array(VAL_STR_TRANSFER_C_TO_B_PERCENT_VALUE));
					$rtn = false;
				}

				if(!$this -> checkStringNumber($this -> transferCtoBPercentMax)) {							// 口座振替（個人→法人）（最高値）
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_VALUE_PREG', array(VAL_STR_C_TO_BSFER_C_TO_B_PERCENT_MAX));
					$rtn = false;
				}
			}

			if($this -> transferCToC == NO_COUNT) {													// 口座振替フラグ（個人→個人）が固定額の場合

				if(!$this -> checkStringNumber($this -> transferCToCFixValue)) {							// 口座振替（個人→個人）（固定値）
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_VALUE_PREG', array(VAL_STR_TRANSFER_C_TO_C_FIX_VALUE));
					$rtn = false;
				}
			} else {																				// その他

				if(!$this -> checkStringNumber($this -> transferCToCPercentValue)) {						// 口座振替（個人→個人）（パーセンテージ）
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_VALUE_PREG', array(VAL_STR_TRANSFER_C_TO_C_PERCENT_VALUE));
					$rtn = false;
				}

				if(!$this -> checkStringNumber($this -> transferCToCPercentMax)) {							// 口座振替（個人→個人）（最高値）
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_VALUE_PREG', array(VAL_STR_TRANSFER_C_TO_C_PERCENT_MAX));
					$rtn = false;
				}
			}

			if($this -> transferBToC == NO_COUNT) {													// 口座振替フラグ（法人→個人）が固定額の場合

				if(!$this -> checkStringNumber($this -> transferBToCFixValue)) {							// 口座振替（法人→個人）（固定値）
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_VALUE_PREG', array(VAL_STR_TRANSFER_B_TO_C_FIX_VALUE));
					$rtn = false;
				}
			} else {																				// その他

				if(!$this -> checkStringNumber($this -> transferBToCPercentValue)) {						// 口座振替（法人→個人）（パーセンテージ）
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_VALUE_PREG', array(VAL_STR_TRANSFER_B_TO_C_PERCENT_VALUE));
					$rtn = false;
				}

				if(!$this -> checkStringNumber($this -> transferBToCPercentMax)) {							// 口座振替（法人→個人）（最高値）
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_VALUE_PREG', array(VAL_STR_TRANSFER_B_TO_C_PERCENT_MAX));
					$rtn = false;
				}
			}

			if($this -> transferBToB == NO_COUNT) {													// 口座振替フラグ（法人→法人）が固定額の場合

				if(!$this -> checkStringNumber($this -> transferBToBFixValue)) {							// 口座振替（法人→法人）（固定値）
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_VALUE_PREG', array(VAL_STR_TRANSFER_B_TO_B_FIX_VALUE));
					$rtn = false;
				}
			} else {																				// その他

				if(!$this -> checkStringNumber($this -> transferBToBPercentValue)) {						// 口座振替（法人→法人）（パーセンテージ）
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_VALUE_PREG', array(VAL_STR_TRANSFER_B_TO_B_PERCENT_VALUE));
					$rtn = false;
				}

				if(!$this -> checkStringNumber($this -> transferBToBPercentMax)) {							// 口座振替（法人→法人）（最高値）
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_VALUE_PREG', array(VAL_STR_TRANSFER_B_TO_B_PERCENT_MAX));
					$rtn = false;
				}
			}

			if($this -> domantPerson == NO_COUNT) {													// 休止フラグ（個人）が固定額の場合

				if(!$this -> checkStringNumber($this -> domantPersonFixValue)) {							// 休止（個人）（固定値）
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_VALUE_PREG', array(VAL_STR_DOMANT_PERSON_FIX_VALUE));
					$rtn = false;
				}
			} else {																				// その他

				if(!$this -> checkStringNumber($this -> domantPersonPercentValue)) {						// 休止（個人）（パーセンテージ）
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_VALUE_PREG', array(VAL_STR_DOMANT_PERSON_PERCENT_VALUE));
					$rtn = false;
				}

				if(!$this -> checkStringNumber($this -> domantPersonPercentMax)) {							// 休止（個人）（最高値）
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_VALUE_PREG', array(VAL_STR_DOMANT_PERSON_PERCENT_MAX));
					$rtn = false;
				}
			}

			if($this -> domantCorp == NO_COUNT) {													// 休止フラグ（法人）が固定額の場合

				if(!$this -> checkStringNumber($this -> domantCorpFixValue)) {								// 休止（法人）（固定値）
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_VALUE_PREG', array(VAL_STR_DOMANT_CORP_FIX_VALUE));
					$rtn = false;
				}
			} else {																				// その他

				if(!$this -> checkStringNumber($this -> domantCorpPercentValue)) {							// 休止（法人）（パーセンテージ）
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_VALUE_PREG', array(VAL_STR_DOMANT_CORP_PERCENT_VALUE));
					$rtn = false;
				}

				if(!$this -> checkStringNumber($this -> domantCorpPercentMax)) {							// 休止（法人）（最高値）
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_VALUE_PREG', array(VAL_STR_DOMANT_CORP_PERCENT_MAX));
					$rtn = false;
				}
			}

			if($this -> deletePerson == NO_COUNT) {													// 削除フラグ（個人）が固定額の場合

				if(!$this -> checkStringNumber($this -> deletePersonFixValue)) {							// 削除（個人）（固定値）
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_VALUE_PREG', array(VAL_STR_DELETE_PERSON_FIX_VALUE));
					$rtn = false;
				}
			} else {																				// その他

				if(!$this -> checkStringNumber($this -> deletePersonPercentValue)) {						// 削除（個人）（パーセンテージ）
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_VALUE_PREG', array(VAL_STR_DELETE_PERSON_PERCENT_VALUE));
					$rtn = false;
				}

				if(!$this -> checkStringNumber($this -> deletePersonPercentMax)) {							// 削除（個人）（最高値）
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_VALUE_PREG', array(VAL_STR_DELETE_PERSON_PERCENT_MAX));
					$rtn = false;
				}
			}

			if($this -> deleteCorp == NO_COUNT) {													// 削除フラグ（法人）が固定額の場合

				if(!$this -> checkStringNumber($this -> deleteCorpFixValue)) {								// 削除（法人）（固定値）
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_VALUE_PREG', array(VAL_STR_DELETE_CORP_FIX_VALUE));
					$rtn = false;
				}
			} else {																				// その他

				if(!$this -> checkStringNumber($this -> deleteCorpPercentValue)) {							// 削除（法人）（パーセンテージ）
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_VALUE_PREG', array(VAL_STR_DELETE_CORP_PERCENT_VALUE));
					$rtn = false;
				}

				if(!$this -> checkStringNumber($this -> deleteCorpPercentMax)) {							// 削除（法人）（最高値）
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_VALUE_PREG', array(VAL_STR_DELETE_CORP_PERCENT_MAX));
					$rtn = false;
				}
			}

			if($this -> cardDepositPerson == NO_COUNT) {													// カード入金フラグ（個人）が固定額の場合

				if(!$this -> checkStringNumber($this -> cardDepositPersonFixValue)) {				// カード入金（個人）（固定値）
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_VALUE_PREG', array(VAR_STR_CARD_DEPOSIT_INDIVIDUAL_DEFINITE));
					$rtn = false;
				}
			} else {																				// その他

				if(!$this -> checkStringNumber($this -> cardDepositPersonPercentValue)) {			// カード入金（個人）（パーセンテージ）
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_VALUE_PREG', array(VAR_STR_CARD_DEPOSIT_INDIVIDUAL_PERCENTAGE));
					$rtn = false;
				}

				if(!$this -> checkStringNumber($this -> cardDepositPersonPercentMax)) {				// カード入金（個人）（最高値）
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_VALUE_PREG', array(VAR_STR_CARD_DEPOSIT_INDIVIDUAL_MAXIMUM));
					$rtn = false;
				}
			}

			if($this -> cardDepositCorp == NO_COUNT) {													// カード入金フラグ（法人）が固定額の場合

				if(!$this -> checkStringNumber($this -> cardDepositCorpFixValue)) {					// カード入金（法人）（固定値）
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_VALUE_PREG', array(VAR_STR_CARD_DEPOSIT_CORPORATE_DEFINITE));
					$rtn = false;
				}
			} else {																				// その他

				if(!$this -> checkStringNumber($this -> cardDepositCorpPercentValue)) {				// カード入金（法人）（パーセンテージ）
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_VALUE_PREG', array(VAR_STR_CARD_DEPOSIT_CORPORATE_PERCENTAGE));
					$rtn = false;
				}

				if(!$this -> checkStringNumber($this -> cardDepositCorpPercentMax)) {				// カード入金（法人）（最高値）
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_VALUE_PREG', array(VAR_STR_CARD_DEPOSIT_CORPORATE_MAXIMUM));
					$rtn = false;
				}
			}

			// パターン名の重複は不可
			if(!$this -> checkMstFeesTargetName($this -> name, $this -> fId)) {	// ターゲット名のチェック
				$this -> popUpSessionMessage(ERROR, 'E_NO_SUCH_ANYTHING_DATA', array(VAL_STR_PATTERN_NAME, $this -> name));
				$rtn = false;
			}

			// 新規登録の場合
			if($this -> getType() == TYPE_REGITS) {

				// 全適用の重複は不可
				if(!$this -> checkMstFeesTargetAll($this -> feeType)) {	// ターゲットのチェック
					$this -> popUpSessionMessage(ERROR, 'E_DO_NOT_OVERLAP', array(VAL_STR_TARGET_ALL));
					$rtn = false;
				}
			}

			if(!$rtn) {
				$this -> setType(TYPE_INPUT);
				return;
			}

			$this -> feeType = $this -> getDataPost(PARAM_FEE_TYPE);									// 手数料種別
		}
	}
	
	/*-------------------------------------------------------------------------
	* @function_name: HTML表示用のデータ取得関数
	* @parameter	: なし
	* @return		: HTML表示用データ配列
	-------------------------------------------------------------------------*/
	public function dispHTML() {
		return array();
	}

	/*-------------------------------------------------------------------------
	* @function_name: 決済セットの設定（口座一覧）
	* @parameter	: 結果セット
	* @return		: なし
	-------------------------------------------------------------------------*/
	function setFees($rs) {
		$this -> fees = $rs;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 手数料IDの取得
	* @parameter	: なし
	* @return		: 手数料ID
	-------------------------------------------------------------------------*/
	function getFId() {
		return $this -> fId;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 手数料IDの設定
	* @parameter	: 手数料ID
	* @return		: なし
	-------------------------------------------------------------------------*/
	function setFId($fId) {
		$this -> fId = $fId;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 手数料名の取得
	* @parameter	: なし
	* @return		: 手数料名
	-------------------------------------------------------------------------*/
	function getName() {
		return $this -> name;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 手数料名の設定
	* @parameter	: 手数料名
	* @return		: なし
	-------------------------------------------------------------------------*/
	function setName($name) {
		$this -> name = $name;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 手数料種別の取得
	* @parameter	: なし
	* @return		: 手数料種別
	-------------------------------------------------------------------------*/
	function getFeeType() {
		return $this -> feeType;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 手数料種別の設定
	* @parameter	: 手数料種別
	* @return		: なし
	-------------------------------------------------------------------------*/
	function setFeeType($feeType) {
		$this -> feeType = $feeType;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 手数料種別の表示
	* @parameter	: なし
	* @return		: 手数料種別
	-------------------------------------------------------------------------*/
	function echoFeeType() {

		// 変数宣言部
		$rtn	= NO_STRING;
		$lists	= array();

		// タイプによって表示形式を変える
		if($this -> fId != NO_STRING) {		// 修正の場合
			if($this -> getFeeType() == VAL_INT_1) {
				$rtn = VAL_FEE_ADMIN_INDAPP;
			} else {
				$rtn = VAL_FEE_ADMIN_ALLAPP;
			}

			// タイプ設定
			$rtn .= '<input type="hidden" name="fee_type" value="' . $this -> getFeeType() . '" />';

		} else {							// 新規登録の場合

			$lists[]	= array(PARAM_DATA_KEY		=> NO_COUNT
								, PARAM_DATA_VALUE	=> VAL_FEE_ADMIN_ALLAPP);
			$lists[]	= array(PARAM_DATA_KEY		=> VAL_INT_1
								, PARAM_DATA_VALUE	=> VAL_FEE_ADMIN_INDAPP);

			$rtn = '<select name="fee_type">' . $this -> dispListOption($lists, $this -> getFeeType()) . '</select>';
		}

		echo $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 手数料登録用パラメータの取得
	* @parameter	: なし
	* @return		: 登録用配列
	-------------------------------------------------------------------------*/
	function getRegistFees() {

		// 変数宣言部
		$rtn = array();

		$rtn[] = $this -> getFId();
		$rtn[] = $this -> getName();
		$rtn[] = $this -> getFeeType();

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 手数料詳細登録用パラメータの取得
	* @parameter	: なし
	* @return		: 登録用配列
	-------------------------------------------------------------------------*/
	function getRegistFeesDetail($mFId, $walletType) {

		// 変数宣言部
		$rtn = array();

		$rtn[] = $this -> getFId();
		$rtn[] = $mFId;
		$rtn[] = $walletType;

		if($mFId					== VAR_MONTHLY
			&& $walletType			== VAR_FEE_PERSON) {	// 月額（個人）

			$rtn[] = $this -> monthlyPerson;
			$rtn[] = $this -> currencyToInt($this -> monthlyPersonFixValue, USD);
			$rtn[] = $this -> currencyToInt($this -> monthlyPersonPercentValue, PERCENT);
			$rtn[] = $this -> currencyToInt($this -> monthlyPersonPercentMax, USD);
			$rtn[] = NO_COUNT;
			$rtn[] = NO_COUNT;

		} else if($mFId				== VAR_MONTHLY
					&& $walletType	== VAR_FEE_CORP) {		// 月額（法人）

			$rtn[] = $this -> monthlyCorp;
			$rtn[] = $this -> currencyToInt($this -> monthlyCorpFixValue, USD);
			$rtn[] = $this -> currencyToInt($this -> monthlyCorpPercentValue, PERCENT);
			$rtn[] = $this -> currencyToInt($this -> monthlyCorpPercentMax, USD);
			$rtn[] = NO_COUNT;
			$rtn[] = NO_COUNT;

		} else if($mFId				== VAR_DEPOSIT
					&& $walletType	== VAR_FEE_PERSON) {	// 入金（個人）

			$rtn[] = $this -> depositPerson;
			$rtn[] = $this -> currencyToInt($this -> depositPersonFixValue, USD);
			$rtn[] = $this -> currencyToInt($this -> depositPersonPercentValue, PERCENT);
			$rtn[] = $this -> currencyToInt($this -> depositPersonPercentMax, USD);
			$rtn[] = NO_COUNT;
			$rtn[] = NO_COUNT;

		} else if($mFId				== VAR_DEPOSIT
					&& $walletType	== VAR_FEE_CORP) {		// 入金（個人）

			$rtn[] = $this -> depositCorp;
			$rtn[] = $this -> currencyToInt($this -> depositCorpFixValue, USD);
			$rtn[] = $this -> currencyToInt($this -> depositCorpPercentValue, PERCENT);
			$rtn[] = $this -> currencyToInt($this -> depositCorpPercentMax, USD);
			$rtn[] = NO_COUNT;
			$rtn[] = NO_COUNT;

		} else if($mFId				== VAR_WITHDRAW_SUCCESS
					&& $walletType	== VAR_FEE_PERSON) {	// 出金成功（個人）

			if($this -> withdrawSuccessPerson1			== VAL_INT_1
				&& $this -> withdrawSuccessPerson2		== VAL_INT_2) {
				$rtn[] = VAL_INT_2;
			} else if($this -> withdrawSuccessPerson2	== VAL_INT_2) {
				$rtn[] = VAL_INT_1;
			} else {
				$rtn[] = NO_COUNT;
			}

			$rtn[] = $this -> currencyToInt($this -> withdrawSuccessPersonFixValue, USD);
			$rtn[] = $this -> currencyToInt($this -> withdrawSuccessPersonPercentValue, PERCENT);
			$rtn[] = $this -> currencyToInt($this -> withdrawSuccessPersonPercentMax, USD);
			$rtn[] = $this -> currencyToInt($this -> withdrawSuccessPersonPercentMin, USD);
			$rtn[] = NO_COUNT;

		} else if($mFId				== VAR_WITHDRAW_SUCCESS
					&& $walletType	== VAR_FEE_CORP) {		// 出金成功（法人）

			if($this -> withdrawSuccessCorp1		== VAL_INT_1
				&& $this -> withdrawSuccessCorp2	== VAL_INT_2) {
				$rtn[] = VAL_INT_2;
			} else if($this -> withdrawSuccessCorp2	== VAL_INT_2) {
				$rtn[] = VAL_INT_1;
			} else {
				$rtn[] = NO_COUNT;
			}

			$rtn[] = $this -> currencyToInt($this -> withdrawSuccessCorpFixValue, USD);
			$rtn[] = $this -> currencyToInt($this -> withdrawSuccessCorpPercentValue, PERCENT);
			$rtn[] = $this -> currencyToInt($this -> withdrawSuccessCorpPercentMax, USD);
			$rtn[] = $this -> currencyToInt($this -> withdrawSuccessCorpPercentMin, USD);
			$rtn[] = NO_COUNT;

		} else if($mFId				== VAR_WITHDRAW_REFUND
					&& $walletType	== VAR_FEE_PERSON) {	// 出金失敗（個人）

			if($this -> withdrawRefundPerson1			== VAL_INT_1
				&& $this -> withdrawRefundPerson2		== VAL_INT_2) {
				$rtn[] = VAL_INT_2;
			} else if($this -> withdrawRefundPerson2	== VAL_INT_2) {
				$rtn[] = VAL_INT_1;
			} else {
				$rtn[] = NO_COUNT;
			}

			$rtn[] = $this -> currencyToInt($this -> withdrawRefundPersonFixValue, USD);
			$rtn[] = $this -> currencyToInt($this -> withdrawRefundPersonPercentValue, PERCENT);
			$rtn[] = $this -> currencyToInt($this -> withdrawRefundPersonPercentMax, USD);
			$rtn[] = $this -> currencyToInt($this -> withdrawRefundPersonPercentMin, USD);
			$rtn[] = NO_COUNT;

		} else if($mFId				== VAR_WITHDRAW_REFUND
					&& $walletType	== VAR_FEE_CORP) {		// 出金失敗（法人）

			if($this -> withdrawRefundCorp1			== VAL_INT_1
				&& $this -> withdrawRefundCorp2		== VAL_INT_2) {
				$rtn[] = VAL_INT_2;
			} else if($this -> withdrawRefundCorp2	== VAL_INT_2) {
				$rtn[] = VAL_INT_1;
			} else {
				$rtn[] = NO_COUNT;
			}

			$rtn[] = $this -> currencyToInt($this -> withdrawRefundCorpFixValue, USD);
			$rtn[] = $this -> currencyToInt($this -> withdrawRefundCorpPercentValue, PERCENT);
			$rtn[] = $this -> currencyToInt($this -> withdrawRefundCorpPercentMax, USD);
			$rtn[] = $this -> currencyToInt($this -> withdrawRefundCorpPercentMin, USD);
			$rtn[] = NO_COUNT;

		} else if($mFId				== VAR_TRANSFER
					&& $walletType	== VAR_C_TO_B) {	// 口座振替（個人→法人）

			$rtn[] = $this -> transferCToB;
			$rtn[] = $this -> currencyToInt($this -> transferCToBFixValue, USD);
			$rtn[] = $this -> currencyToInt($this -> transferCToBPercentValue, PERCENT);
			$rtn[] = $this -> currencyToInt($this -> transferCtoBPercentMax, USD);
			$rtn[] = NO_COUNT;
			$rtn[] = intval($this -> transferCToBAppFlg);

		} else if($mFId				== VAR_TRANSFER
					&& $walletType	== VAR_C_TO_C) {	// 口座振替（個人→個人）

			$rtn[] = $this -> transferCToC;
			$rtn[] = $this -> currencyToInt($this -> transferCToCFixValue, USD);
			$rtn[] = $this -> currencyToInt($this -> transferCToCPercentValue, PERCENT);
			$rtn[] = $this -> currencyToInt($this -> transferCToCPercentMax, USD);
			$rtn[] = NO_COUNT;
			$rtn[] = intval($this -> transferCToCAppFlg);

		} else if($mFId				== VAR_TRANSFER
					&& $walletType	== VAR_B_TO_C) {	// 口座振替（法人→個人）

			$rtn[] = $this -> transferBToC;
			$rtn[] = $this -> currencyToInt($this -> transferBToCFixValue, USD);
			$rtn[] = $this -> currencyToInt($this -> transferBToCPercentValue, PERCENT);
			$rtn[] = $this -> currencyToInt($this -> transferBToCPercentMax, USD);
			$rtn[] = NO_COUNT;
			$rtn[] = intval($this -> transferBToCAppFlg);

		} else if($mFId				== VAR_TRANSFER
					&& $walletType	== VAR_B_TO_B) {	// 口座振替（法人→法人）

			$rtn[] = $this -> transferBToB;
			$rtn[] = $this -> currencyToInt($this -> transferBToBFixValue, USD);
			$rtn[] = $this -> currencyToInt($this -> transferBToBPercentValue, PERCENT);
			$rtn[] = $this -> currencyToInt($this -> transferBToBPercentMax, USD);
			$rtn[] = NO_COUNT;
			$rtn[] = intval($this -> transferBToBAppFlg);

		} else if($mFId				== VAR_DOMANT
					&& $walletType	== VAR_FEE_PERSON) {	// 休止（個人）

			$rtn[] = $this -> domantPerson;
			$rtn[] = $this -> currencyToInt($this -> domantPersonFixValue, USD);
			$rtn[] = $this -> currencyToInt($this -> domantPersonPercentValue, PERCENT);
			$rtn[] = $this -> currencyToInt($this -> domantPersonPercentMax, USD);
			$rtn[] = NO_COUNT;
			$rtn[] = NO_COUNT;

		} else if($mFId				== VAR_DOMANT
					&& $walletType	== VAR_FEE_CORP) {		// 休止（法人）

			$rtn[] = $this -> domantCorp;
			$rtn[] = $this -> currencyToInt($this -> domantCorpFixValue, USD);
			$rtn[] = $this -> currencyToInt($this -> domantCorpPercentValue, PERCENT);
			$rtn[] = $this -> currencyToInt($this -> domantCorpPercentMax, USD);
			$rtn[] = NO_COUNT;
			$rtn[] = NO_COUNT;

		} else if($mFId				== VAR_DELETE
					&& $walletType	== VAR_FEE_PERSON) {	// 削除（個人）

			$rtn[] = $this -> deletePerson;
			$rtn[] = $this -> currencyToInt($this -> deletePersonFixValue, USD);
			$rtn[] = $this -> currencyToInt($this -> deletePersonPercentValue, PERCENT);
			$rtn[] = $this -> currencyToInt($this -> deletePersonPercentMax, USD);
			$rtn[] = NO_COUNT;
			$rtn[] = NO_COUNT;

		} else if($mFId				== VAR_DELETE
					&& $walletType	== VAR_FEE_CORP) {		// 削除（法人）

			$rtn[] = $this -> deleteCorp;
			$rtn[] = $this -> currencyToInt($this -> deleteCorpFixValue, USD);
			$rtn[] = $this -> currencyToInt($this -> deleteCorpPercentValue, PERCENT);
			$rtn[] = $this -> currencyToInt($this -> deleteCorpPercentMax, USD);
			$rtn[] = NO_COUNT;
			$rtn[] = NO_COUNT;

		} else if($mFId				== VAR_CARD_DEPOSIT
					&& $walletType	== VAR_FEE_PERSON) {	// カード入金（個人）

				$rtn[] = $this -> cardDepositPerson;
				$rtn[] = $this -> currencyToInt($this -> cardDepositPersonFixValue, USD);
				$rtn[] = $this -> currencyToInt($this -> cardDepositPersonPercentValue, PERCENT);
				$rtn[] = $this -> currencyToInt($this -> cardDepositPersonPercentMax, USD);
				$rtn[] = NO_COUNT;
				$rtn[] = NO_COUNT;

		} else if($mFId				== VAR_CARD_DEPOSIT
					&& $walletType	== VAR_FEE_CORP) {		// カード入金（法人）

				$rtn[] = $this -> cardDepositCorp;
				$rtn[] = $this -> currencyToInt($this -> cardDepositCorpFixValue, USD);
				$rtn[] = $this -> currencyToInt($this -> cardDepositCorpPercentValue, PERCENT);
				$rtn[] = $this -> currencyToInt($this -> cardDepositCorpPercentMax, USD);
				$rtn[] = NO_COUNT;
				$rtn[] = NO_COUNT;

		} else {										// その他の場合
			$rtn[] = NO_COUNT;
			$rtn[] = NO_COUNT;
			$rtn[] = NO_COUNT;
			$rtn[] = NO_COUNT;
			$rtn[] = NO_COUNT;
			$rtn[] = NO_COUNT;
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 手数料一覧の表示
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function echoList() {

		// 変数宣言部
		$rtn		= NO_STRING;
		$feeType	= NO_STRING;

		if($this -> isLoopData($this -> fees)) {

			
			// データの数だけループを回す
			foreach($this -> fees as $row) {

				// 手数料種別
				if($this -> getColumnData($row, COLUMN_FEE_TYPE) == NO_COUNT) {
					$feeType = VAL_FEE_ADMIN_ALLAPP;
				} else {
					$feeType = VAL_FEE_ADMIN_INDAPP;
				}

				$rtn	.= '<tr>'
						. '<td >' . $this -> getColumnData($row, COLUMN_FEE_TYPE_NAME) . '</td>'
						. '<td >' . $feeType . '</td>'
						. '<td class="blocka"><a href="javascript:actionEdit(\'' . $this -> getColumnData($row, COLUMN_F_ID) . '\');"><span class="fa fa-edit fa-lg"></span></a></td>'
						. '<td class="blocka"><a href="javascript:actionDelete(\'' . $this -> getColumnData($row, COLUMN_F_ID) . '\');"><span class="fa fa-trash fa-lg"></span></a></td>'
						. '</tr>';
			}

		} else {
			$rtn = '<tr><td colspan="4">' . $this -> getMessage(INFO, 'I_NO_SUCHE_SEARCH_DATA', array()) . '</td></tr>';
		}

		echo $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 結果セットよりデータを取得する
	* @parameter	: マスタID、ウォレットタイプ、取得タイプ
	* @return		: 値
	-------------------------------------------------------------------------*/
	function getValueFromFees($mFId
								, $wType
								, $valType
								, $val = NO_COUNT) {

		// 変数宣言部
		$rtn = NO_STRING;

		// データの存在確認
		if($this -> isLoopData($this -> fees)) {

			foreach($this -> fees as $row) {

				if($this -> getColumnData($row, COLUMN_M_F_ID)			== $mFId
					&& $this -> getColumnData($row, COLUMN_WALLET_TYPE)	== $wType) {

					// 実数値とパーセント値での振り分け
					if(COLUMN_FEE_FLG == $valType) {		// フラグの場合
						$rtn = intval($this -> getColumnData($row, $valType));

					} else if(COLUMN_APP_FLG == $valType) {	// 適用フラグの場合
						$rtn = intval($this -> getColumnData($row, $valType));

					} else if(COLUMN_PERCENT == $valType) {	// パーセントの場合
						$rtn = $this -> intToCurrency(intval($this -> getColumnData($row, $valType)), PERCENT) ;

					} else {								// 通貨
						$rtn = $this -> intToCurrency(intval($this -> getColumnData($row, $valType)), USD) ;
					}

					break;
				}
			}
		} else {
			$rtn = $val;
		}

		return $rtn;
	}


	/*-------------------------------------------------------------------------
	* @function_name: 月額維持（個人）（固定値）の取得
	* @parameter	: なし
	* @return		: 月額維持（個人）（固定値）
	-------------------------------------------------------------------------*/
	function getMonthlyPersonFixValue() {
		return $this -> getValueFromFees(VAR_MONTHLY
										, VAR_FEE_PERSON
										, COLUMN_FIX
										, $this -> monthlyPersonFixValue);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 月額維持（個人）（パーセンテージ）の取得
	* @parameter	: なし
	* @return		: 月額維持（個人）（パーセンテージ）
	-------------------------------------------------------------------------*/
	function getMonthlyPersonPercentValue() {
		return $this -> getValueFromFees(VAR_MONTHLY
										, VAR_FEE_PERSON
										, COLUMN_PERCENT
										, $this -> monthlyPersonPercentValue);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 月額維持（個人）（最高値）の取得
	* @parameter	: なし
	* @return		: 月額維持（個人）（最高値）
	-------------------------------------------------------------------------*/
	function getMonthlyPersonMax() {
		return $this -> getValueFromFees(VAR_MONTHLY
										, VAR_FEE_PERSON
										, COLUMN_MAX_VALUE
										, $this -> monthlyPersonPercentMax);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 月額維持（法人）（固定値）の取得
	* @parameter	: なし
	* @return		: 月額維持（法人）（固定値）
	-------------------------------------------------------------------------*/
	function getMonthlyCorpFixValue() {
		return $this -> getValueFromFees(VAR_MONTHLY
										, VAR_FEE_CORP
										, COLUMN_FIX
										, $this -> monthlyCorpFixValue);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 月額維持（法人）（パーセンテージ）の取得
	* @parameter	: なし
	* @return		: 月額維持（法人）（パーセンテージ）
	-------------------------------------------------------------------------*/
	function getMonthlyCorpPercentValue() {
		return $this -> getValueFromFees(VAR_MONTHLY
										, VAR_FEE_CORP
										, COLUMN_PERCENT
										, $this -> monthlyCorpPercentValue);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 月額維持（法人）（最高値）の取得
	* @parameter	: なし
	* @return		: 月額維持（法人）（最高値）
	-------------------------------------------------------------------------*/
	function getMonthlyCorpPercentMax() {
		return $this -> getValueFromFees(VAR_MONTHLY
										, VAR_FEE_CORP
										, COLUMN_MAX_VALUE
										, $this -> monthlyCorpPercentMax);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 入金（個人）（固定値）の取得
	* @parameter	: なし
	* @return		: 入金（個人）（固定値）
	-------------------------------------------------------------------------*/
	function getDepositPersonFixValue() {
		return $this -> getValueFromFees(VAR_DEPOSIT
										, VAR_FEE_PERSON
										, COLUMN_FIX
										, $this -> depositPersonFixValue);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 入金（個人）（パーセンテージ）の取得
	* @parameter	: なし
	* @return		: 入金（個人）（パーセンテージ）
	-------------------------------------------------------------------------*/
	function getDepositPersonPercentValue() {
		return $this -> getValueFromFees(VAR_DEPOSIT
										, VAR_FEE_PERSON
										, COLUMN_PERCENT
										, $this -> depositPersonPercentValue);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 入金（個人）（最高値）の取得
	* @parameter	: なし
	* @return		: 入金（個人）（最高値）
	-------------------------------------------------------------------------*/
	function getDepositPersonPercentMax() {
		return $this -> getValueFromFees(VAR_DEPOSIT
										, VAR_FEE_PERSON
										, COLUMN_MAX_VALUE
										, $this -> depositPersonPercentMax);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 入金（法人）（固定値）の取得
	* @parameter	: なし
	* @return		: 入金（法人）（固定値）
	-------------------------------------------------------------------------*/
	function getDepositCorpFixValue() {
		return $this -> getValueFromFees(VAR_DEPOSIT
										, VAR_FEE_CORP
										, COLUMN_FIX
										, $this -> depositCorpFixValue);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 入金（法人）（パーセンテージ）の取得
	* @parameter	: なし
	* @return		: 入金（法人）（パーセンテージ）
	-------------------------------------------------------------------------*/
	function getDepositCorpPercentValue() {
		return $this -> getValueFromFees(VAR_DEPOSIT
										, VAR_FEE_CORP
										, COLUMN_PERCENT
										, $this -> depositCorpPercentValue);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 入金フラグ（法人）（最高値）の取得
	* @parameter	: なし
	* @return		: 入金フラグ（法人）（最高値）
	-------------------------------------------------------------------------*/
	function getDepositCorpPercentMax() {
		return $this -> getValueFromFees(VAR_DEPOSIT
										, VAR_FEE_CORP
										, COLUMN_MAX_VALUE
										, $this -> depositCorpPercentMax);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 出金（成功時）（個人）（固定値）の取得
	* @parameter	: なし
	* @return		: 出金（成功時）（個人）（固定値）
	-------------------------------------------------------------------------*/
	function getWithdrawSuccessPersonFixValue() {
		return $this -> getValueFromFees(VAR_WITHDRAW_SUCCESS
										, VAR_FEE_PERSON
										, COLUMN_FIX
										, $this -> withdrawSuccessPersonFixValue);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 出金（成功時）（個人）（パーセンテージ）
	* @parameter	: なし
	* @return		: 出金（成功時）（個人）（パーセンテージ）
	-------------------------------------------------------------------------*/
	function getWithdrawSuccessPersonPercentValue() {
		return $this -> getValueFromFees(VAR_WITHDRAW_SUCCESS
										, VAR_FEE_PERSON
										, COLUMN_PERCENT
										, $this -> withdrawSuccessPersonPercentValue);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 出金（成功時）（個人）（最低値）の取得
	* @parameter	: なし
	* @return		: 出金（成功時）（個人）（最低値）
	-------------------------------------------------------------------------*/
	function getWithdrawSuccessPersonPercentMin() {
		return $this -> getValueFromFees(VAR_WITHDRAW_SUCCESS
										, VAR_FEE_PERSON
										, COLUMN_MIN_VALUE
										, $this -> withdrawSuccessPersonPercentMin);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 出金（成功時）（個人）（最高値）の取得
	* @parameter	: なし
	* @return		: 出金（成功時）（個人）（最高値）
	-------------------------------------------------------------------------*/
	function getWithdrawSuccessPersonPercentMax() {
		return $this -> getValueFromFees(VAR_WITHDRAW_SUCCESS
										, VAR_FEE_PERSON
										, COLUMN_MAX_VALUE
										, $this -> withdrawSuccessPersonPercentMax);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 出金（成功時）（法人）（固定値）の取得
	* @parameter	: なし
	* @return		: 出金（成功時）（法人）（固定値）
	-------------------------------------------------------------------------*/
	function getWithdrawSuccessCorpFixValue() {
		return $this -> getValueFromFees(VAR_WITHDRAW_SUCCESS
										, VAR_FEE_CORP
										, COLUMN_FIX
										, $this -> withdrawSuccessCorpFixValue);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 出金（成功時）（法人）（パーセンテージ）の取得
	* @parameter	: なし
	* @return		: 出金（成功時）（法人）（パーセンテージ）
	-------------------------------------------------------------------------*/
	function getWithdrawSuccessCorpPercentValue() {
		return $this -> getValueFromFees(VAR_WITHDRAW_SUCCESS
										, VAR_FEE_CORP
										, COLUMN_PERCENT
										, $this -> withdrawSuccessCorpPercentValue);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 出金（成功時）（法人）（最低値）の取得
	* @parameter	: なし
	* @return		: 出金（成功時）（法人）（最低値）
	-------------------------------------------------------------------------*/
	function getWithdrawSuccessCorpPercentMin() {
		return $this -> getValueFromFees(VAR_WITHDRAW_SUCCESS
										, VAR_FEE_CORP
										, COLUMN_MIN_VALUE
										, $this -> withdrawSuccessPersonPercentMin);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 出金（成功時）（法人）（最高値）の取得
	* @parameter	: なし
	* @return		: 出金（成功時）（法人）（最高値）
	-------------------------------------------------------------------------*/
	function getWithdrawSuccessCorpPercentMax() {
		return $this -> getValueFromFees(VAR_WITHDRAW_SUCCESS
										, VAR_FEE_CORP
										, COLUMN_MAX_VALUE
										, $this -> withdrawSuccessPersonPercentMax);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 出金（失敗時）（個人）（固定値）の取得
	* @parameter	: なし
	* @return		: 出金（失敗時）（個人）（固定値）
	-------------------------------------------------------------------------*/
	function getWithdrawRefundPersonFixValue() {
		return $this -> getValueFromFees(VAR_WITHDRAW_REFUND
										, VAR_FEE_PERSON
										, COLUMN_FIX
										, $this -> withdrawRefundPersonFixValue);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 出金（失敗時）（個人）（パーセンテージ）の取得
	* @parameter	: なし
	* @return		: 出金（失敗時）（個人）（パーセンテージ）
	-------------------------------------------------------------------------*/
	function getWithdrawRefundPersonPercentValue() {
		return $this -> getValueFromFees(VAR_WITHDRAW_REFUND
										, VAR_FEE_PERSON
										, COLUMN_PERCENT
										, $this -> withdrawRefundPersonPercentValue);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 出金（失敗時）（個人）（最低値）の取得
	* @parameter	: なし
	* @return		: 出金（失敗時）（個人）（最低値）
	-------------------------------------------------------------------------*/
	function getWithdrawRefundPersonPercentMin() {
		return $this -> getValueFromFees(VAR_WITHDRAW_REFUND
											, VAR_FEE_PERSON
											, COLUMN_MIN_VALUE
											, $this -> withdrawRefundPersonPercentMin);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 出金（失敗時）（個人）（最高値）の取得
	* @parameter	: なし
	* @return		: 出金（失敗時）（個人）（最高値）
	-------------------------------------------------------------------------*/
	function getWithdrawRefundPersonPercentMax() {
		return $this -> getValueFromFees(VAR_WITHDRAW_REFUND
										, VAR_FEE_PERSON
										, COLUMN_MAX_VALUE
										, $this -> withdrawRefundPersonPercentMax);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 出金（失敗時）（法人）（固定値）の取得
	* @parameter	: なし
	* @return		: 出金（失敗時）（法人）（固定値）
	-------------------------------------------------------------------------*/
	function getWithdrawRefundCorpFixValue() {
		return $this -> getValueFromFees(VAR_WITHDRAW_REFUND
										, VAR_FEE_CORP
										, COLUMN_FIX
										, $this -> withdrawRefundCorpFixValue);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 出金（失敗時）（法人）（パーセンテージ）の取得
	* @parameter	: なし
	* @return		: 出金（失敗時）（法人）（パーセンテージ）
	-------------------------------------------------------------------------*/
	function getWithdrawRefundCorpPercentValue() {
		return $this -> getValueFromFees(VAR_WITHDRAW_REFUND
										, VAR_FEE_CORP
										, COLUMN_PERCENT
										, $this -> withdrawRefundCorpPercentValue);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 出金（失敗時）（法人）（最低値）の取得
	* @parameter	: なし
	* @return		: 出金（失敗時）（法人）（最低値）
	-------------------------------------------------------------------------*/
	function getWithdrawRefundCorpPercentMin() {
		return $this -> getValueFromFees(VAR_WITHDRAW_REFUND
										, VAR_FEE_CORP
										, COLUMN_MIN_VALUE
										, $this -> withdrawRefundCorpPercentMin);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 出金（失敗時）（法人）（最高値）の取得
	* @parameter	: なし
	* @return		: 出金（失敗時）（法人）（最高値）
	-------------------------------------------------------------------------*/
	function getWithdrawRefundCorpPercentMax() {
		return $this -> getValueFromFees(VAR_WITHDRAW_REFUND
										, VAR_FEE_CORP
										, COLUMN_MAX_VALUE
										, $this -> withdrawRefundCorpPercentMax);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座振替（個人→法人）（固定値）の取得
	* @parameter	: なし
	* @return		: 口座振替（個人→法人）（固定値）
	-------------------------------------------------------------------------*/
	function getTransferCToBFixValue() {
		return $this -> getValueFromFees(VAR_TRANSFER
										, VAR_C_TO_B
										, COLUMN_FIX
										, $this -> transferCToBFixValue);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座振替（個人→法人）（パーセンテージ）の取得
	* @parameter	: なし
	* @return		: 口座振替（個人→法人）（パーセンテージ）
	-------------------------------------------------------------------------*/
	function getTransferCToBPercentValue() {
		return $this -> getValueFromFees(VAR_TRANSFER
										, VAR_C_TO_B
										, COLUMN_PERCENT
										, $this -> transferCToBPercentValue);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座振替（個人→法人）（最高値）の取得
	* @parameter	: なし
	* @return		: 口座振替（個人→法人）（最高値）
	-------------------------------------------------------------------------*/
	function getTransferCtoBPercentMax() {
		return $this -> getValueFromFees(VAR_TRANSFER
										, VAR_C_TO_B
										, COLUMN_MAX_VALUE
										, $this -> transferCtoBPercentMax);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座振替（個人→個人）（固定値）の取得
	* @parameter	: なし
	* @return		: 口座振替（個人→個人）（固定値）
	-------------------------------------------------------------------------*/
	function getTransferCToCFixValue() {
		return $this -> getValueFromFees(VAR_TRANSFER
										, VAR_C_TO_C
										, COLUMN_FIX
										, $this -> transferCToCFixValue);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座振替（個人→個人）（パーセンテージ）の取得
	* @parameter	: なし
	* @return		: 口座振替（個人→個人）（パーセンテージ）
	-------------------------------------------------------------------------*/
	function getTransferCToCPercentValue() {
		return $this -> getValueFromFees(VAR_TRANSFER
										, VAR_C_TO_C
										, COLUMN_PERCENT
										, $this -> transferCToCPercentValue);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座振替（個人→個人）（最高値）の取得
	* @parameter	: なし
	* @return		: 口座振替（個人→個人）（最高値）
	-------------------------------------------------------------------------*/
	function getTransferCToCPercentMax() {
		return $this -> getValueFromFees(VAR_TRANSFER
										, VAR_C_TO_C
										, COLUMN_MAX_VALUE
										, $this -> transferCToCPercentMax);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座振替（法人→個人）（固定値）の取得
	* @parameter	: なし
	* @return		: 口座振替（法人→個人）（固定値）
	-------------------------------------------------------------------------*/
	function getTransferBToCFixValue() {
		return $this -> getValueFromFees(VAR_TRANSFER
										, VAR_B_TO_C
										, COLUMN_FIX
										, $this -> transferBToCFixValue);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座振替（法人→個人）（パーセンテージ）の取得
	* @parameter	: なし
	* @return		: 口座振替（法人→個人）（パーセンテージ）
	-------------------------------------------------------------------------*/
	function getTransferBToCPercentValue() {
		return $this -> getValueFromFees(VAR_TRANSFER
										, VAR_B_TO_C
										, COLUMN_PERCENT
										, $this -> transferBToCPercentValue);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座振替（法人→個人）（最高値）の取得
	* @parameter	: なし
	* @return		: 口座振替（法人→個人）（最高値）
	-------------------------------------------------------------------------*/
	function getTransferBToCPercentMax() {
		return $this -> getValueFromFees(VAR_TRANSFER
										, VAR_B_TO_C
										, COLUMN_MAX_VALUE
										, $this -> transferBToCPercentMax);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座振替フラグ（法人→法人）（固定値）の取得
	* @parameter	: なし
	* @return		: 口座振替フラグ（法人→法人）（固定値）
	-------------------------------------------------------------------------*/
	function getTransferBToBFixValue() {
		return $this -> getValueFromFees(VAR_TRANSFER
										, VAR_B_TO_B
										, COLUMN_FIX
										, $this -> transferBToBFixValue);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座振替フラグ（法人→法人）（パーセンテージ）の取得
	* @parameter	: なし
	* @return		: 口座振替フラグ（法人→法人）（パーセンテージ）
	-------------------------------------------------------------------------*/
	function getTransferBToBPercentValue() {
		return $this -> getValueFromFees(VAR_TRANSFER
										, VAR_B_TO_B
										, COLUMN_PERCENT
										, $this -> transferBToBPercentValue);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座振替フラグ（法人→法人）（最高値）の取得
	* @parameter	: なし
	* @return		: 口座振替フラグ（法人→法人）（最高値）
	-------------------------------------------------------------------------*/
	function getTransferBToBPercentMax() {
		return $this -> getValueFromFees(VAR_TRANSFER
										, VAR_B_TO_B
										, COLUMN_MAX_VALUE
										, $this -> transferBToBPercentMax);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座振替（個人→法人）（固定値）の取得
	* @parameter	: なし
	* @return		: 口座振替（個人→法人）（固定値）
	-------------------------------------------------------------------------*/
	function getTransferCToBAppFlg() {
		return $this -> getValueFromFees(VAR_TRANSFER
										, VAR_C_TO_B
										, COLUMN_APP_FLG
										, $this -> transferCToBAppFlg);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座振替（個人→個人）（固定値）の取得
	* @parameter	: なし
	* @return		: 口座振替（個人→個人）（固定値）
	-------------------------------------------------------------------------*/
	function getTransferCToCAppFlg() {
		return $this -> getValueFromFees(VAR_TRANSFER
										, VAR_C_TO_C
										, COLUMN_APP_FLG
										, $this -> transferCToCAppFlg);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座振替（法人→個人）（固定値）の取得
	* @parameter	: なし
	* @return		: 口座振替（法人→個人）（固定値）
	-------------------------------------------------------------------------*/
	function getTransferBToCAppFlg() {
		return $this -> getValueFromFees(VAR_TRANSFER
										, VAR_B_TO_C
										, COLUMN_APP_FLG
										, $this -> transferBToCAppFlg);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座振替フラグ（法人→法人）（固定値）の取得
	* @parameter	: なし
	* @return		: 口座振替フラグ（法人→法人）（固定値）
	-------------------------------------------------------------------------*/
	function getTransferBToBAppFlg() {
		return $this -> getValueFromFees(VAR_TRANSFER
										, VAR_B_TO_B
										, COLUMN_APP_FLG
										, $this -> transferBToBAppFlg);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 休止（個人）（固定値）の取得
	* @parameter	: なし
	* @return		: 休止（個人）（固定値）
	-------------------------------------------------------------------------*/
	function getDomantPersonFixValue() {
		return $this -> getValueFromFees(VAR_DOMANT
										, VAR_FEE_PERSON
										, COLUMN_FIX
										, $this -> domantPersonFixValue);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 休止（個人）（パーセンテージ）の取得
	* @parameter	: なし
	* @return		: 休止（個人）（パーセンテージ）
	-------------------------------------------------------------------------*/
	function getDomantPersonPercentValue() {
		return $this -> getValueFromFees(VAR_DOMANT
										, VAR_FEE_PERSON
										, COLUMN_PERCENT
										, $this -> domantPersonPercentValue);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 休止（個人）（最高値）の取得
	* @parameter	: なし
	* @return		: 休止（個人）（最高値）
	-------------------------------------------------------------------------*/
	function getDomantPersonPercentMax() {
		return $this -> getValueFromFees(VAR_DOMANT
										, VAR_FEE_PERSON
										, COLUMN_MAX_VALUE
										, $this -> domantPersonPercentMax);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 休止（法人）（固定値）の取得
	* @parameter	: なし
	* @return		: 休止（法人）（固定値）
	-------------------------------------------------------------------------*/
	function getDomantCorpFixValue() {
		return $this -> getValueFromFees(VAR_DOMANT
										, VAR_FEE_CORP
										, COLUMN_FIX
										, $this -> domantCorpFixValue);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 休止（法人）（パーセンテージ）の取得
	* @parameter	: なし
	* @return		: 休止（法人）（パーセンテージ）
	-------------------------------------------------------------------------*/
	function getDomantCorpPercentValue() {
		return $this -> getValueFromFees(VAR_DOMANT
										, VAR_FEE_CORP
										, COLUMN_PERCENT
										, $this -> domantCorpPercentValue);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 休止（法人）（最高値）の取得
	* @parameter	: なし
	* @return		: 休止（法人）（最高値）
	-------------------------------------------------------------------------*/
	function getDomantCorpPercentMax() {
		return $this -> getValueFromFees(VAR_DOMANT
										, VAR_FEE_CORP
										, COLUMN_MAX_VALUE
										, $this -> domantCorpPercentMax);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 削除（個人）（固定値）の取得
	* @parameter	: なし
	* @return		: 削除（個人）（固定値）
	-------------------------------------------------------------------------*/
	function getDeletePersonFixValue() {
		return $this -> getValueFromFees(VAR_DELETE
										, VAR_FEE_PERSON
										, COLUMN_FIX
										, $this -> deletePersonFixValue);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 削除（個人）（パーセンテージ）の取得
	* @parameter	: なし
	* @return		: 削除（個人）（パーセンテージ）
	-------------------------------------------------------------------------*/
	function getDeletePersonPercentValue() {
		return $this -> getValueFromFees(VAR_DELETE
										, VAR_FEE_PERSON
										, COLUMN_PERCENT
										, $this -> deletePersonPercentValue);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 削除（個人）（最高値）の取得
	* @parameter	: なし
	* @return		: 削除（個人）（最高値）
	-------------------------------------------------------------------------*/
	function getDeletePersonPercentMax() {
		return $this -> getValueFromFees(VAR_DELETE
										, VAR_FEE_PERSON
										, COLUMN_MAX_VALUE
										, $this -> deletePersonPercentMax);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 削除（法人）（固定値）の取得
	* @parameter	: なし
	* @return		: 削除（法人）（固定値）
	-------------------------------------------------------------------------*/
	function getDeleteCorpFixValue() {
		return $this -> getValueFromFees(VAR_DELETE
										, VAR_FEE_CORP
										, COLUMN_FIX
										, $this -> deleteCorpFixValue);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 削除（法人）（パーセンテージ）の取得
	* @parameter	: なし
	* @return		: 削除（法人）（パーセンテージ）
	-------------------------------------------------------------------------*/
	function getDeleteCorpPercentValue() {
		return $this -> getValueFromFees(VAR_DELETE
										, VAR_FEE_CORP
										, COLUMN_PERCENT
										, $this -> deleteCorpPercentValue);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 削除（法人）（最高値）の取得
	* @parameter	: なし
	* @return		: 削除（法人）（最高値）
	-------------------------------------------------------------------------*/
	function getDeleteCorpPercentMax() {
		return $this -> getValueFromFees(VAR_DELETE
										, VAR_FEE_CORP
										, COLUMN_MAX_VALUE
										, $this -> deleteCorpPercentMax);
	}

	/*-------------------------------------------------------------------------
	* @function_name: カード入金（個人）（固定値）の取得
	* @parameter	: なし
	* @return		: カード入金（個人）（固定値）
	-------------------------------------------------------------------------*/
	function getCardDepositPersonFixValue() {
		return $this -> getValueFromFees(VAR_CARD_DEPOSIT
											, VAR_FEE_PERSON
											, COLUMN_FIX
											, $this -> cardDepositPersonFixValue);
	}

	/*-------------------------------------------------------------------------
	* @function_name: カード入金（個人）（パーセンテージ）の取得
	* @parameter	: なし
	* @return		: カード入金（個人）（パーセンテージ）
	-------------------------------------------------------------------------*/
	function getCardDepositPersonPercentValue() {
		return $this -> getValueFromFees(VAR_CARD_DEPOSIT
											, VAR_FEE_PERSON
											, COLUMN_PERCENT
											, $this -> cardDepositPersonPercentValue);
	}

	/*-------------------------------------------------------------------------
	* @function_name: カード入金（個人）（最高値）の取得
	* @parameter	: なし
	* @return		: カード入金（個人）（最高値）
	-------------------------------------------------------------------------*/
	function getCardDepositPersonPercentMax() {
		return $this -> getValueFromFees(VAR_CARD_DEPOSIT
											, VAR_FEE_PERSON
											, COLUMN_MAX_VALUE
											, $this -> cardDepositPersonPercentMax);
	}

	/*-------------------------------------------------------------------------
	* @function_name: カード入金（法人）（固定値）の取得
	* @parameter	: なし
	* @return		: カード入金（法人）（固定値）
	-------------------------------------------------------------------------*/
	function getCardDepositCorpFixValue() {
		return $this -> getValueFromFees(VAR_CARD_DEPOSIT
											, VAR_FEE_CORP
											, COLUMN_FIX
											, $this -> cardDepositCorpFixValue);
	}

	/*-------------------------------------------------------------------------
	* @function_name: カード入金（法人）（パーセンテージ）の取得
	* @parameter	: なし
	* @return		: カード入金（法人）（パーセンテージ）
	-------------------------------------------------------------------------*/
	function getCardDepositCorpPercentValue() {
		return $this -> getValueFromFees(VAR_CARD_DEPOSIT
											, VAR_FEE_CORP
											, COLUMN_PERCENT
											, $this -> cardDepositCorpPercentValue);
	}

	/*-------------------------------------------------------------------------
	* @function_name: カード入金（法人）（最高値）の取得
	* @parameter	: なし
	* @return		: カード入金（法人）（最高値）
	-------------------------------------------------------------------------*/
	function getCardDepositCorpPercentMax() {
		return $this -> getValueFromFees(VAR_CARD_DEPOSIT
											, VAR_FEE_CORP
											, COLUMN_MAX_VALUE
											, $this -> cardDepositCorpPercentMax);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 次のサブミットタイプを表示する
	* @parameter	: なし
	* @return		: 次画面のサブミットタイプ
	-------------------------------------------------------------------------*/
	function echoType() {

		// 変数宣言部
		$rtn = NO_STRING;

		if($this -> fId == NO_STRING) {	// 手数料IDが存在しない（登録）
			$rtn = TYPE_REGITS;
		} else  {						// 手数料IDが存在する（更新）
			$rtn = TYPE_UPDATE;
		}

		echo $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 月額維持フラグ（個人）の取得
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function getMonthlyPerson() {
		return $this -> getValueFromFees(VAR_MONTHLY
										, VAR_FEE_PERSON
										, COLUMN_FEE_FLG
										, $this -> monthlyPerson);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 月額維持フラグ（法人）の取得
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function getMonthlyCorp() {
		return $this -> getValueFromFees(VAR_MONTHLY
										, VAR_FEE_CORP
										, COLUMN_FEE_FLG
										, $this -> monthlyCorp);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 入金フラグ（個人）の取得
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function getDepositPerson() {
		return $this -> getValueFromFees(VAR_DEPOSIT
										, VAR_FEE_PERSON
										, COLUMN_FEE_FLG
										, $this -> depositPerson);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 入金フラグ（法人）の取得
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function getDepositCorp() {
		return $this -> getValueFromFees(VAR_DEPOSIT
										, VAR_FEE_CORP
										, COLUMN_FEE_FLG
										, $this -> depositCorp);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 出金フラグ（成功時）（個人）の取得
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function getWithdrawSuccessPerson($f) {

		// 変数宣言部
		$rtn = NO_COUNT;
		$flg = NO_COUNT;

		$flg = $this -> getValueFromFees(VAR_WITHDRAW_SUCCESS
										, VAR_FEE_PERSON
										, COLUMN_FEE_FLG
										, $this -> withdrawSuccessPerson);

		if($flg			== VAL_INT_2) {		// 両方の場合
			$rtn = $f;
		} else if($flg	== VAL_INT_1) {		// パーセンテージの場合
			$rtn = $flg;
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 出金フラグ（成功時）（法人）の取得
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function getWithdrawSuccessCorp($f) {

		// 変数宣言部
		$rtn = NO_COUNT;
		$flg = NO_COUNT;

		$flg = $this -> getValueFromFees(VAR_WITHDRAW_SUCCESS
										, VAR_FEE_CORP
										, COLUMN_FEE_FLG
										, $this -> withdrawSuccessCorp);

		if($flg			== VAL_INT_2) {		// 両方の場合
			$rtn = $f;
		} else if($flg	== VAL_INT_1) {		// パーセンテージの場合
			$rtn = $flg;
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 出金フラグ（失敗時）（個人）の取得
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function getWithdrawRefundPerson($f) {

		// 変数宣言部
		$rtn = NO_COUNT;
		$flg = NO_COUNT;

		$flg = $this -> getValueFromFees(VAR_WITHDRAW_REFUND
										, VAR_FEE_PERSON
										, COLUMN_FEE_FLG
										, $this -> withdrawRefundPerson);

		if($flg			== VAL_INT_2) {		// 両方の場合
			$rtn = $f;
		} else if($flg	== VAL_INT_1) {		// パーセンテージの場合
			$rtn = $flg;
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 出金フラグ（失敗時）（法人）の取得
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function getWithdrawRefundCorp($f) {

		// 変数宣言部
		$rtn = NO_COUNT;
		$flg = NO_COUNT;

		$flg = $this -> getValueFromFees(VAR_WITHDRAW_REFUND
										, VAR_FEE_CORP
										, COLUMN_FEE_FLG
										, $this -> withdrawRefundCorp);

		if($flg			== VAL_INT_2) {		// 両方の場合
			$rtn = $f;
		} else if($flg	== VAL_INT_1) {		// パーセンテージの場合
			$rtn = $flg;
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座振替フラグ（個人→法人）の取得
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function getTransferCToB() {
		return $this -> getValueFromFees(VAR_TRANSFER
										, VAR_C_TO_B
										, COLUMN_FEE_FLG
										, $this -> transferCToB);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座振替フラグ（個人→個人）の取得
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function getTransferCToC() {
		return $this -> getValueFromFees(VAR_TRANSFER
										, VAR_C_TO_C
										, COLUMN_FEE_FLG
										, $this -> transferCToC);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座振替フラグ（法人→個人）の取得
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function getTransferBToC() {
		return $this -> getValueFromFees(VAR_TRANSFER
										, VAR_B_TO_C
										, COLUMN_FEE_FLG
										, $this -> transferBToC);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座振替フラグ（法人→法人）の取得
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function getTransferBToB() {
		return $this -> getValueFromFees(VAR_TRANSFER
										, VAR_B_TO_B
										, COLUMN_FEE_FLG
										, $this -> transferBToB);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 休止フラグ（個人）の取得
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function getDomantPerson() {
		return $this -> getValueFromFees(VAR_DOMANT
										, VAR_FEE_PERSON
										, COLUMN_FEE_FLG
										, $this -> domantPerson);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 休止フラグ（法人）の取得
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function getDomantCorp() {
		return $this -> getValueFromFees(VAR_DOMANT
										, VAR_FEE_CORP
										, COLUMN_FEE_FLG
										, $this -> domantCorp);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 削除フラグ（個人）の取得
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function getDeletePerson() {
		return $this -> getValueFromFees(VAR_DELETE
										, VAR_FEE_PERSON
										, COLUMN_FEE_FLG
										, $this -> deletePerson);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 削除フラグ（法人）の取得
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function getDeleteCorp() {
		return $this -> getValueFromFees(VAR_DELETE
										, VAR_FEE_CORP
										, COLUMN_FEE_FLG
										, $this -> deleteCorp);
	}

	/*-------------------------------------------------------------------------
	* @function_name: カード入金フラグ（個人）の取得
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function getCardDepositPerson() {
		return $this -> getValueFromFees(VAR_CARD_DEPOSIT
										, VAR_FEE_PERSON
										, COLUMN_FEE_FLG
										, $this -> cardDepositPerson);
	}

	/*-------------------------------------------------------------------------
	* @function_name: カード入金フラグ（法人）の取得
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function getCardDepositCorp() {
		return $this -> getValueFromFees(VAR_CARD_DEPOSIT
										, VAR_FEE_CORP
										, COLUMN_FEE_FLG
										, $this -> cardDepositCorp);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 月額維持フラグ（個人）の表示
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispMonthlyPersonFix() {
		return $this -> makeRadioOne(PARAM_MONTHLY_PERSON . '_fix'
									, PARAM_MONTHLY_PERSON
									, NO_COUNT
									, $this -> getMonthlyPerson()
									, 'changeDisable(\'' . PARAM_MONTHLY_PERSON . '_fix_value' . '\');');
	}

	/*-------------------------------------------------------------------------
	* @function_name: 月額維持フラグ（個人）の表示
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispMonthlyPersonPercent() {
		return $this -> makeRadioOne(PARAM_MONTHLY_PERSON . '_percent'
									, PARAM_MONTHLY_PERSON
									, VAL_INT_1
									, $this -> getMonthlyPerson()
									, 'changeDisable(\'' . PARAM_MONTHLY_PERSON . '_percent_value' . '\');');
	}

	/*-------------------------------------------------------------------------
	* @function_name: 月額維持フラグ（法人）の表示
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispMonthlyCorpFix() {
		return $this -> makeRadioOne(PARAM_MONTHLY_CORP . '_fix'
									, PARAM_MONTHLY_CORP
									, NO_COUNT
									, $this -> getMonthlyCorp()
									, 'changeDisable(\'' . PARAM_MONTHLY_CORP . '_fix_value' . '\');');
	}

	/*-------------------------------------------------------------------------
	* @function_name: 月額維持フラグ（法人）の表示
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispMonthlyCorpPercent() {
		return $this -> makeRadioOne(PARAM_MONTHLY_CORP . '_percent'
									, PARAM_MONTHLY_CORP
									, VAL_INT_1
									, $this -> getMonthlyCorp()
									, 'changeDisable(\'' . PARAM_MONTHLY_CORP . '_percent_value' . '\');');
	}

	/*-------------------------------------------------------------------------
	* @function_name: 入金フラグ（個人）の表示
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispDepositPersonFix() {
		return $this -> makeRadioOne(PARAM_DEPOSIT_PERSON . '_fix'
									, PARAM_DEPOSIT_PERSON
									, NO_COUNT
									, $this -> getDepositPerson()
									, 'changeDisable(\'' . PARAM_DEPOSIT_PERSON . '_fix_value' . '\');');
	}

	/*-------------------------------------------------------------------------
	* @function_name: 入金フラグ（個人）の表示
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispDepositPersonPercent() {
		return $this -> makeRadioOne(PARAM_DEPOSIT_PERSON . '_percent'
									, PARAM_DEPOSIT_PERSON
									, VAL_INT_1
									, $this -> getDepositPerson()
									, 'changeDisable(\'' . PARAM_DEPOSIT_PERSON . '_percent_value' . '\');');
	}

	/*-------------------------------------------------------------------------
	* @function_name: 入金フラグ（法人）の表示
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispDepositCorpFix() {
		return $this -> makeRadioOne(PARAM_DEPOSIT_CORP . '_fix'
									, PARAM_DEPOSIT_CORP
									, NO_COUNT
									, $this -> getDepositCorp()
									, 'changeDisable(\'' . PARAM_DEPOSIT_CORP . '_fix_value' . '\');');
	}

	/*-------------------------------------------------------------------------
	* @function_name: 入金フラグ（法人）の表示
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispDepositCorpPercent() {
		return $this -> makeRadioOne(PARAM_DEPOSIT_CORP . '_percent'
									, PARAM_DEPOSIT_CORP
									, VAL_INT_1
									, $this -> getDepositCorp()
									, 'changeDisable(\'' . PARAM_DEPOSIT_CORP . '_percent_value' . '\');');
	}

	/*-------------------------------------------------------------------------
	* @function_name: 出金フラグ（成功時）（個人）の表示
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispWithdrawSuccessPersonFix() {
		return $this -> makeCheckOne(PARAM_WITHDRAW_SUCCESS_PERSON . '_fix'
									, PARAM_WITHDRAW_SUCCESS_PERSON . VAL_INT_1
									, VAL_INT_1
									, NO_STRING
									, $this -> getWithdrawSuccessPerson(NO_COUNT) + VAL_INT_1
									, 'changeDisableCheck(\'' . PARAM_WITHDRAW_SUCCESS_PERSON . '_fix' . '\', \'' . PARAM_WITHDRAW_SUCCESS_PERSON . '_fix_value' . '\', \'1\');');
	}

	/*-------------------------------------------------------------------------
	* @function_name: 出金フラグ（成功時）（個人）の表示
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispWithdrawSuccessPersonPercent() {
		return $this -> makeCheckOne(PARAM_WITHDRAW_SUCCESS_PERSON . '_percent'
									, PARAM_WITHDRAW_SUCCESS_PERSON . VAL_INT_2
									, VAL_INT_2
									, NO_STRING
									, $this -> getWithdrawSuccessPerson(VAL_INT_1) + VAL_INT_1
									, 'changeDisableCheck(\'' . PARAM_WITHDRAW_SUCCESS_PERSON . '_percent' . '\', \'' . PARAM_WITHDRAW_SUCCESS_PERSON . '_percent' . '\', \'2\');');
	}

	/*-------------------------------------------------------------------------
	* @function_name: 出金フラグ（成功時）（法人）の表示
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispWithdrawSuccessCorpFix() {
		return $this -> makeCheckOne(PARAM_WITHDRAW_SUCCESS_CORP . '_fix'
									, PARAM_WITHDRAW_SUCCESS_CORP . VAL_INT_1
									, VAL_INT_1
									, NO_STRING
									, $this -> getWithdrawSuccessCorp(NO_COUNT) + VAL_INT_1
									, 'changeDisableCheck(\'' . PARAM_WITHDRAW_SUCCESS_CORP . '_fix' . '\', \'' . PARAM_WITHDRAW_SUCCESS_CORP . '_fix_value' . '\', \'1\');');
	}

	/*-------------------------------------------------------------------------
	* @function_name: 出金フラグ（成功時）（法人）の表示
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispWithdrawSuccessCorpPercent() {
		return $this -> makeCheckOne(PARAM_WITHDRAW_SUCCESS_CORP . '_percent'
									, PARAM_WITHDRAW_SUCCESS_CORP . VAL_INT_2
									, VAL_INT_2
									, NO_STRING
									, $this -> getWithdrawSuccessCorp(VAL_INT_1) + VAL_INT_1
									, 'changeDisableCheck(\'' . PARAM_WITHDRAW_SUCCESS_CORP . '_percent' . '\', \'' . PARAM_WITHDRAW_SUCCESS_CORP . '_percent' . '\', \'2\');');
	}

	/*-------------------------------------------------------------------------
	* @function_name: 出金フラグ（失敗時）（個人）の表示
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispWithdrawRefundPersonFix() {
		return $this -> makeCheckOne(PARAM_WITHDRAW_REFUND_PERSON . '_fix'
									, PARAM_WITHDRAW_REFUND_PERSON . VAL_INT_1
									, VAL_INT_1
									, NO_STRING
									, $this -> getWithdrawRefundPerson(NO_COUNT) + VAL_INT_1
									, 'changeDisableCheck(\'' . PARAM_WITHDRAW_REFUND_PERSON . '_fix' . '\', \'' . PARAM_WITHDRAW_REFUND_PERSON . '_fix_value' . '\', \'1\');');
	}

	/*-------------------------------------------------------------------------
	* @function_name: 出金フラグ（失敗時）（個人）の表示
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispWithdrawRefundPersonPercent() {
		return $this -> makeCheckOne(PARAM_WITHDRAW_REFUND_PERSON . '_percent'
									, PARAM_WITHDRAW_REFUND_PERSON . VAL_INT_2
									, VAL_INT_2
									, NO_STRING
									, $this -> getWithdrawRefundPerson(VAL_INT_1) + VAL_INT_1
									, 'changeDisableCheck(\'' . PARAM_WITHDRAW_REFUND_PERSON . '_percent' . '\', \'' . PARAM_WITHDRAW_REFUND_PERSON . '_percent' . '\', \'2\');');
	}

	/*-------------------------------------------------------------------------
	* @function_name: 出金フラグ（失敗時）（法人）の表示
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispWithdrawRefundCorpFix() {
		return $this -> makeCheckOne(PARAM_WITHDRAW_REFUND_CORP . '_fix'
									, PARAM_WITHDRAW_REFUND_CORP . VAL_INT_1
									, VAL_INT_1
									, NO_STRING
									, $this -> getWithdrawRefundCorp(NO_COUNT) + VAL_INT_1
									, 'changeDisableCheck(\'' . PARAM_WITHDRAW_REFUND_CORP . '_fix' . '\', \'' . PARAM_WITHDRAW_REFUND_CORP . '_fix_value' . '\', \'1\');');
	}

	/*-------------------------------------------------------------------------
	* @function_name: 出金フラグ（失敗時）（法人）の表示
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispWithdrawRefundCorpPercent() {
		return $this -> makeCheckOne(PARAM_WITHDRAW_REFUND_CORP . '_percent'
									, PARAM_WITHDRAW_REFUND_CORP . VAL_INT_2
									, VAL_INT_2
									, NO_STRING
									, $this -> getWithdrawRefundCorp(VAL_INT_1) + VAL_INT_1
									, 'changeDisableCheck(\'' . PARAM_WITHDRAW_REFUND_CORP . '_percent' . '\', \'' . PARAM_WITHDRAW_REFUND_CORP . '_percent' . '\', \'2\');');
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座振替フラグ（個人→法人）の表示
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispTransferCToBFix() {
		return $this -> makeRadioOne(PARAM_TRANSFER_C_TO_B . '_fix'
									, PARAM_TRANSFER_C_TO_B
									, NO_COUNT
									, $this -> getTransferCToB()
									, 'changeDisable(\'' . PARAM_TRANSFER_C_TO_B . '_fix_value' . '\');');
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座振替フラグ（個人→法人）の表示
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispTransferCToBPercent() {
		return $this -> makeRadioOne(PARAM_TRANSFER_C_TO_B . '_percent'
									, PARAM_TRANSFER_C_TO_B
									, VAL_INT_1
									, $this -> getTransferCToB()
									, 'changeDisable(\'' . PARAM_TRANSFER_C_TO_B . '_percent_value' . '\');');
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座振替フラグ（個人→個人）の表示
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispTransferCToCFix() {
		return $this -> makeRadioOne(PARAM_TRANSFER_C_TO_C . '_fix'
									, PARAM_TRANSFER_C_TO_C
									, NO_COUNT
									, $this -> getTransferCToC()
									, 'changeDisable(\'' . PARAM_TRANSFER_C_TO_C . '_fix_value' . '\');');
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座振替フラグ（個人→個人）の表示
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispTransferCToCPercent() {
		return $this -> makeRadioOne(PARAM_TRANSFER_C_TO_C . '_percent'
									, PARAM_TRANSFER_C_TO_C
									, VAL_INT_1
									, $this -> getTransferCToC()
									, 'changeDisable(\'' . PARAM_TRANSFER_C_TO_C . '_percent_value' . '\');');
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座振替フラグ（法人→個人）の表示
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispTransferBToCFix() {
		return $this -> makeRadioOne(PARAM_TRANSFER_B_TO_C . '_fix'
									, PARAM_TRANSFER_B_TO_C
									, NO_COUNT
									, $this -> getTransferBToC()
									, 'changeDisable(\'' . PARAM_TRANSFER_B_TO_C . '_fix_value' . '\');');
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座振替フラグ（法人→個人）の表示
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispTransferBToCPercent() {
		return $this -> makeRadioOne(PARAM_TRANSFER_B_TO_C . '_percent'
									, PARAM_TRANSFER_B_TO_C
									, VAL_INT_1
									, $this -> getTransferBToC()
									, 'changeDisable(\'' . PARAM_TRANSFER_B_TO_C . '_percent_value' . '\');');
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座振替フラグ（法人→法人）の表示の表示
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispTransferBToBFix() {
		return $this -> makeRadioOne(PARAM_TRANSFER_B_TO_B . '_fix'
									, PARAM_TRANSFER_B_TO_B
									, NO_COUNT
									, $this -> getTransferBToB()
									, 'changeDisable(\'' . PARAM_TRANSFER_B_TO_B . '_fix_value' . '\');');
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座振替フラグ（法人→法人）の表示
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispTransferBToBPercent() {
		return $this -> makeRadioOne(PARAM_TRANSFER_B_TO_B . '_percent'
									, PARAM_TRANSFER_B_TO_B
									, VAL_INT_1
									, $this -> getTransferBToB()
									, 'changeDisable(\'' . PARAM_TRANSFER_B_TO_B . '_percent_value' . '\');');
	}

	/*-------------------------------------------------------------------------
	* @function_name: 休止フラグ（個人）の表示
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispDomantPersonFix() {
		return $this -> makeRadioOne(PARAM_DOMANT_PERSON . '_fix'
									, PARAM_DOMANT_PERSON
									, NO_COUNT
									, $this -> getDomantPerson()
									, 'changeDisable(\'' . PARAM_DOMANT_PERSON . '_fix_value' . '\');');
	}

	/*-------------------------------------------------------------------------
	* @function_name: 休止フラグ（個人）の表示
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispDomantPersonPercent() {
		return $this -> makeRadioOne(PARAM_DOMANT_PERSON . '_percent'
									, PARAM_DOMANT_PERSON
									, VAL_INT_1
									, $this -> getDomantPerson()
									, 'changeDisable(\'' . PARAM_DOMANT_PERSON . '_percent_value' . '\');');
	}

	/*-------------------------------------------------------------------------
	* @function_name: 休止フラグ（法人）の表示
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispDomantCorpFix() {
		return $this -> makeRadioOne(PARAM_DOMANT_CORP . '_fix'
									, PARAM_DOMANT_CORP
									, NO_COUNT
									, $this -> getDomantCorp()
									, 'changeDisable(\'' . PARAM_DOMANT_CORP . '_fix_value' . '\');');
	}

	/*-------------------------------------------------------------------------
	* @function_name: 休止フラグ（法人）の表示
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispDomantCorpPercent() {
		return $this -> makeRadioOne(PARAM_DOMANT_CORP . '_percent'
									, PARAM_DOMANT_CORP
									, VAL_INT_1
									, $this -> getDomantCorp()
									, 'changeDisable(\'' . PARAM_DOMANT_CORP . '_percent_value' . '\');');
	}

	/*-------------------------------------------------------------------------
	* @function_name: 削除フラグ（個人）の表示
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispDeletePersonFix() {
		return $this -> makeRadioOne(PARAM_DELETE_PERSON . '_fix'
									, PARAM_DELETE_PERSON
									, NO_COUNT
									, $this -> getDeletePerson()
									, 'changeDisable(\'' . PARAM_DELETE_PERSON . '_fix_value' . '\');');
	}

	/*-------------------------------------------------------------------------
	* @function_name: 削除フラグ（個人）の表示
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispDeletePersonPercent() {
		return $this -> makeRadioOne(PARAM_DELETE_PERSON . '_percent'
									, PARAM_DELETE_PERSON
									, VAL_INT_1
									, $this -> getDeletePerson()
									, 'changeDisable(\'' . PARAM_DELETE_PERSON . '_percent_value' . '\');');
	}

	/*-------------------------------------------------------------------------
	* @function_name: 削除フラグ（法人）の表示
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispDeleteCorpFix() {
		return $this -> makeRadioOne(PARAM_DELETE_CORP . '_fix'
									, PARAM_DELETE_CORP
									, NO_COUNT
									, $this -> getDeleteCorp()
									, 'changeDisable(\'' . PARAM_DELETE_CORP . '_fix_value' . '\');');
	}

	/*-------------------------------------------------------------------------
	* @function_name: 削除フラグ（法人）の表示
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispDeleteCorpPercent() {
		return $this -> makeRadioOne(PARAM_DELETE_CORP . '_percent'
									, PARAM_DELETE_CORP
									, VAL_INT_1
									, $this -> getDeleteCorp()
									, 'changeDisable(\'' . PARAM_DELETE_CORP . '_percent_value' . '\');');
	}

	/*-------------------------------------------------------------------------
	* @function_name: カード入金フラグ（個人）の表示
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispCardDepositPersonFix() {
		return $this -> makeRadioOne(PARAM_CARD_DEPOSIT_PERSON. '_fix'
										, PARAM_CARD_DEPOSIT_PERSON
										, NO_COUNT
										, $this -> getCardDepositPerson()
										, 'changeDisable(\'' . PARAM_CARD_DEPOSIT_PERSON . '_fix_value' . '\');');
	}

	/*-------------------------------------------------------------------------
	* @function_name: カード入金フラグ（個人）の表示
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispCardDepositPersonPercent() {
		return $this -> makeRadioOne(PARAM_CARD_DEPOSIT_PERSON . '_percent'
										, PARAM_CARD_DEPOSIT_PERSON
										, VAL_INT_1
										, $this -> getCardDepositPerson()
										, 'changeDisable(\'' . PARAM_CARD_DEPOSIT_PERSON . '_percent_value' . '\');');
	}

	/*-------------------------------------------------------------------------
	* @function_name: カード入金フラグ（法人）の表示
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispCardDepositCorpFix() {
		return $this -> makeRadioOne(PARAM_CARD_DEPOSIT_CORP. '_fix'
										, PARAM_CARD_DEPOSIT_CORP
										, NO_COUNT
										, $this -> getCardDepositCorp()
										, 'changeDisable(\'' . PARAM_CARD_DEPOSIT_CORP . '_fix_value' . '\');');
	}

	/*-------------------------------------------------------------------------
	* @function_name: カード入金フラグ（法人）の表示
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispCardDepositCorpPercent() {
		return $this -> makeRadioOne(PARAM_CARD_DEPOSIT_CORP . '_percent'
										, PARAM_CARD_DEPOSIT_CORP
										, VAL_INT_1
										, $this -> getCardDepositCorp()
										, 'changeDisable(\'' . PARAM_CARD_DEPOSIT_CORP . '_percent_value' . '\');');
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座振替適用フラグ（個人→法人）の表示
	* @parameter	: なし
	* @return		: 口座振替適用フラグ（個人→法人）の
	-------------------------------------------------------------------------*/
	function dispTransferCToBAppFlg() {
		echo $this -> dispListOption($this -> getMstFeeAppFlgList(), $this -> getTransferCToBAppFlg());
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座振替適用フラグ（個人→個人）の表示
	* @parameter	: なし
	* @return		: 口座振替適用フラグ（個人→個人）
	-------------------------------------------------------------------------*/
	function dispTransferCToCAppFlg() {
		echo $this -> dispListOption($this -> getMstFeeAppFlgList(), $this -> getTransferCToCAppFlg());
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座振替適用フラグ（法人→個人）の表示
	* @parameter	: なし
	* @return		: 口座振替適用フラグ（法人→個人）
	-------------------------------------------------------------------------*/
	function dispTransferBToCAppFlg() {
		echo $this -> dispListOption($this -> getMstFeeAppFlgList(), $this -> getTransferBToCAppFlg());
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座振替適用フラグ（法人→法人）の表示
	* @parameter	: なし
	* @return		: 口座振替適用フラグ（法人→法人）
	-------------------------------------------------------------------------*/
	function dispTransferBToBAppFlg() {
		echo $this -> dispListOption($this -> getMstFeeAppFlgList(), $this -> getTransferBToBAppFlg());
	}

	/*-------------------------------------------------------------------------
	* @function_name: ページャの表示
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispPager() {
		echo  $this -> getPagerCommon($this -> getTargetPage()
										, $this -> getTotalPageCommon(VAR_MST_FEE_PAGE_COUNT, count($this -> fees))
										, count($this -> fees)
										, NO_STRING);
	}

	/*-------------------------------------------------------------------------
	* @function_name: getActivity
	* @parameter	:
	* @return		:
	-------------------------------------------------------------------------*/
   function getActivity(){
   		$type 					= $this -> getType();
   		$details 				= array();
   		$patternName 			= $this -> fId;
   		$newName 				= $this -> name;
	   	$rows 					= $this -> accessSelect('SELECT_FEES', array($this -> fId));
	   	$message 				= NO_STRING;
	   	
	   	//withdraw (success) individual
	 	if($this -> withdrawSuccessPerson1			== VAL_INT_1
			&& $this -> withdrawSuccessPerson2		== VAL_INT_2) {
			$newFeeFlg1 = VAL_INT_2;
		} else if($this -> withdrawSuccessPerson2	== VAL_INT_2) {
			$newFeeFlg1 = VAL_INT_1;
		} else {
			$newFeeFlg1 = NO_COUNT;
		}

		//withdraw (success) corp
		if($this -> withdrawSuccessCorp1		== VAL_INT_1
			&& $this -> withdrawSuccessCorp2	== VAL_INT_2) {
			$newFeeFlg2 = VAL_INT_2;
		} else if($this -> withdrawSuccessCorp2	== VAL_INT_2) {
			$newFeeFlg2 = VAL_INT_1;
		} else {
			$newFeeFlg2 = NO_COUNT;
		}

		//withdraw (failed) individual
		if($this -> withdrawRefundPerson1			== VAL_INT_1
			&& $this -> withdrawRefundPerson2		== VAL_INT_2) {
			$newFeeFlg3 = VAL_INT_2;
		} else if($this -> withdrawRefundPerson2	== VAL_INT_2) {
			$newFeeFlg3 = VAL_INT_1;
		} else {
			$newFeeFlg3 = NO_COUNT;
		}
	   
	   //withdraw(failed) corp
	   if($this -> withdrawRefundCorp1			== VAL_INT_1
			&& $this -> withdrawRefundCorp2		== VAL_INT_2) {
			$newFeeFlg4 = VAL_INT_2;
		} else if($this -> withdrawRefundCorp2	== VAL_INT_2) {
			$newFeeFlg4 = VAL_INT_1;
		} else {
			$newFeeFlg4 = NO_COUNT;
		}

	    if($type == TYPE_UPDATE){
	   		$origName = $this -> getColumnData($rows[0], COLUMN_FEE_TYPE_NAME);
		    if($newName != $origName){
		    	$details[] .= 'pattern name from '. $origName .' to '.$newName;
		    }

		    foreach ($rows as $row) {
		   		$origWalletType[] 	= $this -> getColumnData($row, COLUMN_WALLET_TYPE);
		   		$origAppFlg[] 		= $this -> getColumnData($row, COLUMN_APP_FLG);
		   		$origFeeFlg[] 		= $this -> getColumnData($row, COLUMN_FEE_FLG);
		   		$origMFID[] 		= $this -> getColumnData($row, COLUMN_M_F_ID);
		   		$origFix[] 			= $this -> getColumnData($row, COLUMN_FIX);
		   		$origPercent[] 		= $this -> getColumnData($row, COLUMN_PERCENT);
		   		$origMax[] 			= $this -> getColumnData($row, COLUMN_MAX_VALUE);
		   		$origMin[] 			= $this -> getColumnData($row, COLUMN_MIN_VALUE);



		   	}

		   	for($cnt = 0; $cnt < (count($rows)); $cnt++){
		   		$origFixValue[] 	= ($origFix[$cnt] == 0 ? '0.00' : substr_replace($origFix[$cnt], '.', -2, 0));
			   	$origPercentValue[] = ($origPercent[$cnt] == 0 ? '0.00' : substr_replace($origPercent[$cnt], '.', -2, 0));
			   	$origMaxValue[] 	= ($origMax[$cnt] == 0 ? '0.00' : substr_replace($origMax[$cnt], '.', -2, 0));
			   	$origMinValue[] 	= ($origMin[$cnt] == 0 ? '0.00' : substr_replace($origMin[$cnt], '.', -2, 0));
		   	}

		   	//Monthly - Individual
		   	if($origFeeFlg[0] != $this -> monthlyPerson){
		   			$details[] .= 'Monthly-Individual fee type from ['.$this -> getFeeFlgName($origFeeFlg[0]).'] to ['. $this -> getFeeFlgName($this -> monthlyPerson).']';
		   	}

		   	if($origFixValue[0] != $this -> monthlyPersonFixValue){
					$details[] .= 'Monthly-Individual Definite Amount value from ['.$origFixValue[0].'] to ['. $this -> monthlyPersonFixValue.']';
		   	}

		   	if($origPercentValue[0] != $this -> monthlyPersonPercentValue){
					$details[] .= 'Monthly-Individual Percentage value from ['.$origPercentValue[0].'] to ['. $this -> monthlyPersonPercentValue.']';
		   	}

		   	if($origMaxValue[0] != $this -> monthlyPersonPercentMax){
					$details[] .= 'Monthly-Individual maximum value from ['.$origMaxValue[0].'] to ['. $this -> monthlyPersonPercentMax.']';
		   	}

		   	//Monthly - Corporate
		   	if($origFeeFlg[1] != $this -> monthlyCorp){
		   			$details[] .= 'Monthly-Corporate fee type from ['.$this -> getFeeFlgName($origFeeFlg[1]).'] to ['. $this -> getFeeFlgName($this -> monthlyCorp).']';
		   	}

		   	if($origFixValue[1] != $this -> monthlyCorpFixValue){
					$details[] .= 'Monthly-Corporate Definite Amount value from ['.$origFixValue[1].'] to ['. $this -> monthlyCorpFixValue.']';
		   	}

		   	if($origPercentValue[1] != $this -> monthlyCorpPercentValue){
					$details[] .= 'Monthly-Corporate Percentage value from ['.$origPercentValue[1].'] to ['. $this -> monthlyCorpPercentValue.']';
		   	}

		   	if($origMaxValue[1] != $this -> monthlyCorpPercentMax){
					$details[] .= 'Monthly-Corporate maximum value from ['.$origMaxValue[1].'] to ['. $this -> monthlyCorpPercentMax.']';
		   	}

		   	//Deposit - Individual
		   	if($origFeeFlg[2] != $this -> depositPerson){
		   			$details[] .= 'Deposit-Individual fee type from ['.$this -> getFeeFlgName($origFeeFlg[2]).'] to ['. $this -> getFeeFlgName($this -> depositPerson).']';
		   	}

		   	if($origFixValue[2] != $this -> depositPersonFixValue){
					$details[] .= 'Deposit-Individual Definite Amount value from ['.$origFixValue[2].'] to ['. $this -> depositPersonFixValue.']';
		   	}

		   	if($origPercentValue[2] != $this -> depositPersonPercentValue){
					$details[] .= 'Deposit-Individual Percentage value from ['.$origPercentValue[2].'] to ['. $this -> depositPersonPercentValue.']';
		   	}

		   	if($origMaxValue[2] != $this -> depositPersonPercentMax){
					$details[] .= 'Deposit-Individual maximum value from ['.$origMaxValue[2].'] to ['. $this -> depositPersonPercentMax.']';
		   	}

		   	//Deposit - Corporate
		   	if($origFeeFlg[3] != $this -> depositCorp){
		   			$details[] .= 'Deposit-Corporate fee type from ['.$this -> getFeeFlgName($origFeeFlg[3]).'] to ['. $this -> getFeeFlgName($this -> depositCorp).']';
		   	}

		   	if($origFixValue[3] != $this -> depositCorpFixValue){
					$details[] .= 'Deposit-Corporate Definite Amount value from ['.$origFixValue[3].'] to ['. $this -> depositCorpFixValue.']';
		   	}

		   	if($origPercentValue[3] != $this -> depositCorpPercentValue){
					$details[] .= 'Deposit-Corporate Percentage value from ['.$origPercentValue[3].'] to ['. $this -> depositCorpPercentValue.']';
		   	}

		   	if($origMaxValue[3] != $this -> depositCorpPercentMax){
					$details[] .= 'Deposit-Corporate maximum value from ['.$origMaxValue[3].'] to ['. $this -> depositCorpPercentMax.']';
		   	}


		   	//Withdraw(Success) - Individual
		   	if($origFeeFlg[4] != $newFeeFlg1){
		   			$details[] .= 'Withdraw (Success)-Individual fee type from ['.$this -> getFeeFlgName($origFeeFlg[4]).'] to ['. $this -> getFeeFlgName($newFeeFlg1).']';
		   	}

		   	if($origFixValue[4] != $this -> withdrawSuccessPersonFixValue){
					$details[] .= 'Withdraw (Success)-Individual Definite Amount value from ['.$origFixValue[4].'] to ['. $this -> withdrawSuccessPersonFixValue.']';
		   	}

		   	if($origPercentValue[4] != $this -> withdrawSuccessPersonPercentValue){
					$details[] .= 'Withdraw (Success)-Individual Percentage value from ['.$origPercentValue[4].'] to ['. $this -> withdrawSuccessPersonPercentValue.']';
		   	}

		   	if($origMaxValue[4] != $this -> withdrawSuccessPersonPercentMax && $newFeeFlg1 != 0){
					$details[] .= 'Withdraw (Success)-Individual maximum value from ['.$origMaxValue[4].'] to ['. $this -> withdrawSuccessPersonPercentMax.']';
		   	}

		   	if($origMinValue[4] != $this -> withdrawSuccessPersonPercentMin && $newFeeFlg1 != 0){
					$details[] .= 'Withdraw (Success)-Individual minimum value from ['.$origMinValue[4].'] to ['. $this -> withdrawSuccessPersonPercentMin.']';
		   	}

		   //Withdraw(Success) - Corp
		   	if($origFeeFlg[5] != $newFeeFlg2){
		   			$details[] .= 'Withdraw (Success)-Corporate fee type from ['.$this -> getFeeFlgName($origFeeFlg[5]).'] to ['. $this -> getFeeFlgName($newFeeFlg2).']';
		   	}

		   	if($origFixValue[5] != $this -> withdrawSuccessCorpFixValue){
					$details[] .= 'Withdraw (Success)-Corporate Definite Amount value from ['.$origFixValue[5].'] to ['. $this -> withdrawSuccessCorpFixValue.']';
		   	}

		   	if($origPercentValue[5] != $this -> withdrawSuccessCorpPercentValue){
					$details[] .= 'Withdraw (Success)-Corporate Percentage value from ['.$origPercentValue[5].'] to ['. $this -> withdrawSuccessCorpPercentValue.']';
		   	}

		   	if($origMaxValue[5] != $this -> withdrawSuccessCorpPercentMax && $newFeeFlg2 != 0){
					$details[] .= 'Withdraw (Success)-Corporate maximum value from ['.$origMaxValue[5].'] to ['. $this -> withdrawSuccessCorpPercentMax.']';
		   	}

		   	if($origMinValue[5] != $this -> withdrawSuccessCorpPercentMin && $newFeeFlg2 != 0){
					$details[] .= 'Withdraw (Success)-Corporate minimum value from ['.$origMinValue[5].'] to ['. $this -> withdrawSuccessCorpPercentMin.']';
		   	}

		   	//Withdraw(refund) - Individual
		   	if($origFeeFlg[6] != $newFeeFlg3){
		   			$details[] .= 'Withdraw (Failed)-Individual fee type from ['.$this -> getFeeFlgName($origFeeFlg[6]).'] to ['. $this -> getFeeFlgName($newFeeFlg3).']';
		   	}

		   	if($origFixValue[6] != $this -> withdrawRefundPersonFixValue){
					$details[] .= 'Withdraw (Failed)-Individual Definite Amount value from ['.$origFixValue[6].'] to ['. $this -> withdrawRefundPersonFixValue.']';
		   	}

		   	if($origPercentValue[6] != $this -> withdrawRefundPersonPercentValue){
					$details[] .= 'Withdraw (Failed)-Individual Percentage value from ['.$origPercentValue[6].'] to ['. $this -> withdrawRefundPersonPercentValue.']';
		   	}

		   	if($origMaxValue[6] != $this -> withdrawRefundPersonPercentMax && $newFeeFlg3 != 0){
					$details[] .= 'Withdraw (Failed)-Individual maximum value from ['.$origMaxValue[6].'] to '. $this -> withdrawRefundPersonPercentMax.']';
		   	}

		   	if($origMinValue[6] != $this -> withdrawRefundPersonPercentMin && $newFeeFlg3 != 0){
					$details[] .= 'Withdraw (Failed)-Individual minimum value from ['.$origMinValue[6].'] to ['. $this -> withdrawRefundPersonPercentMin.']';
		   	}

		   	//Withdraw(refund) - Corp
		   	if($origFeeFlg[7] != $newFeeFlg4){
		   			$details[] .= 'Withdraw (Failed)-Corporate fee type from ['.$this -> getFeeFlgName($origFeeFlg[7]).'] to ['. $this -> getFeeFlgName($newFeeFlg4).']';
		   	}

		   	if($origFixValue[7] != $this -> withdrawRefundCorpFixValue){
					$details[] .= 'Withdraw (Failed)-Corporate Definite Amount value from ['.$origFixValue[7].'] to ['. $this -> withdrawRefundCorpFixValue.']';
		   	}

		   	if($origPercentValue[7] != $this -> withdrawRefundCorpPercentValue){
					$details[] .= 'Withdraw (Failed)-Corporate Percentage value from ['.$origPercentValue[7].'] to ['. $this -> withdrawRefundCorpPercentValue.']';
		   	}

		   	if($origMaxValue[7] != $this -> withdrawRefundCorpPercentMax && $newFeeFlg4 != 0){
					$details[] .= 'Withdraw (Failed)-Corporate maximum value from ['.$origMaxValue[7].'] to ['. $this -> withdrawRefundCorpPercentMax.']';
		   	}

		   	if($origMinValue[7] != $this -> withdrawRefundCorpPercentMin && $newFeeFlg4 != 0){
					$details[] .= 'Withdraw (Failed)-Corporate minimum value from ['.$origMinValue[7].'] to ['. $this -> withdrawRefundCorpPercentMin.']';
		   	}


		   	//transfer - Person -> Corp
		   	if($origFeeFlg[8] != $this -> transferCToB){
		   			$details[] .= 'Internal transfer (Individual - Corporate) fee type from ['.$this -> getFeeFlgName($origFeeFlg[8]).'] to ['. $this -> getFeeFlgName($this -> transferCToB).']';
		   	}

		   	if($origFixValue[8] != $this -> transferCToBFixValue){
					$details[] .= 'Internal transfer (Individual - Corporate) Definite Amount value from ['.$origFixValue[8].'] to ['. $this -> transferCToBFixValue.']';
		   	}

		   	if($origPercentValue[8] != $this -> transferCToBPercentValue){
					$details[] .= 'Internal transfer (Individual - Corporate) Percentage value from ['.$origPercentValue[8].'] to ['. $this -> transferCToBPercentValue.']';
		   	}

		   	if($origMaxValue[8] != $this -> transferCtoBPercentMax){
					$details[] .= 'Internal transfer (Individual - Corporate) maximum value from ['.$origMaxValue[8].'] to ['. $this -> transferCtoBPercentMax.']';
		   	}

		   	//transfer - Person -> Corp
		   	if($origAppFlg[8] != $this -> transferCToBAppFlg){
		   			$details[] .= 'Internal transfer (Individual - Corporate) application type from ['.$this -> getAppFlgName($origAppFlg[8]).'] to ['. $this -> getAppFlgName($this -> transferCToBAppFlg).']';
		   	}

		   	//transfer - Person -> Person'
		   	if($origFeeFlg[9] != $this -> transferCToC){
		   			$details[] .= 'Internal transfer (Individual - Individual) fee type from ['.$this -> getFeeFlgName($origFeeFlg[9]).'] to ['. $this -> getFeeFlgName($this -> transferCToC).']';
		   	}

		   	if($origFixValue[9] != $this -> transferCToCFixValue){
					$details[] .= 'Internal transfer (Individual - Individual) Definite Amount value from ['.$origFixValue[9].'] to ['. $this -> transferCToCFixValue.']';
		   	}

		   	if($origPercentValue[9] != $this -> transferCToCPercentValue){
					$details[] .= 'Internal transfer (Individual - Individual) Percentage value from ['.$origPercentValue[9].'] to ['. $this -> transferCToCPercentValue.']';
		   	}

		   	if($origMaxValue[9] != $this -> transferCToCPercentMax){
					$details[] .= 'Internal transfer (Individual - Individual) maximum value from ['.$origMaxValue[9].'] to ['. $this -> transferCToCPercentMax.']';
		   	}

		   	//transfer - Person -> Person
		   	if($origAppFlg[9] != $this -> transferCToCAppFlg){
		   			$details[] .= 'Internal transfer (Individual - Individual) application type from ['.$this -> getAppFlgName($origAppFlg[9]).'] to ['. $this -> getAppFlgName($this -> transferCToCAppFlg).']';
		   	}

		   	//transfer - Corp -> Person'
		   	if($origFeeFlg[10] != $this -> transferBToC){
		   			$details[] .= 'Internal transfer (Corporate - Individual) fee type from ['.$this -> getFeeFlgName($origFeeFlg[10]).'] to ['. $this -> getFeeFlgName($this -> transferBToC).']';
		   	}

		   	if($origFixValue[10] != $this -> transferBToCFixValue){
					$details[] .= 'Internal transfer (Corporate - Individual) Definite Amount value from ['.$origFixValue[10].'] to ['. $this -> transferBToCFixValue.']';
		   	}

		   	if($origPercentValue[10] != $this -> transferBToCPercentValue){
					$details[] .= 'Internal transfer (Corporate - Individual) Percentage value from ['.$origPercentValue[10].'] to ['. $this -> transferBToCPercentValue.']';
		   	}

		   	if($origMaxValue[10] != $this -> transferBToCPercentMax){
					$details[] .= 'Internal transfer (Corporate - Individual) maximum value from ['.$origMaxValue[10].'] to ['. $this -> transferBToCPercentMax.']';
		   	}

		   	//transfer - Corp -> Person'
		   	if($origAppFlg[10] != $this -> transferBToCAppFlg){
		   			$details[] .= 'Internal transfer (Corporate - Individual) application type from ['.$this -> getAppFlgName($origAppFlg[10]).'] to ['. $this -> getAppFlgName($this -> transferBToCAppFlg).']';
		   	}

		   	//transfer - Corp -> Corp'
		   	if($origFeeFlg[11] != $this -> transferBToB){
		   			$details[] .= 'Internal transfer (Corporate - Corporate) fee type from ['.$this -> getFeeFlgName($origFeeFlg[11]).'] to ['. $this -> getFeeFlgName($this -> transferBToB).']';
		   	}

		   	if($origFixValue[11] != $this -> transferBToBFixValue){
					$details[] .= 'Internal transfer (Corporate - Corporate) Definite Amount value from ['.$origFixValue[11].'] to ['. $this -> transferBToBFixValue.']';
		   	}

		   	if($origPercentValue[11] != $this -> transferBToBPercentValue){
					$details[] .= 'Internal transfer (Corporate - Corporate) Percentage value from ['.$origPercentValue[11].'] to ['. $this -> transferBToBPercentValue.']';
		   	}

		   	if($origMaxValue[11] != $this -> transferBToBPercentMax){
					$details[] .= 'Internal transfer (Corporate - Corporate) maximum value from ['.$origMaxValue[11].'] to ['. $this -> transferBToBPercentMax.']';
		   	}

		   	//transfer - Corp -> Corp'
		   	if($origAppFlg[11] != $this -> transferBToBAppFlg){
		   			$details[] .= 'Internal transfer (Corporate - Corporate) application type from ['.$this -> getAppFlgName($origAppFlg[11]).'] to ['. $this -> getAppFlgName($this -> transferBToBAppFlg).']';
		   	}

		   	//Suspension - Individual
		   	if($origFeeFlg[12] != $this -> domantPerson){
		   			$details[] .= 'Suspension-Invidual fee type from ['.$this -> getFeeFlgName($origFeeFlg[12]).'] to ['. $this -> getFeeFlgName($this -> domantPerson).']';
		   	}

		   	if($origFixValue[12] != $this -> domantPersonFixValue){
					$details[] .= 'Suspension-Invidual Definite Amount value from ['.$origFixValue[12].'] to ['. $this -> domantPersonFixValue.']';
		   	}

		   	if($origPercentValue[12] != $this -> domantPersonPercentValue){
					$details[] .= 'Suspension-Invidual Percentage value from ['.$origPercentValue[12].'] to ['. $this -> domantPersonPercentValue.']';
		   	}

		   	if($origMaxValue[12] != $this -> domantPersonPercentMax){
					$details[] .= 'Suspension-Invidual maximum value from ['.$origMaxValue[12].'] to ['. $this -> domantPersonPercentMax.']';
		   	}


		   	//Suspension - Corp
		   	if($origFeeFlg[13] != $this -> domantCorp){
		   			$details[] .= 'Suspension-Corporate fee type from ['.$this -> getFeeFlgName($origFeeFlg[13]).'] to ['. $this -> getFeeFlgName($this -> domantCorp).']';
		   	}

		   	if($origFixValue[13] != $this -> domantCorpFixValue){
					$details[] .= 'Suspension-Corporate Definite Amount value from ['.$origFixValue[13].'] to ['. $this -> domantCorpFixValue.']';
		   	}

		   	if($origPercentValue[13] != $this -> domantCorpPercentValue){
					$details[] .= 'Suspension-Corporate Percentage value from ['.$origPercentValue[13].'] to ['. $this -> domantCorpPercentValue.']';
		   	}

		   	if($origMaxValue[13] != $this -> domantCorpPercentMax){
					$details[] .= 'Suspension-Corporate maximum value from ['.$origMaxValue[13].'] to ['. $this -> domantCorpPercentMax.']';
		   	}

		   	//delete - Individual
		   	if($origFeeFlg[14] != $this -> deletePerson){
		   			$details[] .= 'Deletion-Individual fee type from ['.$this -> getFeeFlgName($origFeeFlg[14]).'] to ['. $this -> getFeeFlgName($this -> deletePerson).']';
		   	}

		   	if($origFixValue[14] != $this -> deletePersonFixValue){
					$details[] .= 'Deletion-Individual Definite Amount value from ['.$origFixValue[14].'] to ['. $this -> deletePersonFixValue.']';
		   	}

		   	if($origPercentValue[14] != $this -> deletePersonPercentValue){
					$details[] .= 'Deletion-Individual Percentage value from ['.$origPercentValue[14].'] to ['. $this -> deletePersonPercentValue.']';
		   	}

		   	if($origMaxValue[14] != $this -> deletePersonPercentMax){
					$details[] .= 'Deletion-Individual maximum value from ['.$origMaxValue[14].'] to ['. $this -> deletePersonPercentMax.']';
		   	}


		   	//delete - Corp
		   	if($origFeeFlg[15] != $this -> deleteCorp){
		   			$details[] .= 'Deletion-Corporate fee type from ['.$this -> getFeeFlgName($origFeeFlg[15]).'] to ['. $this -> getFeeFlgName($this -> deleteCorp).']';
		   	}

		   	if($origFixValue[15] != $this -> deleteCorpFixValue){
					$details[] .= 'Deletion-Corporate Definite Amount value from ['.$origFixValue[15].'] to ['. $this -> deleteCorpFixValue.']';
		   	}

		   	if($origPercentValue[15] != $this -> deleteCorpPercentValue){
					$details[] .= 'Deletion-Corporate Percentage value from ['.$origPercentValue[15].'] to ['. $this -> deleteCorpPercentValue.']';
		   	}

		   	if($origMaxValue[15] != $this -> deleteCorpPercentMax){
					$details[] .= 'Deletion-Corporate maximum value from ['.$origMaxValue[15].'] to ['. $this -> deleteCorpPercentMax.']';
		   	}

		   	//card - individual
		   	if($origFeeFlg[16] != $this -> cardDepositPerson){
		   			$details[] .= 'Card Deposit-Individual fee type from ['.$this -> getFeeFlgName($origFeeFlg[16]).'] to ['. 
		   			$this -> getFeeFlgName($this -> cardDepositPerson).']';
		   	}

		   	if($origFixValue[16] != $this -> cardDepositPersonFixValue){
					$details[] .= 'Card Deposit-Individual Definite Amount value from ['.$origFixValue[16].'] to ['. $this -> cardDepositPersonFixValue.']';
		   	}

		   	if($origPercentValue[16] != $this -> cardDepositPersonPercentValue){
					$details[] .= 'Card Deposit-Individual Percentage value from ['.$origPercentValue[16].'] to ['. $this -> cardDepositPersonPercentValue.']';
		   	}

		   	if($origMaxValue[16] != $this -> cardDepositPersonPercentMax){
					$details[] .= 'Card Deposit-Individual maximum value from ['.$origMaxValue[16].'] to ['. $this -> cardDepositPersonPercentMax.']';
		   	}		   	

		   	//card - corp
		   	if($origFeeFlg[17] != $this -> cardDepositCorp ){
		   			$details[] .= 'Card Deposit-Corporate fee type from ['.$this -> getFeeFlgName($origFeeFlg[17]).'] to ['. 
		   			$this -> getFeeFlgName($this -> cardDepositCorp).']';
		   	}

		   	if($origFixValue[17] != $this -> cardDepositCorpFixValue){
					$details[] .= 'Card Deposit-Corporate Definite Amount value from ['.$origFixValue[17].'] to ['. $this -> cardDepositCorpFixValue.']';
		   	}

		   	if($origPercentValue[17] != $this -> cardDepositCorpPercentValue){
					$details[] .= 'Card Deposit-Corporate Percentage value from ['.$origPercentValue[17].'] to ['. $this -> cardDepositCorpPercentValue.']';
		   	}

		   	if($origMaxValue[17] != $this -> cardDepositCorpPercentMax){
					$details[] .= 'Card Deposit-Corporate maximum value from ['.$origMaxValue[17].'] to ['. $this -> cardDepositCorpPercentMax.']';
		   	}

		    if($details != NULL){
   				$message = 'Edited '. $newName .'\'s '. implode(', <br/>', $details);
   			}else{
   				$message = 'Saved without any changes';
   			}
		}elseif($type == TYPE_REGITS){
			$message = 'Created new commission setting ['.$this -> name .']';
		}elseif($type == TYPE_DELETE){
			$message = 'Deleted commission setting ['.$this -> getColumnData($rows[0], COLUMN_FEE_TYPE_NAME).']';
		}

		$rtn = array();

		$rtn[] = $this -> getAdminUserData(PARAM_UID);
		$rtn[] = $_SERVER[PARAM_REMOTE_ADDR];
		$rtn[] = $_SERVER[PARAM_HTTP_USER_AGENT];
		$rtn[] = 18;
		$rtn[] = date("Y-m-d H:i:s");
		$rtn[] = $message;

		return $rtn;
  	 	
   }

   /*-------------------------------------------------------------------------
	* @function_name: getActivity
	* @parameter	:
	* @return		:
	-------------------------------------------------------------------------*/
	function getFeeFlgName($int){
		
		$rtn = NO_STRING;

		if($int == 0){
			$rtn = 'Definite Amount';
		}elseif($int == 1){
			$rtn = 'Percentage';
		}elseif($int == 2){
			$rtn = 'Definite Amount & Percentage';
		}

		return $rtn;
	}

	   /*-------------------------------------------------------------------------
	* @function_name: getActivity
	* @parameter	:
	* @return		:
	-------------------------------------------------------------------------*/
	function getAppFlgName($int){
		
		$rtn = NO_STRING;

		if($int == 0){
			$rtn = 'Apply to both side';
		}elseif($int == 1){
			$rtn = 'Apply to left side';
		}elseif($int == 2){
			$rtn = 'Apply to right side';
		}

		return $rtn;
	}
}
?>
