<?php
class RegisterModelClass extends ModelClassEx {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $uId						= NO_STRING;	// UID
	private $account					= NO_STRING;	// 口座番号

	private $email						= NO_STRING;	// メールアドレス
	private $accountType				= NO_STRING;	// 口座種別
	private $year						= NO_STRING;	// 生年月日（年）
	private $month						= NO_STRING;	// 生年月日（月）
	private $day						= NO_STRING;	// 生年月日（日）
	private $country					= NO_STRING;	// 居住国
	private $pw							= NO_STRING;	// パスワード
	private $rePw						= NO_STRING;	// パスワード（再入力）
	private $firstName					= NO_STRING;	// 名
	private $lastName					= NO_STRING;	// 姓
	private $agree						= NO_STRING;	// 同意
	private $receive					= NO_STRING;	// Receive Notification
	private $agent						= NO_STRING;	// エージェントコード

	// ------------------ 法人系 ------------------//
	private $name						= NO_STRING;	// 法人名
	private $tel						= NO_STRING;	// 電話番号
	private $state						= NO_STRING;	// 都道府県
	private $city						= NO_STRING;	// 市区町村
	private $address					= NO_STRING;	// 住所
	private $zipCode					= NO_STRING;	// 郵便番号
	private $ceoName					= NO_STRING;	// 代表者名
	private $siteName					= NO_STRING;	// サイト名
	private $targetCountry				= NO_STRING;	// サービス対象国
	private $corpUrl					= NO_STRING;	// 会社URL
	private $siteUrl					= NO_STRING;	// サイトURL
	private $managerName				= NO_STRING;	// 責任者名
	private $managerEmail				= NO_STRING;	// 責任者メールアドレス
	private $managerTel					= NO_STRING;	// 責任者電話番号
	// ------------------ 法人系 ------------------//

	/*-------------------------------------------------------------------------
	* @function_name: コントロールパネルシステムindexモデルクラスコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		// スーパークラスコンストラクタ呼び出し
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: 初期設定関数
	* @parameter	: なし
	* @return		: 成功:success、失敗:error
	-------------------------------------------------------------------------*/
	public function init() {

		try {

			// パラメータの設定
			$this -> setParameter();

			// チェック
			$this -> validate();

		} catch (Exception $e) {
			throw new Exception(NO_STRING);
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: パラメータの設定
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function setParameter() {
		$this -> email						= $this -> getDataPost(PARAM_EMAIL, true);			// メールアドレス
		$this -> accountType				= $this -> getDataPost(PARAM_ACCOUNT_TYPE, true);		// 口座種別
		$this -> year						= $this -> getDataPost(PARAM_BIRTH_YEAR, true);		// 生年月日（年）
		$this -> month						= $this -> getDataPost(PARAM_BIRTH_MONTH, true);		// 生年月日（月）
		$this -> day						= $this -> getDataPost(PARAM_BIRTH_DAY, true);		// 生年月日（日）
		$this -> country					= $this -> getDataPost(PARAM_COUNTRY, true);			// 居住国
		$this -> pw							= $this -> getDataPost(PARAM_PASSWORD);			// パスワード
		$this -> rePw						= $this -> getDataPost(PARAM_PASSWORD_CONFIRM);	// パスワード（再入力）
		$this -> firstName					= $this -> getDataPost(PARAM_FIRST_NAME, true);		// 名
		$this -> lastName					= $this -> getDataPost(PARAM_LAST_NAME, true);		// 姓
		$this -> agree						= $this -> getDataPost(PARAM_AGREE, true);			// 同意
		$this -> receive					= $this -> getDataPost(PARAM_RECEIVE, true);			// Receive Notification

		// ------------------ 法人系 ------------------//
		$this -> name						= $this -> getDataPost(PARAM_NAME, true);				// 法人名
		$this -> tel						= $this -> getDataPost(PARAM_TEL, true);				// 電話番号
		$this -> state						= $this -> getDataPost(PARAM_STATE, true);			// 都道府県
		$this -> city						= $this -> getDataPost(PARAM_CITY, true);				// 市区町村
		$this -> address					= $this -> getDataPost(PARAM_ADDRESS, true);			// 住所
		$this -> zipCode					= $this -> getDataPost(PARAM_ZIP_CODE, true);			// 郵便番号
		$this -> ceoName					= $this -> getDataPost(PARAM_CEO_NAME, true);			// 代表者名
		$this -> siteName					= $this -> getDataPost(PARAM_SITE_NAME, true);		// サイト名
		$this -> targetCountry				= $this -> getDataPost(PARAM_TARGET_COUNTRY, true);	// サービス対象国
		$this -> corpUrl					= $this -> getDataPost(PARAM_CORP_URL, true);			// 会社URL
		$this -> siteUrl					= $this -> getDataPost(PARAM_SITE_URL, true);			// サイトURL
		$this -> managerName				= $this -> getDataPost(PARAM_MANAGER_NAME, true);		   // 責任者名
		$this -> managerEmail				= $this -> getDataPost(PARAM_MANAGER_EMAIL, true);	      // 責任者メールアドレス
		$this -> managerTel					= $this -> getDataPost(PARAM_MANAGER_TEL, true);		  // 責任者電話番号
		// ------------------ 法人系 ------------------//

		// エージェントコード
		if($this -> getDataGet(PARAM_REFERENCE)				!= NO_STRING) {
			$this -> agent = $this -> getDataGet(PARAM_REFERENCE, true);
			$_SESSION[PARAM_AGENT_CODE] = $this -> agent;
		} else if($this -> getDataPost(PARAM_AGENT_CODE)	!= NO_STRING) {
			$this -> agent = $this -> getDataGet(PARAM_REFERENCE, true);
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: サーバ側データチェック
	* @parameter	: なし
	* @return		: TRUE:成功、FALSE:失敗
	-------------------------------------------------------------------------*/
	public function validate() {

		// 変数宣言部
		$rtn = true;

		// 全ての動作において、エージェントコードが存在しない場合はエラー
		if($this -> agent != NO_STRING
			&& !$this -> checkExistAgentCode($this -> agent)) {
			$this -> popMessageCommon(ERROR, 'E_FATAL_URL', array());
			$this -> setType(TYPE_FAIL);
			return;
		}

		if($this -> getType() == TYPE_INPUT) {				// Step1

            $rtn = $this -> validateEmail();

			if(!$rtn) {
				$this -> setType(NO_STRING);
			}

		} else if($this -> getType() == TYPE_CONFIRM) {		// 確認画面

            // 必須項目
            $rtn = $this -> validateEmail();
            if(!$rtn) {
				$this -> setType(NO_STRING);
				return;
			}

            $rtn = $this -> validateNull();

			if(!$rtn) {
				$this -> setType(TYPE_INPUT);
				return;
			}

            $rtn = $this -> validateCorrect();

			// 結果チェック
			if(!$rtn) {
				$this -> setType(TYPE_INPUT);
			}

		} else if($this -> getType() == TYPE_COMPLETE) {		// 完了時

            $rtn = $this -> validateEmail();
            if(!$rtn) {
				$this -> setType(NO_STRING);
				return;
			}

            $rtn = $this -> validateNull();

			if(!$rtn) {
				$this -> setType(TYPE_INPUT);
				return;
			}

            $rtn = $this -> validateCorrect();

			// 結果チェック
			if(!$rtn) {
				$this -> setType(TYPE_INPUT);
                return;
			}

			// 必須項目
			// debit口座のチェック
			if(!$this -> checkNull($this -> agree)) {
				$this -> popMessageCommon(ERROR, 'E_NOT_AGREE', array());
				$rtn = false;
			} 
			if(!$this -> checkNull($this -> receive)) {
				$this -> popMessageCommon(ERROR, 'E_NOT_RECEIVE', array());
				$rtn = false;
			} 
			
			if(!$rtn) {
				$this -> setType(TYPE_CONFIRM);
			}
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: メールアドレスの取得
	* @parameter	: なし
	* @return		: メールアドレス
	-------------------------------------------------------------------------*/
	public function getEmail() {
		return $this -> email;
	}

	/*-------------------------------------------------------------------------
	* @function_name: メールアドレスの取得
	* @parameter	: なし
	* @return		: メールアドレス
	-------------------------------------------------------------------------*/
	public function echoEmail() {
		echo $this -> email;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座種別の取得
	* @parameter	: なし
	* @return		: 口座種別
	-------------------------------------------------------------------------*/
	public function getAccountType() {
		return $this -> accountType;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座種別の取得
	* @parameter	: なし
	* @return		: 口座種別
	-------------------------------------------------------------------------*/
	public function echoAccountType() {
		echo $this -> accountType;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 生年月日（年）の取得
	* @parameter	: なし
	* @return		: 生年月日（年）
	-------------------------------------------------------------------------*/
	public function echoYear() {
		echo $this -> year;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 生年月日（年）リストの取得
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	public function dispYear() {
		$this -> dispBirthYearList($this -> year);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 生年月日（月）の取得
	* @parameter	: なし
	* @return		: 生年月日（月）
	-------------------------------------------------------------------------*/
	public function echoMonth() {
		echo $this -> month;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 生年月日（月）リストの取得
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	public function dispMonth() {
		$list = $this -> makeNumberList(VAR_BIRTH_MONTH_START, VAR_BIRTH_MONTH_END);
		$selected = $this -> month;

		// 変数宣言部
		$rtn 		= NO_STRING;
		$selectStr	= NO_STRING;
		$minYear = date("Y") - 20;
		$month = date("m");

		foreach($list as $val) {

			// 選択データの場合選択する
			if($selected == NO_STRING) {					// 選択が空文字の場合
				$selectStr = NO_STRING;
			} else if($val[PARAM_DATA_KEY] == $selected) {	// 選択が一致した場合
				$selectStr = 'selected="selected"';
			} else {										// その他
				$selectStr = NO_STRING;
			}

			if($this -> year == $minYear){
				if($month>=$val[PARAM_DATA_VALUE]){
					$rtn .= '<option value="' . $val[PARAM_DATA_KEY] . '" ' . $selectStr . '>' . $val[PARAM_DATA_VALUE] . '</option>';
				}else{
					$rtn .= '<option value="' . $val[PARAM_DATA_KEY] . '" ' . $selectStr . ' disabled="disabled">' . $val[PARAM_DATA_VALUE] . '</option>';
				}
			}else{
				$rtn .= '<option value="' . $val[PARAM_DATA_KEY] . '" ' . $selectStr . '>' . $val[PARAM_DATA_VALUE] . '</option>';
			}
		}

		echo $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 生年月日（日）の取得
	* @parameter	: なし
	* @return		: 生年月日（日）
	-------------------------------------------------------------------------*/
	public function echoDay() {
		echo $this -> day;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 生年月日（日）リストの取得
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	public function dispDay() {
		$list = $this -> makeNumberList(VAR_BIRTH_DAY_START, VAR_BIRTH_DAY_END);
		$selected = $this -> day;

		$rtn 		= NO_STRING;
		$selectStr	= NO_STRING;
		$minYear = date("Y") - 20;
		$minMonth = date("m");
		$day = date("d");

		foreach($list as $val) {

			// 選択データの場合選択する
			if($selected == NO_STRING) {					// 選択が空文字の場合
				$selectStr = NO_STRING;
			} else if($val[PARAM_DATA_KEY] == $selected) {	// 選択が一致した場合
				$selectStr = 'selected="selected"';
			} else {										// その他
				$selectStr = NO_STRING;
			}

			if($this -> year == $minYear&&$this -> month == $minMonth){
				if($day>=$val[PARAM_DATA_VALUE]){
					$rtn .= '<option value="' . $val[PARAM_DATA_KEY] . '" ' . $selectStr . '>' . $val[PARAM_DATA_VALUE] . '</option>';
				}else{
					$rtn .= '<option value="' . $val[PARAM_DATA_KEY] . '" ' . $selectStr . ' disabled="disabled">' . $val[PARAM_DATA_VALUE] . '</option>';
				}
			}else{
				$rtn .= '<option value="' . $val[PARAM_DATA_KEY] . '" ' . $selectStr . '>' . $val[PARAM_DATA_VALUE] . '</option>';
			}
		}

		echo $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 国の取得
	* @parameter	: なし
	* @return		: 国
	-------------------------------------------------------------------------*/
	public function getCountry() {
		return $this -> country;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 国の取得
	* @parameter	: なし
	* @return		: 国
	-------------------------------------------------------------------------*/
	public function echoCountry() {
		echo $this -> dispCountryCommon($this -> country);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 国リストの取得
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	public function dispCountry() {
		echo $this -> dispListOption($this -> getCountyList(), $this -> country);
	}

	/*-------------------------------------------------------------------------
	* @function_name: パスワードの取得
	* @parameter	: なし
	* @return		: パスワード
	-------------------------------------------------------------------------*/
	public function getPassword() {
		return $this -> pw;
	}

	/*-------------------------------------------------------------------------
	* @function_name: パスワードの取得
	* @parameter	: なし
	* @return		: パスワード
	-------------------------------------------------------------------------*/
	public function echoPassword() {
		echo $this -> pw;
	}

	/*-------------------------------------------------------------------------
	* @function_name: パスワード（再入力）の取得
	* @parameter	: なし
	* @return		: パスワード（再入力）
	-------------------------------------------------------------------------*/
	public function echoPasswordConfirm() {
		echo $this -> rePw;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 名の取得
	* @parameter	: なし
	* @return		: 名
	-------------------------------------------------------------------------*/
	public function echoFirstName() {
		echo $this -> firstName;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 姓の取得
	* @parameter	: なし
	* @return		: 姓
	-------------------------------------------------------------------------*/
	public function echoLastName() {
		echo $this -> lastName;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座番号の取得
	* @parameter	: なし
	* @return		: 口座番号
	-------------------------------------------------------------------------*/
	public function getUserAccount() {
		return $this -> account;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 法人名の取得
	* @parameter	: なし
	* @return		: 法人名
	-------------------------------------------------------------------------*/
	public function echoName() {
		echo $this -> name;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 電話番号の取得
	* @parameter	: なし
	* @return		: 電話番号
	-------------------------------------------------------------------------*/
	public function echoTel() {
		echo $this -> tel;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 都道府県の取得
	* @parameter	: なし
	* @return		: 都道府県
	-------------------------------------------------------------------------*/
	public function echoState() {
		echo $this -> state;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 市区町村の取得
	* @parameter	: なし
	* @return		: 市区町村
	-------------------------------------------------------------------------*/
	public function echoCity() {
		echo $this -> city;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 住所の取得
	* @parameter	: なし
	* @return		: 住所
	-------------------------------------------------------------------------*/
	public function echoAddress() {
		echo $this -> address;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 郵便番号の取得
	* @parameter	: なし
	* @return		: 郵便番号
	-------------------------------------------------------------------------*/
	public function echoZipCode() {
		echo $this -> zipCode;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 代表者名の取得
	* @parameter	: なし
	* @return		: 代表者名
	-------------------------------------------------------------------------*/
	public function echoCeoName() {
		echo $this -> ceoName;
	}

	/*-------------------------------------------------------------------------
	* @function_name: サイト名の取得
	* @parameter	: なし
	* @return		: サイト名
	-------------------------------------------------------------------------*/
	public function echoSiteName() {
		echo $this -> siteName;
	}

	/*-------------------------------------------------------------------------
	* @function_name: サービス対象国の取得
	* @parameter	: なし
	* @return		: サービス対象国
	-------------------------------------------------------------------------*/
	public function echoTargetCountry() {
		echo $this -> dispCountryCommon($this -> targetCountry);
	}

	/*-------------------------------------------------------------------------
	* @function_name: サービス対象国リストの取得
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	public function dispTargetCountry() {
		echo $this -> dispListOption($this -> getCountyList(), $this -> targetCountry);
	}

	/*-------------------------------------------------------------------------
	* @function_name: サービス対象国の取得
	* @parameter	: なし
	* @return		: サービス対象国
	-------------------------------------------------------------------------*/
	public function getTargetCountry() {
		return $this -> targetCountry;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 会社URLの取得
	* @parameter	: なし
	* @return		: 会社URL
	-------------------------------------------------------------------------*/
	public function echoCorpUrl() {
		echo $this -> corpUrl;
	}

	/*-------------------------------------------------------------------------
	* @function_name: サイトURLの取得
	* @parameter	: なし
	* @return		: サイトURL
	-------------------------------------------------------------------------*/
	public function echoSiteUrl() {
		if($this -> siteUrl == NO_STRING) {
			echo 'http://';
		} else {
			echo $this -> siteUrl;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: 責任者名の取得
	* @parameter	: なし
	* @return		: 責任者名
	-------------------------------------------------------------------------*/
	public function echoManagerName() {
		echo $this -> managerName;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 責任者メールアドレスの取得
	* @parameter	: なし
	* @return		: 責任者メールアドレス
	-------------------------------------------------------------------------*/
	public function echoManagerEmail() {
		echo $this -> managerEmail;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 責任者電話番号の取得
	* @parameter	: なし
	* @return		: 責任者電話番号
	-------------------------------------------------------------------------*/
	public function echoManagerTel() {
		echo $this -> managerTel;
	}

	/*-------------------------------------------------------------------------
	* @function_name: エージェントコードの取得
	* @parameter	: なし
	* @return		: エージェントコード
	-------------------------------------------------------------------------*/
	public function echoAgent() {
		echo $this -> agent;
	}

	/*-------------------------------------------------------------------------
	* @function_name: エージェントコードの取得（セッション対応）
	* @parameter	: なし
	* @return		: エージェントコード
	-------------------------------------------------------------------------*/
	public function getAgentCode() {

		// 変数宣言部
		$rtn = NO_STRING;

		if($this -> agent != NO_STRING) {												// POSTがあった場合
			$rtn = $_POST[PARAM_AGENT_CODE];
		} else if($this -> getColumnData($_SESSION, PARAM_AGENT_CODE) != NO_STRING) {	// セッションがあった場合
			$rtn = $_SESSION[PARAM_AGENT_CODE];
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 登録用のデータ取得関数
	* @parameter	: なし
	* @return		: 登録用データ配列
	-------------------------------------------------------------------------*/
	public function createParams($uId, $account) {

		// 変数宣言部
		$rtn = array();

		$this -> uId		= $uId;
		$this -> account	= $account;


		if($this -> accountType == VAR_PERSON) {		// 個人口座の場合

			$rtn[]	= $uId;							// UID
			$rtn[] 	= $this -> email;				// メルアド
			$rtn[] 	= $this -> accountType;			// 口座種別
			$rtn[] 	= $account;						// 口座番号
			$rtn[] 	= NO_STRING;					// 電話番号
			$rtn[] 	= $this -> lastName;			// 姓
			$rtn[] 	= $this -> firstName;			// 名
			$rtn[] 	= $this -> year;				// 生年月日（年）
			$rtn[] 	= $this -> month;				// 生年月日（月）
			$rtn[] 	= $this -> day;					// 生年月日（日）
			$rtn[] 	= $this -> country;				// 国
			$rtn[] 	= NO_STRING;					// 都道府県
			$rtn[] 	= NO_STRING;					// 市
			$rtn[] 	= NO_STRING;					// 郵便番号
			$rtn[] 	= NO_STRING;					// 番地
			$rtn[] 	= NO_STRING;					// 番地2
			$rtn[] 	= NO_STRING;					// エージェントコード
			$rtn[] 	= NO_COUNT;						// エージェントフラグ
			$rtn[] 	= $this -> getAgentCode();		// 親エージェントコード
			$rtn[] 	= $_SERVER[PARAM_REMOTE_ADDR];	// 登録IPアドレス
			$rtn[] 	= VAL_INT_1;					// ステータス（仮登録)
			$rtn[] 	= NO_STRING;					// CRM ID
			$rtn[] 	= WHITE_LABEL_ID;				// ホワイトレーベルID
			$rtn[] 	= $this -> getLangage();		// 言語

		} else if($this -> accountType == VAR_CORP) {	// 法人口座の場合

			$rtn[]	= $uId;							// UID
			$rtn[] 	= $this -> email;				// メルアド
			$rtn[] 	= $this -> accountType;			// 口座種別
			$rtn[] 	= $account;						// 口座番号
			$rtn[] 	= $this -> tel;					// 電話番号
			$rtn[] 	= NO_STRING;					// 姓
			$rtn[] 	= $this -> name;				// 名
			$rtn[] 	= $this -> year;				// 生年月日（年）
			$rtn[] 	= $this -> month;				// 生年月日（月）
			$rtn[] 	= $this -> day;					// 生年月日（日）
			$rtn[] 	= $this -> country;				// 国
			$rtn[] 	= $this -> state;				// 都道府県
			$rtn[] 	= $this -> city;				// 市
			$rtn[] 	= $this -> zipCode;				// 郵便番号
			$rtn[] 	= $this -> address;				// 番地
			$rtn[] 	= NO_STRING;					// 番地2
			$rtn[] 	= NO_STRING;					// エージェントコード
			$rtn[] 	= NO_COUNT;						// エージェントフラグ
			$rtn[] 	= $this -> getAgentCode();		// 親エージェントコード
			$rtn[] 	= $_SERVER[PARAM_REMOTE_ADDR];	// 親エージェントコード
			$rtn[] 	= VAL_INT_1;					// ステータス（仮登録
			$rtn[] 	= NO_STRING;					// CRM ID
			$rtn[] 	= WHITE_LABEL_ID;				// ホワイトレーベルID
			$rtn[] 	= $this -> getLangage();		// 言語
			$rtn[]	= $this -> firstName;			// 代表者名（名）
			$rtn[]	= $this -> lastName;			// 代表者名（姓）
			$rtn[]	= $this -> siteUrl;				// サイトURL
			$rtn[]	= $this -> siteName;			// サイト名・屋号
			$rtn[]	= $this -> managerName;			// 責任者名
			$rtn[]	= $this -> managerEmail;		// 責任者メールアドレス
			$rtn[]	= $this -> managerTel;			// 責任者電話番号
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 法人テーブル登録用のデータ取得関数
	* @parameter	: なし
	* @return		: 法人テーブル登録用データ配列
	-------------------------------------------------------------------------*/
	public function createParamsCorporate() {

		// 変数宣言部
		$rtn = array();

		$rtn[]	= $this -> uId;					// UID
		$rtn[]	= $this -> firstName;			// 代表者名（名）
		$rtn[]	= $this -> lastName;			// 代表者名（姓）
		$rtn[]	= $this -> corpUrl;				// 会社URL
		$rtn[]	= $this -> targetCountry;		// サービス提供国
		$rtn[]	= $this -> siteName;			// サイト名・屋号
		$rtn[]	= $this -> siteUrl;				// サイトURL
		$rtn[]	= $this -> managerName;			// 責任者名
		$rtn[]	= $this -> managerEmail;		// 責任者メールアドレス
		$rtn[]	= $this -> managerTel;			// 責任者電話番号

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: HTML表示用のデータ取得関数
	* @parameter	: なし
	* @return		: HTML表示用データ配列
	-------------------------------------------------------------------------*/
	public function dispHTML() {
		return array();
	}

    /*-------------------------------------------------------------------------
	* @function_name: validateEmail - validates the email field
	* @parameter	: none
	* @return		: boolean - true if correct ; false if incorrect
	-------------------------------------------------------------------------*/
    public function validateEmail() {
        $rtn = true;

        //check email
        if(!$this -> checkNull($this -> email)) {
            $this -> popMessageCommon(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_EMAIL));
            $rtn = false;
            return $rtn;
        }

        // メールアドレスの正規表現
        if(!$this -> checkStringMailAddress(addslashes($this -> email))) {
            $this -> popMessageCommon(ERROR, 'E_ERROR_REGULAR_EMAIL', array(VAL_STR_EMAIL));
            $rtn = false;
            return $rtn;
        }

        // メールアドレスの存在確認
        if(!$this -> checkMailAddress($this -> email)) {
            $this -> popMessageCommon(ERROR, 'E_NO_SUCH_ANYTHING_DATA', array(VAL_STR_EMAIL, $this -> email));
            $rtn = false;
            return $rtn;
        }

        // メールアドレスのドメインの存在チェック

        $mails = explode(DELIMIT_AT, $this -> email);

        if(!isset($mails[VAL_INT_1])) {	// @マークがない
            $this -> popMessageCommon(ERROR, 'E_WRONG_DOMAIN', array());
            $rtn = false;
        } else {

            $ip = gethostbyname($mails[VAL_INT_1]);

            $forceValidEmail = $this -> getSettingConfiguration("force_valid_email_domain");
            
            if(!in_array($mails[VAL_INT_1], $forceValidEmail -> registration)){
                if($ip == $mails[VAL_INT_1]) {
                    $this -> popMessageCommon(ERROR, 'E_WRONG_DOMAIN', array());
                    $rtn = false;
                }
            }

            // ワンタイムドメインのチェック
            $list = $this -> getInvalidDomainList();
            if($this -> getColumnData($list, $mails[VAL_INT_1]) != NO_STRING) {
                $this -> popMessageCommon(ERROR, 'E_WRONG_DOMAIN', array());
                $rtn = false;
            }
        }

        return $rtn;
    }

    /*-------------------------------------------------------------------------
	* @function_name: validateCorrect - validates if the input fields are empty/null
	* @parameter	: none
	* @return		: boolean - true if all are non-empty ; false if there is 1 or more empty
	-------------------------------------------------------------------------*/
    public function validateNull() {
        $rtn = true;

        // 必須項目
        // パスワード（共通）
        if(!$this -> checkNull($this -> pw)) {
            $this -> popMessageCommon(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_PASSWORD));
            $rtn = false;
        }

        if($this -> accountType == VAR_PERSON) {		// 個人口座の場合

            // 名
            if(!$this -> checkNull($this -> firstName)) {
                $this -> popMessageCommon(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_FIRST_NAME));
                $rtn = false;
            }

            // 姓
            if(!$this -> checkNull($this -> lastName)) {
                $this -> popMessageCommon(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_LAST_NAME));
                $rtn = false;
            }

            // 国コードの取得
            if(!$this -> checkNull($this -> country)) {
                $this -> popMessageCommon(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_COUNTRY));
                $rtn = false;
            }

        } else if($this -> accountType == VAR_CORP) {	// 法人口座の場合

            // 法人名
            if(!$this -> checkNull($this -> name)) {
                $this -> popMessageCommon(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_CORP_NAME));
                $rtn = false;
            }

            // 電話番号
            if(!$this -> checkNull($this -> tel)) {
                $this -> popMessageCommon(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_TEL));
                $rtn = false;
            }

            // 名
            if(!$this -> checkNull($this -> firstName)) {
                $this -> popMessageCommon(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_CEO_FIRST_NAME));
                $rtn = false;
            }

            // 姓
            if(!$this -> checkNull($this -> lastName)) {
                $this -> popMessageCommon(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_CEO_LAST_NAME));
                $rtn = false;
            }

            // 都道府県
            if(!$this -> checkNull($this -> state)) {
                $this -> popMessageCommon(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_STATE));
                $rtn = false;
            }

            // 市区町村
            if(!$this -> checkNull($this -> city)) {
                $this -> popMessageCommon(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_CITY));
                $rtn = false;
            }

            // 住所・建物名
            if(!$this -> checkNull($this -> address)) {
                $this -> popMessageCommon(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_ADDRESS));
                $rtn = false;
            }

            // 郵便番号
            if(!$this -> checkNull($this -> zipCode)) {
                $this -> popMessageCommon(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_ZIP_CODE));
                $rtn = false;
            }

            // サイトURL
            if(!$this -> checkNull($this -> siteUrl)) {
                $this -> popMessageCommon(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_SITE_URL));
                $rtn = false;
            }
        }

        return $rtn;
    }

    /*-------------------------------------------------------------------------
	* @function_name: validateCorrect - validates if the input fields are correct
	* @parameter	: none
	* @return		: boolean - true if all are valid ; false if there is 1 or more invalid
	-------------------------------------------------------------------------*/
    public function validateCorrect() {
        $rtn = true;

        // パスワードの正規表現
        if(!$this -> checkStringPassword($this -> pw)) {
            $this -> popMessageCommon(ERROR, 'E_ERROR_REGULAR_PASSWORD', array(VAL_STR_PASSWORD));
            $rtn = false;
        } else {

            if(!$this -> checkStringPasswordSecond($this -> pw)) {
                $this -> popMessageCommon(ERROR, 'E_ERROR_REGULAR_PASSWORD_SECOND', array(VAL_STR_PASSWORD));
                $rtn = false;
            }
        }

        // パスワードの文字数制限
        if(!$this -> checkLength($this -> pw
                                , VAR_PASSWORD_MIN
                                , VAR_PASSWORD_MAX)) {
            $this -> popMessageCommon(ERROR, 'E_ERROR_STRING_LENGTH_ANY', array(VAL_STR_PASSWORD
                                                                                    , VAR_PASSWORD_MIN
                                                                                    , VAR_PASSWORD_MAX));
            $rtn = false;
        }

        // パスワード複合チェック
        // 新パスワードの文字数制限
        if($this -> getType() != TYPE_COMPLETE){
            if($this -> pw != $this -> rePw) {
                $this -> popMessageCommon(ERROR, 'E_ERROR_CONFIRM', array(VAL_STR_PASSWORD));
                $rtn = false;
            }
        }

        if($this -> accountType == VAR_PERSON) {		// 個人口座の場合

            // 名の正規表現
            if(!$this -> checkStringAlphabetAndSpace($this -> firstName)) {
                $this -> popMessageCommon(ERROR, 'E_ERROR_REGULAR_EMAIL', array(VAL_STR_FIRST_NAME));
                $rtn = false;
            }

            // 名の文字数制限
            if(!$this -> checkLength($this -> firstName
                                    , VAL_INT_1
                                    , VAL_INT_64)) {
                $this -> popMessageCommon(ERROR, 'E_ERROR_STRING_LENGTH_ANY', array(VAL_STR_FIRST_NAME
                                                                                    , VAL_INT_1
                                                                                    , VAL_INT_64));
                $rtn = false;
            }

            // 姓の正規表現
            if(!$this -> checkStringAlphabetAndSpace($this -> lastName)) {
                $this -> popMessageCommon(ERROR, 'E_ERROR_REGULAR_EMAIL', array(VAL_STR_LAST_NAME));
                $rtn = false;
            }

            // 姓の文字数制限
            if(!$this -> checkLength($this -> lastName
                                    , VAL_INT_1
                                    , VAL_INT_64)) {
                $this -> popMessageCommon(ERROR, 'E_ERROR_STRING_LENGTH_ANY', array(VAL_STR_LAST_NAME
                                                                                    , VAL_INT_1
                                                                                    , VAL_INT_64));
                $rtn = false;
            }

            // 日付のチェック
            if(!$this -> checkDate($this -> year
                                    , $this -> month
                                    , $this -> day)) {
                $this -> popMessageCommon(ERROR, 'E_DATE_VALUE', array($this -> year
                                                                        , $this -> month
                                                                        , $this -> day));
                $rtn = false;
            }

        } else if($this -> accountType == VAR_CORP) {	// 法人口座の場合

            ////////////// 法人名 //////////////

            // 法人名の文字数制限
            if(!$this -> checkLength($this -> name
                                    , VAL_INT_1
                                    , VAL_INT_64)) {
                $this -> popMessageCommon(ERROR, 'E_ERROR_STRING_LENGTH_ANY', array(VAL_STR_CORP_NAME
                                                                                    , VAL_INT_1
                                                                                    , VAL_INT_64));
                $rtn = false;
            }

            ////////////// 法人名 //////////////

            ////////////// 電話番号 //////////////

            if(!$this -> checkStringNumberTel($this -> tel)) {
                $this -> popMessageCommon(ERROR, 'E_ERROR_REGULAR_NUMBER_TEL', array(VAL_STR_TEL, VAL_INT_20));
                $rtn = false;
            }

            if(!$this -> checkLength($this -> tel
                                    , VAL_INT_7
                                    , VAL_INT_20)) {
                $this -> popMessageCommon(ERROR, 'E_ERROR_STRING_LENGTH_ANY', array(VAL_STR_TEL
                                                                                    , VAL_INT_7
                                                                                    , VAL_INT_20));
                $rtn = false;
            }

            ////////////// 電話番号 //////////////

            ////////////// 代表者氏名 //////////////

            // 名の正規表現
            if(!$this -> checkStringAlphabetAndSpace($this -> firstName)) {
                $this -> popMessageCommon(ERROR, 'E_ERROR_REGULAR_EMAIL', array(VAL_STR_CEO_FIRST_NAME));
                $rtn = false;
            }

            // 名の文字数制限
            if(!$this -> checkLength($this -> firstName
                                    , VAL_INT_1
                                    , VAL_INT_32)) {
                $this -> popMessageCommon(ERROR, 'E_ERROR_STRING_LENGTH_ANY', array(VAL_STR_CEO_FIRST_NAME
                                                                                    , VAL_INT_1
                                                                                    , VAL_INT_32));
                $rtn = false;
            }

            // 姓の正規表現
            if(!$this -> checkStringAlphabetAndSpace($this -> lastName)) {
                $this -> popMessageCommon(ERROR, 'E_ERROR_REGULAR_EMAIL', array(VAL_STR_CEO_LAST_NAME));
                $rtn = false;
            }

            // 姓の文字数制限
            if(!$this -> checkLength($this -> lastName
                                    , VAL_INT_1
                                    , VAL_INT_32)) {
                $this -> popMessageCommon(ERROR, 'E_ERROR_STRING_LENGTH_ANY', array(VAL_STR_CEO_LAST_NAME
                                                                                    , VAL_INT_1
                                                                                    , VAL_INT_32));
                $rtn = false;
            }

            ////////////// 代表者氏名 //////////////

            ////////////// 都道府県 //////////////

            if(!$this -> checkStringAsciiStateAndCity($this -> state)) {
                $this -> popMessageCommon(ERROR, 'E_ERROR_REGULAR_ASCII_STATE_CITY', array(VAL_STR_STATE, VAL_INT_64));
                $rtn = false;
            }

            if(!$this -> checkLength($this -> state
                                    , VAL_INT_1
                                    , VAL_INT_64)) {
                $this -> popMessageCommon(ERROR, 'E_ERROR_STRING_LENGTH_ANY', array(VAL_STR_STATE
                                                                                    , VAL_INT_1
                                                                                    , VAL_INT_64));
                $rtn = false;
            }

            ////////////// 都道府県 //////////////

            ////////////// 市区町村 //////////////

            if(!$this -> checkStringAsciiStateAndCity($this -> city)) {
                $this -> popMessageCommon(ERROR, 'E_ERROR_REGULAR_ASCII_STATE_CITY', array(VAL_STR_CITY, VAL_INT_64));
                $rtn = false;
            }

            if(!$this -> checkLength($this -> city
                                    , VAL_INT_1
                                    , VAL_INT_64)) {
                $this -> popMessageCommon(ERROR, 'E_ERROR_STRING_LENGTH_ANY', array(VAL_STR_CITY
                                                                                        , VAL_INT_1
                                                                                        , VAL_INT_64));
                $rtn = false;
            }

            ////////////// 市区町村 //////////////

            ////////////// 住所・建物名 //////////////

            // 住所のチェック
            if(!$this -> checkStringAddress($this -> address)) {
                $this -> popUpSessionMessage(ERROR, 'E_ERROR_REGULAR_ASCII_ADDRESS', array(VAL_STR_ADDRESS, VAL_INT_128));
                $rtn = false;
            }

            if(!$this -> checkLength($this -> address
                                    , VAL_INT_1
                                    , VAL_INT_128)) {
                $this -> popUpSessionMessage(ERROR, 'E_ERROR_STRING_LENGTH_ANY', array(VAL_STR_ADDRESS
                                                                                        , VAL_INT_1
                                                                                        , VAL_INT_128));
                $rtn = false;
            }

            ////////////// 住所・建物名 //////////////

            ////////////// 郵便番号 //////////////

            if(!$this -> checkStringNumberZipCode($this -> zipCode)) {
                $this -> popUpSessionMessage(ERROR, 'E_ERROR_REGULAR_NUMBER_ZIP_CODE', array(VAL_STR_ZIP_CODE));
                $rtn = false;
            }

            ////////////// 郵便番号 //////////////

            ////////////// サイトURL //////////////

            // URLの文字数制限
            if(!$this -> checkLength($this -> siteUrl
                                    , VAL_INT_1
                                    , VAL_INT_256)) {
                $this -> popMessageCommon(ERROR, 'E_ERROR_STRING_LENGTH_ANY', array(VAL_STR_SITE_URL
                                                                                    , VAL_INT_1
                                                                                    , VAL_INT_256));
                $rtn = false;
            }

            // URLの正規表現
            if(!$this -> checkStringURL($this -> siteUrl)) {
                $this -> popMessageCommon(ERROR, 'E_ERROR_REGULAR_EMAIL', array(VAL_STR_SITE_URL));
                $rtn = false;
            }

            ////////////// サイトURL //////////////

            // 日付のチェック
            if(!$this -> checkDate(intval($this -> year)
                                    , intval($this -> month)
                                    , intval($this -> day))) {
                $this -> popMessageCommon(ERROR, 'E_DATE_VALUE', array($this -> year
                                                                        , $this -> month
                                                                        , $this -> day));
                $rtn = false;
            }
        }

        if(!$this -> checkLimitAge($this -> country
                                    , $this -> year
                                    , $this -> month
                                    , $this -> day)) {
            $this -> popMessageCommon(ERROR, 'E_LIMIT_AGE', array());
            $rtn = false;
        }

        return $rtn;
    }
}
?>