<?php
require_once(SITE_LOGICS . 'login/model.php');

class LogicLogin extends LoginModelClass {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $htmlStr = NO_STRING;	// 表示用HTML文字列

	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: ロジック（各クラス共通）
	* @parameter	: なし
	* @return		: TRUE:ロジック成功、FALSE:ロジック失敗
	-------------------------------------------------------------------------*/
	function logic() {

		try {
var_dump(11111);exit;
			// 初期データ処理
			if($this -> init()) {
				
				$this -> accountType    = $this -> getColumnData(($this -> getRowData($this -> getAccountCommon($this -> getUserData(PARAM_USER_ACCOUNT)))),'account_type');
				if($this -> accountType == VAL_INT_1){
					//check if 2fa is enabled
					if($this -> check2FAEnabled($this -> getUserData(PARAM_USER_ACCOUNT), 'login')){
						//check if 2fa validated
						if(!$this -> checkIs2FAValidated()) {
							$this -> setType('veri_error');
							$this -> destroySessionUserData();
							return;
						}
					}
				}

				// ロジック実行
				$this -> biz();
				if($this -> getType() == TYPE_VERI_ERROR) {
					return TYPE_VERI_ERROR;
				} else {
					return TYPE_COMPLETE;
				}
			}

		} catch (Exception $e) {
			throw $e;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: ロジックの実行
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function biz() {


		//create session variable for 2favalidated
		$_SESSION['2fa_validated'] = 'not validated';

		if($this -> getType() != TYPE_VERI_ERROR) {
			$this -> regist();	// ログイン履歴を登録
			$this -> update();	// 最終ログイン日時を更新
			$this -> enable2fa($this -> getLang());	//发送启用二次认证code邮件
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: 登録処理
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function regist() {
		$this -> accessModify('INSERT_LOGIN_HIOSTORY', array($this -> getUserData(PARAM_UID)
															, $_SERVER[PARAM_REMOTE_ADDR]
															, $_SERVER[PARAM_HTTP_USER_AGENT])
															, false);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 更新処理
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function update() {
		$this -> accessModify('UPDATE_LAST_LOGIN_TIME', array($this -> getUserData(PARAM_UID),false));
	}

	/*-------------------------------------------------------------------------
	* @function_name: ページ出力文字列取得関数
	* @parameter	: なし
	* @return		: HTML文字列
	-------------------------------------------------------------------------*/
	function getDisplay() {
		return $this -> htmlStr;
	}


	/*-------------------------------------------------------------------------
	* @function_name: 首次使用二次认证code 发送邮件
	* @parameter	: なし
	* @return		: HTML文字列
	-------------------------------------------------------------------------*/
	function  enable2fa($lang){
		$param = array();
		$useraccount = $this -> getColumnData(($this -> accessSelect('SELECT_2FA_USER_ACCOUNT',array($this ->  getUserId())))[0],'user_account');
		$rtn = $this -> accessSelect('SELECT_2FA_ENABLE',array($useraccount));
		if ($this -> getColumnData($rtn[0],'enablemail') == NO_COUNT) {
			$this -> accessModify('UPDATE_2FA_ENABLE_MAIL', array('1',$useraccount,$lang),false);
			if ($this -> checkAccountType($this -> getUserId())) {
			$param[] = $useraccount;
			$param[] = $this -> getColumnData($rtn[0],'first_name').' '.$this -> getColumnData($rtn[0],'last_name');

			$this -> sendMailByTmpFromManual('2fa_enable.xml'
			    , $param
			    , $this ->  getUserId()
			    , VAR_CS_MAIL_ADDRESS
			    , $lang);
			}
		}
	}
}
?>