<?php

require_once('config.php');

/**
 * 
 * @author Anton
 *
 */
class CalculateFee extends System {

    private $fromAccount;
    private $toAccount;
    private $fromCurrency;
    private $toCurrency;
    private $amount;
    
    private $contentType;
    
    private function initParams(){
        $this -> fromAccount    = isset($_REQUEST["fromAccount"]) ? $this -> getAccountCommon($_REQUEST["fromAccount"])[0] : null;
        $this -> toAccount      = isset($_REQUEST["toAccount"]) ? $this -> getAccountCommon($_REQUEST["toAccount"])[0] : null;
        $this -> amount         = isset($_REQUEST["amount"]) ? intval($_REQUEST["amount"]) : 0;
        $this -> fromCurrency   = isset($_REQUEST["fromCurrency"]) ? $_REQUEST["fromCurrency"] : NO_STRING;
        $this -> toCurrency     = isset($_REQUEST["toCurrency"]) ? $_REQUEST["toCurrency"] : NO_STRING;
        
        $this -> contentType    = isset($_SERVER["CONTENT_TYPE"]) ? $_SERVER["CONTENT_TYPE"] : NO_STRING;
    }
    
    private function validateParams(){
        $conditions = [
            [ 
                "notvalid" => ($this -> contentType != "application/x-www-form-urlencoded"),
                "message" => "Invalid Content Type (or not specified)",
                "code" => 1
            ],
            [
                "notvalid" => ($_SERVER["REQUEST_METHOD"] != "POST"),
                "message" => "Request method should be post",
                "code" => 2
            ],
            [
                "notvalid" => (!isset($_REQUEST["fromAccount"]) || empty($_REQUEST["fromAccount"])),
                "message" => "Requestee Account No. is required.",
                "code" => 3
            ],
            [
                "notvalid" => (!isset($_REQUEST["toAccount"]) || empty($_REQUEST["toAccount"])),
                "message" => "Requester Account No. is required.",
                "code" => 4
            ],
            [
                "notvalid" => (!isset($_REQUEST["fromCurrency"]) || empty($_REQUEST["fromCurrency"])),
                "message" => "Requestee currency No. is required.",
                "code" => 5
            ],
            [
                "notvalid" => (!isset($_REQUEST["toCurrency"]) || empty($_REQUEST["toCurrency"])),
                "message" => "Requester currency is required.",
                "code" => 6
            ],
            [
                "notvalid" => empty($this -> amount),
                "message" => "Amount specified is 0 (or no amount specified.)",
                "code" => 7
            ],
            [
                "notvalid" => ($this -> fromAccount == null),
                "message" => "Requestee Account # doesn't exist",
                "code" => 8
            ],
            [
                "notvalid" => ($this -> toAccount == null),
                "message" => "Requester Account # doesn't exist",
                "code" => 9
            ],
            [
                "notvalid" => ($this -> getColumnData($this -> fromAccount, COLUMN_STATUS) == 1),
                "message" => "Requestee Account is on 'Temporary Registration' status",
                "code" => 10
            ],
            [
                "notvalid" => ($this -> getColumnData($this -> toAccount, COLUMN_STATUS) == 1),
                "message" => "Requester Account is on 'Temporary Registration' status",
                "code" => 11
            ],
            [
                "notvalid" => ($this -> getColumnData($this -> fromAccount, COLUMN_USER_ACCOUNT) == $this -> getColumnData($this -> toAccount, COLUMN_USER_ACCOUNT)),
                "message" => "Requestee and Requester account cannot be the same.",
                "code" => 12
            ],
            [
                "notvalid" => empty($this -> fromCurrency),
                "message" => "Requestee Currency is missing.",
                "code" => 13
            ],
            [
                "notvalid" => empty($this -> toCurrency),
                "message" => "Requester Currency is missing.",
                "code" => 14
            ]
        ];
        
       
        foreach($conditions as $validation){     
            if($validation["notvalid"])
                throw new Exception($validation["message"], $validation["code"]);
        }
    }
    
    private function compute(){
        $calculation = [
            "type" => "transactional",
            "requestee" => $this -> getColumnData($this -> fromAccount, COLUMN_USER_ACCOUNT),
            "requestee_cur" => $this -> fromCurrency,
            "requester" => $this -> getColumnData($this -> toAccount, COLUMN_USER_ACCOUNT),
            "requester_cur" => $this -> toCurrency,
            "originalAmount" => $this -> amount,
            "convertedAmount" => $this -> amount
        ];
        
        if($this -> fromCurrency != $this -> toCurrency){
            $exchange = $this -> getExchangeCommon($this -> amount
                , $this -> fromCurrency
                , $this -> toCurrency
                , false
                , true
                , NO_STRING
                , $this -> getColumnData($this -> fromAccount, COLUMN_USER_ACCOUNT));
            
            $calculation["convertedAmount"] = $this -> getColumnData($exchange, PARAM_AMOUNT);
        }
        
        $fee = $this -> getFeeCommon(VAR_TRANSFER
            , $calculation["convertedAmount"]
            , $this -> fromCurrency
            , $this -> getColumnData($this -> fromAccount, COLUMN_USER_ACCOUNT)
            , $this -> getColumnData($this -> toAccount, COLUMN_USER_ACCOUNT)
            , $this -> toCurrency
            , $this -> amount);
                
        $calculation["fromFee"] = $this -> getAmountString($this -> getColumnData($fee, "{$this -> fromCurrency}1"), $this -> fromCurrency);
        $calculation["toFee"] = $this -> getAmountString($this -> getColumnData($fee, "{$this -> toCurrency}2"), $this -> toCurrency);
        
        echo json_encode($calculation);
    }
    
    public function action(){
        header("Content-Type: text/plain");
        
        try{
            $this -> initParams();
            
            $this -> validateParams();
            
            $this -> compute();
        }catch(Exception $ex){
            $trace = [
                "type" => "exception",
                "excode" => $ex->getCode(),
                "exmssg" => $ex->getMessage()
            ];
            echo json_encode($trace);
        }
    }
}

$cf = new CalculateFee();
$cf -> action();