<?php
class RequestModelClass extends ModelClassEx {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $rs					= null;			// 結果セット
	private $detail				= null;			// 詳細データ
	private $rId				= NO_STRING;	// 引き落としID
	private $createTime			= NO_STRING;	// 処理日時
	private $currency			= NO_STRING;	// 申請通貨
	private $amount				= NO_STRING;	// 申請金額
	private $fromName			= NO_STRING;	// 送金名義
	private $fromAccountNumber	= NO_STRING;	// 送金口座番号
	private $fromAccountType	= NO_STRING;	// 送金口座種別
	private $toName				= NO_STRING;	// 申請名義
	private $toAccountNumber	= NO_STRING;	// 申請口座番号
	private $toAccountType		= NO_STRING;	// 申請口座種別
	private $updateTime			= NO_STRING;	// 処理日時
	private $status				= NO_STRING;	// ステータス
	private $debitCurrency		= NO_STRING;	// 出金通貨
	private $debitAmount		= NO_STRING;	// 出金金額
	private $rate				= NO_STRING;	// 出金レート
	private $fromFee			= NO_STRING;	// 支払手数料
	private $toFee				= NO_STRING;	// 申請手数料
	private $requestMessage		= NO_STRING;	// 申請メッセージ
	private $sendMessage		= NO_STRING;	// 送金メッセージ
	private $comment			= NO_STRING;	// 管理者コメント
	private $tNumber			= NO_STRING;

	// ------------------ 検索系 ------------------//
	private $sRequestType		= NO_STRING;	// 検索対象
	private $sAccount			= NO_STRING;	// 検索口座番号
	private $sAccountName		= NO_STRING;	// 検索口座名
	private $sCurrency			= NO_STRING;	// 検索通貨
	private $sStatusProc		= VAL_INT_1;	// 検索状態（処理中）
	private $sStatusComp		= VAL_INT_1;	// 検索状態（完了）
	private $sStatusRefund		= VAL_INT_1;	// 検索状態（拒否）
	private $sFrom				= NO_STRING;	// 検索開始日
	private $sTo				= NO_STRING;	// 検索終了日
	private $sTransactionNumber	= NO_STRING;	// 取引番号

	//新しいメンバー
	private $listCount;

	/**
	 *
	 * anton
	 *
	 */
	private $lang				= NO_STRING;

	/*-------------------------------------------------------------------------
	* @function_name: コントロールパネルシステムindexモデルクラスコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		// スーパークラスコンストラクタ呼び出し
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: 初期設定関数
	* @parameter	: なし
	* @return		: 成功:success、失敗:error
	-------------------------------------------------------------------------*/
	public function init() {

		try {

			// パラメータの設定
			$this -> setParameter();

			// チェック
			return $this -> validate();

		} catch (Exception $e) {
			throw new Exception(NO_STRING);
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: パラメータの設定
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function setParameter() {
		$this -> rId				= $this -> getDataPost(PARAM_R_ID);					// 引き落としID
		$this -> comment			= $this -> getDataPost(PARAM_COMMENT);				// 管理者コメント

		$this -> sRequestType		= $this -> getDataPost(PARAM_S_REQUEST_TYPE);		// 検索対象
		$this -> sAccount			= $this -> getDataPost(PARAM_S_ACCOUNT);			// 検索口座番号
		$this -> sAccountName		= $this -> getDataPost(PARAM_S_ACCOUNT_NAME);		// 検索口座名
		$this -> sCurrency			= $this -> getDataPost(PARAM_S_CURRENCY);			// 検索通貨
		$this -> sFrom				= $this -> getDataPost(PARAM_S_FROM);				// 検索開始日
		$this -> sTo				= $this -> getDataPost(PARAM_S_TO);					// 検索終了日
		$this -> sTransactionNumber	= $this -> getDataPost(PARAM_TRANSACTION_NUMBER);	// 取引番号
		$this -> testAccountFlg		= $this -> getDataPost(PARAM_TEST_ACCOUNT_FLG);			// WLID

		// 検索だった場合
		if($this -> getType() == TYPE_SEARCH || $this -> getType() == TYPE_EXPORT) {
			$this -> sStatusProc	= $this -> getDataPost(PARAM_S_STATUS_PROC);		// 検索状態（処理中）
			$this -> sStatusComp	= $this -> getDataPost(PARAM_S_STATUS_COMP);		// 検索状態（完了）
			$this -> sStatusRefund	= $this -> getDataPost(PARAM_S_STATUS_REFUND);		// 検索状態（拒否）
		}

		$this -> lang				= $this -> getLangage();
	}

	/*-------------------------------------------------------------------------
	* @function_name: パラメータの設定
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function restore() {
		$this -> tNumber			= $this -> getColumnData($this -> detail, COLUMN_TRANSACTION_NUMBER);
		$this -> createTime			= $this -> getColumnData($this -> detail, COLUMN_CREATE_TIME);							// 処理日時
		$this -> currency			= $this -> getColumnData($this -> detail, COLUMN_CURRENCY);								// 申請通貨
		$this -> amount				= $this -> getColumnData($this -> detail, COLUMN_AMOUNT);								// 申請金額
		$this -> fromName			= $this -> getColumnData($this -> detail, COLUMN_FROM_LAST_NAME)
										. DELIMIT_SPACE . $this -> getColumnData($this -> detail, COLUMN_FROM_FIRST_NAME);	// 送金名義
		$this -> fromAccountNumber	= $this -> getColumnData($this -> detail, COLUMN_FROM_ACCOUNT);							// 送金口座番号
		$this -> fromAccountType	= $this -> getColumnData($this -> detail, COLUMN_FROM_ACCOUNT_TYPE);					// 送金口座種別
		$this -> toName				= $this -> getColumnData($this -> detail, COLUMN_TO_LAST_NAME)
										. DELIMIT_SPACE . $this -> getColumnData($this -> detail, COLUMN_TO_FIRST_NAME);	// 申請名義
		$this -> toAccountNumber	= $this -> getColumnData($this -> detail, COLUMN_TO_ACCOUNT);							// 申請口座番号
		$this -> toAccountType		= $this -> getColumnData($this -> detail, COLUMN_TO_ACCOUNT_TYPE);						// 申請口座種別
		$this -> updateTime			= $this -> getColumnData($this -> detail, COLUMN_UPDATE_TIME);							// 処理日時
		$this -> status				= $this -> getColumnData($this -> detail, COLUMN_STATUS);								// ステータス
		$this -> debitCurrency		= $this -> getColumnData($this -> detail, COLUMN_DEBIT_CURRENCY);						// 出金通貨
		$this -> debitAmount		= $this -> getColumnData($this -> detail, COLUMN_DEBIT_AMOUNT);							// 出金金額
		$this -> rate				= $this -> getColumnData($this -> detail, COLUMN_RATE);									// 出金レート
		$this -> fromFee			= $this -> getColumnData($this -> detail, COLUMN_FROM_FEE);								// 支払手数料
		$this -> toFee				= $this -> getColumnData($this -> detail, COLUMN_TO_FEE);								// 申請手数料
		$this -> requestMessage		= $this -> getColumnData($this -> detail, COLUMN_MESSAGE);								// 申請メッセージ
		$this -> sendMessage		= $this -> getColumnData($this -> detail, COLUMN_SEND_MESSAGE);							// 送金メッセージ
		$this -> comment			= $this -> getColumnData($this -> detail, COLUMN_COMMENT);								// 管理者コメント
		$this -> sStatusProc			= $this -> getColumnData($this -> detail, COLUMN_COMMENT);								// 管理者コメント
		$this -> sStatusComp			= $this -> getColumnData($this -> detail, COLUMN_COMMENT);								// 管理者コメント
		$this -> sStatusRefund			= $this -> getColumnData($this -> detail, COLUMN_COMMENT);								// 管理者コメント
	}

	/*-------------------------------------------------------------------------
	* @function_name: サーバ側データチェック
	* @parameter	: なし
	* @return		: TRUE:成功、FALSE:失敗
	-------------------------------------------------------------------------*/
	public function validate() {

		// 変数宣言部
		$rtn = true;

		// ログインチェック
		if(!$this -> checkAdminUserLogin()) {
			throw new Exception(NO_STRING);
		}

		/**
		 *
		 * -- anton --
		 * 04/22/2019
		 *
		 */
		$redirect = ($this -> lang != "en" ? "" : "{$this -> lang}/");

		//check access
		if(!$this -> checkAdminUserAccess('WLST', array(''))){
			$this -> popUpSessionMessage(ERROR, 'E_ERROR_NO_PAGE_ACCESS', array());
			header('Location: /'.$redirect.'menu');
			exit();
		}

		if($this -> getType() == TYPE_DETAIL) {
			//check access
			if(!$this -> checkAdminUserAccess('WDTL', array(''))){
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_NO_PAGE_ACCESS', array());
				header('Location: /'.$redirect.'menu');
				exit();
			}
		}

		if($this -> getType() == TYPE_DELETE) {
			//check access
			if(!$this -> checkAdminUserAccess('WDTL', array('','2'))){
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_NO_FUNCTION_ACCESS', array());
				header('Location: /'.$redirect.'menu');
				exit();
			}
		}

		if($this -> getType() == TYPE_SAVE) {
			//check access
			if(!$this -> checkAdminUserAccess('WDTL', array('','1'))){
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_NO_FUNCTION_ACCESS', array());
				header('Location: /'.$redirect.'menu');
				exit();
			}
		}

		if($this -> getType() == TYPE_INPUT) {

			// データの確認
			if(!$this -> existAccount($this -> userAccount)) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_NOT_EXIST', array(VAL_STR_USER_ACCOUNT));
				$this -> setType(CONTROL_ACTION);
				$rtn = false;
			}
		} else if($this -> getType()		== TYPE_ROLL_BACK
					|| $this -> getType()	== TYPE_SAVE) {

		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: HTML表示用のデータ取得関数
	* @parameter	: なし
	* @return		: HTML表示用データ配列
	-------------------------------------------------------------------------*/
	public function dispHTML() {
		return array();
	}

	/*-------------------------------------------------------------------------
	* @function_name: 検索条件パラメータの取得
	* @parameter	: なし
	* @return		: 検索条件パラメータ
	-------------------------------------------------------------------------*/
	public function getWhere() {

		// 変数宣言部
		$rtnParams = array();

		if($this -> sTransactionNumber != NO_STRING) {			// 取引番号
			$rtnParams[] = ' request.transaction_number = (\')' . $this -> sTransactionNumber . '(\') ';
		}

		if($this -> sRequestType == NO_STRING) {		// すべて対象

			if($this -> sAccount != NO_STRING) {		// 口座番号
				$rtnParams[] = ' (request.from_account = (\')' . $this -> sAccount . '(\') OR request.to_account = (\')' . $this -> sAccount . '(\')) ';
			}

			if($this -> sAccountName != NO_STRING) {	// 口座名義
				$rtnParams[] = ' (from_user.user_name = (\')' . $this -> sAccountName . '(\') OR to_user.user_name = (\')' . $this -> sAccountName . '(\'))';
			}

		} else if($this -> sRequestType == VAL_INT_1) {	// 請求者

			if($this -> sAccount != NO_STRING) {		// 口座番号
				$rtnParams[] = ' request.from_account = (\')' . $this -> sAccount . '(\') ';
			}

			if($this -> sAccountName != NO_STRING) {	// 口座名義
				$rtnParams[] = ' from_user.user_name = (\')' . $this -> sAccountName . '(\') ';
			}
		} else if($this -> sRequestType == VAL_INT_2) {	// 支払者

			if($this -> sAccount != NO_STRING) {		// 口座番号
				$rtnParams[] = ' request.to_account = (\')' . $this -> sAccount . '(\') ';
			}

			if($this -> sAccountName != NO_STRING) {	// 口座名義
				$rtnParams[] = ' to_user.user_name = (\')' . $this -> sAccountName . '(\') ';
			}
		}

		if($this -> sCurrency != NO_STRING) {		// 通貨
			$rtnParams[] = ' request.currency = (\')' . $this -> sCurrency . '(\') ';
		}

		if($this -> sFrom != NO_STRING) {			// 開始日
			$rtnParams[] = ' request.create_time >= (\')' . $this -> sFrom . ' 00:00:00(\') ';
		}else{
			// english-comment
			$this -> sFrom = date("Y-m-01");
			$rtnParams[] = ' request.create_time >= (\')' . $this -> sFrom . ' 00:00:00(\') ';
		}

		if($this -> sTo != NO_STRING) {				// 終了日
			$rtnParams[] = ' request.create_time < (\')' . date('Y-m-d H:i:s', strtotime($this -> sTo . ' +1 days')) . '(\') ';
		}else{
			// english-comment
			$rtnParams[] = ' request.create_time < (\')' . date('Y-m-d H:i:s') . '(\') ';
		}

		// ステータス処理中を削除
		if($this -> sStatusProc != VAL_INT_1) {
			$rtnParams[] = ' request.status != (\')0(\') ';
		}

		// ステータス完了を削除
		if($this -> sStatusComp != VAL_INT_1) {
			$rtnParams[] = ' request.status != (\')1(\') ';
		}

		// ステータス拒否を削除
		if($this -> sStatusRefund != VAL_INT_1) {
			$rtnParams[] = ' request.status != (\')2(\') ';
		}

		if($this -> testAccountFlg != NO_STRING) {
			$rtnParams[] .= 'from_user.test_account_flg = (\')' . $this -> testAccountFlg . '(\')';
			$rtnParams[] .= 'to_user.test_account_flg = (\')' . $this -> testAccountFlg . '(\')';
		}

		// 検索条件の結合
		if(count($rtnParams) > NO_COUNT) {
			return DELIMIT_AND . implode(DELIMIT_AND, $rtnParams);
		} else {
			return NO_STRING;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: 更新用パラメータの取得
	* @parameter	: なし
	* @return		: 更新用パラメータ
	-------------------------------------------------------------------------*/
	public function getUpdateParameter() {

		// 変数宣言部
		$rtn = array();

		$rtn[] = $this -> rId;
		$rtn[] = $this -> comment;

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: HTML表示用のデータ取得関数
	* @parameter	: なし
	* @return		: HTML表示用データ配列
	-------------------------------------------------------------------------*/
	public function echoList() {
		// 変数宣言部
		$rtn = NO_STRING;
		if($this -> isLoopData($this -> rs)) {

			// データの数だけループを回す
			$start		= 	($this -> getTargetPage() - VAL_INT_1) * VAR_DEFAULT_PAGE_COUNT;
			$end		= $this -> getTargetPage() * VAR_DEFAULT_PAGE_COUNT;
			$listCount	= count($this -> rs);
			for($cnt = $start; $cnt < $end && $cnt < $listCount; $cnt++) {
				$row = $this -> getRowData($this -> rs, $cnt);

				$rtn	.= '<tr>'
							. '<td>' . $this -> getColumnData($row, COLUMN_CREATE_TIME) . '</td>'
							. '<td>' . $this -> getColumnData($row, COLUMN_TRANSACTION_NUMBER) . '</td>'
							// . '<td class="l"><a href="javascript:userDetail(\'' . $this -> getColumnData($row, COLUMN_TO_ACCOUNT) . '\');">' . $this -> getColumnData($row, COLUMN_TO_USER_NAME) . '</a></td>'
							. '<td class="l"><a href="account_edit?detail_account=' . $this -> getColumnData($row, COLUMN_TO_ACCOUNT) . '">'. $this -> getColumnData($row, COLUMN_TO_USER_NAME) .'</a></td>'
							. '<td>' . $this -> getColumnData($row, COLUMN_TO_ACCOUNT) . '</td>'
							. '<td>' . $this -> getColumnData($row, COLUMN_CURRENCY) . '</td>'
							. '<td class="r">' . $this -> getAmountString($this -> getColumnData($row, COLUMN_AMOUNT), $this -> getColumnData($row, COLUMN_CURRENCY)) . '</td>'
							. '<td class="r">' . $this -> getAmountString($this -> getColumnData($row, COLUMN_TO_FEE), $this -> getColumnData($row, COLUMN_CURRENCY)) . '</td>'
							// . '<td class="l"><a href="javascript:userDetail(\'' . $this -> getColumnData($row, COLUMN_FROM_ACCOUNT) . '\');">' . $this -> getColumnData($row, COLUMN_FROM_USER_NAME) . '</a></td>'
							. '<td class="l"><a href="account_edit?detail_account=' . $this -> getColumnData($row, COLUMN_FROM_ACCOUNT) . '">'. $this -> getColumnData($row, COLUMN_FROM_USER_NAME) .'</a></td>'
							. '<td>' . $this -> getColumnData($row, COLUMN_FROM_ACCOUNT) . '</td>'
							. '<td>' . $this -> getColumnData($row, COLUMN_UPDATE_TIME) . '</td>'
							. '<td>' . $this -> getColumnData($row, COLUMN_DEBIT_CURRENCY) . '</td>'
							. '<td class="r">' . $this -> getAmountString($this -> getColumnData($row, COLUMN_DEBIT_AMOUNT), $this -> getColumnData($row, COLUMN_DEBIT_CURRENCY)) . '</td>'
							. '<td>' . $this -> getColumnData($row, COLUMN_RATE) . '</td>'
							. '<td class="r">' . $this -> getAmountString($this -> getColumnData($row, COLUMN_FROM_FEE), $this -> getColumnData($row, COLUMN_DEBIT_CURRENCY)) . '</td>'
							. '<td>'.VAL_STR_REQUEST_NORMAL.'</td>'
							. '<td>' . $this -> dispRequestStatusListCommon($this -> getColumnData($row, COLUMN_STATUS)) . '</td>'
							. '<td class="blocka"><a href="javascript:void(0);" onclick="javascript:actionDetail(\'' . $this -> getColumnData($row, COLUMN_R_ID) . '\', \'_blank\');"><span class="fa fa-info-circle fa-lg"></span></a></td>'
							. '</tr>';
			}

		} else {
			$rtn = '<tr><td colspan="17">' . $this -> getMessage(INFO, 'I_NO_SUCHE_SEARCH_DATA', array()) . '</td></tr>';
		}

		echo $rtn;
	}

	/**
	 * my-code
	 */
	public function echoListDBPager(){
		// 変数宣言部
		$rtn = NO_STRING;
		if($this -> isLoopData($this -> rs)) {
			foreach($this -> rs as $row){
				$rtn	.= '<tr>'
						. '<td>' . $this -> getColumnData($row, COLUMN_CREATE_TIME) . '</td>'
						. '<td>' . $this -> getColumnData($row, COLUMN_TRANSACTION_NUMBER) . '</td>'
								// . '<td class="l"><a href="javascript:userDetail(\'' . $this -> getColumnData($row, COLUMN_TO_ACCOUNT) . '\');">' . $this -> getColumnData($row, COLUMN_TO_USER_NAME) . '</a></td>'
						. '<td class="l"><a href="account_edit?detail_account=' . $this -> getColumnData($row, COLUMN_TO_ACCOUNT) . '">'. $this -> getColumnData($row, COLUMN_TO_USER_NAME) .'</a></td>'
						. '<td>' . $this -> getColumnData($row, COLUMN_TO_ACCOUNT) . '</td>'
						. '<td>' . $this -> getColumnData($row, COLUMN_CURRENCY) . '</td>'
						. '<td class="r">' . $this -> getAmountString($this -> getColumnData($row, COLUMN_AMOUNT), $this -> getColumnData($row, COLUMN_CURRENCY)) . '</td>'
						. '<td class="r">' . $this -> getAmountString($this -> getColumnData($row, COLUMN_TO_FEE), $this -> getColumnData($row, COLUMN_CURRENCY)) . '</td>'
					// . '<td class="l"><a href="javascript:userDetail(\'' . $this -> getColumnData($row, COLUMN_FROM_ACCOUNT) . '\');">' . $this -> getColumnData($row, COLUMN_FROM_USER_NAME) . '</a></td>'
						. '<td class="l"><a href="account_edit?detail_account=' . $this -> getColumnData($row, COLUMN_FROM_ACCOUNT) . '">'. $this -> getColumnData($row, COLUMN_FROM_USER_NAME) .'</a></td>'
						. '<td>' . $this -> getColumnData($row, COLUMN_FROM_ACCOUNT) . '</td>'
						. '<td>' . $this -> getColumnData($row, COLUMN_UPDATE_TIME) . '</td>'
						. '<td>' . $this -> getColumnData($row, COLUMN_DEBIT_CURRENCY) . '</td>'
						. '<td class="r">' . $this -> getAmountString($this -> getColumnData($row, COLUMN_DEBIT_AMOUNT), $this -> getColumnData($row, COLUMN_DEBIT_CURRENCY)) . '</td>'
						. '<td>' . $this -> getColumnData($row, COLUMN_RATE) . '</td>'
						. '<td class="r">' . $this -> getAmountString($this -> getColumnData($row, COLUMN_FROM_FEE), $this -> getColumnData($row, COLUMN_DEBIT_CURRENCY)) . '</td>'
						. '<td>'.VAL_STR_REQUEST_NORMAL.'</td>'
						. '<td>' . $this -> dispRequestStatusListCommon($this -> getColumnData($row, COLUMN_STATUS)) . '</td>'
						. '<td class="blocka"><a href="javascript:void(0);" onclick="actionDetail(\'' . $this -> getColumnData($row, COLUMN_R_ID) . '\', \'_blank\');"><span class="fa fa-info-circle fa-lg"></span></a></td>'
						. '</tr>';
			}
		}else{
			$rtn = '<tr><td colspan="17">' . $this -> getMessage(INFO, 'I_NO_SUCHE_SEARCH_DATA', array()) . '</td></tr>';
		}

		echo $rtn;
	}

	public function exportWithdrawalList(){
		if($this -> isLoopData($this -> rs)){
			if($this -> lang == "en") {
				$data = 'Date Of Application,Transaction Number,Applicant Name,Applicant Account Number,Currency,Application Amount,Fee,Supporter Name,Supporter Account Number,Processing Date,Currency,Payment Amount,Rate,Fee,Processing Type,Status' . "\n";
			} else {
				$data = '申請日時,取引番号,申請者名,申請者口座番号,通貨,申請金額,手数料,支払者名,支払者口座番号,処理日時,通貨,支払金額,レート,手数料,処理タイプ,状態' . "\n";
			}
			foreach($this -> rs as $row){
				$arr = [
						$this -> getColumnData($row, COLUMN_CREATE_TIME),
						$this -> getColumnData($row, COLUMN_TRANSACTION_NUMBER),
						$this -> getColumnData($row, COLUMN_TO_USER_NAME),
						$this -> getColumnData($row, COLUMN_TO_ACCOUNT),
						$this -> getColumnData($row, COLUMN_CURRENCY),
						$this -> getAmountString($this -> getColumnData($row, COLUMN_AMOUNT), $this -> getColumnData($row, COLUMN_CURRENCY)),
						$this -> getAmountString($this -> getColumnData($row, COLUMN_TO_FEE), $this -> getColumnData($row, COLUMN_CURRENCY)),
						$this -> getColumnData($row, COLUMN_FROM_USER_NAME),
						$this -> getColumnData($row, COLUMN_FROM_ACCOUNT),
						$this -> getColumnData($row, COLUMN_UPDATE_TIME),
						$this -> getColumnData($row, COLUMN_DEBIT_CURRENCY),
						$this -> getAmountString($this -> getColumnData($row, COLUMN_DEBIT_AMOUNT), $this -> getColumnData($row, COLUMN_DEBIT_CURRENCY)),
						$this -> getColumnData($row, COLUMN_RATE),
						$this -> getAmountString($this -> getColumnData($row, COLUMN_FROM_FEE), $this -> getColumnData($row, COLUMN_DEBIT_CURRENCY)),
						VAL_STR_REQUEST_NORMAL,
						$this -> dispRequestStatusListCommon($this -> getColumnData($row, COLUMN_STATUS)),
				];

				$data .= '"'. implode('"' . DELIMIT_COMMA . '"', $arr) . '"' . "\n";
			}

			$this -> setExportDataCommon($data);
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: 引き落としリストの設定
	* @parameter	: 引き落としリスト
	* @return		: なし
	-------------------------------------------------------------------------*/
	public function setResult($rs) {
		$this -> rs = $rs;
	}

	public function setCount($where){
		$rs = $this -> accessSelect('LIST_REQUEST_COUNT', array($this -> getWhere()));

		if($this -> isLoopData($rs)){
			$this -> listCount = $this -> getColumnData($rs[0], 'listCount');
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: 引き落とし詳細の設定
	* @parameter	: 引き落とし詳細
	* @return		: なし
	-------------------------------------------------------------------------*/
	public function setDetail($rs) {
		$this -> detail = $this -> getRowData($rs);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 通貨リストの取得
	* @parameter	: なし
	* @return		: HTML表示用データ配列
	-------------------------------------------------------------------------*/
	public function echoRequestTypeList() {
		echo $this -> dispListOption($this -> getRequestTypeList(), $this -> sRequestType);
	}

	function echoTestAccountFlg() {
		echo $this -> dispListOption($this -> getTestAccountList(), $this -> testAccountFlg);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 通貨リストの取得
	* @parameter	: なし
	* @return		: HTML表示用データ配列
	-------------------------------------------------------------------------*/
	public function echoCurrencyList() {

		// 変数宣言部
		$lists	= array();

		echo $this -> dispListOption($this -> getCurrencyList(), $this -> sCurrency);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 検索口座番号の取得
	* @parameter	: なし
	* @return		: 検索口座番号
	-------------------------------------------------------------------------*/
	public function echoSAccount() {
		echo $this -> sAccount;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 検索口座名の取得
	* @parameter	: なし
	* @return		: 検索口座名
	-------------------------------------------------------------------------*/
	public function echoSAccountName() {
		echo $this -> sAccountName;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 検索通貨の取得
	* @parameter	: なし
	* @return		: 検索通貨
	-------------------------------------------------------------------------*/
	public function echoSCurrency() {
		echo $this -> sCurrency;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 取引番号の取得
	* @parameter	: なし
	* @return		: 取引番号
	-------------------------------------------------------------------------*/
	public function echoSTransactionNumber() {
		echo $this -> sTransactionNumber;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 検索状態（処理中）の取得
	* @parameter	: なし
	* @return		: 検索状態（処理中）
	-------------------------------------------------------------------------*/
	public function dispSStatusProc() {

		// チェックボックスの生成
		echo $this -> makeCheckOne(PARAM_S_STATUS_PROC
									, PARAM_S_STATUS_PROC
									, VAL_INT_1
									, VAL_STR_STATUS_PROC
									, $this -> sStatusProc);
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 検索状態（処理中）の取得
	* @parameter	: なし
	* @return		: 検索状態（処理中）
	-------------------------------------------------------------------------*/
	public function dispSStatusComp() {

		// チェックボックスの生成
		echo $this -> makeCheckOne(PARAM_S_STATUS_COMP
									, PARAM_S_STATUS_COMP
									, VAL_INT_1
									, VAL_STR_STATUS_COMP
									, $this -> sStatusComp);
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 検索状態（処理中）の取得
	* @parameter	: なし
	* @return		: 検索状態（処理中）
	-------------------------------------------------------------------------*/
	public function dispSStatusRefund() {

		// チェックボックスの生成
		echo $this -> makeCheckOne(PARAM_S_STATUS_REFUND
									, PARAM_S_STATUS_REFUND
									, VAL_INT_1
									, VAL_STR_STATUS_REFUND
									, $this -> sStatusRefund);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 検索開始日の取得
	* @parameter	: なし
	* @return		: 検索開始日
	-------------------------------------------------------------------------*/
	public function echoSFrom() {
		echo $this -> sFrom;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 検索終了日の取得
	* @parameter	: なし
	* @return		: 検索終了日
	-------------------------------------------------------------------------*/
	public function echoSTo() {
		echo $this -> sTo;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 引き落としIDの取得
	* @parameter	: なし
	* @return		: 引き落としID
	-------------------------------------------------------------------------*/
	public function getRId() {
		return $this -> rId;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 処理日時の取得
	* @parameter	: なし
	* @return		: 処理日時
	-------------------------------------------------------------------------*/
	public function echoCreateTime() {
		echo $this -> createTime;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 申請通貨の取得
	* @parameter	: なし
	* @return		: 申請通貨
	-------------------------------------------------------------------------*/
	public function echoCurrency() {
		echo $this -> currency;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 申請金額の取得
	* @parameter	: なし
	* @return		: 申請金額
	-------------------------------------------------------------------------*/
	public function echoAmount() {
		echo $this -> amount;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 申請金額の取得
	* @parameter	: なし
	* @return		: 申請金額
	-------------------------------------------------------------------------*/
	public function dispAmount() {
		echo $this -> getAmountString($this -> amount, $this -> currency);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 送金名義の取得
	* @parameter	: なし
	* @return		: 送金名義
	-------------------------------------------------------------------------*/
	public function echoFromName() {
		echo $this -> fromName;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 送金口座番号の取得
	* @parameter	: なし
	* @return		: 送金口座番号
	-------------------------------------------------------------------------*/
	public function echoFromAccountNumber() {
		echo $this -> fromAccountNumber;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 送金口座種別の取得
	* @parameter	: なし
	* @return		: 送金口座種別
	-------------------------------------------------------------------------*/
	public function dispFromAccountType() {
		echo $this-> dispUserAccountTypeCommon($this -> fromAccountType);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 申請者名義の取得
	* @parameter	: なし
	* @return		: 申請者名義
	-------------------------------------------------------------------------*/
	public function echoToName() {
		echo $this -> toName;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 申請口座番号の取得
	* @parameter	: なし
	* @return		: 申請口座番号
	-------------------------------------------------------------------------*/
	public function echoToAccountNumber() {
		echo $this -> toAccountNumber;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 申請口座種別の取得
	* @parameter	: なし
	* @return		: 申請口座種別
	-------------------------------------------------------------------------*/
	public function dispToAccountType() {
		echo $this -> dispUserAccountTypeCommon($this -> toAccountType);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 処理日時の取得
	* @parameter	: なし
	* @return		: 処理日時
	-------------------------------------------------------------------------*/
	public function echoUpdateTime() {
		echo $this -> updateTime;
	}

	/*-------------------------------------------------------------------------
	* @function_name: ステータスの取得
	* @parameter	: なし
	* @return		: ステータス
	-------------------------------------------------------------------------*/
	public function dispStatus() {
		echo $this -> dispRequestStatusListCommon($this -> status);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 出金通貨の取得
	* @parameter	: なし
	* @return		: 出金通貨
	-------------------------------------------------------------------------*/
	public function echoDebitCurrency() {
		echo $this -> debitCurrency;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 出金金額の取得
	* @parameter	: なし
	* @return		: 出金金額
	-------------------------------------------------------------------------*/
	public function echoDebitAmount() {
		echo $this -> debitAmount;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 申請金額の取得
	* @parameter	: なし
	* @return		: 申請金額
	-------------------------------------------------------------------------*/
	public function dispDebitAmount() {
		echo $this -> getAmountString($this -> debitAmount, $this -> debitCurrency);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 出金レートの取得
	* @parameter	: なし
	* @return		: 出金レート
	-------------------------------------------------------------------------*/
	public function echoRate() {
		echo $this -> rate;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 支払手数料の取得
	* @parameter	: なし
	* @return		: 支払手数料
	-------------------------------------------------------------------------*/
	public function dispFromFee() {
		echo $this -> getAmountString($this -> fromFee, $this -> debitCurrency);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 申請手数料の取得
	* @parameter	: なし
	* @return		: 申請手数料
	-------------------------------------------------------------------------*/
	public function dispToFee() {
		echo $this -> getAmountString($this -> toFee, $this -> currency);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 申請メッセージの取得
	* @parameter	: なし
	* @return		: 申請メッセージ
	-------------------------------------------------------------------------*/
	public function dispRequestMessage() {
		echo nl2br($this -> requestMessage);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 送金メッセージの取得
	* @parameter	: なし
	* @return		: 送金メッセージ
	-------------------------------------------------------------------------*/
	public function dispSendMessage() {
		echo nl2br($this -> sendMessage);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 管理者コメントの取得
	* @parameter	: なし
	* @return		: 管理者コメント
	-------------------------------------------------------------------------*/
	public function echoComment() {
		echo $this -> comment;
	}

	/*-------------------------------------------------------------------------
	* @function_name: ページャの表示
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispPager() {
		/**
		echo  $this -> getPagerCommon($this -> getTargetPage()
				, $this -> getTotalPageCommon(VAR_DEFAULT_PAGE_COUNT, count($this -> rs))
				, count($this -> rs)
				, NO_STRING);
				*/

		echo  $this -> getPagerCommon($this -> getTargetPage()
				, $this -> getTotalPageCommon(VAR_DEFAULT_PAGE_COUNT, $this -> listCount /* count($this -> rs) */)
				, $this -> listCount /* count($this -> rs) */
				, NO_STRING,
				true /* false */);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 管理者コメントの取得
	* @parameter	: なし
	* @return		: 管理者コメント
	-------------------------------------------------------------------------*/
	public function echoTransactionNumber() {
		echo $this -> tNumber;
	}

	function getActivity(){
		$type = $this -> getType();
		$rs = $this -> accessSelect('SELECT_REQUEST_BY_RID', array($this -> rId));
		$tNumber = $this -> getColumnData($rs[0], COLUMN_TRANSACTION_NUMBER);

		if($type == TYPE_DELETE){
			$message = 'Deleted transaction ['. $tNumber . ']';
		}

		$rtn = array();

		$rtn[] = $this -> getAdminUserData(PARAM_UID);
		$rtn[] = $_SERVER[PARAM_REMOTE_ADDR];
		$rtn[] = $_SERVER[PARAM_HTTP_USER_AGENT];
		$rtn[] = 25;
		$rtn[] = date("Y-m-d H:i:s");
		$rtn[] = $message;

		return $rtn;
	}
}
?>