<?php
require_once(SITE_LOGICS . 'withdraw/model.php');

class LogicWithdraw extends WithdrawModelClass {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $htmlStr = NO_STRING;	// 表示用HTML文字列

	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: ロジック（各クラス共通）
	* @parameter	: なし
	* @return		: TRUE:ロジック成功、FALSE:ロジック失敗
	-------------------------------------------------------------------------*/
	function logic() {

		try {

			// 初期データ処理
			$this -> init();

			// ロジック実行
			$this -> biz();

		} catch (Exception $e) {
			throw $e;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: ロジックの実行
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function biz() {

		if($this -> getType() == TYPE_COMPLETE
            || $this -> getType() == TYPE_FLAT3_COMPLETE) {

			// データを登録する
			$this -> regist();

			// コミッションの登録
			$this -> registCommision(VAR_WITHDRAW_SUCCESS
									, null
									, $this -> getUserData(PARAM_USER_ACCOUNT)
									, $this -> getDebitCurrency()
									, $this -> currencyToInt($this -> getFeeEx(), $this -> getDebitCurrency()));

			//create session variable for 2favalidated
			$_SESSION['2fa_validated'] = 'not validated';

		} else if($this -> getType()	== TYPE_INPUT
				|| $this -> getType()	== NO_STRING) {

			// データをロード
			$this -> load();

			$this -> history();
		} else if($this -> getType()	== TYPE_BACK) {

			$this -> loadAccount();

			$this -> history();
	    }  else if($this -> getType()	== TYPE_FLAT3_INPUT
				|| $this -> getType()	== NO_STRING) {

			// データをロード
			$this -> load();

			$this -> flat3History();
		} else if($this -> getType()	== TYPE_FLAT3_BACK) {

			$this -> loadAccount();

			$this -> flat3History();
	    } else if ($this->getType() == TYPE_LOCAL_INPUT) {

	        $this->load();

	        $this->disWithdarawLocalBank();

	        $this->Localhistory();
	    } else if ($this->getType() == TYPE_LOCAL_BACK) {

	        $this->loadAccount();

	        $this->Localhistory();

	    } else if ($this->getType() == TYPE_LOCAL_COPLETE) {
	            // データを登録する
	        $this->localRegist();

			//create session variable for 2favalidated
			$_SESSION['2fa_validated'] = 'not validated';
		}  else if($this -> getType()	== TYPE_WITHDRAW_H2P_INPUT) {

			// データをロード
			$this -> load();

			$this -> h2pHistory();
		} else if ($this->getType() == TYPE_WITHDRAW_H2P_BACK) {

	        $this->loadAccount();

	        $this->h2pHistory();

	    }else if ($this->getType() == TYPE_WITHDRAW_H2P_COMPLETE) {
	            // データを登録する
	        $this->h2pRegist();

			//create session variable for 2favalidated
			$_SESSION['2fa_validated'] = 'not validated';
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: データのロード
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function load() {
		$this -> setUser($this -> accessSelect('SELECT_USER_BY_ACCOUNT', array($this -> getUserData(PARAM_USER_ACCOUNT))));

		//$this -> restore();

		// 口座情報の取得
		$this -> loadAccount();

	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座情報のロード
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function loadAccount() {

		// 通貨情報
		$this -> setCurrencies($this -> accessSelect('LIST_MST_CURRENCY_ACTIVE', array()));

		// バランスの取得
		$this -> setBalances($this -> accessSelect('SELECT_USER_BALANCES', array($this -> getUserData(PARAM_USER_ACCOUNT))));
	}

	/*-------------------------------------------------------------------------
	* @function_name: データのロード
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function history() {

		// 過去の送金履歴の取得
		$this -> setHistory($this -> accessSelect('LIST_WITHDRAW_HISTORY', array($this -> getUserData(PARAM_USER_ACCOUNT))));
	}

	private function flat3History() {

		// 過去の送金履歴の取得
		$this -> setHistory($this -> accessSelect('LIST_WITHDRAW_FLAT3_HISTORY', array($this -> getUserData(PARAM_USER_ACCOUNT))));
	}

	/*-------------------------------------------------------------------------
	* @function_name: Local_history
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function Localhistory() {

		// 過去の送金履歴の取得
		$this -> setHistory($this -> accessSelect('LIST_WITHDRAW_LOCAL_HISTORY', array($this -> getUserData(PARAM_USER_ACCOUNT))));
	}


	private function h2pHistory() {

		// 過去の送金履歴の取得
		$this -> setHistory($this -> accessSelect('LIST_WITHDRAW_H2P_HISTORY', array($this -> getUserData(PARAM_USER_ACCOUNT))));
	}

	/*-------------------------------------------------------------------------
	* @function_name: ロジックの実行
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function regist() {

		// 出金申請の登録
		if($this -> accessModify('INSERT_WITHDRAW', $this -> getRegistData())) {

			// 異通貨の場合は為替コミッション発生
			if($this -> getCurrency() != $this -> getDebitCurrency()) {
				$this -> registCommisionExchange($this -> getUserData(PARAM_USER_ACCOUNT)
													, $this -> getCurrency()
													, $this -> getDebitCurrency()
													, $this -> currencyToInt($this -> getDebitAmount(), $this -> getDebitCurrency()));
			}

			$params = $this -> getSendData();

            //specify email based on solution
            if($this -> getType() == TYPE_COMPLETE){
                $emailTemplateUser ='withdraw_apply_for_user.xml';
            } else{
                $emailTemplateUser ='withdraw_flat3_apply_for_user.xml';
            }


			// メールを送信（ユーザ）
			$this -> sendMailByTmp($emailTemplateUser
									, $params
									, $params[VAL_INT_5]
									, VAR_BS_MAIL_ADDRESS);


			// メールを送信（管理者）
			$this -> sendMailByTmp('withdraw_apply_for_admin.xml'
									, $params
									, VAR_NOTICE_MAIL_ADDRESS
									, VAR_NOTICE_MAIL_ADDRESS);

			$this -> accessModify('UPDATE_USER_BANK_INFO', $this -> getRegistData(), false);
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: ページ出力文字列取得関数
	* @parameter	: なし
	* @return		: HTML文字列
	-------------------------------------------------------------------------*/
	function getDisplay() {
		return $this -> htmlStr;
	}
/*-------------------------------------------------------------------------
     * @function_name: LOCAL ロジックの実行
     * @parameter    : なし
     * @return        : なし
    -------------------------------------------------------------------------*/
    private function localRegist()
    {
        $rtn    = $this->getLocalRegistData();
        $strApi = array();
        // 出金申請の登録
        if ($this->accessModify('INSERT_WITHDRAW_LOCAL', $rtn)) {
            $this->accessModify('INSERT_WITHDRAW_TIMER',$rtn);
            $this->getSDpay($rtn);
        }
    }

	private function h2pRegist(){
		$rtn    = $this->geth2pRegistData();

		$this->accessModify('INSERT_WITHDRAW_H2P_TEMP', $rtn);

		if ($this->sendH2PRequest()) {
			$flag = $this->accessModify('INSERT_WITHDRAW', $rtn);
			if($flag){
				$this -> setType(TYPE_WITHDRAW_H2P_SUCCESS);
			}
		}else{
			$this -> setType(TYPE_WITHDRAW_H2P_FAIL);
		}
	}
}
?>