<?php
class AdminCategoryModelClass extends ModelClassEx {
	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $rs					= null;			// 結果セット
	private $fcId				= NO_COUNT;		// admin Department ID
	private $name				= NO_STRING;	// タイトル
	private $code				= NO_STRING;	// 本文
	private $access				= NO_STRING;	// 公開日
	private $category			= NO_STRING;		// 言語
	private $categoryId			= NO_STRING;		// 言語

	/**
	 *
	 * anton
	 *
	 */
	private $lang				= NO_STRING;
	
	/*-------------------------------------------------------------------------
	* @function_name: コントロールパネルシステムindexモデルクラスコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		// スーパークラスコンストラクタ呼び出し
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: 初期設定関数
	* @parameter	: なし
	* @return		: 成功:success、失敗:error
	-------------------------------------------------------------------------*/
	public function init() {

		try {

			// パラメータの設定
			$this -> setParameter();

			// チェック
			return $this -> validate();

		} catch (Exception $e) {
			throw new Exception(NO_STRING);
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: パラメータの設定
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function setParameter() {
		// var_dump($this -> getDataPost('fc_id'));
		// die();
		$this -> fcId		= $this -> getDataPost(PARAM_FC_ID, true);
		$this -> name		= $this -> getDataPost(PARAM_NAME, true);		// タイトル
		$this -> code		= $this -> getDataPost(PARAM_CODE, true);
		
		$this -> lang		= $this -> getLangage();

	}

	/*-------------------------------------------------------------------------
	* @function_name: サーバ側データチェック
	* @parameter	: なし
	* @return		: TRUE:成功、FALSE:失敗
	-------------------------------------------------------------------------*/
	public function validate() {

		// 変数宣言部
		$rtn = true;

		// ログインチェック
		if(!$this -> checkAdminUserLogin()) {
			throw new Exception(NO_STRING);
		}

		/**
		 *
		 * -- anton --
		 * 04/22/2019
		 *
		 */
		$redirect = ($this -> lang != "en" ? "" : "{$this -> lang}/");
		
		//check access
		if(!$this -> checkAdminUserAccess('CLST', array(''))){
			$this -> popUpSessionMessage(ERROR, 'E_ERROR_NO_PAGE_ACCESS', array());
			header('Location: /'.$redirect.'menu');
			exit();
		}

		if($this -> getType() == TYPE_REGITS) {
			//check access
			if(!$this -> checkAdminUserAccess('CLST', array('','1'))){
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_NO_FUNCTION_ACCESS', array());
				header('Location: /'.$redirect.'menu');
				exit();
			}
		}

		if($this -> getType() == TYPE_DETAIL) {
			//check access
			if(!$this -> checkAdminUserAccess('CDTL', array(''))){
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_NO_PAGE_ACCESS', array());
				header('Location: /'.$redirect.'menu');
				exit();
			}
		}

		if($this -> getType() == TYPE_EDIT) {
			//check access
			if(!$this -> checkAdminUserAccess('CDTL', array('','1'))){
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_NO_FUNCTION_ACCESS', array());
				header('Location: /'.$redirect.'menu');
				exit();
			}
		}

		// 登録時・更新時
		if($this -> getType() == TYPE_COMPLETE || $this -> getType() == TYPE_UPDATE) {

			if(!$this -> checkNull($this -> code)){
				$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_CODE));
				$rtn = false;
			}
			if(!$this -> checkNull($this -> name)){
				$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_FIRST_NAME));
				$rtn = false;
			}


			if(!$rtn) {
				if($this -> getType() == TYPE_UPDATE){
					$this -> setType(TYPE_EDIT);
					return $rtn;
				}else{
					$this -> setType(TYPE_REGITS);
					return $rtn;
				}
			}

		}

		return true;
	}

	/*-------------------------------------------------------------------------
	* @function_name: HTML表示用のデータ取得関数
	* @parameter	: なし
	* @return		: HTML表示用データ配列
	-------------------------------------------------------------------------*/
	public function dispHTML() {
		return array();
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 口座振替リストの設定
	 * @parameter	: 出金リスト
	 * @return		: なし
	 -------------------------------------------------------------------------*/
	public function setResult($rs) {
		$this -> rs = $rs;
	}

	/*-------------------------------------------------------------------------
	* @function_name: HTML表示用のデータ取得関数
	* @parameter	: なし
	* @return		: HTML表示用データ配列
	-------------------------------------------------------------------------*/
	public function echoList() {

		// 変数宣言部
		$rtn			= NO_STRING;
			if($this -> isLoopData($this -> rs)) {

				// データの数だけループを回す
				$start	= 	($this -> getTargetPage() - VAL_INT_1) * VAR_DEFAULT_PAGE_COUNT;
				$end		= $this -> getTargetPage() * VAR_DEFAULT_PAGE_COUNT;
				$listCount	= count($this -> rs);

				for($cnt = $start; $cnt < $end && $cnt < $listCount; $cnt++) {

					$row = $this -> getRowData($this -> rs, $cnt);

					$rtn	.= '<tr>'
								. '<td>' . $this -> getColumnData($row, COLUMN_CATEGORY_CODE) . '</td>'
								. '<td>' . $this -> getColumnData($row, COLUMN_CATEGORY_NAME) . '</td>'
								. '<td class="blocka"><a href="javascript:actionDetail(' . $this -> getColumnData($row, COLUMN_CATEGORY_ID) . ');"><span class="fa fa-info-circle fa-lg"></span></a></td>'
								. '</tr>';
				}

			} else {
				$rtn = '<tr><td colspan="6">' . $this -> getMessage(INFO, 'I_NO_SUCHE_SEARCH_DATA', array()) . '</td></tr>';
			}

			echo $rtn;

	}


	/*-------------------------------------------------------------------------
	* @function_name: 登録用のデータを取得
	* @parameter	: なし
	* @return		: 登録用データ
	-------------------------------------------------------------------------*/
	public function getRegistData() {

		// 変数宣言部
		$rtn = array();

		$rtn[] = $this -> name;		// 公開日
		$rtn[] = $this -> code;		// 公開日


		return $rtn;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 更新用のデータを取得
	 * @parameter	: なし
	 * @return		: 更新用データ
	 -------------------------------------------------------------------------*/
	public function getUpdateData() {

		// 変数宣言部
		$rtn = array();

		 $rtn[] = $this -> fcId;
		 $rtn[] = $this -> name;		// 公開日
		 $rtn[] = $this -> code;		// 公開日

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: ページャの表示
	 * @parameter	: なし
	 * @return		: 表示用HTML文字列
	 -------------------------------------------------------------------------*/
	function dispPager() {
		echo  $this -> getPagerCommon($this -> getTargetPage()
										, $this -> getTotalPageCommon(VAR_DEFAULT_PAGE_COUNT, count($this -> rs))
										, count($this -> rs)
										, NO_STRING);
	}

	/*-------------------------------------------------------------------------
	* @function_name: newsIDの取得
	* @parameter	: なし
	* @return		: newsID
	-------------------------------------------------------------------------*/
	public function getFcId() {
		return $this -> fcId;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: newsIDの取得
	 * @parameter	: なし
	 * @return		: newsID
	 -------------------------------------------------------------------------*/
	public function echoFcId() {
		echo $this -> fcId;
	}



	/*-------------------------------------------------------------------------
	 * @function_name: 登録ボタンの取得
	 * @parameter	: なし
	 * @return		: 登録ボタンタグ
	 -------------------------------------------------------------------------*/
	public function echoButton() {
		
		if($this -> fcId == NO_STRING) {
			echo '<input type="button" id="btnComplete" value="'.VAL_STR_ADMIN_REGISTER.'" class="btn bg-grad px100 hi25">';
		} else {
			if($this -> getType() == TYPE_DETAIL){
				echo '<input type="button" id="btnEdit" value="'.VAL_STR_ADMIN_ECATEGORY.'" class="btn bg-grad px100 hi25">&emsp;';
			}else{
				echo '<input type="button" id="btnUpdate" value="'.VAL_STR_ADMIN_SAVE.'" class="btn bg-grad px100 hi25">&emsp;';
			}

		}
	}

	/*-------------------------------------------------------------------------
	 * @function_name: パラメータの取得
	 * @parameter	: なし
	 * @return		: パラメータ
	 -------------------------------------------------------------------------*/
	public function echoParam() {
		if($this -> fcId == NO_STRING) {
			echo '<a id="btnRegist" class="btn bg-default">&laquo; 戻る</a>';
		} else {
			echo '<a id="btnDetail" class="btn bg-default">&laquo; 戻る</a>';
		}
	}

	public function echoCategoryCode() {
			echo $this -> getColumnData($this -> rs[NO_COUNT], 'category_code');

	}
	public function echoCategoryName() {
			echo $this -> getColumnData($this -> rs[NO_COUNT], 'category_name');

	}

	public function echoFunctionCategoryList() {
		$category = NO_COUNT;
		$selected = NO_STRING;

		if($this -> getType() == TYPE_EDIT){
			$category =  $this -> getFunctionCategoryId();
		}

		//echo $category;

		// 変数宣言部
		$rtn			= NO_STRING;
		$categoryList = $this -> accessSelect('LIST_CATEGORY', array());
		if($this -> isLoopData($this -> rs)) {
		$row='';
			$listCount	= count($categoryList);

			for($cnt = 0; $cnt < $listCount; $cnt++) {
				$row = $this -> getRowData($categoryList, $cnt);
				if($this -> getColumnData($row, COLUMN_CATEGORY_ID) == $category){
						$selected = 'selected';
				}else{
					$selected = NO_STRING;
				}

					$rtn	.= '<option name="category_id" id="category_id" value='.$this -> getColumnData($row, COLUMN_CATEGORY_ID).' '.$selected.'>'.$this -> getColumnData($row, COLUMN_CATEGORY_NAME).'</option>';
			}

		} else {
			$rtn = '<tr><td colspan="6">' . $this -> getMessage(INFO, 'I_NO_SUCHE_SEARCH_DATA', array()) . '</td></tr>';
		}

		echo $rtn;
	}


	public function echoCategoryFunctionList() {

		// 変数宣言部
		$rtn			= NO_STRING;

		$functionList = $this -> accessSelect('LIST_CATEGORY_FUNCTIONS', array($this -> fcId));

		if($this -> isLoopData($this -> rs)) {
		$row='';
			$listCount	= count($functionList);

			for($cnt = 0; $cnt < $listCount; $cnt++) {
				$row = $this -> getRowData($functionList, $cnt);

					$rtn	.= '<tr>'
								. '<td>'. $this -> getColumnData($row, COLUMN_FUNC_NAME).'</td>'
								. '</tr>';


			}

		} else {
			$rtn = '<tr><td colspan="6">' . $this -> getMessage(INFO, 'I_NO_SUCHE_SEARCH_DATA', array()) . '</td></tr>';
		}

		echo $rtn;
	}

	function getActivity(){
		$type = $this -> getType();

		if($type == TYPE_UPDATE){
			
			$rs 		= $this -> accessSelect('DETAIL_CATEGORY', array($this -> fcId));
			$oldName 	= $this -> getColumnData($rs[0], COLUMN_CATEGORY_NAME);
			$oldCode 	= $this -> getColumnData($rs[0], COLUMN_CATEGORY_CODE);
			$newName    = $this -> name;
			$newCode 	= $this -> code;

			if($oldName != $newName){
				$detail[] = 'category name from ['.$oldName.'] to ['.$newName.']';
			}

			if($oldCode != $newCode){
				$detail[] = 'category code from ['.$oldCode.'] to ['.$newCode.']';
			}

			if($detail != NULL){
   				$message = 'Edited category '. $newName .'\'s '. implode(', <br/>', $detail);
   			}else{
   				$message = 'Saved without any changes';
   			}

		}elseif($type == TYPE_COMPLETE){
			$message = 'Created new category '.$this -> name;
		}

		$rtn = array();

		$rtn[] = $this -> getAdminUserData(PARAM_UID);
		$rtn[] = $_SERVER[PARAM_REMOTE_ADDR];
		$rtn[] = $_SERVER[PARAM_HTTP_USER_AGENT];
		$rtn[] = 23;
		$rtn[] = date("Y-m-d H:i:s");
		$rtn[] = $message;

		return $rtn;
	}

}
?>
