<?php
class AdminLogModelClass extends ModelClassEx {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $rs = null; // ログデータ

	private $lang = null;

	//search parameters
	private $category	= array();
	private $sDate 		= NO_STRING;
	private $sFrom 		= NO_STRING;
	private $sTo	 	= NO_STRING;
	private $name 		= NO_STRING;
	private $details	= NO_STRING;
	private $ip 		= NO_STRING;
	private $total 		= NO_STRING;
	
	/*-------------------------------------------------------------------------
	* @function_name: コントロールパネルシステムindexモデルクラスコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		// スーパークラスコンストラクタ呼び出し
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: 初期設定関数
	* @parameter	: なし
	* @return		: 成功:success、失敗:error
	-------------------------------------------------------------------------*/
	public function init() {

		try {

			// パラメータの設定
			$this -> setParameter();

			// チェック
			$this -> validate();

			return true;
		} catch (Exception $e) {
			throw new Exception(NO_STRING);
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: パラメータの設定
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function setParameter() {
		$this -> lang 			= $this -> getLangage();
		$this -> category 		= $this -> getDataPost(PARAM_CATEGORY);
		$this -> sDate 		    = $this -> getDataPost(PARAM_DATE_TAGGED);
		$this -> sFrom 			= $this -> getDataPost(PARAM_FROM);
		$this -> sTo 			= $this -> getDataPost(PARAM_TO);
		$this -> name 			= $this -> getDataPost(PARAM_NAME);
		$this -> details 		= $this -> getDataPost('details');
		$this -> ip 		= $this -> getDataPost(PARAM_IP_ADDRESS);
	}

	/*-------------------------------------------------------------------------
	* @function_name: サーバ側データチェック
	* @parameter	: なし
	* @return		: TRUE:成功、FALSE:失敗
	-------------------------------------------------------------------------*/
	public function validate() {
		
		/**
		 *
		 * -- anton --
		 * 04/22/2019
		 *
		 */
		$redirect = ($this -> lang != "en" ? "" : "{$this -> lang}/");
		
		//check access
		if(!$this -> checkAdminUserAccess('OLOG', array(''))){
			$this -> popUpSessionMessage(ERROR, 'E_ERROR_NO_PAGE_ACCESS', array());
			header('Location: /'.$redirect.'menu');
			exit();
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: データ一覧の表示
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	public function echoList() {

		// 変数宣言部
		$rtn	= NO_STRING;
		$row	= null;

		if($this -> isLoopData($this -> rs)) {

			$start		= ($this -> getTargetPage() - VAL_INT_1) * VAR_DEFAULT_PAGE_COUNT;
			$end		= $this -> getTargetPage() * VAR_DEFAULT_PAGE_COUNT;
			$listCount	= count($this -> rs);
			// for($cnt = $start; $cnt < $end && $cnt < $listCount; $cnt++) {
			// 	echo 'miko';
			// 	$row 		= $this -> getRowData($this -> rs, $cnt);
			// 	$category 	= $this -> getColumnData($row, COLUMN_TRANSACTION_TYPE);
			// 	$details 	= $this -> getColumnData($row, 'details');


			// 	$rtn .= '<tr>'
			// 			. '<td>' . $this -> getColumnData($row, COLUMN_CREATE_TIME) . '</td>'
			// 			. '<td class="l">' . $this -> dispTransactionListCommon($category) . '</td>'
			// 			. '<td>' . $this -> getAdminName($this -> getColumnData($row, COLUMN_USER_ACCOUNT)) . '</td>'
			// 			. '<td>' . $this -> getColumnData($row, COLUMN_IP_ADDRESS) . '</td>'
			// 			. '<td class="l">' . $this -> getColumnData($row, COLUMN_USER_AGENT) . '</td>'
			// 			. '<td>' . $details . '</td>'
			// 			. '</tr>';

			// }

			foreach($this -> rs as $row) {
				//$row 		= $this -> getRowData($this -> rs, $cnt);
				$category 	= $this -> getColumnData($row, COLUMN_TRANSACTION_TYPE);
				$details 	= $this -> getColumnData($row, 'details');


				$rtn .= '<tr>'
						. '<td>' . $this -> getColumnData($row, COLUMN_CREATE_TIME) . '</td>'
						. '<td class="l">' . $this -> dispTransactionListCommon($category) . '</td>'
						. '<td>' . $this -> getAdminName($this -> getColumnData($row, COLUMN_USER_ACCOUNT)) . '</td>'
						. '<td>' . $this -> getColumnData($row, COLUMN_IP_ADDRESS) . '</td>'
						. '<td class="l">' . $this -> getColumnData($row, COLUMN_USER_AGENT) . '</td>'
						. '<td>' . $details . '</td>'
						. '</tr>';

			}

		} else {
			$rtn = '<tr><td colspan="6">' . $this -> getMessage(INFO, 'I_NO_SUCHE_SEARCH_DATA', array()) . '</td></tr>';
		}

		echo $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 一覧データの設定
	* @parameter	: なし
	* @return		: TRUE:成功、FALSE:失敗
	-------------------------------------------------------------------------*/
	public function setResult($rs) {
		$this -> rs = $rs;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 
	* @parameter	: 
	* @return		: 
	-------------------------------------------------------------------------*/
	public function setTotal($rs) {
		$this -> total = $rs;
	}

	/*-------------------------------------------------------------------------
	* @function_name: ページャの表示
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispPager() {
		echo  $this -> getPagerCommon($this -> getTargetPage()
				, $this -> getTotalPageCommon(VAR_DEFAULT_PAGE_COUNT, $this -> total)
				, $this -> total
				, NO_STRING);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座状態の表示
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispStatuses() {

		// 変数宣言部
		$rtn		= NO_STRING;
		$category	= array();
		$checked	= array();

		// 口座状態リストの取得
		$category = $this -> getCategory();

		// チェックリストの作成（デフォルト全取得）
		if(!is_array($this -> category)) {

			if($this -> getType() == NO_STRING) {
				if($this -> isLoopData($category)) {

					foreach($category as $row) {
						$checked[$this -> getColumnData($row, PARAM_DATA_KEY)] = $this -> getColumnData($row, PARAM_DATA_KEY);
					}
				}
			}
		} else {

			foreach($this -> category as $row) {
				$checked[$row] = $row;
			}
		}

		if($this -> isLoopData($category)) {

			foreach($category as $row) {
				$rtn .= '<label>' . $this -> makeCheckOne(PARAM_CATEGORY . $row[PARAM_DATA_KEY], PARAM_CATEGORY . '[]', $row[PARAM_DATA_KEY], $row[PARAM_DATA_VALUE] , $this -> getColumnData($checked, $row[PARAM_DATA_KEY])) . '</label>';
			}
		}

		echo $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座状態の取得
	* @parameter	: なし
	* @return		: 口座状態リスト
	------------------------------------------------------------------------*/
	public function getCategory() {

		// 変数宣言部
		$rtn = array();

		$rtn[] = array(PARAM_DATA_KEY => '12'
						, PARAM_DATA_VALUE => VAL_STR_INTERNAL_TRANSFER);
		$rtn[] = array(PARAM_DATA_KEY => '10'
						, PARAM_DATA_VALUE => VAL_STR_LOGIN_HISTORY);
		$rtn[] = array(PARAM_DATA_KEY => '13'
						, PARAM_DATA_VALUE => VAL_STR_BULK_TRANSFER);
		$rtn[] = array(PARAM_DATA_KEY => '14'
						, PARAM_DATA_VALUE => VAL_STR_ACCOUNT_VIEWING);
		$rtn[] = array(PARAM_DATA_KEY => '15'
						, PARAM_DATA_VALUE => VAL_STR_DEPOSIT);
		$rtn[] = array(PARAM_DATA_KEY => '16'
						, PARAM_DATA_VALUE => VAL_STR_WITHDARAW);
		$rtn[] = array(PARAM_DATA_KEY => '17'
						, PARAM_DATA_VALUE => 'API Registration');
		$rtn[] = array(PARAM_DATA_KEY => '18'
						, PARAM_DATA_VALUE => 'Commission Setting');
		$rtn[] = array(PARAM_DATA_KEY => '21'
						, PARAM_DATA_VALUE => 'Notice');
		$rtn[] = array(PARAM_DATA_KEY => '22'
						, PARAM_DATA_VALUE => 'KYC');
		$rtn[] = array(PARAM_DATA_KEY => '25'
						, PARAM_DATA_VALUE => 'Request');
		$rtn[] = array(PARAM_DATA_KEY => '20'
						, PARAM_DATA_VALUE => 'Agent Management');
		$rtn[] = array(PARAM_DATA_KEY => '19'
						, PARAM_DATA_VALUE => 'Exchange Fee Setting');
		$rtn[] = array(PARAM_DATA_KEY => '24'
						, PARAM_DATA_VALUE => 'Deleted Transactions');
		$rtn[] = array(PARAM_DATA_KEY => '23'
						, PARAM_DATA_VALUE => 'Account Administration');
		$rtn[] = array(PARAM_DATA_KEY => '26'
						, PARAM_DATA_VALUE => 'Advertisements');

		return $rtn;
	}

	public function getWhere(){

		// 変数宣言部
		$where		= NO_STRING;
		$rtn		= array();
		$category	= array();

		// search name
		if($this -> name != NO_STRING) {
			$where .= ' AND (users_admin.last_name LIKE (\')%' . $this -> name . '%(\') OR users_admin.first_name LIKE (\')%' . $this -> name . '%(\'))';
		}

		// search details
		if($this -> details != NO_STRING) {
			$where .= ' AND (login_history.details LIKE (\')%' . $this -> details . '%(\'))';
		}

		// search ip
		if($this -> ip != NO_STRING) {
			$where .= ' AND (login_history.ip_address LIKE (\')%' . $this -> ip . '%(\'))';
		}

		//search via status
		// if($this -> getType() == NO_STRING) {		// 検索ボタンを押している場合

			if(is_array($this -> category)) {

				$where .= ' AND (';

				foreach($this -> category as $row) {
					$category[] = 'login_history.transaction_type = (\')' . $row . '(\')';
				}

				$where .= implode(DELIMIT_OR, $category) . ')';
			}else{
				$where .= 'AND login_history.transaction_type != (\')'. NO_COUNT .'(\')';
			}
		// }

		if($this -> sDate != NO_STRING){
			//search via date (FROM)
			if($this -> sFrom != '2014/01/01'
					&& $this -> sFrom != NO_STRING) {
				$where .= ' AND login_history.create_time >= (\')' . str_replace(DELIMIT_SLASH, DELIMIT_HYPHEN, $this -> sFrom) . '(\')';
			}

			//search via date (TO)
			if($this -> sTo != NO_STRING) {
				$where .= ' AND login_history.create_time < DATE_ADD((\')' . str_replace(DELIMIT_SLASH, DELIMIT_HYPHEN, $this -> sTo) . '(\'), INTERVAL 1 DAY)';
			}
		}else{
			$where .= ' AND login_history.create_time >= (\')' . '2014/01/01' . '(\')';
			$where .= ' AND login_history.create_time < DATE_ADD((\')' . date('Y-m-d') . '(\'), INTERVAL 1 DAY)';
		}

		// ページ数
		$start	= ($this -> getTargetPage() - VAL_INT_1) * VAR_DEFAULT_PAGE_COUNT;
		$end	= $this -> getTargetPage() * VAR_DEFAULT_PAGE_COUNT;

		$page = ' LIMIT ' . $start . DELIMIT_COMMA . VAL_INT_50;


		$rtn[] = $where;
		$rtn[] = $page;

		return $rtn;


	}

	/*-------------------------------------------------------------------------
	* @function_name: 開設日検索フラグの表示
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispOpenFlg() {
		echo '<label>'
				. $this -> makeCheckOne(PARAM_DATE_TAGGED
											, PARAM_DATE_TAGGED
											, VAL_INT_1
											, NO_STRING
											, $this -> sDate)
				. '</label>';
	}

	/*-------------------------------------------------------------------------
	* @function_name: 
	* @parameter	: 
	* @return		: 
	-------------------------------------------------------------------------*/
	function echoFrom() {
		echo $this -> sFrom;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 
	* @parameter	: 
	* @return		: 
	-------------------------------------------------------------------------*/
	function echoTo() {
		echo $this -> sTo;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 
	* @parameter	: 
	* @return		: 
	-------------------------------------------------------------------------*/
	function echoName() {
		echo $this -> name;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 
	* @parameter	: 
	* @return		: 
	-------------------------------------------------------------------------*/
	function echoDetails() {
		echo $this -> details;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 
	* @parameter	: 
	* @return		: 
	-------------------------------------------------------------------------*/
	function echoiP() {
		echo $this -> ip;
	}
	

}
?>