<?php
class ForgotModelClass extends ModelClassEx {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $user						= null;			// ユーザデータ
	private $id							= NO_STRING;	// ID
	private $pw							= NO_STRING;	// パスワード
	private $rePw						= NO_STRING;	// パスワード（再入力）
	private $email						= NO_STRING;	// メールアドレス
	private $userAccount				= NO_STRING;	// 口座番号
	private $name						= NO_STRING;	// 名前
	private $uId						= NO_STRING;	// UID
	private $confCode					= NO_STRING;	// 確認コード
	private $year						= NO_STRING;	// 生年月日（年）
	private $month						= NO_STRING;	// 生年月日（月）
	private $day						= NO_STRING;	// 生年月日（日）
	private $userName					= NO_STRING;	// ログインID

	/*-------------------------------------------------------------------------
	* @function_name: コントロールパネルシステムindexモデルクラスコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		// スーパークラスコンストラクタ呼び出し
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: 初期設定関数
	* @parameter	: なし
	* @return		: 成功:success、失敗:error
	-------------------------------------------------------------------------*/
	public function init() {

		try {

			// パラメータの設定
			$this -> setParameter();

			// チェック
			$this -> validate();

		} catch (Exception $e) {
			throw new Exception(NO_STRING);
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: パラメータの設定
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function setParameter() {
		$this -> email		= $this -> getDataPost(PARAM_EMAIL);		// メールアドレス
		$this -> id			= $this -> getDataGet(PARAM_ID);			// ID
		$this -> confCode	= $this -> getDataPost(PARAM_CONF_CODE);	// 確認コード
		$this -> year		= $this -> getDataPost(PARAM_BIRTH_YEAR);	// 生年月日（年）
		$this -> month		= $this -> getDataPost(PARAM_BIRTH_MONTH);	// 生年月日（月）
		$this -> day		= $this -> getDataPost(PARAM_BIRTH_DAY);	// 生年月日（日）

		$this -> pw			= $this -> getDataPost(PARAM_PASSWORD);	// 生年月日（日）
		$this -> rePw		= $this -> getDataPost(PARAM_PASSWORD_CONFIRM);	// 生年月日（日）
	}

	/*-------------------------------------------------------------------------
	* @function_name: サーバ側データチェック
	* @parameter	: なし
	* @return		: TRUE:成功、FALSE:失敗
	-------------------------------------------------------------------------*/
	public function validate() {

		// 変数宣言部
		$rtn	= true;
		$rs		= null;
		$row	= null;

		if($this -> getType() == TYPE_SEND) {				// Step1

			// 必須項目
			if(!$this -> checkNull($this -> email)) {
				$this -> popMessageCommon(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_EMAIL));
				$rtn = false;
			}

			if(!$rtn) {
				$this -> setType(NO_STRING);
				return;
			}

			// メールアドレスの正規表現
			if(!$this -> checkStringMailAddress(addslashes($this -> email))) {
				$this -> popMessageCommon(ERROR, 'E_ERROR_REGULAR_EMAIL', array(VAL_STR_EMAIL));
				$rtn = false;
			}

			if(!$rtn) {
				$this -> setType(NO_STRING);
				return;
			}

			// メールアドレスの存在確認
			if($this -> checkMailAddress($this -> email)) {
				$this -> popMessageCommon(ERROR, 'E_ERROR_NOT_EXIST', array(VAL_STR_EMAIL, $this -> email));
				$rtn = false;
			}

			if(!$rtn) {
				$this -> setType(NO_STRING);
			}

		} else if($this -> getType() == TYPE_INPUT) {		// 入力画面

			$rs = $this -> getApplyPassword($this -> id);

			if($this -> isLoopData($rs)) {	// データが存在する場合

				// 制限時間のチェック
				$row = $this -> getRowData($rs);

				if($this -> getColumnData($row, COLUMN_DIFF_TIME) > VAL_INT_10) {
					$this -> popMessageCommon(ERROR, 'E_ERROR_EXPIRATION_DATE', array());
					$this -> setType(TYPE_FAIL);
					return;
				}


				// データの設定
				$this -> setUser($rs);
				$this -> restore();

			} else {
				$this -> popMessageCommon(ERROR, 'E_APPLY_DATA', array());
				$this -> setType(TYPE_FAIL);
			}

		} else if($this -> getType() == TYPE_COMPLETE) {	// 確認画面

			// 必須項目
			// パスワード
			if(!$this -> checkNull($this -> pw)) {
				$this -> popMessageCommon(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_PASSWORD));
				$rtn = false;
			}

			if(!$this -> checkNull($this -> confCode)) {
				$this -> popMessageCommon(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_CONFIG_CODE));
				$rtn = false;
			}

			if(!$rtn) {
				$this -> setType(TYPE_INPUT);
				return;
			}

					// パスワードの正規表現
			if(!$this -> checkStringPassword($this -> pw)) {
				$this -> popMessageCommon(ERROR, 'E_ERROR_REGULAR_PASSWORD', array(VAL_STR_PASSWORD));
				$rtn = false;
			} else {

				if(!$this -> checkStringPasswordSecond($this -> pw)) {
					$this -> popMessageCommon(ERROR, 'E_ERROR_REGULAR_PASSWORD_SECOND', array(VAL_STR_PASSWORD));
					$rtn = false;
				}
			}

			// パスワードの文字数制限
			if(!$this -> checkLength($this -> pw
										, VAR_PASSWORD_MIN
										, VAR_PASSWORD_MAX)) {
				$this -> popMessageCommon(ERROR, 'E_ERROR_STRING_LENGTH_ANY', array(VAL_STR_PASSWORD
																					, VAR_PASSWORD_MIN
																					, VAR_PASSWORD_MAX));
				$rtn = false;
			}

			// パスワード複合チェック
			// 新パスワードの文字数制限
			if($this -> pw != $this -> rePw) {
				$this -> popMessageCommon(ERROR, 'E_ERROR_CONFIRM', array(VAL_STR_PASSWORD));
				$rtn = false;
			}

			// 日付のチェック
			if(!$this -> checkDate($this -> year
									, $this -> month
									, $this -> day)) {
				$this -> popMessageCommon(ERROR, 'E_DATE_VALUE', array($this -> year
																		, $this -> month
																		, $this -> day));
				$rtn = false;
			}

			if(!$rtn) {
				$this -> setType(TYPE_INPUT);
				return;
			}

			$rs = $this -> getApplyPassword($this -> id);

			if($this -> isLoopData($rs)) {	// データが存在する場合

				// データの設定
				$row = $this -> getRowData($rs);

			} else {
				$this -> popMessageCommon(ERROR, 'E_FATAL', array());
				$this -> setType(TYPE_FAIL);
				return;
			}

			if($this -> getColumnData($row, COLUMN_CONFIRM_CODE) != $this -> confCode
				|| $this -> getColumnData($row, COLUMN_BIRTH_YEAR) != $this -> year
				|| $this -> getColumnData($row, COLUMN_BIRTH_MONTH) != $this -> month
				|| $this -> getColumnData($row, COLUMN_BIRTH_DAY) != $this -> day) {
				$this -> popMessageCommon(ERROR, 'E_ERROR_SAME_DATA', array(VAL_STR_INPUT_DATA));
				$rtn = false;
			}

			// 結果チェック
			if(!$rtn) {		// NG
				$this -> setType(TYPE_INPUT);
			} else {		// OK
				$this -> userAccount	= $this -> getColumnData($row, COLUMN_USER_ACCOUNT);
				$this -> userName		= $this -> getColumnData($row, COLUMN_USER_NAME);
			}
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: メールアドレスの取得
	* @parameter	: なし
	* @return		: メールアドレス
	-------------------------------------------------------------------------*/
	public function getEmail() {
		return $this -> email;
	}

	/*-------------------------------------------------------------------------
	* @function_name: メールアドレスの取得
	* @parameter	: なし
	* @return		: メールアドレス
	-------------------------------------------------------------------------*/
	public function echoEmail() {
		echo $this -> email;
	}

	/*-------------------------------------------------------------------------
	* @function_name: IDの取得
	* @parameter	: なし
	* @return		: ID
	-------------------------------------------------------------------------*/
	public function getID() {
		return $this -> id;
	}

	/*-------------------------------------------------------------------------
	* @function_name: IDの取得
	* @parameter	: なし
	* @return		: ID
	-------------------------------------------------------------------------*/
	public function echoID() {
		echo $this -> id;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 生年月日（年）リストの取得
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	public function dispYear() {
		$this -> dispBirthYearList($this -> year);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 生年月日（月）リストの取得
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	public function dispMonth() {
		$this -> dispBirthMonthList($this -> month);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 生年月日（日）リストの取得
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	public function dispDay() {
		$this -> dispBirthDayList($this -> day);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座番号の取得
	* @parameter	: なし
	* @return		: 口座番号
	-------------------------------------------------------------------------*/
	public function getUserAccount() {
		return $this -> userAccount;
	}

	/*-------------------------------------------------------------------------
	* @function_name: ユーザデータを設定する
	* @parameter	: ユーザデータ
	* @return		: なし
	-------------------------------------------------------------------------*/
	public function setUser($rs) {
		$this -> user = $this -> getRowData($rs);
	}

	/*-------------------------------------------------------------------------
	* @function_name: ユーザデータの各項目を再設定
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	public function restore() {
		$this -> userAccount	= $this -> getColumnData($this -> user, COLUMN_USER_ACCOUNT);					// 口座番号
		$this -> name			= $this -> getColumnData($this -> user, COLUMN_FIRST_NAME)
									. DELIMIT_SPACE . $this -> getColumnData($this -> user, COLUMN_LAST_NAME);	// 名前
		$this -> uId			= $this -> getColumnData($this -> user, COLUMN_UID);							// UID

		if($this -> getType() == TYPE_SEND) {			// メール送信時
			$this -> confCode		= $this -> createConfirmCode();												// 確認コード
		} else if($this -> getType() == TYPE_INPUT) {	// データ入力時
			$this -> confCode		= $this -> getColumnData($this -> user, COLUMN_CONFIRM_CODE);				// 確認コード
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: 申請メール送信用のデータ取得関数
	* @parameter	: なし
	* @return		: 申請メール送信用データ配列
	-------------------------------------------------------------------------*/
	public function getSendParams() {

		// 変数宣言部
		$rtn = array();

		$rtn[]	= $this -> userAccount;	// 口座番号
		$rtn[]	= $this -> name;		// 名前
		$rtn[]	= $this -> uId;			// UID
		$rtn[]	= $this -> confCode;	// 確認コード

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 申請データ登録用のデータ取得関数
	* @parameter	: なし
	* @return		: 申請データ登録用データ配列
	-------------------------------------------------------------------------*/
	public function getInsertParams() {

		// 変数宣言部
		$rtn = array();

		$rtn[]	= $this -> uId;			// UID
		$rtn[]	= $this -> userAccount;	// 口座番号
		$rtn[]	= $this -> confCode;	// 確認コード

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 申請データ登録用のデータ取得関数
	* @parameter	: なし
	* @return		: 申請データ登録用データ配列
	-------------------------------------------------------------------------*/
	public function getUpdateParams() {

		// 変数宣言部
		$rtn = array();

		$rtn[]	= $this -> userName;	// ログインID
		$rtn[]	= password_hash($this -> pw.VAL_STR_AUTH_HASH_SECRET_KEY, PASSWORD_BCRYPT, array('cost'=>13));			// 口座番号

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 申請データ登録用のデータ取得関数
	* @parameter	: なし
	* @return		: 申請データ登録用データ配列
	-------------------------------------------------------------------------*/
	public function getDeleteParams() {

		// 変数宣言部
		$rtn = array();

		$rtn[]	= $this -> id;	// ログインID

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: HTML表示用のデータ取得関数
	* @parameter	: なし
	* @return		: HTML表示用データ配列
	-------------------------------------------------------------------------*/
	public function dispHTML() {
		return array();
	}
}
?>