<?php
$page_title = "Credit Card Deposit Solution";
include_once('./config.php');
include_once('template/base_head.php');
?>

<aside id="colLeft">
	<h1><a href="/en/menu"><img src="../img/logo.png" alt="iWallet"></a></h1>
	<?php include_once('template/base_sidebar.php'); ?>
</aside>

<div id="colMain">
	<div class="mainIn">
		<?php include_once('template/base_nav.php'); ?>
		<article>
			<div class="article-heading">
				<h2>
					<?php echo $page_title; ?>
				</h2>
			</div>
			<div class="mb10 pleft40"><?php echo $this -> echoMessage(); ?></div>
			
			<div id="confirm_main_content">
			
    			<p class="pleft40 mb20 respM">Please review the deposit details and read the note below before making any transactions.</p>
    
    			<div class="pleft40">
    				
    				<table class="table col bdr default odd  fontM summaryT">
                        <tr>
                            <th style="width: 180px;" colspan="2">Deposit Details</th>
                        </tr>
                        <tr>
                            <th style="width: 180px;">Deposit Amount</th>
                            <td class="ralign"><?php echo $this -> getCurrency();?>&nbsp;<?php $this -> echoAmount(); ?></td>
                        </tr> 
                        <tr>
                            <th style="width: 180px;">Transaction Fee</th>
                            <td class="ralign"><?php echo $this -> getCurrency();?>&nbsp;<?php $this -> echoFee(); ?></td>
                        </tr>
                        <tr>
                            <th style="width: 180px;">Deposit Amount Due</th>
                            <td class="ralign"><?php echo $this -> getCurrency();?>&nbsp;<?php $this -> echoDepositAmountNatural(); ?></td>
                        </tr>
                  	</table>
    			</div>
    			<br />
    			<br />
                <div class="container_wi650">
                    <ul class="pleft40 ul_list">
    			        <li>A transaction fee, 6% of the deposited amount will be charged to the member.</li>
    			        <li>This option is only available for members with Credit Card.</li>
    			        <li>The deposited amount will be instantly credited into your credit card balance of your iWallet account.</li>			 	
                    </ul>
    			 	<div style="margin-top:50px" class="red pleft40">※To continue your transaction, click "Next." You will be redirected to the bank information page to settle your deposit transaction.
    		 		</div>
                </div>
    			<div class="calign nextwbtn" style="    margin-top: 10px;">
    				<a id="btnBackCCDInput" class="btn bg-default calign">&laquo; Back</a>&emsp;
    				<a id="btnCCDComplete" class="btn bg-grad px180 mt10">Next</a>
    			</div>
			
			</div>
						
			<form id="acForm" action="" method="post">
			    <input type="hidden" name="type" id="type" />
			    <input type="hidden" name="amount" value="<?php $this -> echoAmountPure(); ?>"  />
			    <input type="hidden" name="currency" value="<?php echo $this -> getCurrency(); ?>" />
			    <input type="hidden" name="fee" value="<?php $this -> echoFee() ?>" />
			    <input type="hidden" name="message" value="<?php echo $this -> message; ?>" />
			</form>
			
		</article>
	</div>
</div>
</div>
</div>
<?php include_once('template/base_foot.php'); ?>
</div>
<script src="../js/deposit.js"></script>
</body>
</html>

