<?php
require_once('config.php');
require_once('CheckRequestBase.php');

class APIMakeRequest extends System {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $signature					= NO_STRING;
	private $account					= NO_STRING;
	private $fromAccount				= NO_STRING;	// 送金元口座
	private $toAccunt					= NO_STRING;	// 送金先口座
	private $currency					= NO_STRING;	// 通貨
	private $amount						= NO_STRING;	// 金額
	private $message					= NO_STRING;	// 送金メッセージ

	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: パスワードの更新
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function action() {

		// 変数宣言部
		$rtn		= array();
		$params		= array();
		$base		= null;

		try {

			// パラメータの設定
			$this -> signature					= $this -> getDataPost(PARAM_SIGNATURE);
			$this -> account					= $this -> getDataPost(PARAM_USER_ACCOUNT);					// 送金先口座
			$this -> fromAccount				= $this -> getDataPost(PARAM_FROM);							// 送金元口座
			$this -> currency					= strtoupper($this -> getDataPost(PARAM_CURRENCY));			// 通貨
			$this -> amount						= $this -> getDataPost(PARAM_AMOUNT);						// 金額
			$this -> message					= $this -> getDataPost(PARAM_MESSAGE);						// メッセージ

			// シグネチャのチェック（デバッグの場合は処理しない）
			if($this -> getDataPost('debug') == NO_STRING) {
				$this -> checkSignature($this -> signature, 'R' . $this -> account . $this -> fromAccount);
			}

			// チェッククラスの生成
			$base = new APICheckRequestBase();
			$base -> action();

			// 送金実行
			$params[] = $this -> fromAccount;													// 送金元口座番号
			$params[] = $this -> account;														// 送金先口座番号
			$params[] = $this -> currency;														// 通貨
			$params[] = $this -> currencyToInt($this -> amount, $this -> currency);				// 金額
			$params[] = NO_COUNT;																// ステータス
			$params[] = addslashes($this -> message);											// メッセージ
			$params[] = $this -> getTransactionNumberCommon(VAR_TRANSACTION_REQUEST_WITHDRAW);	// 取引番号

			$this -> accessModify('INSERT_REQUEST', $params, false);

			// メールの送信
			$params = array();
			$params[] = $this -> fromAccount;											// 送金元口座番号
			$params[] = $this -> getUserNameCommon($this -> fromAccount);				// 送金元ユーザ氏名
			$params[] = $this -> account;												// 送金先口座番号
			$params[] = $this -> getCurrentTimeCommon();								// 現在時刻
			$params[] = $this -> currency;												// 通貨
			$params[] = $this -> formatCurrency($this -> amount, $this -> currency);	// 金額
			$params[] = addslashes($this -> message);									// メッセージ

			$this -> sendMailByTmp('request_apply.xml'
									, $params
									, $this -> getUserEMailCommon($this -> fromAccount)
									, VAR_CS_MAIL_ADDRESS);

			echo json_encode(array('result'		=> 'OK'
								, 'messages'	=> 'I_COMPLETE_PROCESS'));

		} catch (Exception $e) {
			$rtn = array('result'		=> 'NG'
						, 'messages'	=> $e -> getMessage());

			echo json_encode($rtn);
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: エラーチェック
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function validate() {
	}
}

$api = new APIMakeRequest();
$api -> action();
?>