<?php

class MoneyOutTransactions extends OpenAPIAbstraction{
    
    /**
     * 
     * @var ParamHolder
     */
    private $holder;
    private $view;
    
    public function setView($view){
        $this -> view = $view;
    }
    
    public function showResults(){
        $this -> holder = $this -> getHolder();
        
        switch($this -> view){
            case "totalPerCurrency":
                $this -> getWithdrawalTotalPerCurrency();
                break;
            case "withdrawalList":
                $this -> list();
                break;
        }
    }
    
    public function getWithdrawalTotalPerCurrency(){ 
        $result = $this -> accessSelect('LIST_WITHDRAW_TOTAL', [$this -> getWhere()]);
                         
        if($this -> isLoopData($result)) {
            foreach($result as &$row) {
                $row["amount"] = $this -> intToCurrency($row["amount"], $row["currency"]);
            }
        }
        
        echo json_encode($result); 
    }
    
    private function list(){
        $list = $this -> accessSelect('LIST_WITHDRAW_REVISED', [$this -> getWhere()]);
        
        $rowCount = count($list);
        $totalPage = $this -> getTotalPageCommon(VAR_DEFAULT_PAGE_COUNT, $rowCount);
        
        $currentPage = !empty($this -> holder -> page) ? $this -> holder -> page : 1;
        
        if($currentPage > $totalPage)
            $currentPage = $totalPage;
        
        $start		= 	 ($currentPage - VAL_INT_1) * VAR_DEFAULT_PAGE_COUNT;
        $end		=     $currentPage * VAR_DEFAULT_PAGE_COUNT;
        
        $result = [
            "row_count" => $rowCount,
            "page_total" => $totalPage,
            "current_page" => $currentPage,
            "result" => []
        ];
        
        for($i = $start; $i < $end && $i < $rowCount; $i++) {
            $result["result"][] = $this -> getRowData($list, $i);
        }
        
        echo json_encode($result);
    }
    
    private function getWhere() : String { 
        // 変数宣言部
        $rtn = NO_STRING;
        
        // 送金先口座番号（検索項目）
        if($this -> holder -> transactionNum != NO_STRING) {
            $rtn .= ' AND withdraw.transaction_number = (\')' . $this -> holder -> transactionNum . '(\')';
        }
        
        // メールアドレス（検索項目）
//         if($this -> sEmail != NO_STRING) {
//             $rtn .= ' AND (users.user_name = (\')' . $this -> sEmail . '(\')'
//                 . ' OR users.mail = (\')' . $this -> sEmail . '(\')' . ')';
//         }
        
        // 銀行データ（検索項目）
        if($this -> holder -> bankName != NO_STRING) {
            $rtn .= ' AND (withdraw.receipt_bank_name = (\')' . $this -> holder -> bankName . '(\')'
                . ' OR withdraw.receipt_bank_swift = (\')' . $this -> holder -> bankName . '(\')'
                . ' OR withdraw.intermediary_bank_name = (\')' . $this -> holder -> bankName . '(\')'
                . ' OR withdraw.intermediary_bank_swift = (\')' . $this -> holder -> bankName . '(\')'
                . ')';
        }
        
        // 送金先口座番号（検索項目）
        if($this -> holder -> remittanceAccount != NO_STRING) {
            $rtn .= ' AND withdraw.account_number = (\')' . $this -> holder -> remittanceAccount . '(\')';
        }
        
        // 銀行注文番号
        if($this -> holder -> bankSlipNumber  != NO_STRING) {
            $rtn .= ' AND withdraw.order_number = (\')' . $this -> holder -> bankSlipNumber . '(\')';
        }
        
        // ステータス（検索項目）
        if($this -> holder -> withdrawalStatus != NO_STRING) {
            $rtn .= ' AND withdraw.status = (\')' . $this -> holder -> withdrawalStatus . '(\')';
        }
        if($this -> holder -> tier != NO_STRING) {
            $rtn .= ' AND users.tier_tag = (\')' . $this -> holder -> tier . '(\')';
        }
        
        // 通貨
        if($this -> holder -> currency != NO_STRING) {
            $rtn .= ' AND withdraw.currency = (\')' . $this -> holder -> currency . '(\')';
        }
        
        // 口座番号
        if($this -> holder -> userAccount != NO_STRING) {
            $rtn .= ' AND withdraw.user_account = (\')' . $this -> holder -> userAccount . '(\')';
        }
        
        // 送金額（最少）（検索項目）
        if($this -> holder -> minAmount != NO_STRING) {
            if($this -> holder -> currency == NO_STRING) {	// 通貨未指定
                $rtn .= ' AND withdraw.amount >= (\')' . $this -> holder -> minAmount . '(\')';
            } else {								// 通貨指定
                $rtn .= ' AND withdraw.amount >= (\')' . $this -> currencyToInt($this -> holder -> minAmount, $this -> holder -> currency) . '(\')';
            }
        }
        
        // 送金額（最大）（検索項目）
        if($this -> holder -> maxAmount != NO_STRING) {
            if($this -> holder -> currency == NO_STRING) {	// 通貨未指定
                $rtn .= ' AND withdraw.amount <= (\')' . $this -> holder -> maxAmount . '(\')';
            } else {								// 通貨指定
                $rtn .= ' AND withdraw.amount <= (\')' . $this -> currencyToInt($this -> holder -> maxAmount, $this -> holder -> currency) . '(\')';
            }
        }
        
        if($this -> holder -> withdrawalFee != NO_STRING && $this -> holder -> withdrawalFee == 'All' ){
             $rtn .= ' AND (LEFT(withdraw.transaction_number, 1) = (\')F(\')
		          OR LEFT(withdraw.transaction_number, 1) = (\')M(\'))';
        }
        
        if($this -> holder -> withdrawalFee != NO_STRING && $this -> holder -> withdrawalFee != 'All' && $this -> holder -> withdrawalFee != 'Select') {
            $rtn .= ' AND LEFT(withdraw.transaction_number, 1) = (\')'. $this -> holder -> withdrawalFee .'(\')';
        }
        
        if($this -> holder -> searchByAppDate != NO_STRING){
            // 登録時刻（開始日）（検索項目）
            if($this -> holder -> applicationDateFrom != NO_STRING) {
                $rtn .= ' AND withdraw.create_time >= (\')' . $this -> holder -> applicationDateFrom . '(\')';
            }
            
            // 登録時刻（終了）（検索項目）
            if($this -> holder -> applicationDateTo != NO_STRING) {
                $rtn .= ' AND withdraw.create_time < DATE_ADD((\')' . $this -> holder -> applicationDateTo . '(\'), INTERVAL 1 DAY)';
            }
        }
        
        if($this -> holder -> searchByProcessDate != NO_STRING){
            // 登録時刻（開始日）（検索項目）
            if($this -> holder -> processDateFrom != NO_STRING) {
                $rtn .= ' AND withdraw.process_time >= (\')' . $this -> holder -> processDateFrom . '(\')';
            }
            
            // 登録時刻（終了）（検索項目）
            if($this -> holder -> processDateTo != NO_STRING) {
                $rtn .= ' AND withdraw.process_time < DATE_ADD((\')' . $this -> holder -> processDateTo . '(\'), INTERVAL 1 DAY)';
            }
        }
        
        if($this -> holder -> withdrawalSolution != NO_STRING && $this -> holder -> withdrawalSolution != 'All' &&  $this -> holder -> withdrawalSolution != 'Select') {
            $rtn .= ' AND withdraw.withdraw_solution = (\')' . $this -> holder -> withdrawalSolution . '(\')';
        }
        
        if($this -> holder -> withdrawalSolution != NO_STRING && $this -> holder -> withdrawalSolution == 'All' ){
            $rtn .= 'AND LEFT(withdraw.transaction_number, 1) = (\')W(\')';
        }
        
        if($this -> holder -> testAccountFlag != NO_STRING) {
            $rtn .= 'AND users.test_account_flg = (\')' . $this -> holder -> testAccountFlag . '(\')';
        }
        
        return $rtn;
    }
}