<?php
class SettingModelClass extends ModelClassEx {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $user			= null;			// ユーザデータ
	private $kycs			= null;			// KYCデータ一覧
	private $mail			= NO_STRING;	// メールアドレス
	private $mail2			= NO_STRING;	// メールアドレス（再入力用）
	private $birth			= NO_STRING;	// 生年月日
	private $lastName		= NO_STRING;	// 姓
	private $firstName		= NO_STRING;	// 名
	private $country		= NO_STRING;	// 国
	private $state			= NO_STRING;	// 都道府県
	private $city			= NO_STRING;	// 市町村
	private $zipCode		= NO_STRING;	// 郵便番号
	private $address		= NO_STRING;	// 番地1
	private $address2		= NO_STRING;	// 番地2
	private $tel			= NO_STRING;	// 電話番号
	private $currentPw		= NO_STRING;	// 現在のパスワード
	private $password		= NO_STRING;	// パスワード
	private $password2		= NO_STRING;	// パスワード（再入力用）
	private $img1Flg		= NO_STRING;	// KYC書類1
	private $img2Flg		= NO_STRING;	// KYC書類2
	private $img3Flg		= NO_STRING;	// KYC書類3
	private $img4Flg		= NO_STRING;	// KYC書類4
	private $img5Flg		= NO_STRING;	// KYC書類5
	private $img6Flg		= NO_STRING;	// KYC書類6
	private $img7Flg		= NO_STRING;	// KYC書類7
	private $img8Flg		= NO_STRING;	// KYC書類8
	private $img9Flg		= NO_STRING;	// KYC書類9
	private $img10Flg		= NO_STRING;	// KYC書類10
	private $img11Flg		= NO_STRING;	// KYC書類11
	private $kId			= NO_STRING;	// KYC書類ID
	private $oldFileName	= NO_STRING;	// 旧ファイル名
	private $path			= NO_STRING;	// ファイルパス
	private $kycUpdateCntr	= NO_STRING;	// kyc status countre
	private $transferFlg	= NO_STRING;	

	/*-------------------------------------------------------------------------
	* @function_name: コントロールパネルシステムindexモデルクラスコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		// スーパークラスコンストラクタ呼び出し
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: 初期設定関数
	* @parameter	: なし
	* @return		: 成功:success、失敗:error
	-------------------------------------------------------------------------*/
	public function init() {

		try {

			// パラメータの設定
			$this -> setParameter();

			// チェック
			return $this -> validate();

		} catch (Exception $e) {
			throw new Exception(NO_STRING);
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: パラメータの設定
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function setParameter() {
		$this -> kId				= $this -> getDataPost(PARAM_K_ID);			// KYC書類ID
		$this -> mail				= $this -> getDataPost(PARAM_MAIL);			// メール
		$this -> mail2				= $this -> getDataPost(PARAM_MAIL2);		// メール（再入力用）
		$this -> state				= $this -> getDataPost(PARAM_STATE);		// 都道府県
		$this -> city				= $this -> getDataPost(PARAM_CITY);			// 市町村
		$this -> zipCode			= $this -> getDataPost(PARAM_ZIP_CODE);		// 郵便番号
		$this -> address			= $this -> getDataPost(PARAM_ADDRESS);		// 番地1
		$this -> address2			= $this -> getDataPost(PARAM_ADDRESS_2);	// 番地2
		$this -> tel				= $this -> getDataPost(PARAM_TEL);			// 電話番号
		$this -> currentPw			= $this -> getDataPost(PARAM_PASSWORD);		// パスワード
		$this -> password			= $this -> getDataPost(PARAM_NEW_PW);		// パスワード
		$this -> password2			= $this -> getDataPost(PARAM_NEW_PW2);		// パスワード
		$this -> img1Flg			= $this -> getDataPost(PARAM_IMG_1_FLG);	// KYC書類1フラグ
		$this -> img2Flg			= $this -> getDataPost(PARAM_IMG_2_FLG);	// KYC書類2フラグ
		$this -> img3Flg			= $this -> getDataPost(PARAM_IMG_3_FLG);	// KYC書類3フラグ
		$this -> img4Flg			= $this -> getDataPost(PARAM_IMG_4_FLG);	// KYC書類4フラグ
		$this -> img5Flg			= $this -> getDataPost(PARAM_IMG_5_FLG);	// KYC書類5フラグ
		$this -> img6Flg			= $this -> getDataPost(PARAM_IMG_6_FLG);	// KYC書類6フラグ
		$this -> img7Flg			= $this -> getDataPost(PARAM_IMG_7_FLG);	// KYC書類7フラグ
		$this -> img8Flg			= $this -> getDataPost(PARAM_IMG_8_FLG);	// KYC書類8フラグ
		$this -> img9Flg			= $this -> getDataPost(PARAM_IMG_9_FLG);	// KYC書類9フラグ
		$this -> img10Flg			= $this -> getDataPost(PARAM_IMG_10_FLG);	// KYC書類10フラグ
		$this -> img11Flg			= $this -> getDataPost(PARAM_IMG_11_FLG);	// KYC書類11フラグ
		$this -> country			= $this -> getDataPost(PARAM_COUNTRY);		// 国コード
		$this -> transferFlg 		= $this -> getDataPost('disableTransfer');
	}

	/*-------------------------------------------------------------------------
	* @function_name: サーバ側データチェック
	* @parameter	: なし
	* @return		: TRUE:成功、FALSE:失敗
	-------------------------------------------------------------------------*/
	public function validate() {

		// 変数宣言部
		$rtn = true;

		// ログインチェック
		if(!$this -> checkSiteUserLogin()) {
			throw new Exception(NO_STRING);
		}

		// プロフィールのチェック
		if($this -> getAction()		== NO_STRING
			&& $this -> getType()	== TYPE_CONFIRM) {

			// 必須項目
			// 都道府県のチェック
			if(!$this -> checkNull($this -> state)) {
				$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_STATE));
				$rtn = false;
			}

			// 市区町村のチェック
			if(!$this -> checkNull($this -> city)) {
				$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_CITY));
				$rtn = false;
			}

			// 住所のチェック
			if(!$this -> checkNull($this -> address)) {
				$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_ADDRESS));
				$rtn = false;
			}

			// 郵便番号のチェック
			if(!$this -> checkNull($this -> zipCode)) {
				$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_ZIP_CODE));
				$rtn = false;
			}

			// 電話番号のチェック
			if(!$this -> checkNull($this -> tel)) {
				$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_TEL));
				$rtn = false;
			}

			if(!$rtn) {
				$this -> setType(TYPE_BACK);
				return;
			}

			// 正規表現
			// 都道府県のチェック
			if(!$this -> checkStringAsciiStateAndCity($this -> state)) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_REGULAR_ASCII_STATE_CITY', array(VAL_STR_STATE, VAL_INT_64));
				$rtn = false;
			}

			if(!$this -> checkLength($this -> state
									, VAL_INT_1
									, VAL_INT_64)) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_STRING_LENGTH_ANY', array(VAL_STR_STATE
																						, VAL_INT_1
																						, VAL_INT_64));
				$rtn = false;
			}

			// 市区町村のチェック
			if(!$this -> checkStringAsciiStateAndCity($this -> city)) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_REGULAR_ASCII_STATE_CITY', array(VAL_STR_CITY, VAL_INT_64));
				$rtn = false;
			}

			if(!$this -> checkLength($this -> city
									, VAL_INT_1
									, VAL_INT_64)) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_STRING_LENGTH_ANY', array(VAL_STR_CITY
																						, VAL_INT_1
																						, VAL_INT_64));
				$rtn = false;
			}

			// 住所のチェック
			if(!$this -> checkStringAddress($this -> address)) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_REGULAR_ASCII_ADDRESS', array(VAL_STR_ADDRESS, VAL_INT_128));
				$rtn = false;
			}

			if(!$this -> checkLength($this -> address
									, VAL_INT_1
									, VAL_INT_128)) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_STRING_LENGTH_ANY', array(VAL_STR_ADDRESS
																						, VAL_INT_1
																						, VAL_INT_128));
				$rtn = false;
			}

			// 郵便番号のチェック
			if(!$this -> checkStringNumberZipCode($this -> zipCode)) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_REGULAR_NUMBER_ZIP_CODE', array(VAL_STR_ZIP_CODE));
				$rtn = false;
			}

			// 電話番号のチェック
			if(!$this -> checkStringNumberTel($this -> tel)) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_REGULAR_NUMBER_TEL', array(VAL_STR_TEL, VAL_INT_25));
				$rtn = false;
			}

			if(!$this -> checkLength($this -> tel
									, VAL_INT_7
									, VAL_INT_25)) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_STRING_LENGTH_ANY', array(VAL_STR_TEL
																						, VAL_INT_7
																						, VAL_INT_25));
				$rtn = false;
			}

			if(!$rtn) {
				$this -> setType(TYPE_BACK);
			}
		} else if($this -> getAction() 		== CONTROL_SETTING_CHANGE_PASSWORD
					&& $this -> getType()	== TYPE_CONFIRM) {

			// 必須項目
			// 現在パスワード
			if(!$this -> checkNull($this -> currentPw)) {
				$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_CURRENT_PASSWORD));
				$rtn = false;
			}

			// 新パスワード
			if(!$this -> checkNull($this -> password)) {
				$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_NEW_PASSWORD));
				$rtn = false;
			}

			// 新パスワード（再入力）
			if(!$this -> checkNull($this -> password2)) {
				$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_NEW_PASSWORD_RE_ENTER));
				$rtn = false;
			}

			if(!$rtn) {
				$this -> setType(CONTROL_SETTING_CHANGE_PASSWORD);
				return;
			}

			// パスワードチェック

			// 現在のパスワード
			if(!$this -> checkPassword($this -> getUserData(PARAM_USER_ACCOUNT), $this -> currentPw)) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_SAME_PASS_WORD', array());
				$rtn = false;
			}else{
				if($this -> currentPw == $this -> password){
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_SAME_PASSWORD', array());
					$rtn = false;
				}
			}

			// 再入力の同一
			if($this -> password != $this -> password2) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_SAME_DATA', array(VAL_STR_NEW_PASSWORD, VAL_STR_NEW_PASSWORD_RE_ENTER));
				$rtn = false;
			}

			// パスワードの正規表現
			if(!$this -> checkStringPassword($this -> password)) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_REGULAR_PASSWORD', array(VAL_STR_PASSWORD));
				$rtn = false;
			} else {

				if(!$this -> checkStringPasswordSecond($this -> password)) {
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_REGULAR_PASSWORD_SECOND', array(VAL_STR_PASSWORD));
					$rtn = false;
				}
			}

			// 新パスワードの文字数制限
			if(!$this -> checkLength($this -> password
									, VAR_PASSWORD_MIN
									, VAR_PASSWORD_MAX)) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_STRING_LENGTH_ANY', array(VAL_STR_PASSWORD
																						, VAR_PASSWORD_MIN
																						, VAR_PASSWORD_MAX));
				$rtn = false;
			}

			if(!$rtn) {
				$this -> setType(CONTROL_SETTING_CHANGE_PASSWORD);
			}
		} else if($this -> getAction() 		== CONTROL_SETTING_CHANGE_MAIL
					&& $this -> getType()	== TYPE_CONFIRM) {

			// 必須項目
			// メールアドレスのチェック
			if(!$this -> checkNull($this -> mail)) {
				$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_EMAIL));
				$rtn = false;
			}

			// メールアドレス（再入力用）のチェック
			if(!$this -> checkNull($this -> mail2)) {
				$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_EMAIL_RE_ENTER));
				$rtn = false;
			}

			if(!$rtn) {
				$this -> setType(CONTROL_SETTING_CHANGE_MAIL);
				return;
			}

			// 正規表現
			if(!$this -> checkStringMailAddress($this -> mail)) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_VALUE_PREG', array(VAL_STR_EMAIL));
				$rtn = false;
			}

			// 再入力チェック
			if($this -> mail != $this -> mail2) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_SAME_DATA', array(VAL_STR_EMAIL, VAL_STR_EMAIL_RE_ENTER));
				$rtn = false;
			}

			// 同一チェック
			if(!$this -> checkMailAddress($this -> mail)) {
				$this -> popUpSessionMessage(ERROR, 'E_DO_NOT_OVERLAP', array(VAL_STR_EMAIL));
				$rtn = false;
			}

			if(!$rtn) {
				$this -> setType(CONTROL_SETTING_CHANGE_MAIL);
			}

		//判断是否可以进邮箱修改
		} else if ($this -> getType() == CONTROL_SETTING_CHANGE_MAIL) {

			//create session variable for 2favalidated
			$_SESSION['2fa_validated'] = 'not validated';

			if (!$this -> get2FaValue(array($this -> getUserData(PARAM_USER_ACCOUNT),'mail_status','mail_update_time'))) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_2FA_24MAIL_LOCK', array());
				$this -> setType(TYPE_2FA_DISABLE_ONE);
			}

		//判断是否可以修改密码
		} else if ($this -> getType() == CONTROL_SETTING_CHANGE_PASSWORD) {

			if (!$this -> get2FaValue(array($this -> getUserData(PARAM_USER_ACCOUNT),'password_status','password_update_time'))) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_2FA_24PASSWORD_LOCK', array());
				$this -> setType(TYPE_2FA_DISABLE_TWE);
			}

		}else if($this -> getType()		== CONTROL_SETTING_KYC) {	// KYCアップロード前のチェック

			// ユーザデータの取得
			$account = $this -> getAccountCommon($this -> getUserData(PARAM_USER_ACCOUNT));
			$account = $this -> getRowData($account);

			// 州・都道府県
			// 市区町村
			// 住所
			// 郵便番号
			// 電話番号が空欄の場合はデータの転送
			if($this -> getColumnData($account, PARAM_STATE)		== NO_STRING
				|| $this -> getColumnData($account, PARAM_CITY)		== NO_STRING
				|| $this -> getColumnData($account, PARAM_ADDRESS)	== NO_STRING
				|| $this -> getColumnData($account, PARAM_ZIP_CODE)	== NO_STRING
				|| $this -> getColumnData($account, PARAM_TEL)		== NO_STRING) {
				$this -> popUpSessionMessage(WARNING, 'W_NOT_ADDRESS', array());

				$this -> setType();
			}

		} else if($this -> getAction()		== CONTROL_SETTING_KYC
					&& $this -> getType()	== TYPE_SAVE) {				// KYC登録（個人）

			// 画像1がアップロードされている
			if($this -> isUpload(PARAM_IMG1)) {

				$f = $_FILES[PARAM_IMG1];

				// 拡張子のチェック
				if(!$this -> checkStringExtension($f[PARAM_NAME])) {
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_FILE_FORMAT', array());
					$rtn = false;
				}

				// ファイルサイズ
				if(filesize($f[PARAM_TMP_NAME]) > 5242880) {
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_UPLOAD_SIZE', array());
					$rtn = false;
				}
			}


			// 画像2がアップロードされている
			if($this -> isUpload(PARAM_IMG2)) {

				$f = $_FILES[PARAM_IMG2];

				// 拡張子のチェック
				if(!$this -> checkStringExtension($f[PARAM_NAME])) {
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_FILE_FORMAT', array());
					$rtn = false;
				}

				// ファイルサイズ
				if(filesize($f[PARAM_TMP_NAME]) > 5242880) {
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_UPLOAD_SIZE', array());
					$rtn = false;
				}
			}

			// 画像3がアップロードされている
			if($this -> isUpload(PARAM_IMG3)) {

				$f = $_FILES[PARAM_IMG3];

				// 拡張子のチェック
				if(!$this -> checkStringExtension($f[PARAM_NAME])) {
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_FILE_FORMAT', array());
					$rtn = false;
				}

				// ファイルサイズ
				if(filesize($f[PARAM_TMP_NAME]) > 5242880) {
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_UPLOAD_SIZE', array());
					$rtn = false;
				}
			}

			// 画像4がアップロードされている
			if($this -> isUpload(PARAM_IMG4)) {

				$f = $_FILES[PARAM_IMG4];

				// 拡張子のチェック
				if(!$this -> checkStringExtension($f[PARAM_NAME])) {
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_FILE_FORMAT', array());
					$rtn = false;
				}

				// ファイルサイズ
				if(filesize($f[PARAM_TMP_NAME]) > 5242880) {
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_UPLOAD_SIZE', array());
					$rtn = false;
				}
			}

			// 画像5がアップロードされている
			if($this -> isUpload(PARAM_IMG5)) {

				$f = $_FILES[PARAM_IMG5];

				// 拡張子のチェック
				if(!$this -> checkStringExtension($f[PARAM_NAME])) {
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_FILE_FORMAT', array());
					$rtn = false;
				}

				// ファイルサイズ
				if(filesize($f[PARAM_TMP_NAME]) > 5242880) {
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_UPLOAD_SIZE', array());
					$rtn = false;
				}
			}

			// 画像6がアップロードされている
			if($this -> isUpload(PARAM_IMG6)) {

				$f = $_FILES[PARAM_IMG6];

				// 拡張子のチェック
				if(!$this -> checkStringExtension($f[PARAM_NAME])) {
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_FILE_FORMAT', array());
					$rtn = false;
				}

				// ファイルサイズ
				if(filesize($f[PARAM_TMP_NAME]) > 5242880) {
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_UPLOAD_SIZE', array());
					$rtn = false;
				}
			}

			if(!$rtn) {
				$this -> setType(CONTROL_SETTING_KYC);
			}

		} else if($this -> getAction()		== CONTROL_SETTING_KYC
					&& $this -> getType()	== TYPE_COMPLETE) {			// KYC登録（法人）

			// 画像1がアップロードされている
			if($this -> isUpload(PARAM_IMG1)) {

				$f = $_FILES[PARAM_IMG1];

				// 拡張子のチェック
				if(!$this -> checkStringExtension($f[PARAM_NAME])) {
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_FILE_FORMAT', array());
					$rtn = false;
				}

				// ファイルサイズ
				if(filesize($f[PARAM_TMP_NAME]) > 5242880) {
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_UPLOAD_SIZE', array());
					$rtn = false;
				}
			}


			// 画像2がアップロードされている
			if($this -> isUpload(PARAM_IMG2)) {

				$f = $_FILES[PARAM_IMG2];

				// 拡張子のチェック
				if(!$this -> checkStringExtension($f[PARAM_NAME])) {
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_FILE_FORMAT', array());
					$rtn = false;
				}

				// ファイルサイズ
				if(filesize($f[PARAM_TMP_NAME]) > 5242880) {
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_UPLOAD_SIZE', array());
					$rtn = false;
				}
			}

			// 画像3がアップロードされている
			if($this -> isUpload(PARAM_IMG3)) {

				$f = $_FILES[PARAM_IMG3];

				// 拡張子のチェック
				if(!$this -> checkStringExtension($f[PARAM_NAME])) {
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_FILE_FORMAT', array());
					$rtn = false;
				}

				// ファイルサイズ
				if(filesize($f[PARAM_TMP_NAME]) > 5242880) {
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_UPLOAD_SIZE', array());
					$rtn = false;
				}
			}

			// 画像4がアップロードされている
			if($this -> isUpload(PARAM_IMG4)) {

				$f = $_FILES[PARAM_IMG4];

				// 拡張子のチェック
				if(!$this -> checkStringExtension($f[PARAM_NAME])) {
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_FILE_FORMAT', array());
					$rtn = false;
				}

				// ファイルサイズ
				if(filesize($f[PARAM_TMP_NAME]) > 5242880) {
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_UPLOAD_SIZE', array());
					$rtn = false;
				}
			}

			// 画像5がアップロードされている
			if($this -> isUpload(PARAM_IMG5)) {

				$f = $_FILES[PARAM_IMG5];

				// 拡張子のチェック
				if(!$this -> checkStringExtension($f[PARAM_NAME])) {
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_FILE_FORMAT', array());
					$rtn = false;
				}

				// ファイルサイズ
				if(filesize($f[PARAM_TMP_NAME]) > 5242880) {
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_UPLOAD_SIZE', array());
					$rtn = false;
				}
			}

			// 画像6がアップロードされている
			if($this -> isUpload(PARAM_IMG6)) {

				$f = $_FILES[PARAM_IMG6];

				// 拡張子のチェック
				if(!$this -> checkStringExtension($f[PARAM_NAME])) {
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_FILE_FORMAT', array());
					$rtn = false;
				}

				// ファイルサイズ
				if(filesize($f[PARAM_TMP_NAME]) > 5242880) {
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_UPLOAD_SIZE', array());
					$rtn = false;
				}
			}

			// 画像6がアップロードされている
			if($this -> isUpload(PARAM_IMG7)) {

				$f = $_FILES[PARAM_IMG7];

				// 拡張子のチェック
				if(!$this -> checkStringExtension($f[PARAM_NAME])) {
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_FILE_FORMAT', array());
					$rtn = false;
				}

				// ファイルサイズ
				if(filesize($f[PARAM_TMP_NAME]) > 5242880) {
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_UPLOAD_SIZE', array());
					$rtn = false;
				}
			}

			// 画像6がアップロードされている
			if($this -> isUpload(PARAM_IMG8)) {

				$f = $_FILES[PARAM_IMG8];

				// 拡張子のチェック
				if(!$this -> checkStringExtension($f[PARAM_NAME])) {
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_FILE_FORMAT', array());
					$rtn = false;
				}

				// ファイルサイズ
				if(filesize($f[PARAM_TMP_NAME]) > 5242880) {
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_UPLOAD_SIZE', array());
					$rtn = false;
				}
			}

			// 画像6がアップロードされている
			if($this -> isUpload(PARAM_IMG9)) {

				$f = $_FILES[PARAM_IMG9];

				// 拡張子のチェック
				if(!$this -> checkStringExtension($f[PARAM_NAME])) {
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_FILE_FORMAT', array());
					$rtn = false;
				}

				// ファイルサイズ
				if(filesize($f[PARAM_TMP_NAME]) > 5242880) {
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_UPLOAD_SIZE', array());
					$rtn = false;
				}
			}

			// 画像6がアップロードされている
			if($this -> isUpload(PARAM_IMG10)) {

				$f = $_FILES[PARAM_IMG10];

				// 拡張子のチェック
				if(!$this -> checkStringExtension($f[PARAM_NAME])) {
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_FILE_FORMAT', array());
					$rtn = false;
				}

				// ファイルサイズ
				if(filesize($f[PARAM_TMP_NAME]) > 5242880) {
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_UPLOAD_SIZE', array());
					$rtn = false;
				}
			}

			// 画像6がアップロードされている
			if($this -> isUpload(PARAM_IMG11)) {

				$f = $_FILES[PARAM_IMG11];

				// 拡張子のチェック
				if(!$this -> checkStringExtension($f[PARAM_NAME])) {
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_FILE_FORMAT', array());
					$rtn = false;
				}

				// ファイルサイズ
				if(filesize($f[PARAM_TMP_NAME]) > 5242880) {
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_UPLOAD_SIZE', array());
					$rtn = false;
				}
			}

			if(!$rtn) {
				$this -> setType(CONTROL_SETTING_KYC);
			}
		}elseif($this -> getType() == TYPE_TRANSFER_FLAG_SAVE && $this -> getAction() == TYPE_TRANSFER_SETTING) {

			if($this -> transferFlg != VAL_INT_1 && $this -> transferFlg != NO_COUNT && $this -> transferFlg != NO_STRING){
				$rtn = false;
			}

			if(!$rtn) {
				$this -> setType(TYPE_TRANSFER_SETTING);
			}

		}elseif($this -> getType() == TYPE_TRANSFER_SETTING) {
			$accountType = $this -> accessSelect('SELECT_ACCOUNT_TYPE', array($this -> getUserData(PARAM_MAIL)));
			if(count($accountType) == NO_COUNT){
				header('Location: /' . $this ->  getLangage() . '/menu');
			}

		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: メールアドレスの取得
	* @parameter	: なし
	* @return		: メールアドレス
	-------------------------------------------------------------------------*/
	public function echoMail() {
		echo $this -> mail;
	}

	/*-------------------------------------------------------------------------
	* @function_name: メールアドレスの取得
	* @parameter	: なし
	* @return		: メールアドレス
	-------------------------------------------------------------------------*/
	public function getMail() {
		return $this -> mail;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 姓の取得
	* @parameter	: なし
	* @return		: 姓
	-------------------------------------------------------------------------*/
	public function echoLastName() {
		echo $this -> lastName;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 姓の取得
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	public function dispLastName() {

		if($this -> getColumnData($this -> user, COLUMN_ACCOUNT_TYPE) == VAR_PERSON) {	// 個人口座の場合
			echo '	<tr>'
				. '<th>' . VAL_STR_LAST_NAME . '</th>'
				. '<td>' . $this -> lastName . '</td>'
				. '</tr>';
		}
	}


	/*-------------------------------------------------------------------------
	* @function_name: 名の取得
	* @parameter	: なし
	* @return		: 名
	-------------------------------------------------------------------------*/
	public function echoFirstName() {
		echo $this -> firstName;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 名の取得
	* @parameter	: なし
	* @return		: 名
	-------------------------------------------------------------------------*/
	public function echoFirstNameTitle() {

		if($this -> getColumnData($this -> user, COLUMN_ACCOUNT_TYPE) == VAR_CORP) {	// 法人口座の場合
			echo VAL_STR_CORP_NAME;

		} else {																		// 個人口座の場合
			echo VAL_STR_FIRST_NAME;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: 姓の取得
	* @parameter	: なし
	* @return		: 姓
	-------------------------------------------------------------------------*/
	public function getLastName() {
		return  $this -> lastName;
	}



	/*-------------------------------------------------------------------------
	* @function_name: 名の取得
	* @parameter	: なし
	* @return		: 名
	-------------------------------------------------------------------------*/
	public function getFirstName() {
		return $this -> firstName;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 生年月日の取得
	* @parameter	: なし
	* @return		: 生年月日
	-------------------------------------------------------------------------*/
	public function echoBirth() {
		echo $this -> birth;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 国の取得
	* @parameter	: なし
	* @return		: 国
	-------------------------------------------------------------------------*/
	public function getCountry() {
		return $this -> country;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 国の取得
	* @parameter	: なし
	* @return		: 国
	-------------------------------------------------------------------------*/
	public function echoCountry() {
		echo $this -> dispCountryCommon($this -> country);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 国の取得
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	public function dispCountry() {
		echo $this -> dispListOption($this -> getCountyList(), $this -> country);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 都道府県の取得
	* @parameter	: なし
	* @return		: 都道府県
	-------------------------------------------------------------------------*/
	public function echoState() {
		echo $this -> state;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 市区町村の取得
	* @parameter	: なし
	* @return		: 市区町村
	-------------------------------------------------------------------------*/
	public function echoCity() {
		echo $this -> city;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 郵便番号の取得
	* @parameter	: なし
	* @return		: 郵便番号
	-------------------------------------------------------------------------*/
	public function echoZipCode() {
		echo $this -> zipCode;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 番地1の取得
	* @parameter	: なし
	* @return		: 番地1
	-------------------------------------------------------------------------*/
	public function echoAddress() {
		echo $this -> address;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 番地2の取得
	* @parameter	: なし
	* @return		: 番地2
	-------------------------------------------------------------------------*/
	public function echoAddress2() {
		echo $this -> address2;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 電話番号の取得
	* @parameter	: なし
	* @return		: 電話番号
	-------------------------------------------------------------------------*/
	public function echoTel() {
		echo $this -> tel;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 画像1フラグの取得
	* @parameter	: なし
	* @return		: 画像1フラグ
	-------------------------------------------------------------------------*/
	public function getImg1Flg() {
		return $this -> img1Flg;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 画像2フラグの取得
	* @parameter	: なし
	* @return		: 画像2フラグ
	-------------------------------------------------------------------------*/
	public function getImg2Flg() {
		return $this -> img2Flg;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 画像3フラグの取得
	* @parameter	: なし
	* @return		: 画像3フラグ
	-------------------------------------------------------------------------*/
	public function getImg3Flg() {
		return $this -> img3Flg;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 画像4フラグの取得
	* @parameter	: なし
	* @return		: 画像4フラグ
	-------------------------------------------------------------------------*/
	public function getImg4Flg() {
		return $this -> img4Flg;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 画像5フラグの取得
	* @parameter	: なし
	* @return		: 画像5フラグ
	-------------------------------------------------------------------------*/
	public function getImg5Flg() {
		return $this -> img5Flg;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 画像6フラグの取得
	* @parameter	: なし
	* @return		: 画像6フラグ
	-------------------------------------------------------------------------*/
	public function getImg6Flg() {
		return $this -> img6Flg;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 画像7フラグの取得
	* @parameter	: なし
	* @return		: 画像7フラグ
	-------------------------------------------------------------------------*/
	public function getImg7Flg() {
		return $this -> img7Flg;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 画像8フラグの取得
	* @parameter	: なし
	* @return		: 画像8フラグ
	-------------------------------------------------------------------------*/
	public function getImg8Flg() {
		return $this -> img8Flg;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 画像9フラグの取得
	* @parameter	: なし
	* @return		: 画像9フラグ
	-------------------------------------------------------------------------*/
	public function getImg9Flg() {
		return $this -> img9Flg;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 画像10フラグの取得
	* @parameter	: なし
	* @return		: 画像10フラグ
	-------------------------------------------------------------------------*/
	public function getImg10Flg() {
		return $this -> img10Flg;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 画像11フラグの取得
	* @parameter	: なし
	* @return		: 画像11フラグ
	-------------------------------------------------------------------------*/
	public function getImg11Flg() {
		return $this -> img11Flg;
	}

	/*-------------------------------------------------------------------------
	* @function_name: パスワードの取得
	* @parameter	: なし
	* @return		: パスワード
	-------------------------------------------------------------------------*/
	public function echoPassword() {
		echo $this -> password;
	}

	/*-------------------------------------------------------------------------
	* @function_name: KYC書類IDの取得
	* @parameter	: なし
	* @return		: KYC書類ID
	-------------------------------------------------------------------------*/
	public function getKId() {
		return $this -> kId;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 旧ファイル名の取得
	* @parameter	: なし
	* @return		: 旧ファイル名
	-------------------------------------------------------------------------*/
	public function getOldFileName() {
		return $this -> oldFileName;
	}

	/*-------------------------------------------------------------------------
	* @function_name: ファイルパスの取得
	* @parameter	: なし
	* @return		: ファイルパス
	-------------------------------------------------------------------------*/
	public function getPath() {
		return $this -> path;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 旧ファイル名の設定
	* @parameter	: 旧ファイル名
	* @return		: なし
	-------------------------------------------------------------------------*/
	public function setOldFileName($name) {
		$this -> oldFileName = $name;
	}

	/*-------------------------------------------------------------------------
	* @function_name: ファイルパスの設定
	* @parameter	: ファイルパス
	* @return		: なし
	-------------------------------------------------------------------------*/
	public function setPath($path) {
		$this -> path = $path;
	}

	/*-------------------------------------------------------------------------
	* @function_name: ユーザデータの設定
	* @parameter	: 出金リスト
	* @return		: なし
	-------------------------------------------------------------------------*/
	public function setUser($rs) {
		$this -> user = $rs[NO_COUNT];
	}

	/*-------------------------------------------------------------------------
	* @function_name: ユーザデータの設定
	* @parameter	: 出金リスト
	* @return		: なし
	-------------------------------------------------------------------------*/
	public function setKYCS($rs) {
		$this -> kycs = $rs;
	}

	/*-------------------------------------------------------------------------
	* @function_name: パラメータの再設定
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	public function restore() {
		$this -> kycUpdateCntr 		= $this -> getColumnData($this -> user, COLUMN_STATUS_UPDATE_COUNTER); 
		$this -> transferFlg 		= $this -> getColumnData($this -> user, COLUMN_TRANSFER_FLG); 
		if($this -> getAction()		== CONTROL_SETTING_CHANGE_MAIL
			&& $this -> getType()	== TYPE_CONFIRM) {

		} else {
			$this -> mail		= $this -> getColumnData($this -> user, COLUMN_MAIL);				// メールアドレス
		}

		$this -> lastName	= $this -> getColumnData($this -> user, COLUMN_LAST_NAME);			// 姓
		$this -> firstName	= $this -> getColumnData($this -> user, COLUMN_FIRST_NAME);			// 名
		$this -> birth		= $this -> getColumnData($this -> user, COLUMN_BIRTH_STRING);		// 生年月日

		if($this -> getAction()			== NO_STRING
			&& ($this -> getType()		== TYPE_CONFIRM
				|| $this -> getType()	== TYPE_BACK)) {
		} else {
			$this -> country	= $this -> getColumnData($this -> user, COLUMN_COUNTRY);		// 国
		}

		// 入力画面の場合のみ
		if($this -> getType()		== TYPE_INPUT
			|| $this -> getType()	== NO_STRING) {
			$this -> state		= $this -> getColumnData($this -> user, COLUMN_STATE);			// 都道府県
			$this -> city		= $this -> getColumnData($this -> user, COLUMN_CITY);			// 市区町村
			$this -> zipCode	= $this -> getColumnData($this -> user, COLUMN_ZIP_CODE);		// 郵便番号
			$this -> address	= $this -> getColumnData($this -> user, COLUMN_ADDRESS);		// 住所
			$this -> address2	= $this -> getColumnData($this -> user, COLUMN_ADDRESS_2);		// 住所2
			$this -> tel		= $this -> getColumnData($this -> user, COLUMN_TEL);			// 電話番号
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: 会社データの取得
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	public function dispCorporation() {

		// 変数宣言部
		$rtn = NO_STRING;

		if($this -> getColumnData($this -> user, COLUMN_ACCOUNT_TYPE) == VAR_CORP) {	// 法人口座の場合

			$rtn = '<table class="table col bdr default odd settingT fontM mb20 ma90sp">'
					. '<tr>'
					. '<th>' . VAL_STR_CEO_NAME . '</th>'
					. '<td>' . $this -> getColumnData($this -> user, COLUMN_CEO_FIRST_NAME) . DELIMIT_SPACE . $this -> getColumnData($this -> user, COLUMN_CEO_LAST_NAME) . '</td>'
					. '</tr>'
					. '<tr>'
					. '<th>' . VAL_STR_SITE_NAME . '</th>'
					. '<td>' . $this -> getColumnData($this -> user, COLUMN_SITE_NAME) . '</td>'
					. '</tr>'
					. '<tr>'
					. '<th>' . VAL_STR_SITE_URL . '</th>'
					. '<td>' . $this -> getColumnData($this -> user, COLUMN_SITE_URL) . '</td>'
					. '</tr>'
					. '</table>';
		}

		echo $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: KYC書類一覧
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	public function dispKYCList() {

		// 変数宣言部
		$rtn		= NO_STRING;
		$fileType	= NO_STRING;
		$kycFlg		= NO_STRING;

		if($this -> isLoopData($this -> kycs)) {

			foreach($this -> kycs as $row) {

				$fileType	= $this -> getValueByList($this -> getIdentityTypeList(), $this -> getColumnData($row, COLUMN_FILE_TYPE));
				$kycFlg		= $this -> getValueByList($this -> getKYCFlgList(), $this -> getColumnData($row, COLUMN_STATUS));

				$rtn .= '<tr>'
						. '<td class="lines">' . $this -> getColumnData($row, COLUMN_CREATE_TIME) . '</td>'
						. '<td class="lines">' . $fileType . '</td>'
						. '<td class="break lines">' . $this -> getColumnData($row, COLUMN_OLD_FILENAME) . '</td>'
						. '</tr>';
			}

		} else {
			$rtn = '<tr><td colspan="5">' . $this -> getMessage(INFO, 'I_NO_SUCHE_SEARCH_DATA', array()) . '</td></tr>';
		}

		echo $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 更新用のデータ取得関数
	* @parameter	: なし
	* @return		: 更新用データ配列
	-------------------------------------------------------------------------*/
	public function getUpdateDataProfile() {

		// 変数宣言部
		$rtn = array();

		$rtn[] = $this -> getUserData(PARAM_USER_ACCOUNT);	// iwallet口座番号
		$rtn[] = $this -> state;							// 都道府県
		$rtn[] = $this -> city;								// 市町村
		$rtn[] = $this -> zipCode;							// 郵便番号
		$rtn[] = $this -> address;							// 番地1
		$rtn[] = $this -> address2;							// 番地2
		$rtn[] = $this -> tel;								// 電話番号
		$rtn[] = $this -> country;							// 国

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: CRM更新用のデータ取得関数
	* @parameter	: なし
	* @return		: CRM更新用データ配列
	-------------------------------------------------------------------------*/
	public function getUpdateDataCRM() {

		// 変数宣言部
		$rtn = array();
		$crmId = NO_COUNT;

		// CRM IDを取得する
		$crmId = $this -> getCRMIDCommon($this -> getUserData(PARAM_USER_ACCOUNT));

		$rtn[] = $crmId;									// CRM ID
		$rtn[] = $this -> country;							// 国
		$rtn[] = $this -> state;							// 都道府県
		$rtn[] = $this -> city;								// 市町村
		$rtn[] = $this -> address;							// 番地1
		$rtn[] = $this -> zipCode;							// 郵便番号
		$rtn[] = $this -> tel;								// 電話番号


		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 更新用のデータ取得関数
	* @parameter	: なし
	* @return		: 更新用データ配列
	-------------------------------------------------------------------------*/
	public function getUpdateDataPassword() {

		// 変数宣言部
		$rtn = array();

		$rtn[] = $this -> getUserData(PARAM_USER_ID);	// ユーザID
		$rtn[] = password_hash(
		    $this -> password.VAL_STR_AUTH_HASH_SECRET_KEY, 
		    PASSWORD_BCRYPT, 
		    array('cost'=>13)
		);	// パスワード

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: getUpdateTransferFlg
	* @parameter	: 
	* @return		: enable or disable
	-------------------------------------------------------------------------*/
	public function getUpdateTransferFlg() {
		$rtn = array();

		if($this -> transferFlg == NO_STRING || $this -> transferFlg == NO_COUNT){
			$rtn[] = NO_COUNT;
		}elseif($this -> transferFlg == VAL_INT_1){
			$rtn[] = VAL_INT_1;
		}

		$rtn[] = $this -> getUserData(PARAM_USER_ACCOUNT);

		return $rtn;
	}



	/*-------------------------------------------------------------------------
	* @function_name: アップロードファイルの存在確認
	* @parameter	: パラメータ
	* @return		: 存在する:true、存在しない:false
	-------------------------------------------------------------------------*/
	function isUpload($param) {

		// 変数宣言部
		$rtn = false;

		if(isset($_FILES[$param])) {

			if(is_uploaded_file($_FILES[$param][PARAM_TMP_NAME])) {
				$rtn = true;
			}
		}

		return $rtn;
	}


	public function getStatus(){
		$arrDisplist = array(
			'0' => VAR_KYC_VALIDATE_UNVALIDATE,
			'1' => VAL_STR_PROGRESS,
			'2' => VAL_STR_PROGRESS,
			'3' => VAL_STR_PROGRESS,
			'4' => VAL_STR_PROGRESS,
			'5' => VAL_STR_PROGRESS,
			'6' => VAL_STR_PROGRESS,
			'7' => VAL_STR_PROGRESS,
			'8' => VAR_KYC_VALIDATE_ERROR,
			'9' => VAL_STR_PROGRESS,
			'10' => VAR_KYC_VALIDATE_ADMIT,
			'11' => VAR_KYC_VALIDATE_COMPLETE,
			'12' => VAR_KYC_VALIDATE_CARD_PROCESSING,
			'13' => VAR_KYC_VALIDATE_CARD_PROCESSING,
			'14' => VAR_KYC_VALIDATE_CARD_PROCESSING,
			'15' => VAR_KYC_VALIDATE_CARD_PROCESSING,
			'16' => VAR_KYC_VALIDATE_CARD_PROCESSING,
			'17' => VAR_KYC_VALIDATE_CARD_PROCESSING,
			'18' => VAR_KYC_VALIDATE_CARD_ERROR,
			'19' => VAR_KYC_VALIDATE_CARD_ADMIT,
			'20' => VAR_KYC_VALIDATE_ACCEPT,
		);
		return $arrDisplist[$this -> validate_status];
	}

	public function canUpload(){
		$this -> validate_status = 0;
		$kycUpdateCntr = array(); 
		$rtn = true;
		if($this -> isLoopData($this -> kycs)) {
			foreach ($this -> kycs as $row) {
					if($this -> kycUpdateCntr == $this -> getColumnData($row, COLUMN_STATUS_UPDATE_COUNTER)){
						 $kycUpdateCntr[] = $this -> getColumnData($row, COLUMN_STATUS_UPDATE_COUNTER);
					}
			}

			$count = count($kycUpdateCntr);
			if($count >= VAL_INT_10){
				$rtn = false;
			}else{
				$rtn = true;
			}
		}

		$arrayAllowList = array(
			'0','8','11','18','20',
		);
		if($this -> isLoopData($this -> kycs)){
			$this -> validate_status = $this -> getColumnData($this -> kycs[0], COLUMN_VALIDATE_STATUS);
		} else {
			$this -> validate_status = 0;
		}
		if($rtn){
			if(!in_array($this -> validate_status, $arrayAllowList) && $this -> validate_status != Null){
				return false;
			}else{
				return true;
			}
		}
	}

	public function canUploadPI($file) {
		$kycUpdateCntr = array(); 

		if($this -> isLoopData($this -> kycs)) {
			foreach ($this -> kycs as $row) {
				if($this -> getColumnData($row, COLUMN_FILE_TYPE) == $file){
					if($this -> kycUpdateCntr == $this -> getColumnData($row, COLUMN_STATUS_UPDATE_COUNTER)){
						 $kycUpdateCntr[] = $this -> getColumnData($row, COLUMN_STATUS_UPDATE_COUNTER);
					}
				}
			}

			$count = count($kycUpdateCntr);
			if($count >= VAL_INT_5){
				return false;
			}else{
				return true;
			}
		}else{
			return true;
		}
	}

	public function dispInputs($file){
		$kycUpdateCntr = array(); 
		$proofMsg1 = ($file == NO_COUNT) ? $this -> getMessage(INFO, 'I_PROOF_OF_IDENTITY', array()) : $this -> getMessage(INFO, 'I_PROOF_OF_ADDRESS', array());
		$proofMsg2 = (($this -> getLangage() == "en" || $this -> getLangage() == "id") ? $proofMsg1 : trim($proofMsg1));
		if($this -> isLoopData($this -> kycs)) {
			foreach ($this -> kycs as $row) {
				if($this -> getColumnData($row, COLUMN_FILE_TYPE) == $file){
					if($this -> kycUpdateCntr == $this -> getColumnData($row, COLUMN_STATUS_UPDATE_COUNTER)){
						 $kycUpdateCntr[] = $this -> getColumnData($row, COLUMN_STATUS_UPDATE_COUNTER);
					}
				}
			}
			$count = count($kycUpdateCntr);
			$fileCount = ($file == 0) ? $file = 0 : $file = 3;
			
			if($count < VAL_INT_3){
				$loop = ($fileCount + VAL_INT_4);
			}elseif($count == VAL_INT_3){
				$loop = ($fileCount + VAL_INT_3);

			}elseif($count > VAL_INT_3){
				$loop = ($fileCount + VAL_INT_2);
			}

			for($i = 1 + $fileCount; $i < $loop; $i++){
					echo '<tr>'
						.'<th>'. $proofMsg2 . ($i - $fileCount).'</th>'
						.'<td><input type="file" accept="image/jpeg,image/png,image/jpg,image/gif,application/pdf" id="img'.$i.'" name="img'.$i.'" value="" class="w100p"></td>'
						.'</tr>';
			}
		}else{
			$fileCount = ($file == 0) ? $file = 0 : $file = 3;
			for($i = 1 + $fileCount; $i < ($fileCount + VAL_INT_4); $i++){
					echo '<tr>'
						.'<th>'. $proofMsg2 . ($i - $fileCount ).'</th>'
						.'<td><input type="file" accept="image/jpeg,image/png,image/jpg,image/gif,application/pdf" id="img'.$i.'" name="img'.$i.'" value="" class="w100p"></td>'
						.'</tr>';
				}
		}
	}

	public function getValidateStatus(){
		$this -> validate_status = 0;
		if($this -> isLoopData($this -> kycs)){
			$this -> validate_status = $this -> getColumnData($this -> kycs[0], COLUMN_VALIDATE_STATUS);
		} else {
			$this -> validate_status = 0;
		}
		return $this -> validate_status;
	}

	/*-------------------------------------------------------------------------
	* @function_name: HTML表示用のデータ取得関数
	* @parameter	: なし
	* @return		: HTML表示用データ配列
	-------------------------------------------------------------------------*/
	public function dispHTML() {
		return array();
	}

	/*------------------------------------------------------------------------
	* @function_name:
	* @parameter	:
	* @return		:
	-------------------------------------------------------------------------*/
	public function dispTransferFlg() {
		$rtn 		 = NO_STRING;
		$list 		 = null;
		$cnt		 = NO_COUNT;
		$selected	 = NO_STRING;
		$transferFlg = $this -> transferFlg;

		$lang 		= $this -> getLangage();


		switch ($lang) {

			case 'en':
				$content = 'Disable the Internal Transfer';
				break;
			case 'sc':
				$content = '停用内部转账功能';
				break;
			case 'tc':
				$content = '停用內部轉帳功能';
				break;
			case 'ja':
				$content = '口座間送金を無効にする';
				break;
			case 'id':
				$content = 'Nonaktifkan Transfer Internal';
				break;

		}

		$list 		=  array(array(PARAM_DATA_KEY		=> VAL_INT_1
							, PARAM_DATA_VALUE			=> $content));

		if($this -> isLoopData($list)) {

			foreach($list as $val) {

					if($transferFlg == VAL_INT_1){
						$selected = VAL_INT_1;
					}

					$rtn .= '<label>'
							. $this -> makeCheckOne('disableTransfer'
													,	'disableTransfer'
													,	$this -> getColumnData($val, PARAM_DATA_KEY)
													,	$this -> getColumnData($val, PARAM_DATA_VALUE)
													,	$selected)
							. '</label>&nbsp';

				}
		}

		echo $rtn;


	}
}
?>
