<?php
header("Content-Type: text/html; charset=UTF-8");
date_default_timezone_set('Asia/Tokyo');
include_once('../system/lib/config.php');

$system = new System();

if(empty($system -> getDataGet("lang")) && empty($system -> getDataGet("id"))){
	echo "data error";
	exit();
}
$apiPath 		= dirname(SYSTEM_PATH).DIRECTORY_SEPARATOR.'api';
$responseUrl 	= $apiPath.DIRECTORY_SEPARATOR.'Logs'.DIRECTORY_SEPARATOR.'cashflow'.DIRECTORY_SEPARATOR.'response';
$responseDbUrl 	= $apiPath.DIRECTORY_SEPARATOR.'Logs'.DIRECTORY_SEPARATOR.'cashflow'.DIRECTORY_SEPARATOR.'db_response';
//获取结果
$lang = $system -> getDataGet("lang", true, false, true);
$token = $system -> getDataGet("id", true, true);

$url = str_replace('{id}', $token, CASHFLOW_RESULTURL);

$resultPayment = @file_get_contents($url);

if(empty($resultPayment)){
	echo "data error";
	exit();
}

$resultJson = @json_decode($resultPayment, true);

session_start();
$transaction_number 				= $system -> getColumnData($resultJson,'merchantTransactionId');
$apiUrl								= SITE_DOMAIN;
$EndResult 							= in_array($system -> getColumnData($resultJson['result'], 'code'),$arraySuccess) ? 'ACK': 'NOK';
$result['err_flg']					= $EndResult == 'ACK' ? 0 : 1;
$_SESSION['transaction_number'] 	= $transaction_number;


error_log(date("[Y-m-d H:i:s]")."\r\n".$transaction_number.' response:' ."\r\n". print_r($resultJson,true) ."\r\n", 3, $responseUrl.DIRECTORY_SEPARATOR.'Log_'.date("Y-m-d").'.log');
chmod($responseUrl.DIRECTORY_SEPARATOR.'Log_'.date("Y-m-d").'.log',511);

//获取结果终了

if($EndResult == 'ACK') {					// 正常終了
	$sqlObject 	= new mysql($system->getConfigValue(SECTION_DB,HOST_NAME),$system->getConfigValue(SECTION_DB,USER_NAME),$system->getConfigValue(SECTION_DB,LOGIN_PASS),$system->getConfigValue(SECTION_DB,TARGET_DB_NAME),'','UTF8');
	//搜索deposit_temporary表，将对应的交易记录取出
	//检查deposit表，防止数据重复插入
	$sqlstr = 'select * from t_deposit where transaction_number = "'.$transaction_number.'"';

	$result = $sqlObject -> query($sqlstr);
	$row = $sqlObject -> fetch_assoc($result);
	//结果为空才能将数据插入
	if(empty($row)){
		$sqlstr = 'select * from t_deposit_cashflow_temporary where transaction_number = "'.$transaction_number.'"';
		$result = $sqlObject -> query($sqlstr);
		$row = $sqlObject -> fetch_assoc($result);
		$row['comment'] = addslashes($resultPayment);

		//循环模型，将搜索来的临时记录赋值到模型中
		foreach($CASHFLOW['Model'] as $key=>$val){
			$CASHFLOW['Model'][$key] = $row[$key];
		}
		//根据模型字段，将数据放入deposit表
		$sql = "insert into t_deposit ";
		$strsql = $sqlObject->Insertsql($CASHFLOW['Model']);
		$sql .= $strsql;
		$sqlObject->query($sql);
		error_log(date("[Y-m-d H:i:s]")."\r\n".$transaction_number.' db_response:' ."\r\n". $sql ."\r\n", 3, $responseDbUrl.DIRECTORY_SEPARATOR.'Log_'.date("Y-m-d").'.log');
		chmod($responseDbUrl.DIRECTORY_SEPARATOR.'Log_'.date("Y-m-d").'.log',511);
	}
	header('Location: https://secure.' . $apiUrl . '/' . $lang . '/deposit?type='.CASHFLOW_DEPOSIT_SUCCESS);
}  else {															// 異常終了
	header('Location: https://secure.' . $apiUrl . '/' . $lang . '/deposit?type='.CASHFLOW_DEPOSIT_FAILURE);
}


?>