<?php
require_once(SYSTEM_LOGICS . 'news/model.php');

class LogicNews extends NewsModelClass {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $htmlStr = NO_STRING;	// 表示用HTML文字列

	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: ロジック（各クラス共通）
	* @parameter	: なし
	* @return		: TRUE:ロジック成功、FALSE:ロジック失敗
	-------------------------------------------------------------------------*/
	function logic() {

		try {
			// 初期化
			$this -> init();
			// 処理
			$this -> biz();
		} catch (Exception $e) {
			throw $e;
		}
	}

	/*-------------------------------------------------------------------------
	 * @function_name: ロジック
	 * @parameter	: なし
	 * @return		: なし
	 -------------------------------------------------------------------------*/
	function biz() {
		if($this -> getType() == TYPE_COMPLETE) {				// 登録時
			$this -> regist();
			$this -> insertActivity();
			$this -> lists();
		} else if($this -> getType() == TYPE_UPDATE) {			// 更新時
			$this -> detail();
			$this -> insertActivity();
			$this -> update();
			$this -> lists();
		} else if($this -> getType() == TYPE_DELETE) {			// 削除時
			$this -> insertActivity();
			$this -> delete();
			$this -> lists();
		} else if($this -> getType() == TYPE_DETAIL) {			// 詳細表示
			$this -> detail();
		} else {
			$this -> lists();
		}
	}
	
	/*-------------------------------------------------------------------------
	* @function_name: ニュースリストの取得
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function lists() {
		$this -> setResult($this -> accessSelect('LIST_NEWS', array()));
	}
	
	/*-------------------------------------------------------------------------
	 * @function_name: 詳細の取得
	 * @parameter	: なし
	 * @return		: なし
	 -------------------------------------------------------------------------*/
	function detail() {
		$this -> setResult($this -> accessSelect('DETAIL_NEWS', array($this -> getNId())));
	}

	/*-------------------------------------------------------------------------
	* @function_name: ニュースの登録
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function regist() {
		$this -> accessModify('INSERT_NEWS', $this -> getRegistData());
	}

	/*-------------------------------------------------------------------------
	 * @function_name: ニュースの削除
	 * @parameter	: なし
	 * @return		: なし
	 -------------------------------------------------------------------------*/
	function delete() {
		$this -> accessModify('DELETE_NEWS', array($this -> getNId()));
	}
	
	/*-------------------------------------------------------------------------
	 * @function_name: ニュースの更新
	 * @parameter	: なし
	 * @return		: なし
	 -------------------------------------------------------------------------*/
	function update() {
		$this -> accessModify('UPDATE_NEWS', $this -> getUpdateData());
	}

	/*-------------------------------------------------------------------------
	 * @function_name: insertActivity
	 * @parameter	: なし
	 * @return		: なし
	 -------------------------------------------------------------------------*/
	function insertActivity(){
		$this -> accessModify('INSERT_ACTIVITY', $this -> getActivity());
	}
}
?>