<?php
class Chiket extends Common {

	/*-------------------------------------------------------------------------
	 * @ メンバ変数
	-------------------------------------------------------------------------*/
	private $chicketId			= NO_STRING;	// チケット
	private $reloadFlg			= true;			// リロードのフラグ
	private static  $modifyFlg	= false;		// 更新操作フラグ

	/*-------------------------------------------------------------------------
	* @function_name: 共通関数群コンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {

		// スーパークラスコンストラクタ呼び出し
		parent::__construct();

		if(isset($_SESSION[PARAM_CHICKET_ID])) {
			$this -> chicketId = $_SESSION[PARAM_CHICKET_ID];
		}

		$this -> reloadFlg = $this -> checkChiket();
	}

	/*-------------------------------------------------------------------------
	* @function_name: チケット発行
	* @parameter	: なし
	* @return		: 新規チケットデータ
	-------------------------------------------------------------------------*/
	function createChicket() {

		// 変数宣言部
		$this -> chicketId = sha1(uniqid(mt_rand(), true));

		return $this -> chicketId;
	}

	/*-------------------------------------------------------------------------
	* @function_name: チケット発行の整合性チェック
	* @detail		: セッションのチケット情報の整合性をチェックします
	* @parameter	: なし
	* @return		: TRUE:成功、FALSE:失敗
	-------------------------------------------------------------------------*/
	function checkChiket() {

		// 変数宣言部

		if($this -> chicketId != NO_STRING) {

			// チケットデータの取得
			$rs = $this -> accessSelect('SELECT_CHICKET', array($this -> chicketId));

			if(count($rs) > NO_COUNT) {
				return false;
			} else {
				return true;
			}

		} else {
			return true;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: 更新系SQLを発行する（チケット処理を通す）
	* @parameter	: $sqlId[SQL発行ID]、 $elementArr[パラメータ配列]、チケット操作を行うフラグ（true=行う、false=行わない）
	* @return		: なし
	-------------------------------------------------------------------------*/
	function accessModify($sqlId
							, $elementArr
							, $cFlg = true) {

		$chicketId = $this -> chicketId;

		if($cFlg) {	// チケットのチェックを行う

			self::$modifyFlg = $cFlg;

			if(!$this -> reloadFlg) {
				$this -> popUpSessionMessage(WARNING, 'W_MODIFY_RE_REQUEST', array());

				return false;
			}

			// チケットの登録
			$this -> createChicket();
			$this -> accessModifyCommon('DELETE_CHICKET', array($this -> chicketId));
			$this -> accessModifyCommon('INSERT_CHICKET', array($this -> chicketId));
			$_SESSION[PARAM_CHICKET_ID] = $this -> chicketId;
		}

		return $this -> accessModifyCommon($sqlId, $elementArr);	//if sql success,return true;if sql error,return false

	}

	/*-------------------------------------------------------------------------
	* @function_name: チケットを取得する
	* @parameter	: なし
	* @return		: チケット番号
	-------------------------------------------------------------------------*/
	function getChicket() {
		return $this -> chicketId;
	}

	/*-------------------------------------------------------------------------
	* @function_name: チケットを取得する
	* @parameter	: なし
	* @return		: チケット番号
	-------------------------------------------------------------------------*/
	function __destruct() {

		if(self::$modifyFlg) {

// 			echo '更新操作が行われました！！！';
			$_SESSION[PARAM_CHICKET_ID] = $this -> chicketId;
		} else {
// 			echo '更新操作が行われませんでした。';
			$_SESSION[PARAM_CHICKET_ID] = '';
		}

    	session_cache_limiter('nocache');
    	session_write_close();
    	session_register_shutdown();		
	}
}
?>