﻿<?php
require_once(SITE_LOGICS . 'settlement/config.php');

class SettlementModelClass extends ModelClassEx {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $rs							= null;			// ユーザデータ
	private $account					= null;			// 送金先口座情報
	private $params						= null;			// 任意パラメータ
	private $signature					= NO_STRING;	// シグネチャ
	private $userAccount				= NO_STRING;	// 口座番号
	private $fromAccount				= NO_STRING;	// from account
	private $currency					= NO_STRING;	// 通貨
	private $amount						= NO_STRING;	// 金額
	private $title						= NO_STRING;	// 商品名
	private $pNum						= NO_STRING;	// 番組コード
	private $userName					= NO_STRING;	// ユーザ名
	private $password					= NO_STRING;	// パスワード
	private $toAccount					= NO_STRING;	// 送金先口座
	private $msg						= NO_STRING;	// 送金メッセージ
	private $debitCurrency				= NO_STRING;	// 出金通貨
	private $debitAmount				= NO_STRING;	// 出金金額
	private $fromFee					= NO_STRING;	// 送金元手数料
	private $toFee						= NO_STRING;	// 送金先手数料
	private $successUrl					= NO_STRING;	// 成功時URL
	private $failUrl					= NO_STRING;	// 失敗URL
	private $cancelUrl					= NO_STRING;	// キャンセルURL
	private $returnUrl					= NO_STRING;	// 返却URL
	private $transactionNumber			= NO_STRING;	// 取引番号
	private $rate						= NO_STRING;	// 為替レート

	/*-------------------------------------------------------------------------
	* @function_name: コントロールパネルシステムindexモデルクラスコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		// スーパークラスコンストラクタ呼び出し
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: 初期設定関数
	* @parameter	: なし
	* @return		: 成功:success、失敗:error
	-------------------------------------------------------------------------*/
	public function init() {

		try {

			// パラメータの設定
			$this -> setParameter();

			// チェック
			$this -> validate();

		} catch (Exception $e) {
			throw $e;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: パラメータの設定
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function setParameter() {
		$this -> signature		= $this -> purifyInput($this -> getDataPost(PARAM_SIGNATURE, true));		// シグネチャ
		$this -> pNum			= $this -> purifyInput($this -> getDataPost(PARAM_P_NUM, true));			// 番組コード
		$this -> userAccount	= ($this -> getType() == NO_STRING || !isset($_SESSION['settlement_user_account'])) ? $this -> purifyInput($this -> getDataPost(PARAM_USER_ACCOUNT, true)) : $_SESSION['settlement_user_account'];		// 口座番号
		$this -> fromAccount	= $this -> purifyInput($this -> getDataPost(PARAM_FROM_ACCOUNT, true));		// from account
		$this -> currency		= ($this -> getType() == NO_STRING || !isset($_SESSION['settlement_currency'])) ? $this -> purifyInput($this -> getDataPost(PARAM_CURRENCY, true)) : $_SESSION['settlement_currency'];			// 通貨
		$this -> amount			= ($this -> getType() == NO_STRING || !isset($_SESSION['settlement_amount'])) ? $this -> purifyInput($this -> getDataPost(PARAM_AMOUNT, true)) : $_SESSION['settlement_amount'];			// 金額
		$this -> title			= $this -> purifyInput($this -> getDataPost(PARAM_TITLE, true));			// 商品名
		$this -> userName		= $this -> purifyInput($this -> getDataPost(PARAM_USER_NAME, true));		// ユーザ名
		$this -> password		= $this -> getDataPost(PARAM_PASSWORD);			// パスワード
		$this -> toAccount		= $this -> purifyInput($this -> getDataPost(PARAM_USER_ACCOUNT, true));		// 送金先口座
		$this -> debitCurrency	= ($this -> getType() == TYPE_CONFIRM || !isset($_SESSION['settlement_debit_currency'])) ? $this -> purifyInput($this -> getDataPost(PARAM_DEBIT_CURRENCY, true)) : $_SESSION['settlement_debit_currency'];	// 出金通貨
		$this -> debitAmount	= $this -> purifyInput($this -> getDataPost(PARAM_DEBIT_AMOUNT, true));		// 出金金額
		$this -> msg			= $this -> purifyInput($this -> getDataPost(PARAM_MESSAGE, true));			// 送金メッセージ
		$this -> fromFee		= ($this -> getType() == NO_STRING || !isset($_SESSION['from_fee'])) ? $this -> purifyInput($this -> getDataPost(PARAM_FROM_FEE, true)) : $_SESSION['from_fee'];			// 送金元手数料
		$this -> toFee			= ($this -> getType() == NO_STRING || !isset($_SESSION['to_fee'])) ? $this -> purifyInput($this -> getDataPost(PARAM_TO_FEE, true)) : $_SESSION['to_fee'];			// 送金先手数料
		$this -> successUrl		= $this -> purifyInput($this -> getDataPost(PARAM_SUCCESS_URL));		// 成功時URL
		$this -> failUrl		= $this -> purifyInput($this -> getDataPost(PARAM_FAIL_URL));			// 失敗URL
		$this -> cancelUrl		= $this -> purifyInput($this -> getDataPost(PARAM_CANCEL_URL));		// キャンセルURL
		$this -> returnUrl		= $this -> purifyInput($this -> getDataPost(PARAM_RETURN_URL));		// 返却URL
		$this -> rate			= $this -> purifyInput($this -> getDataPost(PARAM_RATE, true));				// 取引レート
		$this -> setRateEx($this -> rate);										// 取引レート

		//get account data
        $this -> account     = $this -> getRowData($this -> getAccountCommon($this -> getUserData(PARAM_USER_ACCOUNT)));

		// 任意パラメータの設定
		$this -> params = array();

		foreach($_POST as $key => $val) {
			switch ($key) {
				case PARAM_SIGNATURE:		// 何もしない
					break;
				case PARAM_P_NUM:			// 何もしない
					break;
				case PARAM_CURRENCY:		// 何もしない
					$val = (isset($_SESSION['settlement_currency'])) ? $_SESSION['settlement_currency'] : $val;
					break;
				case PARAM_AMOUNT:			// 何もしない
					break;
				case PARAM_AMOUNT:			// 何もしない
					$val = (isset($_SESSION['settlement_amount'])) ? $_SESSION['settlement_amount'] : $val;
					break;
				case PARAM_TITLE:			// 何もしない
					break;
				case PARAM_SUCCESS_URL:		// 何もしない
					break;
				case PARAM_FAIL_URL:		// 何もしない
					break;
				case PARAM_CANCEL_URL:		// 何もしない
					break;
				case PARAM_RETURN_URL:		// 何もしない
					break;
				case PARAM_USER_NAME:		// 何もしない
					break;
				case PARAM_PASSWORD:		// 何もしない
					break;
				case PARAM_TYPE:			// 何もしない
					break;
				case PARAM_USER_ACCOUNT:	// 何もしない
					break;
				case PARAM_DEBIT_CURRENCY:	// 何もしない
					$val = (isset($_SESSION['settlement_debit_currency'])) ? $_SESSION['settlement_debit_currency'] : $val;
					break;
				case PARAM_FROM_ACCOUNT:	// 何もしない
					break;
				case PARAM_MESSAGE:			// 何もしない
					break;
				case PARAM_RATE:			// 何もしない
					break;
				case PARAM_DEBIT_AMOUNT:	// 何もしない
					break;
				case PARAM_FROM_FEE:		// 何もしない
					$val = (isset($_SESSION['from_fee'])) ? $_SESSION['from_fee'] : $val;
					break;
				default:
					if($key == PARAM_TO_FEE){
						$val = (isset($_SESSION['to_fee'])) ? $_SESSION['to_fee'] : $val;
						$val = $this -> formatCurrency($val, $this -> currency);
					}
					$this -> params[$key] = $val;
					break;
			}
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: パラメータの再設定
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	public function restore() {}

	/*-------------------------------------------------------------------------
	* @function_name: サーバ側データチェック
	* @parameter	: なし
	* @return		: TRUE:成功、FALSE:失敗
	-------------------------------------------------------------------------*/
	public function validate() {

		// 変数宣言部
		$rtn = true;

		//check if session variable for previous type is not set
		if(!isset($_SESSION['settlement_previous_type'])) {
			$_SESSION['settlement_previous_type'] = $this -> getType();
		}

		if($this -> getType() == NO_STRING) {					// 初回アクセス時
			//check previous type is not equal to NO_STRING
			if($_SESSION['settlement_previous_type'] != NO_STRING) {
				$this -> setType(CONTROL_ACTION);
				return false;
			} else {
				//set session variable previous type
				$_SESSION['settlement_previous_type'] = $this -> getType();
			}

			// 必須項目チェック

			// シグネチャ
			if(!$this -> checkNull($this -> signature)) {
				$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_SIGNATURE));
				$rtn = false;
			}

			// 番組コード
			if(!$this -> checkNull($this -> pNum)) {
				$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_P_NUM));
				$rtn = false;
			}

			// 通貨
			if(!$this -> checkNull($this -> currency)) {
				$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_CURRENCY));
				$rtn = false;
			}

			// 金額
			if(!$this -> checkNull($this -> amount)) {
				$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_AMOUNT));
				$rtn = false;
			}

			if(!$rtn) {
				$this -> setType(TYPE_FAIL);
				return false;
			}

			// 金額のチェック
			if(!$this -> checkStringNumber($this -> amount)) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_REGULAR_NUMBER', array(VAL_STR_AMOUNT));
				$rtn = false;
			}

			if($this -> amount <= NO_COUNT) {
				$this -> popUpSessionMessage(ERROR, 'E_MINIMUM', array(VAL_STR_AMOUNT, NO_COUNT));
				$rtn = false;
			}

			// 通貨のチェック
			$this -> currency = strtoupper($this -> currency);
			if(!$this -> checkCurrency($this -> currency)) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_SAME_DATA', array(VAL_STR_CURRENCY));
				$rtn = false;
			}

			if(!$rtn) {
				$this -> setType(TYPE_FAIL);
				return false;
			}

			$domWhitelistedDisabled = false;
			// APIの確認
			if(!$this -> checkSettlementDomain($this -> pNum, "allow_domain_in_payment", $domWhitelistedDisabled)){
			    if(!$domWhitelistedDisabled){
			        $this -> popUpSessionMessage(ERROR, 'E_ERROR_DOMAIN', array());
			        $rtn = false;
			    }
			}
			
			$ipWhitelistDisabled = false;
			// APIの確認
			if(!$this -> checkSettlementIpAddress($this -> pNum, "allow_ip_in_payment", $ipWhitelistDisabled)) {
			    if(!$ipWhitelistDisabled){
			        $this -> popUpSessionMessage(ERROR, 'E_ERROR_IP_ADDRESS', array());
				    $rtn = false;
			    }
			}

			// シグネチャのチェック
			if(!$this -> checkSettlementSignature($this -> pNum
													, $this -> signature
													, $this -> userAccount)) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_VALUE', array(VAL_STR_SIGNATURE));
				$rtn = false;
			}

			$account = addslashes($this -> userAccount);
			if(!$this -> existAccountOrEmail($account)) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_NOT_EXIST', array(VAL_STR_USER_ACCOUNT));
				$rtn = false;
			} else {
				//set session user account
				$_SESSION['settlement_user_account'] = $account;
			}

			if(!$rtn) {		// パラメータチェック失敗
				$this -> setType(TYPE_FAIL);

			} else {		// パラメータチェック成功ログイン画面へ*/

				// 最終的に金額の桁を落とす
				$this -> amount = $this -> currencyToInt($this -> amount, $this -> currency);
				$this -> amount = $this -> intToCurrency($this -> amount, $this -> currency);

				$_SESSION['settlement_amount'] = $this -> amount;
				$_SESSION['settlement_currency'] = $this -> currency;

				// POSTのログを取る
				$this -> logPost($this -> getProgramCode());

				$this -> setType(CONTROL_NAME_LOGIN);

				//create request token for every request
				$_SESSION['request_token'] = uniqid();
			}

			return false;

		} else if($this -> getType() == CONTROL_NAME_LOGIN) {	// ログイン時

			//set session variable previous type
			$_SESSION['settlement_previous_type'] = $this -> getType();

			//check request session token
			if(!isset($_SESSION['request_token'])) {
				$this -> setType(TYPE_REQUEST_SESSION_EXPIRED);
				return;
			}

			// ユーザ名のチェック
			if(!$this -> checkNull($this -> userName)) {
				$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_USER_NAME));
				$rtn = false;
			}

			// ユーザパスワードのチェック
			if(!$this -> checkNull($this -> password)) {
				$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_PASSWORD));
				$rtn = false;
			}

			// この時点でエラーの場合はスロー
			if(!$rtn) {
				$this -> setType(CONTROL_ACTION);
				return false;
			}

			// 複合チェックを行う

			// 失敗リストチェック
			if(!$this -> checkLoginFail($this -> userName)) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_LOGIN_FAIL_COUNT', array());
				return false;
			}

			// この時点でエラーの場合はスロー
			if(!$rtn) {
				$this -> setType(CONTROL_ACTION);
				return false;
			}

			// ユーザの存在確認
			$rs = $this -> checkUser($this -> userName, $this -> password);

			if(count($rs) == VAL_INT_1) {

				// セッションへデータを詰める
				$this -> putSessionUserData($rs);

				// ログイン成功で回数をリセット
				$this -> clearFailCounter($this -> userName);

				$row = $this -> getRowData($rs);

			} else {

				// 認証しているか否か
				if(!$this -> existVerification($this -> userName, $this -> password)) {	// メール未認証
					$this -> setType(TYPE_VERI_ERROR);
					return true;
				}

				$this -> popUpSessionMessage(ERROR, 'E_CAN_NOT_LOGIN', array());

				// 失敗リストの加算
				$this -> incrementFailCounter($this -> userName);

				return false;
			}

			// ログインチェック
			if(count($_COOKIE) == 0) {
				throw new Exception(NO_STRING);
			}

			//check if settlement is sent to self
			if(isset($row) && ($row['user_account'] == $this -> userAccount )){
				$this -> popUpSessionMessage(ERROR, 'E_CAN_NOT_REMIT_SELF', array());
				$this -> setType(TYPE_FAIL);
			} else{
				// 入力画面へ
				$this -> setType(TYPE_INPUT);
				//set session variable previous type
				$_SESSION['settlement_previous_type'] = $this -> getType();
			}

		} else if($this -> getType() == TYPE_INPUT) {

			// ログインチェック
			if(!$this -> checkSiteUserLogin()) {
				throw new Exception(NO_STRING);
			}

			//check request session token
			if(!isset($_SESSION['request_token'])) {
				$this -> setType(TYPE_REQUEST_SESSION_EXPIRED);
				return;
			}

			//set session variable previous type
			$_SESSION['settlement_previous_type'] = $this -> getType();

		} else if($this -> getType() == TYPE_CONFIRM
					|| $this -> getType() == TYPE_COMPLETE) {							// 注文確認画面時

			// ログインチェック
			if(!$this -> checkSiteUserLogin()) {
				throw new Exception(NO_STRING);
			}

			//check if user is high risk - Mikko 2019 0312
			if($this -> getColumnData($this -> account, COLUMN_RISK_LEVEL) == VAL_INT_1){
    			$this -> popUpSessionMessage(ERROR, 'E_ERROR_WITHDRAW_HIGH_RISK', array());
    			$this -> setType(TYPE_INPUT);
    			return false;
            }

			//check request session token
			if(!isset($_SESSION['request_token'])) {
				$this -> setType(TYPE_REQUEST_SESSION_EXPIRED);
				return;
			}

			//check if type is confirm
			if($this -> getType() == TYPE_CONFIRM) {
				$_SESSION['settlement_debit_currency'] = $this -> debitCurrency;

				//check if previous type is not equal to TYPE_INPUT
				if($_SESSION['settlement_previous_type'] != TYPE_INPUT) {
					$this -> setType(CONTROL_ACTION);
					return false;
				} else {
					//set session variable previous type
					$_SESSION['settlement_previous_type'] = $this -> getType();
				}
			} elseif($this -> getType() == TYPE_COMPLETE) {

				//check if previous type is not equal to TYPE_CONFIRM
				if($_SESSION['settlement_previous_type'] != TYPE_CONFIRM) {
					$this -> setType(CONTROL_ACTION);
					return false;
				} else {
					//set session variable previous type
					$_SESSION['settlement_previous_type'] = $this -> getType();
				}
			}

			//check if settlement is sent to self
			if($this -> fromAccount == $this -> userAccount || $this -> userAccount == $this -> getUserData(PARAM_USER_ACCOUNT)){
				$this -> popUpSessionMessage(ERROR, 'E_CAN_NOT_REMIT_SELF', array());
				$this -> setType(TYPE_FAIL);
				return;
			}

			// 口座ステータスチェック
			if(!$this -> checkAccountStatus($this -> getUserData(PARAM_USER_ACCOUNT), VAR_TRANSACTION_WITHDRAW)) {
				throw new Exception(VAL_INT_99);
			}

			// 制限口座のチェック(出金確認時)
			if(!$this -> checkWithdrawLimit($this -> getUserData(PARAM_USER_ACCOUNT)
											, $this -> currency
											, $this -> currencyToInt(floatval($this -> amount), $this -> currency))) {
				$this -> popUpSessionMessage(ERROR, 'E_LIMIT_WITHDRAW', array());
				$this -> setType(TYPE_BACK);
				return;
			}

			// 金額のチェック
			if(!$this -> checkNull($this -> amount)) {
				$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_AMOUNT));
				$rtn = false;
			}

			// 必須項目
			// debit口座のチェック
			if(!$this -> checkNull($this -> debitCurrency)) {
				$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_DEBIT_ACCOUNT));
				$rtn = false;
			}

			// 金額の正規表現チェック
			if(!$this -> checkStringNumber($this -> amount)) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_REGULAR_NUMBER', array(VAL_STR_AMOUNT));
				$rtn = false;
			}

			// メッセージのも字数制限チェック
			if(!$this -> checkLength($this -> msg
									, NO_COUNT
									, VAL_INT_128)) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_STRING_LENGTH_ANY', array(VAL_STR_RECEIPT_MESSAGE
																						, NO_COUNT
																						, VAL_INT_128));
				$rtn = false;
			}

			// タイプを戻す
			if(!$rtn) {
				$this -> setType(TYPE_INPUT);
				return;
			}

			// チェックが通ったら各種項目を設定する
			$this -> setData();

			// 口座残高チェック
			if($this -> balance < ($this -> debitAmount + $this -> getFeeEx())) {
				$this -> popUpSessionMessage(ERROR, 'E_INSUFFICIENT_FUNDS', array($this -> debitCurrency, $this -> formatCurrency(($this -> debitAmount + $this -> getFeeEx()), $this -> debitCurrency)));
				$rtn = false;
			}

			// タイプを戻す
			if(!$rtn) {
				$this -> setType(TYPE_INPUT);
				$_SESSION['settlement_previous_type'] = $this -> getType();
				return;
			}

		} else {}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: パラメータを設定し直す
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	public function setData() {

		// 変数宣言部
		$exchange	= null;
		$fee		= null;
		$fromAmount	= NO_COUNT;

		// バランスの取得
		$this -> balance = $this -> getBalanceCommon($this -> getUserData(PARAM_USER_ACCOUNT), $this -> debitCurrency);

		// デビット額の計算
		// タイプによって変更パラメータ
		if($this -> currency == $this -> debitCurrency) {	// 通貨が一緒だった場合

			$fromAmount				= $this -> amount;
			$this -> debitAmount	= $this -> amount;
			$this -> toAmount		= $this -> amount;
			$this -> setRateEx(VAL_INT_1);

		} else {											// 送金通貨指定

			// 出金額の両替
			$exchange = $this -> getExchangeCommon($this -> amount
													, $this -> currency
													, $this -> debitCurrency
													, false
													, true
													, NO_STRING
													, $this -> getUserData(PARAM_USER_ACCOUNT));

// 			// 手数料の両替
// 			$fee = $this -> getExchangeCommon($this -> getFeeEx()
// 					, USD
// 					, $this -> debitCurrency
// 					, true
// 					, false);

			$fromAmount				= $this -> getColumnData($exchange, PARAM_AMOUNT);
			$this -> debitAmount	= $this -> getColumnData($exchange, PARAM_AMOUNT);
			$this -> toAmount		= $this -> amount;
			$this -> setRateEx($this -> getColumnData($exchange, PARAM_RATE));
		}

		// 手数料の取得
		$fee		= $this -> getFeeCommon(VAR_TRANSFER
											, $this -> debitAmount
											, $this -> debitCurrency
											, $this -> getUserData(PARAM_USER_ACCOUNT)
											, $this -> userAccount
											, $this -> currency
											, $this -> amount);
// print_r($fee);
// echo $this -> debitCurrency . ' : ' . $this -> debitAmount . ' : ' . $this -> currency . ' : ' . $this -> amount;
// echo $this -> amount;

		$fee2 = $fee[$this -> currency . VAL_INT_2];
// 		$this -> setFeeEx($this -> getColumnData($fee, PARAM_AMOUNT));
// 		$this -> setFee2Ex($this -> getColumnData($fee2, PARAM_AMOUNT));
// 		$this -> setFee2Ex($fee2);



		$this -> setFeeEx($this -> getColumnData($fee, $this -> debitCurrency . VAL_INT_1));
// 		$this -> setFee2Ex($this -> getColumnData($fee, $this -> currency . VAL_INT_2));
		$this -> setFee2Ex($fee2);

		$_SESSION['to_fee'] = (($this -> setFee2Ex($fee2))==NULL) ? NO_COUNT : $this -> setFee2Ex($fee2);
		$_SESSION['from_fee'] = (($this -> setFeeEx($this -> getColumnData($fee, $this -> debitCurrency . VAL_INT_1)))==NULL) ? NO_COUNT : $this -> setFeeEx($this -> getColumnData($fee, $this -> debitCurrency . VAL_INT_1));


	}

	function getAgentCodeURL(){
		$baseUrl = 'https://'.SITE_DOMAIN.'/'. $this -> getLangage() .'/register';
		if(!empty($this -> pNum)){
			$rowData = $this -> getRowData($this -> accessSelect('SELECT_AGENT_CODE_BY_AID', array($this -> pNum)));
			$AgentCode = $this -> getColumnData($rowData, COLUMN_AGENT_CODE);
		}else{
			$AgentCode = NO_STRING;
		}
		if($AgentCode == NO_STRING){
			$result = $baseUrl;
		}else{
			$result = $baseUrl . '?reference='.$AgentCode;
		}
		return $result;

	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座番号の取得
	* @parameter	: なし
	* @return		: 口座番号
	-------------------------------------------------------------------------*/
	function echoUserAccount() {
		echo $this -> getUserData(PARAM_USER_ACCOUNT);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 出金通貨の取得
	* @parameter	: なし
	* @return		: 出金通貨
	-------------------------------------------------------------------------*/
	function echoDebitCurrency() {
		echo $this -> debitCurrency;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 出金通貨の取得
	* @parameter	: なし
	* @return		: 出金通貨
	-------------------------------------------------------------------------*/
	function getDebitCurrency() {
		return $this -> debitCurrency;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 出金金額の取得
	* @parameter	: なし
	* @return		: 出金金額
	-------------------------------------------------------------------------*/
	function getDebitAmount() {
		return $this -> debitAmount;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 出金金額の取得
	* @parameter	: なし
	* @return		: 出金金額
	-------------------------------------------------------------------------*/
	function echoDebitAmount() {
		echo $this -> debitAmount;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 出金金額の取得
	* @parameter	: なし
	* @return		: 出金金額
	-------------------------------------------------------------------------*/
	function dispDebitAmount() {
		echo $this -> formatCurrency($this -> debitAmount, $this -> debitCurrency);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 出金金額合計の取得
	* @parameter	: なし
	* @return		: 出金金額合計
	-------------------------------------------------------------------------*/
	function echoTotalDebitAmount() {
		echo $this -> debitAmount + $this -> getFeeEx();
	}

	/*-------------------------------------------------------------------------
	* @function_name: 出金金額合計の取得
	* @parameter	: なし
	* @return		: 出金金額合計
	-------------------------------------------------------------------------*/
	function dispTotalDebitAmount() {
		echo $this -> formatCurrency($this -> debitAmount + $this -> getFeeEx(), $this -> debitCurrency);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 換金レートの取得
	* @parameter	: なし
	* @return		: 換金レート
	-------------------------------------------------------------------------*/
	function echoRate() {
		echo $this -> getRateEx();
	}

	/*-------------------------------------------------------------------------
	* @function_name: 手数料金額の取得
	* @parameter	: なし
	* @return		: 手数料金額
	-------------------------------------------------------------------------*/
	function echoFeeAmount() {
		echo $this -> getFeeEx();
	}

	/*-------------------------------------------------------------------------
	* @function_name: 手数料金額の取得
	* @parameter	: なし
	* @return		: 手数料金額
	-------------------------------------------------------------------------*/
	function echoFee2Amount() {
		echo $this -> getFee2Ex();
	}

	/*-------------------------------------------------------------------------
	* @function_name: 手数料金額の取得
	* @parameter	: なし
	* @return		: 手数料金額
	-------------------------------------------------------------------------*/
	function dispFeeAmount() {
		echo $this -> formatCurrency($this -> getFeeEx(), $this -> debitCurrency);
	}

	/*-------------------------------------------------------------------------
	* @function_name: シグネチャの取得
	* @parameter	: なし
	* @return		: シグネチャ
	-------------------------------------------------------------------------*/
	function echoSignature() {
		echo $this -> signature;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座番号の取得
	* @parameter	: なし
	* @return		: 口座番号
	-------------------------------------------------------------------------*/
	function echoToAccount() {
		echo $this -> userAccount;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座番号の取得
	* @parameter	: なし
	* @return		: 口座番号
	-------------------------------------------------------------------------*/
	function getToAccount() {
		return $this -> userAccount;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 通貨の取得
	* @parameter	: なし
	* @return		: 通貨
	-------------------------------------------------------------------------*/
	function echoCurrency() {
		echo $this -> currency;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 通貨の取得
	* @parameter	: なし
	* @return		: 通貨
	-------------------------------------------------------------------------*/
	function getCurrency() {
		return $this -> currency;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 商品名の取得
	* @parameter	: なし
	* @return		: 商品名
	-------------------------------------------------------------------------*/
	function echoTitle() {
		echo $this -> title;
	}

	/*-------------------------------------------------------------------------
	* @function_name: ユーザの入力額の取得
	* @parameter	: なし
	* @return		: ユーザの入力額
	-------------------------------------------------------------------------*/
	function dispAmount() {
		echo $this -> formatCurrency($this -> amount, $this -> currency);
	}

	/*-------------------------------------------------------------------------
	* @function_name: ユーザの入力額の取得
	* @parameter	: なし
	* @return		: ユーザの入力額
	-------------------------------------------------------------------------*/
	function getAmount() {
		return $this -> amount;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: ユーザの入力額の取得
	* @parameter	: なし
	* @return		: ユーザの入力額
	-------------------------------------------------------------------------*/
	function echoAmount() {
		echo $this -> amount;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 送金メッセージの取得
	* @parameter	: なし
	* @return		: 送金メッセージ
	-------------------------------------------------------------------------*/
	function echoMsg() {
		echo $this -> msg;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 送金メッセージの取得
	* @parameter	: なし
	* @return		: 送金メッセージ
	-------------------------------------------------------------------------*/
	function dispMsg() {
		echo nl2br($this -> msg);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 通貨リストの取得
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispCurrency() {
		echo $this -> dispListOption($this -> getCurrencyList(), $this -> debitCurrency) ;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 通貨リストの取得
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function echoSuccessUrl() {
		echo $this -> successUrl;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 通貨リストの取得
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function echoFailUrl() {
		echo $this -> failUrl;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 通貨リストの取得
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function echoCancelUrl() {
		echo $this -> cancelUrl;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 通貨リストの取得
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function echoReturnUrl() {
		echo $this -> returnUrl;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 任意パラメータの取得
	* @parameter	: なし
	* @return		: HiddenHTML文字列
	-------------------------------------------------------------------------*/
	function echoParams() {

		// 変数宣言部
		$rtn = NO_STRING;

		if($this -> isLoopData($this -> params)) {

			foreach($this -> params as $key => $val) {
				$rtn .= '<input type="hidden" value="' . $val . '" name="' . $key . '" />';
			}
		}

		echo $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 転送先URLの取得
	* @parameter	: なし
	* @return		: 転送先URL
	-------------------------------------------------------------------------*/
	function getUrl() {
		return $this -> successUrl;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 転送先URLの取得
	* @parameter	: なし
	* @return		: 転送先URL
	-------------------------------------------------------------------------*/
	function getFailUrl() {
		return $this -> failUrl;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 転送先URLの取得
	* @parameter	: なし
	* @return		: 転送先URL
	-------------------------------------------------------------------------*/
	function getCallBackUrl() {
		return $this -> returnUrl;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 転送先URLの取得
	* @parameter	: なし
	* @return		: 転送先URL
	-------------------------------------------------------------------------*/
	function echoPNum() {
		echo $this -> pNum;
	}
	
	/*-------------------------------------------------------------------------
	 * @function_name: 番組コードの取得
	 * @parameter	: なし
	 * @return		: 転送先URL
	 -------------------------------------------------------------------------*/
	function getProgramCode() {
	    return $this -> pNum;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 送金元手数料の取得
	* @parameter	: なし
	* @return		: 送金元手数料
	-------------------------------------------------------------------------*/
	function getFromFee() {
		return $this -> fromFee;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 送金先手数料の取得
	* @parameter	: なし
	* @return		: 送金先手数料
	-------------------------------------------------------------------------*/
	function getToFee() {
		return $this -> toFee;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 任意パラメータの取得
	* @parameter	: なし
	* @return		: HiddenHTML文字列
	-------------------------------------------------------------------------*/
	function getForwardParams($result) {

		// 変数宣言部
		$rtn = array();

		// 固定パラメータ
		$rtn[PARAM_AMOUNT]				= $this -> amount;
		$rtn[PARAM_CURRENCY]			= $this -> currency;
		$rtn[PARAM_P_NUM]				= $this -> pNum;
		$rtn[PARAM_TRANSACTION_NUMBER]	= $this -> transactionNumber;
		$rtn[PARAM_RESULT]				= $result;

		// 任意パラメータがある場合
		if($this -> isLoopData($this -> params)) {

			foreach($this -> params as $key => $val) {
				$rtn[$key] = $val;
			}
		}

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 表示名の取得
	* @parameter	: なし
	* @return		: サイト名・屋号または会社名
	-------------------------------------------------------------------------*/
	function dispSiteName() {

		if($this -> getColumnData($this -> account, COLUMN_SITE_NAME) != NO_STRING) {	// サイト名がある場合
			echo $this -> getColumnData($this -> account, COLUMN_SITE_NAME);
		} else {																		// 氏名を表示
			echo $this -> getColumnData($this -> account, COLUMN_FIRST_NAME)
					. DELIMIT_SPACE . $this -> getColumnData($this -> account, COLUMN_LAST_NAME);
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: 受取人口座情報の取得
	* @parameter	: なし
	* @return		: 登録用データ
	-------------------------------------------------------------------------*/
	public function setAccount($rs) {
		$this -> account = $this -> getRowData($rs);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 登録用のデータを取得
	* @parameter	: なし
	* @return		: 登録用データ
	-------------------------------------------------------------------------*/
	public function getRegistData() {

		// 変数宣言部
		$rtn = array();

		// 取引番号の取得
		$this -> transactionNumber = $this -> getTransactionNumberCommon(VAR_TRANSACTION_TRANSFER_DEPOSIT);

		// will include account # within API callback - anton
		$this -> params[PARAM_FROM_ACCOUNT] = $this -> getUserData(PARAM_USER_ACCOUNT);
		$this -> params[PARAM_TO_ACCOUNT] = $this -> userAccount;
		
		$rtn[] = $this -> getUserData(PARAM_USER_ACCOUNT);										// 送金元口座番号
		$rtn[] = $this -> getUserData(PARAM_USER_ACCOUNT);										// 送金元口座番号
		$rtn[] = $this -> debitCurrency;														// 送金通貨
		$rtn[] = $this -> currencyToInt($this -> fromFee, $this -> debitCurrency);				// 口座元手数料
		$rtn[] = $this -> userAccount;															// 送金先口座番号
		$rtn[] = $this -> currency;																// 送金元通貨
		$rtn[] = $this -> currencyToInt($this -> toFee, $this -> currency);						// 送金先手数料
		$rtn[] = $this -> amount;																// 入力金額
		$rtn[] = VAL_INT_1;																		// 送金方法
		$rtn[] = addslashes($this-> getExtraMessage($this -> userAccount, $this -> params, getSpecialClientList()) . $this -> msg);														// メッセージ
		$rtn[] = $this -> debitCurrency;														// 出金通貨
		$rtn[] = $this -> currencyToInt($this -> debitAmount, $this -> debitCurrency);			// 出金金額
		$rtn[] = $this -> currency;																// 送金通貨
		$rtn[] = $this -> currencyToInt($this -> amount, $this -> currency);					// 送金金額
		$rtn[] = $this -> getRateEx();															// レート
		$rtn[] = NO_COUNT;																		// 処理種別
		$rtn[] = NO_STRING;																		// 管理者ID
		$rtn[] = VAL_INT_2;																		// 処理ステータス（API）
		$rtn[] = $this -> transactionNumber;													// トランザクションナンバー
		$rtn[] = json_encode($this -> params);													// トランザクションナンバー

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: メール送信用のデータを取得（送金元ユーザ）
	* @parameter	: なし
	* @return		: メール送信用データ
	-------------------------------------------------------------------------*/
	public function getSendDataFrom() {

		// 変数宣言部
		$rtn	= array();
		$data	= $this -> getAccountCommon($this -> getUserData(PARAM_USER_ACCOUNT));
		$row	= $this -> getRowData($data);
		$data2	= $this -> getAccountCommon($this -> userAccount);
		$row2	= $this -> getRowData($data2);

		$rtn[] = $this -> getUserData(PARAM_USER_ACCOUNT);										// ユーザ口座番号
		$rtn[] = $this -> getColumnData($row, COLUMN_FIRST_NAME)
				. DELIMIT_SPACE . $this -> getColumnData($row, COLUMN_LAST_NAME);				// ユーザ名
		$rtn[] = $this -> userAccount;															// 送金先口座番号
		$rtn[] = $this -> getColumnData($row2, COLUMN_FIRST_NAME)
				. DELIMIT_SPACE . $this -> getColumnData($row2, COLUMN_LAST_NAME);				// ユーザ名（送金先）
		$rtn[] = $this -> getCurrentTimeCommon();												// 現在時刻
		$rtn[] = $this -> debitCurrency;														// 通貨
		$rtn[] = $this -> formatCurrency($this -> debitAmount, $this -> debitCurrency);			// 金額
		$rtn[] = $this -> debitCurrency;														// 手数料通貨
		$rtn[] = $this -> formatCurrency($this -> fromFee, $this -> debitCurrency);				// 手数料
		$rtn[] = $this -> msg;																	// メッセージ
		$rtn[] = $this -> transactionNumber;													// 取引番号
		$rtn[] = $this -> getColumnData($row, COLUMN_MAIL);										// メールアドレス

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: メール送信用のデータを取得（送金先ユーザ）
	* @parameter	: なし
	* @return		: メール送信用データ
	-------------------------------------------------------------------------*/
	public function getSendDataTo() {

		// 変数宣言部
		$rtn	= array();
		$data	= $this -> getAccountCommon($this -> getUserData(PARAM_USER_ACCOUNT));
		$row	= $this -> getRowData($data);
		$data2	= $this -> getAccountCommon($this -> userAccount);
		$row2	= $this -> getRowData($data2);

		$rtn[] = $this -> userAccount;															// ユーザ口座番号
		$rtn[] = $this -> getColumnData($row2, COLUMN_FIRST_NAME)
					. DELIMIT_SPACE . $this -> getColumnData($row2, COLUMN_LAST_NAME);			// ユーザ名
		$rtn[] = $this -> getUserData(PARAM_USER_ACCOUNT);										// 送金先口座番号
		$rtn[] = $this -> getColumnData($row, COLUMN_FIRST_NAME)
					. DELIMIT_SPACE . $this -> getColumnData($row, COLUMN_LAST_NAME);			// ユーザ名（送金元）
		$rtn[] = $this -> getCurrentTimeCommon();												// 現在時刻
		$rtn[] = $this -> currency;																// 通貨
		$rtn[] = $this -> formatCurrency($this -> amount, $this -> currency);					// 金額
		$rtn[] = $this -> debitCurrency;														// 手数料通貨
		$rtn[] = $this -> formatCurrency($this -> toFee, $this -> currency);					// 手数料
		$rtn[] = $this -> msg;																	// メッセージ
		$rtn[] = $this -> transactionNumber;													// 取引番号
		$rtn[] = $this -> getColumnData($row2, COLUMN_MAIL);									// メールアドレス

		return $rtn;
	}


	/*-------------------------------------------------------------------------
	* @function_name: HTML表示用のデータ取得関数
	* @parameter	: なし
	* @return		: HTML表示用データ配列
	-------------------------------------------------------------------------*/
	public function dispHTML() {
		return array();
	}

	public function getExtraMessage($client, $params, $specialClientArray){
		$rtn = '';

			if(array_key_exists($client, $specialClientArray)){

				foreach($specialClientArray[$client] as $key => $val) {
					if(array_key_exists($val,$params)){
						$rtn .= $val . ' : ' . $params[$val].'<br>';
					}
				}
			}
		return $rtn;
	}
}
?>
