<?php
class CardApplyModelClass extends ModelClassEx {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $rs					= null;			// 結果セット（リスト）
	private $detail				= null;			// 結果セット（詳細）
	private $aId				= NO_STRING;	// カード申請ID
	private $createTime			= NO_STRING;	// 申請日時
	private $userName			= NO_STRING;	// ユーザ名
	private $userAccount		= NO_STRING;	// ユーザ口座番号
	private $firstName			= NO_STRING;	// 名
	private $lastName			= NO_STRING;	// 姓
	private $country			= NO_STRING;	// 国
	private $state				= NO_STRING;	// 県・州
	private $city				= NO_STRING;	// 市区町村
	private $address			= NO_STRING;	// 住所
	private $zipCode			= NO_STRING;	// 郵便番号
	private $tel				= NO_STRING;	// 電話番号
	private $cardType			= NO_STRING;	// カード種別
	private $cardNumber			= NO_STRING;	// カード番号
	private $chid				= NO_STRING;	// CHID
	private $pin				= NO_STRING;	// PIN
	private $status				= NO_STRING;	// ステータス
	private $updateTime			= NO_STRING;	// 最終処理日時
	private $processUser		= NO_STRING;	// 処理ユーザ
	private $comment			= NO_STRING;	// メッセージ
	private $kycFlg				= NO_STRING;	// KYCフラグ
	private $adminFirstName		= NO_STRING;	// 管理者名
	private $adminLastName		= NO_STRING;	// 管理者姓

	// ------------------ 検索系 ------------------//
	private $sEmail				= NO_STRING;	// メールアドレス
	private $sUserAccount		= NO_STRING;	// 口座番号
	private $sAgent				= NO_STRING;	// エージェントコード
	private $sName				= NO_STRING;	// 氏名
	private $sCardType			= NO_STRING;	// カード種別
	private $sCardStatus		= NO_STRING;	// カードステータス
	private $sCardNumber		= NO_STRING;	// カード番号
	private $sChid				= NO_STRING;	// CHID
	private $sFrom				= NO_STRING;	// 申請日（開始）
	private $sTo				= NO_STRING;	// 終了日（終了）
	private $sProcessFrom		= NO_STRING;	// 処理日（開始）
	private $sProcessTo			= NO_STRING;	// 処理日（終了）
	private $sOpenFlg			= NO_STRING;	// 申請日検索フラグ
	private $sProcessFlg		= NO_STRING;	// 処理日検索フラグ

	private $lang				= NO_STRING;

	// ------------------ 検索系 ------------------//

	/*-------------------------------------------------------------------------
	* @function_name: コントロールパネルシステムindexモデルクラスコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		// スーパークラスコンストラクタ呼び出し
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: 初期設定関数
	* @parameter	: なし
	* @return		: 成功:success、失敗:error
	-------------------------------------------------------------------------*/
	public function init() {

		try {

			// パラメータの設定
			$this -> setParameter();

			// チェック
			return $this -> validate();

		} catch (Exception $e) {
			throw new Exception(NO_STRING);
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: パラメータの設定
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function setParameter() {

		$this -> aId				= $this -> getDataPost(PARAM_A_ID);					// カード申請ID
		$this -> cardNumber			= $this -> getDataPost(PARAM_CARD_NUMBER);			// カード番号
		$this -> chid				= $this -> getDataPost(PARAM_CARD_HOLDER_ID);		// CHID
		$this -> pin				= $this -> getDataPost(PARAM_PIN);					// PIN
		$this -> status				= $this -> getDataPost(PARAM_STATUS);				// ステータス
		$this -> comment			= $this -> getDataPost(PARAM_COMMENT);				// 更新メモ
		$this -> cardType			= $this -> getDataPost(PARAM_CARD_TYPE);			// カード種別
		$this -> userAccount		= $this -> getDataPost(PARAM_USER_ACCOUNT);			// 口座番号
		$this -> country			= $this -> getDataPost(PARAM_COUNTRY);				// 国
		$this -> state				= $this -> getDataPost(PARAM_STATE);				// 県・州
		$this -> city				= $this -> getDataPost(PARAM_CITY);					// 市区町村
		$this -> address			= $this -> getDataPost(PARAM_ADDRESS);				// 住所
		$this -> zipCode			= $this -> getDataPost(PARAM_ZIP_CODE);				// 郵便番号
		$this -> tel				= $this -> getDataPost(PARAM_TEL);					// 電話番号

		// ------------------ 検索系 ------------------//
		$this -> sEmail				= $this -> getDataPost(PARAM_S_EMAIL);			// メールアドレス
		$this -> sUserAccount		= $this -> getDataPost(PARAM_S_ACCOUNT);		// 口座番号
		$this -> sAgent				= $this -> getDataPost(PARAM_S_AGENT_CODE);		// エージェントコード
		$this -> sName				= $this -> getDataPost(PARAM_S_NAME);			// 氏名
		$this -> sCardType			= $this -> getDataPost(PARAM_S_CARD_TYPE);		// カード種別
		$this -> sCardStatus		= $this -> getDataPost(PARAM_S_CARD_STATUS);	// カードステータス
		$this -> sCardNumber		= $this -> getDataPost(PARAM_S_CARD_NUMBER);	// カード番号
		$this -> sChid				= $this -> getDataPost(PARAM_S_CHID);			// CHID
		$this -> sFrom				= $this -> getDataPost(PARAM_S_FROM);			// 申請日（開始）
		$this -> sTo				= $this -> getDataPost(PARAM_S_TO);				// 終了日（終了）
		$this -> sProcessFrom		= $this -> getDataPost(PARAM_S_PROCESS_FROM);	// 処理日（開始）
		$this -> sProcessTo			= $this -> getDataPost(PARAM_S_PROCESS_TO);		// 処理日（終了）
		$this -> sOpenFlg			= $this -> getDataPost(PARAM_OPEN_FLG);			// 申請日検索フラグ
		$this -> sProcessFlg		= $this -> getDataPost(PARAM_S_PROCESS_FLG);	// 処理日検索フラグ
		// ------------------ 検索系 ------------------//

		$this -> lang 				= $this -> getLangage();
	}

	/*-------------------------------------------------------------------------
	* @function_name: パラメータの再設定
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	public function restore() {

		if($this -> getType()		== TYPE_BACK
			|| $this -> getType()	== TYPE_CONFIRM) {	// 入力エラー、確認画面の場合は最低情報のみ
			$this -> userName			= $this -> getColumnData($this -> detail, COLUMN_USER_NAME);		// ユーザ名
			$this -> userAccount		= $this -> getColumnData($this -> detail, COLUMN_USER_ACCOUNT);		// ユーザ口座番号
			$this -> firstName			= $this -> getColumnData($this -> detail, COLUMN_FIRST_NAME);		// 名
			$this -> lastName			= $this -> getColumnData($this -> detail, COLUMN_LAST_NAME);		// 姓

		} else {
			$this -> createTime			= $this -> getColumnData($this -> detail, COLUMN_CREATE_TIME);		// 申請日時
			$this -> userName			= $this -> getColumnData($this -> detail, COLUMN_USER_NAME);		// ユーザ名
			$this -> userAccount		= $this -> getColumnData($this -> detail, COLUMN_USER_ACCOUNT);		// ユーザ口座番号
			$this -> firstName			= $this -> getColumnData($this -> detail, COLUMN_FIRST_NAME);		// 名
			$this -> lastName			= $this -> getColumnData($this -> detail, COLUMN_LAST_NAME);		// 姓
			$this -> country			= $this -> getColumnData($this -> detail, COLUMN_COUNTRY);			// 国
			$this -> state				= $this -> getColumnData($this -> detail, COLUMN_STATE);			// 県・州
			$this -> city				= $this -> getColumnData($this -> detail, COLUMN_CITY);				// 市区町村
			$this -> address			= $this -> getColumnData($this -> detail, COLUMN_ADDRESS);			// 住所
			$this -> zipCode			= $this -> getColumnData($this -> detail, COLUMN_ZIP_CODE);			// 郵便番号
			$this -> tel				= $this -> getColumnData($this -> detail, COLUMN_TEL);				// 電話番号
			$this -> cardType			= $this -> getColumnData($this -> detail, COLUMN_CARD_TYPE);		// カード種別
			$this -> cardNumber			= $this -> getColumnData($this -> detail, COLUMN_CARD_NUMBER);		// カード番号
			$this -> chid				= $this -> getColumnData($this -> detail, COLUMN_CARD_HOLDER_ID);	// CHID
			$this -> pin				= $this -> getColumnData($this -> detail, COLUMN_PIN);				// PIN
			$this -> status				= $this -> getColumnData($this -> detail, COLUMN_STATUS);			// ステータス
			$this -> updateTime			= $this -> getColumnData($this -> detail, COLUMN_UPDATE_TIME);		// 最終処理日時
			$this -> processUser		= $this -> getColumnData($this -> detail, COLUMN_PROCESS_USER);		// 処理ユーザ
			$this -> comment			= $this -> getColumnData($this -> detail, COLUMN_COMMENT);			// メッセージ
			$this -> kycFlg				= $this -> getColumnData($this -> detail, COLUMN_KYC_FLG);			// KYCフラグ
			$this -> adminFirstName		= $this -> getColumnData($this -> detail, COLUMN_ADMIN_FIRST_NAME);	// 管理者名
			$this -> adminLastName		= $this -> getColumnData($this -> detail, COLUMN_ADMIN_LAST_NAME);	// 管理者姓
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: サーバ側データチェック
	* @parameter	: なし
	* @return		: TRUE:成功、FALSE:失敗
	-------------------------------------------------------------------------*/
	public function validate() {

		// 変数宣言部
		$rtn		= true;
		$path		= NO_STRING;
		$errorFlg	= true;

		// ログインチェック
		if(!$this -> checkAdminUserLogin()) {
			throw new Exception(NO_STRING);
		}

		/**
		 *
		 * -- anton --
		 * 04/22/2019
		 *
		 */
		$redirect = ($this -> lang != "en" ? "" : "{$this -> lang}/");

		//check access
		if(!$this -> checkAdminUserAccess('CAAP', array(''))){
			$this -> popUpSessionMessage(ERROR, 'E_ERROR_NO_PAGE_ACCESS', array());
			header('Location: /'.$redirect.'menu');
			exit();
		}

		if($this -> getType() == TYPE_CREATE) {
			//check access
			if(!$this -> checkAdminUserAccess('CAAP', array('','1'))){
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_NO_FUNCTION_ACCESS', array());
				header('Location: /'.$redirect.'menu');
				exit();
			}
		}

		if($this -> getType() == TYPE_DETAIL) {
			//check access
			if(!$this -> checkAdminUserAccess('CADT', array(''))){
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_NO_PAGE_ACCESS', array());
				header('Location: /'.$redirect.'menu');
				exit();
			}
		}

		if($this -> getType() == TYPE_SAVE) {
			//check access
			if(!$this -> checkAdminUserAccess('CADT', array('', '1'))){
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_NO_FUNCTION_ACCESS', array());
				header('Location: /'.$redirect.'menu');
				exit();
			}
		}
		if($this -> getType() == TYPE_UPDATE) {
			//check access
			if(!$this -> checkAdminUserAccess('CADN', array('', '1'))){
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_NO_FUNCTION_ACCESS', array());
				header('Location: /'.$redirect.'menu');
				exit();
			}
		}

		// 送信の時だけチェック
		if($this -> getType() == TYPE_INPUT) {	// 口座番号のチェック

			$this -> detail = $this -> getAccountCommon($this -> userAccount);

			// 口座番号のチェック
			if(count($this -> detail) == NO_COUNT) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_VALUE', array($this -> userAccount));
				$this -> setType(TYPE_CREATE);
			} else {
				$this -> detail = $this -> getRowData($this -> detail);
			}

		} else if($this -> getType()		== TYPE_CONFIRM
					|| $this -> getType()	== TYPE_COMPLETE) {	// 入力情報

			// 必須項目
			// 都道府県のチェック
			if(!$this -> checkNull($this -> state)) {
				$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_STATE));
				$rtn = false;
			}

			// 市区町村のチェック
			if(!$this -> checkNull($this -> city)) {
				$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_CITY));
				$rtn = false;
			}

			// 住所のチェック
			if(!$this -> checkNull($this -> address)) {
				$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_ADDRESS));
				$rtn = false;
			}

			// 郵便番号のチェック
			if(!$this -> checkNull($this -> zipCode)) {
				$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_ZIP_CODE));
				$rtn = false;
			}

			// 電話番号のチェック
			if(!$this -> checkNull($this -> tel)) {
				$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_TEL));
				$rtn = false;
			}

			if(!$rtn) {
				$this -> setType(TYPE_BACK);
				return true;
			}

			// 正規表現
			// 都道府県のチェック
			if(!$this -> checkStringAsciiStateAndCity($this -> state)) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_REGULAR_ASCII_STATE_CITY', array(VAL_STR_STATE, VAL_INT_64));
				$rtn = false;
			}

			if(!$this -> checkLength($this -> state
					, VAL_INT_1
					, VAL_INT_64)) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_STRING_LENGTH_ANY', array(VAL_STR_STATE
						, VAL_INT_1
						, VAL_INT_64));
				$rtn = false;
			}

			// 市区町村のチェック
			if(!$this -> checkStringAsciiStateAndCity($this -> city)) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_REGULAR_ASCII_STATE_CITY', array(VAL_STR_CITY, VAL_INT_64));
				$rtn = false;
			}

			if(!$this -> checkLength($this -> city
					, VAL_INT_1
					, VAL_INT_64)) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_STRING_LENGTH_ANY', array(VAL_STR_CITY
						, VAL_INT_1
						, VAL_INT_64));
				$rtn = false;
			}

			// 住所のチェック
			if(!$this -> checkStringAddress($this -> address)) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_REGULAR_ASCII_ADDRESS', array(VAL_STR_ADDRESS, VAL_INT_128));
				$rtn = false;
			}

			if(!$this -> checkLength($this -> address
					, VAL_INT_1
					, VAL_INT_128)) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_STRING_LENGTH_ANY', array(VAL_STR_ADDRESS
						, VAL_INT_1
						, VAL_INT_128));
				$rtn = false;
			}

			// 郵便番号のチェック
			if(!$this -> checkStringNumberZipCode($this -> zipCode)) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_REGULAR_NUMBER_ZIP_CODE', array(VAL_STR_ZIP_CODE));
				$rtn = false;
			}

			// 電話番号のチェック
			if(!$this -> checkStringNumberTel($this -> tel)) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_REGULAR_NUMBER_TEL', array(VAL_STR_TEL, VAL_INT_20));
				$rtn = false;
			}

			if(!$this -> checkLength($this -> tel
					, VAL_INT_7
					, VAL_INT_20)) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_STRING_LENGTH_ANY', array(VAL_STR_TEL
						, VAL_INT_7
						, VAL_INT_20));
				$rtn = false;
			}

		} else if($this -> getType() == TYPE_SAVE) {	// カードデータ登録時

			// CHIDとカード番号の重複チェック
			$or 		= ($this -> lang == "en" ? "or" : "か");
			if(!$this -> checkExistCHIDAndCardNumber($this -> chid, $this -> cardNumber)) {
				$this -> popUpSessionMessage(ERROR, 'E_EXIST_DATA', array(VAL_STR_CARD_HOLDER_ID . " " . $or . " ". VAL_STR_CARD_NUMBER));
				$rtn = false;
			}

			if(!$rtn) {
				$this -> setType(TYPE_DETAIL);
				return false;
			}
		}

		return true;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 検索条件パラメータの取得
	* @parameter	: なし
	* @return		: 検索条件パラメータ
	-------------------------------------------------------------------------*/
	public function getWhere() {

		// 変数宣言部
		$rtnParams = array();

		if($this -> sEmail != NO_STRING) {					// メールアドレス
			$rtnParams[] = ' users_active.user_name = (\')' . $this -> sEmail . '(\') ';
		}

		if($this -> sUserAccount != NO_STRING) {			// 口座番号
			$rtnParams[] = ' user_cards_apply.user_account = (\')' . $this -> sUserAccount . '(\') ';
		}

		if($this -> sAgent != NO_STRING) {					// エージェントコード
			$rtnParams[] = ' users_active.parent_agent_code = (\')' . $this -> sAgent . '(\') ';
		}

		if($this -> sName != NO_STRING) {					// 氏名
			$rtnParams[] = ' (users_active.first_name LIKE (\')%' . $this -> sName . '%(\') OR users_active.last_name LIKE (\')%' . $this -> sName . '%(\'))';
		}

		if($this -> sCardType != NO_STRING) {				// カード種別
			$rtnParams[] = ' user_cards_apply.card_type = (\')' . $this -> sCardType . '(\') ';
		}

		if($this -> sCardStatus == NO_STRING) {				// カードステータス（全て表示の場合）
			$rtnParams[] = ' user_cards_apply.status < (\')6(\') ';

		} else {											// カードステータス指定
			$rtnParams[] = ' user_cards_apply.status = (\')' . $this -> sCardStatus . '(\') ';
		}

		if($this -> sCardNumber != NO_STRING) {				// カード番号
			$rtnParams[] = ' user_cards_apply.card_number = (\')' . $this -> sCardNumber . '(\') ';
		}

		if($this -> sChid != NO_STRING) {					// CHID
			$rtnParams[] = ' user_cards_apply.card_holder_id = (\')' . $this -> sChid . '(\') ';
		}

		// 申請日検索フラグがある場合
		if($this -> sOpenFlg != NO_STRING) {

			if($this -> sFrom != NO_STRING) {				// 申請日（開始）
				$rtnParams[] = ' user_cards_apply.create_time >= (\')' . str_replace(DELIMIT_SLASH, DELIMIT_HYPHEN, $this -> sFrom) . ' 00:00:00(\') ';
			}

			if($this -> sTo != NO_STRING) {					// 終了日（終了）
				$rtnParams[] = ' user_cards_apply.create_time < (\')' . date('Y-m-d H:i:s', strtotime($this -> sTo . ' +1 days')) . '(\') ';
			}
		}

		// 処理日検索フラグがある場合
		if($this -> sProcessFlg != NO_STRING) {

			if($this -> sProcessFrom != NO_STRING) {				// 処理日（開始）
				$rtnParams[] = ' user_cards_apply.update_time >= (\')' . $this -> sProcessFrom . ' 00:00:00(\') ';
			}

			if($this -> sProcessTo != NO_STRING) {					// 処理日（終了）
				$rtnParams[] = ' user_cards_apply.update_time < (\')' . date('Y-m-d H:i:s', strtotime($this -> sProcessTo . ' +1 days')) . '(\') ';
			}
		}

		// 検索条件の結合
		if(count($rtnParams) > NO_COUNT) {
			return DELIMIT_AND . implode(DELIMIT_AND, $rtnParams);
		} else {
			return NO_STRING;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: カード申請IDの取得
	* @parameter	: なし
	* @return		: カード申請ID
	-------------------------------------------------------------------------*/
	public function echoAId() {
		echo $this -> aId;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 申請日時の取得
	* @parameter	: なし
	* @return		: 申請日時
	-------------------------------------------------------------------------*/
	public function echoCreateTime() {
		echo $this -> createTime;
	}

	/*-------------------------------------------------------------------------
	* @function_name: ユーザ名の取得
	* @parameter	: なし
	* @return		: ユーザ名
	-------------------------------------------------------------------------*/
	public function echoUserName() {
		echo $this -> userName;
	}

	/*-------------------------------------------------------------------------
	* @function_name: ユーザ口座番号の取得
	* @parameter	: なし
	* @return		: ユーザ口座番号
	-------------------------------------------------------------------------*/
	public function getUserAccount() {
		return $this -> userAccount;
	}

	/*-------------------------------------------------------------------------
	* @function_name: ユーザ口座番号の取得
	* @parameter	: なし
	* @return		: ユーザ口座番号
	-------------------------------------------------------------------------*/
	public function echoUserAccount() {
		echo $this -> userAccount;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 名の取得
	* @parameter	: なし
	* @return		: 名
	-------------------------------------------------------------------------*/
	public function echoFirstName() {
		echo $this -> firstName;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 姓の取得
	* @parameter	: なし
	* @return		: 姓
	-------------------------------------------------------------------------*/
	public function echoLastName() {
		echo $this -> lastName;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 国の取得
	* @parameter	: なし
	* @return		: 国
	-------------------------------------------------------------------------*/
	public function echoCountry() {
		echo $this -> country;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 国の取得
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	public function dispCountry() {
		echo $this -> dispCountryCommon($this -> country);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 国の取得
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	public function dispHTMLCountry() {
		echo $this -> dispListOption($this -> getCountyList(), $this -> country);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 県・州の取得
	* @parameter	: なし
	* @return		: 県・州
	-------------------------------------------------------------------------*/
	public function echoState() {
		echo $this -> state;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 市区町村の取得
	* @parameter	: なし
	* @return		: 市区町村
	-------------------------------------------------------------------------*/
	public function echoCity() {
		echo $this -> city;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 住所の取得
	* @parameter	: なし
	* @return		: 住所
	-------------------------------------------------------------------------*/
	public function echoAddress() {
		echo $this -> address;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 郵便番号の取得
	* @parameter	: なし
	* @return		: 郵便番号
	-------------------------------------------------------------------------*/
	public function echoZipCode() {
		echo $this -> zipCode;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 電話番号の取得
	* @parameter	: なし
	* @return		: 電話番号
	-------------------------------------------------------------------------*/
	public function echoTel() {
		echo $this -> tel;
	}

	/*-------------------------------------------------------------------------
	* @function_name: カード種別の取得
	* @parameter	: なし
	* @return		: カード種別
	-------------------------------------------------------------------------*/
	public function echoCardType() {
		echo $this -> cardType;
	}

	/*-------------------------------------------------------------------------
	* @function_name: カード種別の取得
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	public function dispHTMLCardType() {
		echo $this -> dispListOption($this -> getCardTypeList(), $this -> cardType);
	}

	/*-------------------------------------------------------------------------
	* @function_name: カード番号の取得
	* @parameter	: なし
	* @return		: カード番号
	-------------------------------------------------------------------------*/
	public function echoCardNumber() {
		echo $this -> cardNumber;
	}

	/*-------------------------------------------------------------------------
	* @function_name: CHIDの取得
	* @parameter	: なし
	* @return		: CHID
	-------------------------------------------------------------------------*/
	public function echoChid() {
		echo $this -> chid;
	}

	/*-------------------------------------------------------------------------
	* @function_name: PINの取得
	* @parameter	: なし
	* @return		: PIN
	-------------------------------------------------------------------------*/
	public function echoPin() {
		echo $this -> pin;
	}

	/*-------------------------------------------------------------------------
	* @function_name: PINの取得
	* @parameter	: なし
	* @return		: PIN
	-------------------------------------------------------------------------*/
	public function dispPin() {
		if($this -> pin == NO_COUNT) {
			echo NO_STRING;
		} else {
			echo $this -> pin;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: ステータスの取得
	* @parameter	: なし
	* @return		: ステータス
	-------------------------------------------------------------------------*/
	public function echoStatus() {
		echo $this -> status;
	}

	/*-------------------------------------------------------------------------
	* @function_name: ステータスの取得
	* @parameter	: なし
	* @return		: ステータス
	-------------------------------------------------------------------------*/
	public function getStatus() {
		return $this -> status;
	}

	/*-------------------------------------------------------------------------
	* @function_name: ステータスの取得
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	public function dispHTMLStatus() {
		echo $this -> dispListOption($this -> getCardProgressAdminList(), $this -> status) ;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 最終処理日時の取得
	* @parameter	: なし
	* @return		: 最終処理日時
	-------------------------------------------------------------------------*/
	public function echoUpdateTime() {
		echo $this -> updateTime;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 処理ユーザの取得
	* @parameter	: なし
	* @return		: 処理ユーザ
	-------------------------------------------------------------------------*/
	public function echoProcessUser() {
		echo $this -> processUser;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 処理ユーザ名の取得
	* @parameter	: なし
	* @return		: 処理ユーザ名
	-------------------------------------------------------------------------*/
	public function echoProcessUserFirstName() {
		echo $this -> adminFirstName;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 処理ユーザ姓の取得
	* @parameter	: なし
	* @return		: 処理ユーザ姓
	-------------------------------------------------------------------------*/
	public function echoProcessUserLastName() {
		echo $this -> adminLastName;
	}

	/*-------------------------------------------------------------------------
	* @function_name: メッセージの取得
	* @parameter	: なし
	* @return		: メッセージ
	-------------------------------------------------------------------------*/
	public function echoComment() {
		echo $this -> comment;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 検索メールアドレスの取得
	* @parameter	: なし
	* @return		: 検索メールアドレス
	-------------------------------------------------------------------------*/
	public function echoSEmail() {
		echo $this -> sEmail;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 検索口座番号の取得
	* @parameter	: なし
	* @return		: 検索口座番号
	-------------------------------------------------------------------------*/
	public function echoSUserAccount() {
		echo $this -> sUserAccount;
	}

	/*-------------------------------------------------------------------------
	* @function_name: エージェントコードの取得
	* @parameter	: なし
	* @return		: エージェントコード
	-------------------------------------------------------------------------*/
	public function echoSAgent() {
		echo $this -> sAgent;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 氏名の取得
	* @parameter	: なし
	* @return		: 氏名
	-------------------------------------------------------------------------*/
	public function echoSName() {
		echo $this -> sName;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 検索カード種別の取得
	* @parameter	: なし
	* @return		: 検索カード種別
	-------------------------------------------------------------------------*/
	public function dispSCardType() {
		echo $this -> dispListOption($this -> getCardTypeList(), $this -> sCardType);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 検索カードステータスの取得
	* @parameter	: なし
	* @return		: 検索カードステータス
	-------------------------------------------------------------------------*/
	public function dispSCardStatus() {
		echo $this -> dispListOption($this -> getCardProgressAdminList(), $this -> sCardStatus);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 検索カード番号の取得
	* @parameter	: なし
	* @return		: 検索カード番号
	-------------------------------------------------------------------------*/
	public function echoSCardNumber() {
		echo $this -> sCardNumber;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 検索CHIDの取得
	* @parameter	: なし
	* @return		: 検索CHID
	-------------------------------------------------------------------------*/
	public function echoSChid() {
		echo $this -> sChid;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 検索申請日時（開始）の取得
	* @parameter	: なし
	* @return		: 検索申請日時（開始）
	-------------------------------------------------------------------------*/
	public function echoSFrom() {
		echo $this -> sFrom;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 検索申請日時（終了）の取得
	* @parameter	: なし
	* @return		: 検索申請日時（終了）
	-------------------------------------------------------------------------*/
	public function echoSTo() {
		echo $this -> sTo;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 検索処理日時（開始）の取得
	* @parameter	: なし
	* @return		: 検索処理日時（開始）
	-------------------------------------------------------------------------*/
	public function echoSProcessFrom() {
		echo $this -> sProcessFrom;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 検索処理日時（終了）の取得
	* @parameter	: なし
	* @return		: 検索処理日時（終了）
	-------------------------------------------------------------------------*/
	public function echoSProcessTo() {
		echo $this -> sProcessTo;
	}

	/*-------------------------------------------------------------------------
	* @function_name: メッセージの取得
	* @parameter	: なし
	* @return		: メッセージ
	-------------------------------------------------------------------------*/
	public function dispSOpenFlg() {
		echo '<label>'
				. $this -> makeCheckOne(PARAM_OPEN_FLG
										, PARAM_OPEN_FLG
										, VAL_INT_1
										, NO_STRING, $this -> sOpenFlg)
				. '</label>';
	}

	/*-------------------------------------------------------------------------
	 * @function_name: メッセージの取得
	* @parameter	: なし
	* @return		: メッセージ
	-------------------------------------------------------------------------*/
	public function dispSProcessFlg() {
		echo '<label>'
				. $this -> makeCheckOne(PARAM_S_PROCESS_FLG
										, PARAM_S_PROCESS_FLG
										, VAL_INT_1
										, NO_STRING, $this -> sProcessFlg)
				. '</label>';
	}

	/*-------------------------------------------------------------------------
	* @function_name: リストデータの設定
	* @parameter	: リストデータ
	* @return		: なし
	-------------------------------------------------------------------------*/
	public function setResult($rs) {
		$this -> rs = $rs;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 詳細データの取得
	* @parameter	: 詳細データ
	* @return		: なし
	-------------------------------------------------------------------------*/
	public function setDetail($rs) {
		$this -> detail = $rs;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: HTML表示用のデータ取得関数
	* @parameter	: なし
	* @return		: HTML表示用データ配列
	-------------------------------------------------------------------------*/
	public function echoList() {

		// 変数宣言部
		$rtn		= NO_STRING;
		$exist		= NO_STRING;
		$err		= NO_STRING;
		$amount		= NO_STRING;
		$pin		= NO_STRING;
		$cardNum	= NO_STRING;
		$status		= NO_STRING;
		$statusCss	= NO_STRING;

		if($this -> isLoopData($this -> rs)) {

			// データの数だけループを回す
			$start		= 	($this -> getTargetPage() - VAL_INT_1) * VAR_DEFAULT_PAGE_COUNT;
			$end		= $this -> getTargetPage() * VAR_DEFAULT_PAGE_COUNT;
			$listCount	= count($this -> rs);

			for($cnt = $start; $cnt < $end && $cnt < $listCount; $cnt++) {

				$row = $this -> getRowData($this -> rs, $cnt);

				// 存在の表示
				if($this -> getColumnData($row, COLUMN_USER_NAME) == NO_STRING) {
					$exist = '存在せず';
				} else {
					$exist = '存在';
				}

				// エラーファイルの表示
				if($this -> getColumnData($row, COLUMN_ERR_FLG) == NO_COUNT) {
					$err = 'エラーなし';
				} else {
					$err = '<a id="linkDownload" href="javascript:fileDownloadError(\'' . $this -> getColumnData($row, COLUMN_D_ID) . '\');">エラーあり</a>';
				}

				// PINコードの修正（マスク）
				$pin = $this -> getColumnData($row, COLUMN_PIN);

				if($pin > NO_COUNT) {
					$pin = '****';
				} else {
					$pin = NO_STRING;
				}

				// カード番号の修正（マスク）
				$cardNum = $this -> getColumnData($row, COLUMN_CARD_NUMBER);

				if($cardNum != NO_STRING) {
					$cardNum = '**** **** **** ' . substr($cardNum, -4);
				}

				// 申請中のみ
				$status = $this -> getColumnData($row, COLUMN_STATUS);
				if($status == VAL_INT_1) {
					$statusCss = ' class="orange" ';
				} else if($status == VAL_INT_2) {
					$statusCss = ' class="red" ';
				} else {
					$statusCss = NO_STRING;
				}

				$rtn	.= '<tr>'
						. '<td>' . $this -> getColumnData($row, COLUMN_CREATE_TIME) . '</td>'
						// . '<td class="l"><a href="javascript:userDetail(\'' . $this -> getColumnData($row, COLUMN_USER_ACCOUNT) . '\');">' . $this -> getColumnData($row, COLUMN_USER_NAME) . '</a></td>'
						. '<td class="l"><a href="account_edit?detail_account=' . $this -> getColumnData($row, COLUMN_USER_ACCOUNT) . '">'. $this -> getColumnData($row, COLUMN_USER_NAME) .'</a></td>'
						. '<td class="l">' . $this -> getColumnData($row, COLUMN_FIRST_NAME) . DELIMIT_SPACE . $this -> getColumnData($row, COLUMN_LAST_NAME) . '</td>'
						. '<td>' . $this -> getColumnData($row, COLUMN_USER_ACCOUNT) . '</td>'
						. '<td>' . $this -> getValueByList($this -> getCardTypeList(), $this -> getColumnData($row, COLUMN_CARD_TYPE)) . '</td>'
						. '<td>' . $cardNum . '</td>'
						. '<td>' . $pin . '</td>'
						. '<td>' . $this -> getColumnData($row, COLUMN_CARD_HOLDER_ID) . '</td>'
						. '<td>' . $this -> getColumnData($row, COLUMN_UPDATE_TIME) . '</td>'
						. '<td' . $statusCss . '>' . $this -> getValueByList($this -> getCardProgressAdminList(), $this -> getColumnData($row, COLUMN_STATUS))  . '</td>'
						. '<td  class="blocka"><a href="javascript:actionDetail(\'' . $this -> getColumnData($row, COLUMN_A_ID) . '\');"><span class="fa fa-info-circle fa-lg"></span></a></td>'
						. '</tr>';
			}
		} else {
			$rtn = '<tr><td colspan="11">' . $this -> getMessage(INFO, 'I_NO_SUCHE_SEARCH_DATA', array()) . '</td></tr>';
		}

		echo $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: HTML表示用のデータ取得関数
	* @parameter	: なし
	* @return		: HTML表示用データ配列
	-------------------------------------------------------------------------*/
	public function dispHTML() {
		return array();
	}

	/*-------------------------------------------------------------------------
	* @function_name: データ取得用パラメータ
	* @parameter	: なし
	* @return		: データ取得用の配列
	-------------------------------------------------------------------------*/
	public function getDetailDatas() {
		return array($this -> aId);
	}

	/*-------------------------------------------------------------------------
	* @function_name: ページャの表示
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	function dispPager() {
		echo  $this -> getPagerCommon($this -> getTargetPage()
										, $this -> getTotalPageCommon(VAR_DEFAULT_PAGE_COUNT, count($this -> rs))
										, count($this -> rs)
										, NO_STRING);
	}

	/*-------------------------------------------------------------------------
	* @function_name: カード登録用のパラメータを取得する
	* @parameter	: なし
	* @return		: カード登録用のパラメータ
	-------------------------------------------------------------------------*/
	function getUserCardRegistParams() {

		// 変数宣言部
		$rtn = array();

		$rtn[] = $this -> userAccount;
		$rtn[] = $this -> chid;
		$rtn[] = substr($this -> cardNumber, -4);
		$rtn[] = $this -> cardNumber;

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: コメント更新用のパラメータを取得する
	* @parameter	: なし
	* @return		: コメント更新用のパラメータ
	-------------------------------------------------------------------------*/
	function getUpdateParams() {

		// 変数宣言部
		$rtn = array();

		$rtn[] = $this -> aId;
		$rtn[] = intval($this -> cardType);
		$rtn[] = $this -> cardNumber;
		$rtn[] = $this -> chid;
		$rtn[] = $this -> pin;
		$rtn[] = $this -> status;
		$rtn[] = $this -> comment;
		$rtn[] = $this -> getAdminUserData(COLUMN_USER_ACCOUNT);

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 削除用のパラメータを取得する
	* @parameter	: なし
	* @return		: 削除用のパラメータ
	-------------------------------------------------------------------------*/
	function getDeleteParams() {

		// 変数宣言部
		$rtn = array();

		$rtn[] = $this -> chid;

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: コメント更新（コメント）用のパラメータを取得する
	* @parameter	: なし
	* @return		: コメント更新（コメント）用のパラメータ
	-------------------------------------------------------------------------*/
	function getUpdateCommentParams() {

		// 変数宣言部
		$rtn = array();

		$rtn[] = $this -> aId;
		$rtn[] = $this -> comment;
		$rtn[] = $this -> getAdminUserData(COLUMN_USER_ACCOUNT);

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 登録用のパラメータを取得する
	* @parameter	: なし
	* @return		: 登録用のパラメータ
	-------------------------------------------------------------------------*/
	function getRegistParams() {

		// 変数宣言部
		$rtn = array();

		$rtn[] = $this -> userAccount;
		$rtn[] = $this -> country;
		$rtn[] = $this -> state;
		$rtn[] = $this -> city;
		$rtn[] = $this -> address;
		$rtn[] = $this -> zipCode;
		$rtn[] = $this -> tel;
		$rtn[] = VAL_INT_1;
		$rtn[] = $this -> getAdminUserData(COLUMN_USER_ACCOUNT);

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: メール送信用のパラメータを取得する
	* @parameter	: なし
	* @return		: メール送信用のパラメータ
	-------------------------------------------------------------------------*/
	function getSendParams() {

		// 変数宣言部
		$rtn	= array();
		$user	= $this -> getRowData($this -> getAccountCommon($this -> userAccount));

		// パラメータの設定
		$rtn[] = $this -> userAccount;
		$rtn[] = $this -> getColumnData($user, COLUMN_FIRST_NAME) . DELIMIT_SPACE . $this -> getColumnData($user, COLUMN_LAST_NAME);

		return $rtn;
	}
}
?>
