<?php
require_once(SYSTEM_LOGICS . 'advertisements/model.php');

class LogicAdvertisements extends AdvertisementModelClass {
	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $htmlStr = NO_STRING;	// 表示用HTML文字列

	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: ロジック（各クラス共通）
	* @parameter	: なし
	* @return		: TRUE:ロジック成功、FALSE:ロジック失敗
	-------------------------------------------------------------------------*/
	function logic() {
		try {
            $this -> init();
			
            switch($this -> getType()){
                case TYPE_IMAGE_MANAGER_UPLOAD_COMPLETE:
                    $this -> insertNewAd();
                    $this -> listsImages();
                    break;
                case TYPE_IMAGE_MANAGER:
                case TYPE_SEARCH:
                    $this -> listsImages();
                    break;
                case TYPE_IMAGE_MANAGER_DETAIL:
                    $this -> selectAdDetails();
                    break;
                case TYPE_UPDATE:
                    $this -> insertActivity();
                    $this -> update();
                    $this -> listsImages();
                    break;
                case TYPE_DELETE:
                    $this -> insertActivity();
                    $this -> deleteAd();
                    $this -> listsImages();
                    break;
                default:
                    $this -> lists();
                    break;
            }
		} catch (Exception $e) {
			throw $e;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: 出金リストの取得
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function lists() {
		$where = $this -> getWhere();
		$this -> setResult($this -> accessSelect('LIST_CLICKED_ADS', $where));
	}
	
	function insertNewAd(){ 
	    if($this -> loadImageAds()){
	        $this -> insertActivity();
	        $this -> accessModify('INSERT_ADS', $this -> getImageAdRegistData());
	        $this -> popUpSessionMessage(INFO, 'I_COMPLATE_SAVE', array());
	    }else{
	        $this -> popUpSessionMessage(ERROR, 'E_ERROR_UPLOAD_ADMIN_FAILED', array());
	    }
	}

	function listsImages() {
		$this -> setImages($this -> accessSelect('LIST_IMAGES', $this -> getWhereAds()));
	}

	function selectAdDetails(){
		$this -> setAdDetails($this -> accessSelect('SELECT_AD_DETAILS', array($this -> getAdID())));
		$this -> restore();
	}

	function update(){
	    $result = $this -> getRowData($this -> accessSelect('SELECT_AD_DETAILS', [$this -> getAdID()]));
	    	    
	    if($this -> isLoopData($result)){	        
	        if($this -> loadImageAds())
	            $this -> deleteAdImageFile($result);
	        else
	            $this -> referToExistingDetails($result);
	        	            
	        $this -> accessModify('UPDATE_AD_DETAILS', $this -> getUpdateData());
	        $this -> popUpSessionMessage(INFO, 'I_COMPLATE_SAVE', array());
	    }
	}

	function updateSequence(){
		$this -> getUpdateSequence();
	}

	function deleteAd(){
	    $deleteData = $this -> getDeleteData();
	    $adDetails  = $this -> getRowData($this -> accessSelect('SELECT_AD_DETAILS', $deleteData));
	    
	    $this -> deleteAdImageFile($adDetails);
	    $this -> accessModify('DELETE_AD_FILE', $deleteData, false);
	}

    function insertActivity(){
		$this -> accessModify('INSERT_ACTIVITY', $this -> getActivity(), false);
	}

}


?>