<?php
require_once(SYSTEM_LOGICS . 'transfer/model.php');

class LogicTransfer extends TransferModelClass {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $htmlStr = NO_STRING;	// 表示用HTML文字列

	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: ロジック（各クラス共通）
	* @parameter	: なし
	* @return		: TRUE:ロジック成功、FALSE:ロジック失敗
	-------------------------------------------------------------------------*/
	function logic() {

		try {
			// 初期化
			$this -> init();
			// 処理
			$this -> biz();
		} catch (Exception $e) {
			throw $e;
		}
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 処理
	 * @parameter	: なし
	 * @return		: なし
	 -------------------------------------------------------------------------*/
	function biz() {
		if($this -> getType() == TYPE_INPUT) {
			$this -> input();
		} else if($this -> getType() == TYPE_COMPLETE) {
			$this -> regist();
		} else if($this -> getType() == TYPE_DETAIL) {
			$this -> detail();
		} else if($this -> getType() == TYPE_UPDATE) {
			$this -> update();
			$this -> detail();
			$this -> insertActivity();
		} else if($this -> getType() == TYPE_DELETE) {
			$this -> insertActivity();
			$this -> deleteTransaction();
			$this -> lists();
		} else {
			$this -> lists();
		}
		$this -> setCurrencies($this -> accessSelect('LIST_MST_CURRENCY_ACTIVE', array()));
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座振替リストの取得
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function lists() {
		$this -> setRs($this -> accessSelect('LIST_TRANSFER_SIMPLE', array($this -> getWhereTransfer())));
		// // $this -> setTotal($this -> accessSelect('LIST_TRANSFER_TOTAL', array($this -> getWhereTotal($this -> getWhereTransfer()))));
		//  $this -> setTotalFrom($this -> accessSelect('LIST_TRANSFER_TOTAL_FROM', array($this -> getWhereTotal($this -> getWhereTransfer()))));
		//  $this -> setTotalTo($this -> accessSelect('LIST_TRANSFER_TOTAL_TO', array($this -> getWhereTotal($this -> getWhereTransfer()))));
		$this -> setTotalFromTo($this -> accessSelect('LIST_TRANSFER_TOTAL_FROM_TO', array($this -> getWhereTotal($this -> getWhereTransfer()))));

		$this -> setJoinUserData();
	}

	/*-------------------------------------------------------------------------
	* @function_name: 検索データからユーザデータをJOINする
	* @parameter	: なし
	* @return		: なし
	 -------------------------------------------------------------------------*/
	function setJoinUserData() {

		// 変数宣言部
		$iIds	= NO_STRING;
		$users	= null;

		$iIds = $this -> getUIds();

		$users = $this -> accessSelect('LIST_TRANSFER_JOIN_USER', array($iIds, $this -> getWhereUser()));

		$this -> mergeUser($users);
	}


	/*-------------------------------------------------------------------------
	 * @function_name: 口座振替の取得
	 * @parameter	: なし
	 * @return		: なし
	 -------------------------------------------------------------------------*/
	function detail() {
		$this -> setRs($this -> accessSelect('SELECT_TRANSFER', array($this -> getTId())));
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座振替の登録
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function regist() {

		// 口座振替データ登録
		$regist = $this -> getRegistData();
		if($this -> accessModify('INSERT_TRANSFER', $regist)) {

			// コミッション登録
			$this -> transferRegistCommision();

			// 異通貨の場合は為替コミッション発生
			$from	= $this -> getDebitCurrency();
			$to		= $this -> getTransferCurrency();

			if($from != $to) {
				if($this -> getTransferType() == NO_COUNT) {	// 送金額指定の場合
					$this -> registCommisionExchange($this -> getFrom()
							, $from
							, $to
							, $this -> currencyToInt($this -> getTransferAmount(), $to));
				} else {										// 着金額指定の場合
					$this -> registCommisionExchange($this -> getFrom()
							, $to
							, $from
							, $this -> currencyToInt($this -> getDebitAmount(), $from));
				}
			}


// 			// メールを送信（送金元ユーザ）
			$params = $this -> getSendDataFrom();
// 			$this -> sendMailByTmp('transfer_send_user.xml'
// 					, $params
// 					, $params[VAL_INT_11]
// 					, VAR_CS_MAIL_ADDRESS);

// 			// メールを送信（送金先ユーザ）
// 			$params = $this -> getSendDataTo();
// 			$this -> sendMailByTmp('transfer_receive_user.xml'
// 					, $params
// 					, $params[VAL_INT_11]
// 					, VAR_CS_MAIL_ADDRESS);

			// メールを送信（送金元ユーザ）
			$params = $this -> getSendDataFrom();
			$this -> sendMailByTmpAndWL($this -> getFrom()
					, 'transfer_send_user.xml'
					, $params
					, $params[VAL_INT_11]
					, 'marchant@');

			// メールを送信（送金先ユーザ）
			$params = $this -> getSendDataTo();
			$this -> sendMailByTmpAndWL($this -> getTo()
					, 'transfer_receive_user.xml'
					, $params
					, $params[VAL_INT_11]
					, 'marchant@');

			$this -> accessModify('INSERT_ACTIVITY', array($this -> getAdminUserData(PARAM_UID)
															, $_SERVER[PARAM_REMOTE_ADDR]
															, $_SERVER[PARAM_HTTP_USER_AGENT]
															, VAL_INT_12
															, $regist[19]
															, 'Created/Imported transaction '.$regist[18]));
		}
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 更新
	 * @parameter	: なし
	 * @return		: なし
	 -------------------------------------------------------------------------*/
	function update() {
		$this -> accessModify('UPDATE_TRANSFER_MESSAGE', $this -> getUpdateDateData(),false);
		$this -> popUpSessionMessage(INFO, 'I_COMPLATE_REGIST', array());
	}

    function insertActivity(){
		$this -> accessModify('INSERT_ACTIVITY', $this -> getActivity(),false);
	}

	function deleteTransaction() {
		$this -> accessModify('COPY_TRANSFER_TRANSACTION', array($this -> getTId() , $this -> getAdminUserData(PARAM_UID)));
		$this -> accessModify('DELETE_TRANSFER_TRANSACTION', array($this -> getTId()));

		$this -> popUpSessionMessage(INFO, 'I_COMPLATE_DELETE', array());
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 口座振替情報の取得
	 * @parameter	: 口座番号セット
	 * @return		: なし
	 -------------------------------------------------------------------------*/
	function input() {
		// ユーザ情報の取得
		$this -> setResult($this -> accessSelect('SELECT_TRANSFER_ACCOUNT_INFO', $this -> getViewData()));

		// バランスの取得
		$this -> setBalances($this -> accessSelect('SELECT_USER_BALANCES', array($this -> getUserAccount())));

		// 通貨情報
		$this -> setCurrencies($this -> accessSelect('LIST_MST_CURRENCY_ACTIVE', array()));
	}

    /*-------------------------------------------------------------------------
	* @function_name: makeExportData
	* @parameter	:
	* @return		:
	-------------------------------------------------------------------------*/
    function makeExportData(){
        $rtn  = NO_STRING;

        
        
        if($this -> lang == "en"){
        	$rtn  = ',,Remitter Information,,,,,Remitter Destination Information,,,,,,' . "\n";
        	$rtn .= 'Processing Date,Transaction Number,Name,Account Number,Currency,Amount,Fee,Name,Account Number,Currency,Amount,Fee,Type,Exchange Rate,Message' . "\n";
        }else{
        	$rtn  = ',,送信元情報,,,,,送信先情報,,,,,,' . "\n";
        	$rtn .= '処理時間,取引番号,名前,口座番号,通貨,金額,手数料,名前,口座番号,通貨,金額,手数料,種別,為替レート,メッセージ' . "\n";
        }
        
        $rtn .= $this -> getExportDetails();

        return $rtn;
    }

    /*-------------------------------------------------------------------------
	* @function_name: exportData
	* @parameter	:
	* @return		:
	-------------------------------------------------------------------------*/
    function exportData(){
        $fileName = 'Internal Transfer_' . str_replace("/", "", 
            $this -> getDataPost(PARAM_S_FROM, true, true, true) . '-' 
                . $this -> getDataPost(PARAM_S_TO, true, true, true)) . '_' 
                . $this -> getDataPost(PARAM_CURRENCY, true, true, true);

        header('Content-Encoding: UTF-8');
        header("Content-type: text/csv; charset=UTF-8");
        header('Content-Disposition: attachment; filename="' . $fileName . '.csv"');
        header('Content-Transfer-Encoding: binary');

        echo "\xEF\xBB\xBF";
        echo trim($this -> makeExportData());
        exit();
    }

}
?>