<?php
require_once "{$_SERVER['DOCUMENT_ROOT']}/lib/config.php";

/**
 * 
 * @author Anton
 *
 */
class DevComponents extends System {
    
    public function __construct(){
        parent::__construct();
    }
    
    /**
     * 
     * @param string $devKey
     * @return array
     */
    public function getDevCred($devKey){
        return $this -> getRowData($this -> accessSelect("SELECT_DEV_CREDENTIAL", [$devKey]), NO_COUNT);
    }
    
    /**
     * 
     * @param string $devSettingId
     * @return array
     */
    public function getDevSetting($devSettingId){
        return $this -> getSettingConfiguration($devSettingId);
    }
    
    /**
     * 
     * @param string $fetcherStr
     * @return array[]
     */
    public function getResults($fetcherStr){
        return $this -> rawSQL($fetcherStr);
    }
    
    /**
     * 
     * @param string $devSettingId
     * @param string $newValue
     */
    public function updateDevSetting($devSettingId, $newValue){
        $this -> accessModify("UPDATE_DEV_SETTING", [
            $devSettingId,
            $newValue
        ], false);
    }
    
    /**
     * 
     * @param string $devKey
     */
    public function updateDevCredExecution($devKey){
        $this -> accessModify("UPDATE_DEV_CREDENTIAL_EXECUTION", [
            $devKey,
            date("Y-m-d H:i:s")
        ], false);
    }
}