<?php
class RequestModelClass extends ModelClassEx {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $rs							= null;			// 結果セット
	private $user						= null;			// ユーザデータ
	private $history					= null;			// 履歴
	private $currencies					= null;			// 通貨
	private $balances					= null;			// 口座バランス
	private $rId						= NO_STRING;	// 引落ID
	private $userAccount				= NO_STRING;	// iwallet口座番号
	private $fromAccount				= NO_STRING;	// iwallet口座番号（申請先）
	private $toAccount					= NO_STRING;	// iwallet口座番号（申請元）
	private $toName						= NO_STRING;	// 名前（申請元）
	private $name						= NO_STRING;	// ユーザ名
	private $amount						= NO_STRING;	// 金額
	private $currency					= NO_STRING;	// 通貨
	private $message					= NO_STRING;	// メッセージ
	private $createTime					= NO_STRING;	// 作成日時
	private $fromCurrency				= NO_STRING;	// From通貨
	private $fee						= NO_STRING;	// 手数料
	private $fee2						= NO_STRING;	// 手数料2
	private $agent1						= NO_STRING;	// エージェントコード1
	private $agent2						= NO_STRING;	// エージェントコード2
	private $status						= NO_STRING;	// ステータス
	private $debitCurrency				= NO_STRING;	// 引き落とし通貨
	private $deibitAmount				= NO_STRING;	// 引き落とし金額
	private $rate						= NO_STRING;	// レート
	private $sendMessage				= NO_STRING;	// メッセージ（返信メッセージ）
	
	//　anton
	private $receiver					= NO_STRING;

	/*-------------------------------------------------------------------------
	* @function_name: コントロールパネルシステムindexモデルクラスコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		// スーパークラスコンストラクタ呼び出し
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: 初期設定関数
	* @parameter	: なし
	* @return		: 成功:success、失敗:error
	-------------------------------------------------------------------------*/
	public function init() {

		try {

			// パラメータの設定
			$this -> setParameter();

			// チェック
			return $this -> validate();

		} catch (Exception $e) {
			throw $e;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: パラメータの設定
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function setParameter() {
		$this -> rId						= $this -> purifyInput($this -> getDataPost(PARAM_R_ID));						// 引落ID
		$this -> amount						= $this -> purifyInput($this -> getDataPost(PARAM_AMOUNT));					// 金額
		$this -> userAccount				= $this -> purifyInput($this -> getDataPost(PARAM_ACCOUNT));					// iwallet口座番号
		$this -> currency					= $this -> purifyInput($this -> getDataPost(PARAM_CURRENCY));					// 金額
		$this -> message					= $this -> purifyInput($this -> getDataPost(PARAM_MESSAGE));					// 金額
		$this -> fromCurrency				= $this -> purifyInput($this -> getDataPost(PARAM_TRANSFER_FROM_CURRENCY));	// From通貨
		$this -> status						= $this -> purifyInput($this -> getDataPost(PARAM_STATUS));					// ステータス
		$this -> sendMessage				= $this -> purifyInput($this -> getDataPost(PARAM_SEND_MESSAGE));				// メッセージ（返信メッセージ）
	}

	/*-------------------------------------------------------------------------
	* @function_name: サーバ側データチェック
	* @parameter	: なし
	* @return		: TRUE:成功、FALSE:失敗
	-------------------------------------------------------------------------*/
	public function validate() {

		// 変数宣言部
		$rtn = true;

		// ログインチェック
		if(!$this -> checkSiteUserLogin()) {
			throw new Exception(NO_STRING);
		}

		if($this -> getType() == TYPE_APPLY) {				// 申請された一覧

			// 口座ステータスチェック
			if(!$this -> checkAccountStatus($this -> getUserData(PARAM_USER_ACCOUNT), VAR_TRANSACTION_REQUEST_WITHDRAW)) {
				throw new Exception(VAL_INT_99);
			}

			//create session variable for 2favalidated
			$_SESSION['2fa_validated'] = 'not validated';

		} else if($this -> getType() == TYPE_INPUT) {		// 入力画面

			// 口座ステータスチェック
			if(!$this -> checkAccountStatus($this -> getUserData(PARAM_USER_ACCOUNT), VAR_TRANSACTION_REQUEST_DEPOSIT)) {
				throw new Exception(VAL_INT_99);
			}

			// 口座の存在確認
			$account = addslashes($this -> userAccount);

			/****************04/23/2018 - Joshua U Dino - Start***********/
            //add checker if the request is sent to self
            if(!$this -> existAccountOrEmail($account)) {	// チェック失敗
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_NOT_EXIST', array(VAL_STR_USER_ACCOUNT));
				$this -> setType(CONTROL_ACTION);
				$rtn = false;

			} elseif ($this -> userAccount ==  $this -> getUserData(PARAM_USER_ACCOUNT) || $this -> userAccount ==  $this -> getUserData(PARAM_USER_ID)) { //additional checker if the request is sent to self via email- 5/22/2018, Joanne Rinos
                $this -> popUpSessionMessage(ERROR, 'E_ERROR_CANNOT_MONEY_REQUEST_SELF', array());
				$this -> setType(CONTROL_ACTION);
				$rtn = false;
      		} else {													// チェック成功
				$this -> userAccount = $account;
			}
            /****************04/23/2018 -Joshua U Dino - End***********/

		} else if($this -> getType() == TYPE_CONFIRM) {		// 確認画面
			// 必須項目
			// 金額のチェック
			if(!$this -> checkNull($this -> amount)) {
				$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_AMOUNT));
				$rtn = false;
			}

			if(!$rtn) {
				$this -> setType(TYPE_INPUT);
				return;
			}

			// 数値の正規表現
			if(!$this -> checkStringNumber($this -> amount)) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_REGULAR_NUMBER', array(VAL_STR_AMOUNT));
				$rtn = false;
			}

			// 最低値と最高値の設定
			if(!$this -> checkRangeCurrency($this -> amount
											, $this -> currency
											, NO_COUNT
											, VAR_MAX_TRANSFER_LIMIT)) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_AMOUNT', array());
				$rtn = false;
			}

            /****************04/23/2018 - Joshua U Dino - Start***********/
            //add checker of message length
            if(!$this -> checkLength($this -> message, NO_COUNT, VAL_INT_256)) {
                $this -> popUpSessionMessage(ERROR, 'E_ERROR_MESSAGE_LENGTH_EXCEEDED', array(VAL_STR_MESSAGE, VAL_INT_256));
				$rtn = false;
            }
            /****************04/23/2018 -Joshua U Dino - End***********/

			if(!$rtn) {
				$this -> setType(TYPE_INPUT);
			}

		} else if($this -> getType() == TYPE_COMPLETE) {		// 確認画面
		
			// 必須項目
			// 金額のチェック
			if(!$this -> checkNull($this -> amount)) {
				$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_AMOUNT));
				$rtn = false;
			}

			if(!$rtn) {
				$this -> setType(TYPE_INPUT);
				return;
			}

			// 数値の正規表現
			if(!$this -> checkStringNumber($this -> amount)) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_REGULAR_NUMBER', array(VAL_STR_AMOUNT));
				$rtn = false;
			}

			// 最低値と最高値の設定
			if(!$this -> checkRangeCurrency($this -> amount
											, $this -> currency
											, NO_COUNT
											, VAR_MAX_TRANSFER_LIMIT)) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_AMOUNT', array());
				$rtn = false;
			}

            /****************04/23/2018 - Joshua U Dino - Start***********/
            //add checker of message length
            if(!$this -> checkLength($this -> message, NO_COUNT, VAL_INT_256)) {
                $this -> popUpSessionMessage(ERROR, 'E_ERROR_MESSAGE_LENGTH_EXCEEDED', array(VAL_STR_MESSAGE, VAL_INT_256));
				$rtn = false;
            }
            /****************04/23/2018 -Joshua U Dino - End***********/

			if(!$rtn) {
				$this -> setType(TYPE_INPUT);
			}
		} else if($this -> getType() == TYPE_SAVE) {		// 保存時

			//check if user is high risk - Mikko 2019 0313
			$from = $this -> getRowData($this -> getAccountCommon($this -> getUserData(PARAM_USER_ACCOUNT)));
    		if($this -> getColumnData($from, COLUMN_RISK_LEVEL) == VAL_INT_1){
               $this -> popUpSessionMessage(ERROR, 'E_ERROR_WITHDRAW_HIGH_RISK', array());
               $rtn =  false;
            }else
            
			// 必須項目
			// debit口座のチェック
			if(!$this -> checkNull($this -> fromCurrency)) {
				$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_DEBIT_ACCOUNT));
				$rtn = false;
			}

			if(!$rtn) {
				$this -> setType(TYPE_BACK);
				return $rtn;
			}

			// 残高のチェック
			$balance			= $this -> getBalanceCommon($this -> getUserData(PARAM_USER_ACCOUNT), $this -> fromCurrency);
			$user				= $this -> getRequestCommon($this -> rId);
			$row				= $this -> getRowData($user);

            //check if user approves own request
            if($this -> getUserData(PARAM_USER_ACCOUNT) != $this -> getColumnData($row, COLUMN_FROM_ACCOUNT)) {
				$this -> popUpSessionMessage(ERROR, 'E_PROCESS_OWN_MONEY_REQUEST', array());
                $this -> setType(TYPE_BACK);
                return false;
			}

			$this -> currency	= $this -> getColumnData($row, COLUMN_CURRENCY);
			$amount				= $this -> intToCurrency($this -> getColumnData($row, COLUMN_AMOUNT), $this -> currency);
 			$fee    = $this -> getFeeCommon(VAR_TRANSFER
 			             , $amount
 			             , $this -> currency
 			             , $this -> getColumnData($row, COLUMN_FROM_ACCOUNT)
 			             , $this -> getColumnData($row, COLUMN_TO_ACCOUNT)
 			             , $this -> currency
 			             , $amount);

			// バランスと（送金額 + 手数料）のチェック

			// 引き落し額
			$exchange		= $this -> getExchangeCommon($amount, $this -> currency, $this -> fromCurrency, 
					false, true, NO_STRING, $this -> getUserData(PARAM_USER_ACCOUNT));
			$this -> amount	= $exchange[PARAM_AMOUNT];

			// 引き落し手数料
			$exchange		= $this -> getExchangeCommon($fee[$this -> currency . VAL_INT_1], $this -> currency, $this -> fromCurrency
							,false, false, NO_STRING, $this -> getUserData(PARAM_USER_ACCOUNT));

			$this -> fee	= $exchange[PARAM_AMOUNT];

			// レート
			$this -> rate	= $exchange[PARAM_RATE];

			// 受け取り手数料
			$this -> fee2	= $fee[$this -> currency . VAL_INT_2];
			$total			= $this -> amount + $this -> fee;
			$this -> agent1	= $fee[PARAM_AGENT_CODE . VAL_INT_1];
			$this -> agent2	= $fee[PARAM_AGENT_CODE . VAL_INT_2];


			if($balance < $total) {
				$this -> popUpSessionMessage(ERROR, 'E_INSUFFICIENT_FUNDS', array($this -> fromCurrency, $this -> formatCurrency(($this -> amount + $this -> fee), $this -> fromCurrency)));
				$rtn = false;
			}

			if(!$rtn) {
				$this -> setType(TYPE_DETAIL);
			}

			// 制限口座のチェック
			if(!$this -> checkWithdrawLimit($this -> getUserData(PARAM_USER_ACCOUNT), $this -> getColumnData($row, COLUMN_CURRENCY), $this -> getColumnData($row, COLUMN_AMOUNT))) {
				$this -> popUpSessionMessage(ERROR, 'E_LIMIT_WITHDRAW', array());
				$this -> setType(TYPE_DETAIL);
			}
		} else if ($this -> getType() == TYPE_DETAIL) {
			if (!$this -> get2FaValue(array($this -> getUserData(PARAM_USER_ACCOUNT),'received_status','received_update_time'))) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_2FA_24RECEIVE_LOCK', array());
				$this -> setType(TYPE_2FA_DISABLE_ONE);
			}

		} elseif($this -> getType() == TYPE_DELETE){
            $user				= $this -> getRequestCommon($this -> rId);
			$row				= $this -> getRowData($user);
            $status             = $this -> getColumnData($row, COLUMN_STATUS);

            //check if user deletes completed or rejected request
            if($status == '1' || $status == '2') {
				$this -> popUpSessionMessage(ERROR, 'E_PROCESS_OWN_MONEY_REQUEST', array());
                $this -> setType(TYPE_BACK);
                return false;
			}
        }
		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: データリストの表示
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	public function echoList() {

		// 変数宣言部
		$rtn	= NO_STRING;
		$remove	= NO_STRING;

		if($this -> isLoopData($this -> rs)) {
			$rtn	= '<table class="table col bdr default odd calign w99p fontXS" id="table-breakpoint">'
					. '<tr>'
					. '<th class="w15p">' . VAL_STR_DATETIME . '</th>'
					. '<th class="w20p">' . VAL_STR_REQUEST_DESTINATION . '</th>'
					. '<th class="w10p">' . VAL_STR_APPLY_AMOUNT . '</th>'
					. '<th class="w35p">' . VAL_STR_MESSAGE . '</th>'
					. '<th class="w10p">' . VAL_STR_STATE_COMMON . '</th>'
					. '<th class="w5p">' . VAL_STR_DETAIL . '</th>'
					. '<th class="w5p">' . VAL_STR_REMOVE . '</th>'
					. '</tr>';

			foreach($this -> rs as $row) {

				// 結果が出たリストは非表示にする
				if($this -> getColumnData($row, COLUMN_STATUS) != NO_COUNT) {
					$remove = '<a href="javascript:remove(\'' . $this -> getColumnData($row, COLUMN_R_ID)  . '\')">' . VAL_STR_HIDDEN . '</a>';
 				} else {
 					$remove = '&nbsp;';
 				}

				$rtn	.= '<tr>'
							. '<td class="lines">' . $this -> getColumnData($row, COLUMN_CREATE_TIME) . '</td>'
							. '<td class="lines">' . $this -> getColumnData($row, COLUMN_FROM_ACCOUNT) . ' ' . $this -> getColumnData($row, COLUMN_LAST_NAME) . DELIMIT_SPACE . $this -> getColumnData($row, COLUMN_FIRST_NAME) . '</td>'
							. '<td class="r lines">' . $this -> getColumnData($row, COLUMN_CURRENCY) . ' ' . $this -> getAmountString($this -> getColumnData($row, COLUMN_AMOUNT), $this -> getColumnData($row, COLUMN_CURRENCY)) . '</td>'
							. '<td class="l lines">' . $this -> getColumnData($row, COLUMN_MESSAGE) . '</td>'
							. '<td class="lines">' . $this -> getValueByList($this -> getRequestStatusList(), $this -> getColumnData($row, COLUMN_STATUS)) . '</td>'
							. '<td class="lines"><a href="javascript:goDetail(\'' . $this -> getColumnData($row, COLUMN_R_ID) . '\');"><span class="fa fa-info-circle fa-lg"></span></a></td>'
							. '<td class="lines">' . $remove . '</td>'
							. '</tr>';
			}

			$rtn .= '</table>';
		} else {
			$rtn = '<p class="red">' . $this -> getMessage(INFO, 'I_NO_MORE_REQUEST_APPLY', array()) . '</p>';
		}

		echo $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 申請データリストの表示
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	public function echoApplyList() {

		// 変数宣言部
		$rtn = NO_STRING;

		if($this -> isLoopData($this -> rs)) {
			$rtn	= '<table class="table col bdr default odd calign w99p fontXS" id="table-breakpoint">'
					. '<tr>'
					. '<th class="w15p">' . VAL_STR_DATETIME . '</th>'
					. '<th class="w30p">' . VAL_STR_WITHDRAWAL_CLIENT . '</th>'
					. '<th class="w10p">' . VAL_STR_AMOUNT . '</th>'
					. '<th class="w40p">' . VAL_STR_MESSAGE . '</th>'
					. '<th class="w5p">' . VAL_STR_DETAIL . '</th>'
					. '</tr>';

			foreach($this -> rs as $row) {
				$rtn	.= '<tr>'
						. '<td>' . $this -> getColumnData($row, COLUMN_CREATE_TIME) . '</td>'
						. '<td>' . $this -> getColumnData($row, COLUMN_TO_ACCOUNT) . ' ' . $this -> getColumnData($row, COLUMN_LAST_NAME) . DELIMIT_SPACE . $this -> getColumnData($row, COLUMN_FIRST_NAME) . '</td>'
						. '<td class="r">' . $this -> getColumnData($row, COLUMN_CURRENCY) . ' ' . $this -> getAmountString($this -> getColumnData($row, COLUMN_AMOUNT), $this -> getColumnData($row, COLUMN_CURRENCY)) . '</td>'
						. '<td class="l">' . $this -> getColumnData($row, COLUMN_MESSAGE) . '</td>'
						. '<td><a href="javascript:goDetail(\'' . $this -> getColumnData($row, COLUMN_R_ID) . '\');"><span class="fa fa-info-circle fa-lg"></span></a></td>'
						. '</tr>';
			}

			$rtn .= '</table>';
		} else {
			$rtn = '<p class="red">' . $this -> getMessage(INFO, 'I_NO_MORE_REQUEST', array()) . '</p>';
		}

		echo $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 引落IDの取得
	* @parameter	: なし
	* @return		: 引落ID
	-------------------------------------------------------------------------*/
	public function getRId() {
		return $this -> rId;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 引落IDの取得
	* @parameter	: なし
	* @return		: 引落ID
	-------------------------------------------------------------------------*/
	public function echoRId() {
		echo $this -> rId;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 金額の取得
	* @parameter	: なし
	* @return		: 金額
	-------------------------------------------------------------------------*/
	public function echoAmount() {
		echo $this -> amount;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 金額の取得
	* @parameter	: なし
	* @return		: 金額
	-------------------------------------------------------------------------*/
	public function dispAmount() {
		echo $this -> formatCurrency($this -> amount, $this -> currency);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 通貨の取得
	* @parameter	: なし
	* @return		: 通貨
	-------------------------------------------------------------------------*/
	public function echoCurrency() {
		echo $this -> currency;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 通貨の取得
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	public function dispCurrency() {
		echo $this -> dispCurrencyOptionList($this -> currency, false);
	}

	/*-------------------------------------------------------------------------
	* @function_name: メッセージの取得
	* @parameter	: なし
	* @return		: メッセージ
	-------------------------------------------------------------------------*/
	public function getRequestMessage() {
		return $this -> message;
	}

	/*-------------------------------------------------------------------------
	* @function_name: メッセージの取得
	* @parameter	: なし
	* @return		: メッセージ
	-------------------------------------------------------------------------*/
	public function echoRequestMessage() {
		echo $this -> message;
	}

	/*-------------------------------------------------------------------------
	* @function_name: メッセージの取得
	* @parameter	: なし
	* @return		: メッセージ
	-------------------------------------------------------------------------*/
	public function getSendMessage() {
		return $this -> sendMessage;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: メッセージの取得
	* @parameter	: なし
	* @return		: メッセージ
	-------------------------------------------------------------------------*/
	public function echoSendMessage() {
		echo $this -> sendMessage;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座番号の取得
	* @parameter	: なし
	* @return		: 口座番号
	-------------------------------------------------------------------------*/
	public function getUserAccount() {
		return $this -> userAccount;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座番号の取得
	* @parameter	: なし
	* @return		: 口座番号
	-------------------------------------------------------------------------*/
	public function echoUserAccount() {
		echo $this -> userAccount;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座名の取得
	* @parameter	: なし
	* @return		: 口座名
	-------------------------------------------------------------------------*/
	public function echoName() {
		echo (strlen(trim($this -> name)) ? $this -> name : $this -> toName);
	}
	
	/*-------------------------------------------------------------------------
	 * -- anton --
	 * @function_name: echoReceiver
	 * @parameter	: なし
	 * @return		: receiver's name
	 -------------------------------------------------------------------------*/
	public function echoReceiver() {
		echo $this -> receiver;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 作成日時の取得
	* @parameter	: なし
	* @return		: 作成日時
	-------------------------------------------------------------------------*/
	public function echoCreateTime() {
		echo $this -> createTime;
	}

	/*-------------------------------------------------------------------------
	* @function_name: iwallet口座番号（申請先）の取得
	* @parameter	: なし
	* @return		: iwallet口座番号（申請先）
	-------------------------------------------------------------------------*/
	public function echoFromAccount() {
		echo $this -> fromAccount;
	}

	/*-------------------------------------------------------------------------
	* @function_name: iwallet口座番号（申請元）の取得
	* @parameter	: なし
	* @return		: iwallet口座番号（申請元）
	-------------------------------------------------------------------------*/
	public function echoToAccount() {
		echo $this -> toAccount;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 引き落とし通貨の取得
	* @parameter	: なし
	* @return		: 引き落とし通貨
	-------------------------------------------------------------------------*/
	public function echoDebitCurrency() {
		echo $this -> debitCurrency;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 引き落とし申請ステータスの取得
	* @parameter	: なし
	* @return		: 引き落とし申請ステータス
	-------------------------------------------------------------------------*/
	public function echoStatus() {
		echo $this -> status;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 申請元名義の取得
	* @parameter	: なし
	* @return		: 申請元名義
	-------------------------------------------------------------------------*/
	public function echoToName() {
		echo $this -> toName;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 引き落とし金額の取得
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	public function dispDeibtAmount() {

		if($this -> status == VAL_INT_1) {
			echo $this -> getAmountString($this -> deibtAmount, $this -> debitCurrency);
		} else {
			echo NO_STRING;

		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: 引き落とし時レートの取得
	* @parameter	: なし
	* @return		: 引き落とし時レート
	-------------------------------------------------------------------------*/
	public function dispRate() {

		if($this -> status == VAL_INT_1) {
			echo $this -> rate;
		} else {
			echo NO_STRING;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: 履歴の取得
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	public function dispHistory() {

		// 変数宣言部
		$rtn = NO_STRING;
		$list = array();

		// データが存在する場合
		if($this -> isLoopData($this -> history)) {

			// データを作り直す
			foreach($this -> history as $row) {
				$list[] = array(PARAM_DATA_KEY		=> $this -> getColumnData($row, COLUMN_FROM_ACCOUNT)
								, PARAM_DATA_VALUE	=> $this -> getColumnData($row, COLUMN_MAIL) . ' (' . $this -> getColumnData($row, COLUMN_FROM_ACCOUNT) . ')');
			}

			$rtn = $this -> dispListOption($list, $this -> userAccount);
		}

		echo $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: バランスの取得
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	public function dispBalances() {

		// 変数宣言部
		$rtn 	= NO_STRING;
		$lists	= array();

		// データを入れ替える
		if($this -> isLoopData($this -> balances)) {

			foreach($this -> balances as $row) {
				$lists[$this -> getColumnData($row, COLUMN_CURRENCY)] = $row;
			}
		}

		if($this -> isLoopData($this -> currencies)) {
			foreach($this -> currencies as $row) {

				$currency	= $this -> getColumnData($row, COLUMN_CURRENCY_NAME);
				$data		= $this -> getColumnData($lists, $currency);
				$amount		= NO_COUNT;

				// データを生成
				if($data == NO_STRING) {	// データが無い
					$amount = $this -> getAmountString($amount, $currency);
				} else {
					$amount = $this -> getAmountString($this -> getColumnData($data, COLUMN_BALANCE), $currency);
				}

				$rtn .= '<label class="w33p"><input type="radio" name="from_currency" value="' . $currency . '"> ' . $currency . ' - ' . $amount . '</label>';
			}
		}

		echo $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: ユーザデータの設定
	* @parameter	: 出金リスト
	* @return		: なし
	-------------------------------------------------------------------------*/
	public function setUser($rs) {
		$this -> user = $this -> getRowData($rs);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 引落履歴の設定
	* @parameter	: 出金リスト
	* @return		: なし
	-------------------------------------------------------------------------*/
	public function setHistory($rs) {
		$this -> history = $rs;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 引落リストの設定
	* @parameter	: 引落リスト
	* @return		: なし
	-------------------------------------------------------------------------*/
	public function setResult($rs) {
		$this -> rs = $rs;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 通貨のバランスデータの設定
	* @parameter	: 結果セット
	* @return		: なし
	-------------------------------------------------------------------------*/
	function setBalances($rs) {
		$this -> balances = $rs;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 通貨のの設定
	* @parameter	: 結果ット
	* @return		: なし
	-------------------------------------------------------------------------*/
	function setCurrencies($rs) {
		$this -> currencies = $rs;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: パラメータの再設定
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	public function restore($restore = true) {
		$this -> name				= $this -> getColumnData($this -> user, COLUMN_FIRST_NAME)
										. DELIMIT_SPACE . $this -> getColumnData($this -> user, COLUMN_LAST_NAME);						// 口座名義
		
			
		if($restore){
			
			$this -> receiver = sprintf("%s %s", $this -> getColumnData($this -> user, COLUMN_FROM_LAST_NAME), 
					$this -> getColumnData($this -> user, COLUMN_FROM_FIRST_NAME));
			
			$this -> toName				= $this -> getColumnData($this -> user, COLUMN_TO_LAST_NAME)
			. DELIMIT_SPACE . $this -> getColumnData($this -> user, COLUMN_TO_FIRST_NAME);					// 口座名義（申請元）
			
			$this -> userAccount		= $this -> getColumnData($this -> user, COLUMN_USER_ACCOUNT);										// iwallet口座番号（申請先）
			$this -> fromAccount		= $this -> getColumnData($this -> user, COLUMN_FROM_ACCOUNT);										// iwallet口座番号（申請先）
			$this -> toAccount			= $this -> getColumnData($this -> user, COLUMN_TO_ACCOUNT);											// iwallet口座番号（申請元）
			$this -> currency			= $this -> getColumnData($this -> user, COLUMN_CURRENCY);											// 通貨
			$this -> amount				= $this -> intToCurrency($this -> getColumnData($this -> user, COLUMN_AMOUNT), $this -> currency);	// 金額
			$this -> message			= $this -> getColumnData($this -> user, COLUMN_MESSAGE);											// メッセージ
			$this -> createTime			= $this -> getColumnData($this -> user, COLUMN_CREATE_TIME);										// 作成日時
			$this -> status				= $this -> getColumnData($this -> user, COLUMN_STATUS);												// ステータス
			
			if($this -> getType() != TYPE_BACK) {
				$this -> sendMessage	= $this -> getColumnData($this -> user, COLUMN_SEND_MESSAGE);										// メッセージ（返信メッセージ）
			}
		}	
		
		// 引き落とし結果 //
		$this -> debitCurrency	= $this -> getColumnData($this -> user, COLUMN_DEBIT_CURRENCY);											// 引き落とし通貨
		$this -> deibtAmount	= $this -> getColumnData($this -> user, COLUMN_DEBIT_AMOUNT);											// 引き落とし金額
		$this -> rate			= $this -> getColumnData($this -> user, COLUMN_RATE);													// レート
	}
	
	/*-------------------------------------------------------------------------
	* @function_name: 登録用のデータ取得関数
	* @parameter	: なし
	* @return		: 登録用データ配列
	-------------------------------------------------------------------------*/
	public function getRegistData() {

		// 変数宣言部
		$rtn = array();

		$rtn[] = $this -> userAccount;													// 送金元口座番号
		$rtn[] = $this -> getUserData(PARAM_USER_ACCOUNT);								// 送金先口座番号
		$rtn[] = $this -> currency;														// 通貨
		$rtn[] = $this -> currencyToInt($this -> amount, $this -> currency);			// 金額
		$rtn[] = NO_COUNT;																// ステータス
		$rtn[] = addslashes($this -> message);											// メッセージ
		$rtn[] = $this -> getTransactionNumberCommon(VAR_TRANSACTION_REQUEST_WITHDRAW);	// 取引番号

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: メール送信用のデータ取得関数
	* @parameter	: なし
	* @return		: メール送信用データ配列
	-------------------------------------------------------------------------*/
	public function getSendData() {

		// 変数宣言部
		$rtn = array();

		$rtn[] = $this -> userAccount;											// 送金元口座番号
		$rtn[] = $this -> getUserNameCommon($this -> userAccount);				// 送金元ユーザ氏名
		$rtn[] = $this -> getUserData(PARAM_USER_ACCOUNT);						// 送金先口座番号
		$rtn[] = $this -> getCurrentTimeCommon();								// 現在時刻
		$rtn[] = $this -> currency;												// 通貨
		$rtn[] = $this -> formatCurrency($this -> amount, $this -> currency);	// 金額
		$rtn[] = addslashes($this -> message);									// メッセージ

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 削除用のデータ取得関数
	* @parameter	: なし
	* @return		: 削除用データ配列
	-------------------------------------------------------------------------*/
	public function getDeleteData() {

		// 変数宣言部
		$rtn = array();

		$rtn[] = $this -> rId;													// 引き落し申請番号

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 更新用のデータ取得関数
	* @parameter	: なし
	* @return		: 更新用データ配列
	-------------------------------------------------------------------------*/
	public function getSaveParams() {

		// 変数宣言部
		$rtn = array();

		$rtn[] = $this -> rId;
		$rtn[] = $this -> fromCurrency;
		$rtn[] = $this -> currencyToInt($this -> amount, $this -> fromCurrency);
		$rtn[] = $this -> status;
		$rtn[] = $this -> rate;
		$rtn[] = addslashes($this -> sendMessage);
		$rtn[] = $this -> currencyToInt($this -> fee, $this -> fromCurrency);
		$rtn[] = $this -> currencyToInt($this -> fee2, $this -> currency);

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 更新用のデータ取得関数
	* @parameter	: なし
	* @return		: 更新用データ配列
	-------------------------------------------------------------------------*/
	public function getRollBackParams() {

		// 変数宣言部
		$rtn = array();

		$rtn[] = $this -> rId;
		$rtn[] = $this -> status;
		$rtn[] = addslashes($this -> sendMessage);

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: メール送信用（否認時）のデータ取得関数
	* @parameter	: なし
	* @return		: メール送信用（否認時）データ配列
	-------------------------------------------------------------------------*/
	public function getSendRollBackParams() {

		// 変数宣言部
		$request	= null;
		$rtn		= array();
		$row		= null;

		$request	= $this -> getRequestCommon($this -> getRId());
		$row		= $this -> getRowData($request);

		$rtn[] = $this -> getColumnData($row, COLUMN_TO_ACCOUNT);
		$rtn[] = $this -> getColumnData($row, COLUMN_TO_FIRST_NAME)
					. DELIMIT_SPACE . $this -> getColumnData($row, COLUMN_TO_LAST_NAME);
		$rtn[] = $this -> getColumnData($row, COLUMN_FROM_ACCOUNT);
		$rtn[] = $this -> getColumnData($row, COLUMN_CREATE_TIME_STRING);
		$rtn[] = $this -> getColumnData($row, COLUMN_CURRENCY);
		$rtn[] = $this -> getAmountString($this -> getColumnData($row, COLUMN_AMOUNT), $this -> getColumnData($row, COLUMN_CURRENCY));
		$rtn[] = $this -> getColumnData($row, COLUMN_MESSAGE);
		$rtn[] = $this -> getCurrentTimeCommon();
		$rtn[] = addslashes($this -> sendMessage);
		$rtn[] = $this -> getColumnData($row, COLUMN_TO_MAIL);

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: メール送信用（認証時）のデータ取得関数
	* @parameter	: なし
	* @return		: メール送信用（認証時）データ配列
	-------------------------------------------------------------------------*/
	public function getSendCompleteParams() {

		// 変数宣言部
		$request	= null;
		$rtn		= array();
		$row		= null;

		$request	= $this -> getRequestCommon($this -> getRId());
		$row		= $this -> getRowData($request);
		$rtn[] = $this -> getColumnData($row, COLUMN_TO_ACCOUNT);
		$rtn[] = $this -> getColumnData($row, COLUMN_TO_FIRST_NAME)
				. DELIMIT_SPACE . $this -> getColumnData($row, COLUMN_TO_LAST_NAME);
		$rtn[] = $this -> getColumnData($row, COLUMN_FROM_ACCOUNT);
		$rtn[] = $this -> getColumnData($row, COLUMN_CREATE_TIME_STRING);
		$rtn[] = $this -> getColumnData($row, COLUMN_CURRENCY);
		$rtn[] = $this -> getAmountString($this -> getColumnData($row, COLUMN_AMOUNT), $this -> getColumnData($row, COLUMN_CURRENCY));
		$rtn[] = $this -> getColumnData($row, COLUMN_MESSAGE);
		$rtn[] = $this -> getCurrentTimeCommon();
		$rtn[] = $this -> fromCurrency;
		$rtn[] = $this -> formatCurrency($this -> amount, $this -> fromCurrency);
		$rtn[] = addslashes($this -> sendMessage);
		$rtn[] = $this -> getColumnData($row, COLUMN_TO_MAIL);

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: メール送信用（認証時）のデータ取得関数
	* @parameter	: なし
	* @return		: メール送信用（認証時）データ配列
	-------------------------------------------------------------------------*/
	public function getSendInfoParams() {

		// 変数宣言部
		$request	= null;
		$rtn		= array();
		$row		= null;

		$request	= $this -> getRequestCommon($this -> getRId());
		$row		= $this -> getRowData($request);

		$rtn[] 		= $this -> getColumnData($row, COLUMN_FROM_ACCOUNT);
		$rtn[]		= $this -> getUserNameCommon($this -> getColumnData($row, COLUMN_FROM_ACCOUNT));
		$rtn[] 		= $this -> getColumnData($row, COLUMN_TO_ACCOUNT);
		$rtn[]	 	= $this -> getColumnData($row, COLUMN_TRANSACTION_NUMBER);
		$rtn[]      = date("Y-m-d H:i:s");
		$rtn[] 		= $this -> fromCurrency;
		$rtn[] 		= $this -> formatCurrency($this -> amount, $this -> fromCurrency);
		$rtn[] 		= addslashes($this -> getColumnData($row, COLUMN_MESSAGE));
		$rtn[] 		= $this -> getColumnData($row, COLUMN_FROM_MAIL);
		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 更新用のデータ取得関数
	* @parameter	: なし
	* @return		: 更新用データ配列
	-------------------------------------------------------------------------*/
	public function getRemoveParams() {

		// 変数宣言部
		$rtn = array();

		$rtn[] = $this -> rId;
		$rtn[] = VAL_INT_1;

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: エージェントコミッション1
	* @parameter	: なし
	* @return		: 更新用データ配列
	-------------------------------------------------------------------------*/
	public function getComssion1Params() {

		// 変数宣言部
		$rtn = array();

		$rtn[] = $this -> agent1;
		$rtn[] = VAR_TRANSFER;
		$rtn[] = $this -> fromCurrency;
		$rtn[] = $this -> currencyToInt($this -> fee, $this -> fromCurrency);

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: エージェントコミッション2
	* @parameter	: なし
	* @return		: 更新用データ配列
	-------------------------------------------------------------------------*/
	public function getComssion2Params() {

		// 変数宣言部
		$rtn = array();

		$rtn[] = $this -> agent2;
		$rtn[] = VAR_TRANSFER;
		$rtn[] = $this -> fromCurrency;
		$rtn[] = $this -> currencyToInt($this -> fee2, $this -> fromCurrency);

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: HTML表示用のデータ取得関数
	* @parameter	: なし
	* @return		: HTML表示用データ配列
	-------------------------------------------------------------------------*/
	public function dispHTML() {
		return array();
	}

}
?>
