<?php
$page_title = "China Local Bank Transfer Deposit Application";
include_once('template/base_head.php');

?>
			<!-- サイドバー -->
			<aside id="colLeft">
				<h1><a href="/en/menu"><img src="../img/logo.png" alt="iWallet"></a></h1>
<?php include_once('template/base_sidebar.php'); ?>
			</aside>
			<!-- /サイドバー -->
			<!-- メインカラム -->
			<div id="colMain">
				<div class="mainIn">
<?php include_once('template/base_nav.php'); ?>
					<article>
						<div class="article-heading">
							<h2><?php echo $page_title; ?></h2>
						</div>
                        <div class="mb10 pleft40"><?php echo $this -> echoMessage(); ?></div>
							<p class="pleft40 mb20 respM">Please review the deposit details and read the note below before making any transactions.</p>

							<div class="pleft40">
							<table class="table col bdr default odd  fontM summaryT">
										<tr>
												<th style="width: 180px;" colspan="2">Account Details</th>
										</tr>
                    <tr>
                        <th style="width: 180px;">Account Number</th>
                        <td class="ralign"><?php echo $this -> getUserData(PARAM_USER_ACCOUNT); ?></td>
                    </tr>
                    <tr>
                        <th style="width: 180px;">First Name</th>
                        <td class="ralign"><?php $this -> echoUserData(PARAM_FIRST_NAME); ?></td>
                    </tr>
                    <tr>
                        <th style="width: 180px;">Last Name</th>
                        <td class="ralign"><?php $this -> echoUserData(PARAM_LAST_NAME); ?></td>
                    </tr>
                    <tr>
                        <th style="width: 180px;">Email Address</th>
                        <td class="ralign"><?php $this -> echoUserData(PARAM_MAIL); ?></td>
                    </tr>
                    <tr>
                        <th style="width: 180px;">Country</th>
                        <td class="ralign"><?php $this -> echoCountryName(); ?></td>
                    </tr>
							</table>
							<br>
							<table class="table col bdr default odd  fontM summaryT">
                    <tr>
                        <th style="width: 180px;" colspan="2">Deposit Details</th>
                    </tr>
                    <tr>
                        <th style="width: 180px;">Debit Amount</th>
                        <td class="ralign"><?php echo $this -> getCurrency();?>&nbsp;<?php $this -> echoDepositAmountNatural(); ?></td>
                    </tr>
                    <tr>
                        <th style="width: 180px;">Credit Amount</th>
                        <td class="ralign"><?php echo $this -> getCurrency();?>&nbsp;<?php $this -> echoAmount(); ?></td>
                    </tr>
                    <tr>
                        <th style="width: 180px;">Transaction Fee</th>
                        <td class="ralign"><?php echo $this -> getCurrency();?>&nbsp;<?php $this -> echoFee(); ?></td>
                    </tr>
                    <tr>
                        <th style="width: 180px;">Message</th>
                        <td class="ralign"><?php echo $this -> message; ?></td>
                    </tr>
              </table>
							</div>
               <br />
               <br />
               <div class="container_wi650">
                   <ul class="pleft40 ul_list">
										 <li>Please use the bank account details provided on the next page to settle the payment via electronic banking. Be careful when providing the account number, iWallet will not be liable for any funds not reflected on the iWallet account due to customer’s inconsistency.</li>
										 <li>Please pay for the exact amount. Payments must be made within thirty (30) min from the time of your deposit application in order to avoid delays. For deposits made after an hour, please contact our Customer Support team so we can guide you with the next steps in order to have the funds credited to your iWallet account.</li>
										 <li>Please do not forget to indicate the reference number provided on the payment page when you settle your payments. If you fail to indicate your reference number, the deposit request will not be processed immediately.</li>
										 <li>You may deposit an amount from CNY 500 to CNY 49,000.</li>
										 <li>A transaction fee, 1.60% of the amount deposited, will be charged to the member. The funds will be reflected on your iWallet account.</li>
										 <li>Deposit via electronic banking is real time. The funds received will be instantly credited to your iWallet account. If you fail to receive it in your iWallet account after 2 business days, please contact our Customer Support team along with the remittance statement.</li>
										 <li>Keep the remittance statement as it is necessary when making an inquiry or follow-up on your deposit.</li>
										 <li>A transfer fee may be assessed by your bank when settling the amount.</li>
										 <li>We do not recommend payments via ATM or over the counter. Otherwise, your money will not be credited immediately and might take 7 business days to receive the funds.</li>
										 <li>The option to cancel any request for this payment method is not available. You may withdraw the funds once reflected on your iWallet account.</li>
										 <li>For questions and inquiries, please contact our <a href="https://secure.iwl.world/en/support" target="_blank" class="blue_text">Customer Support</a> along with the remittance statement.</li>
                   </ul>
									 <div style="margin-top:50px" class="red pleft40">※To continue your transaction, click "Next." You will be redirected to the bank information page to settle your deposit transaction.
									 </div>
               </div>
               <div class="calign nextwbtn" style="    margin-top: 10px;">
                   <a id="btnBackLbtcInput" class="btn bg-default calign">&laquo; Back</a>&emsp;
                   <a id="btnLbtcSendAPI" class="btn bg-grad px180 mt10" href="">Next</a>
               </div>
               <form id="acForm" action="" method="post">
                   <input type="hidden" value="" id="type" name="type" />
               </form>

               <form id="lbtcForm" action="<?php echo SD_DEPOSIT_API_URL;?>" method="post">
                   <input type="hidden" name="content" value="<?php echo $this -> sdPayEncrypted; ?>" />
               </form>
					</article>
				</div>
			</div>
			<!-- /メインカラム -->
		</div>
<?php include_once('template/base_foot.php'); ?>
	</div>
	<script src="../js/deposit.js"></script>
</body>
</html>
