<?php
include_once('config.php');

class H2PWithdrawalWebhook extends System {
 
    private $transactionNum     = NO_STRING;
    private $transactionKey     = NO_STRING;
    private $memberCode         = NO_STRING;
    private $status             = NO_STRING;
    
    // directories
    private $successLog;
    private $errorLog;
    private $accessLog;
    
    public function __construct(){
        parent::__construct();
        
        $this -> setParameter();
        $this -> validation();
    }
    
    private function setParameter(){
        $this -> transactionNum     = $this -> getDataPost("TransactionID");
        $this -> transactionKey     = $this -> getDataPost("Key");
        $this -> memberCode         = $this -> getDataPost("MemberCode");
        $this -> status             = $this -> getDataPost("Status");
        
        $this -> successLog = "Logs/H2P_Withdrawal/callback/success";
        $this -> errorLog   = "Logs/H2P_Withdrawal/callback/error";
        $this -> accessLog  = "Logs/H2P_Withdrawal/callback/access";
    }
    
    private function validation(){
        if(!file_exists($this -> successLog)) {
            mkdir($this -> successLog, 0777, true);
        }
        
        if(!file_exists($this -> errorLog)) {
            mkdir($this -> errorLog, 0777, true);
        }
        
        if(!file_exists($this -> accessLog)) {
            mkdir($this -> accessLog, 0777, true);
        }
    }
    
    private function emailParams($status, $result){
        $params = [];
        
        $memberCode = $this -> getColumnData($result, COLUMN_USER_ACCOUNT);
        $amount     = $this -> getColumnData($result, COLUMN_AMOUNT);
        
        switch($status){
            case "000":
                $date = date('Y-m-d H:i:s');
                $newdate = strtotime ('-1 hour' , strtotime($date)) ;
                $newdate = date('Y-m-d H:i:s', $newdate);
                
                $params = [
                    $memberCode,
                    $this -> getUserNameCommon($memberCode),
                    $this -> getColumnData($result, COLUMN_CURRENCY),
                    number_format($amount, 2, ".", NO_STRING),
                    $newdate
                ];
                
                break;
            case "001":
                $params = [
                    $memberCode,
                    $this -> getUserNameCommon($memberCode)
                ];
                break;
        }
        
        return $params;
    }
    
    public function listen(){
        $logDate = date("Y-m-d");
        $response = implode("&", $_POST);
        
        //log the access details
        error_log(
            date("[Y-m-d H:i:s]")."\r\nAccessed: {$response}\r\n\r\n", 
            VAL_INT_3, 
            "{$this -> accessLog}/Log_{$logDate}.log"
        );
        
        if($this -> transactionNum != NO_STRING && $this -> transactionKey != NO_STRING){
            $result = $this -> getRowData($this -> accessSelect('SELECT_WITHDRAW_H2P_TEMP', array($this -> transactionNum)));
            
            if($this -> isLoopData($result)){
                $memberCode = $this -> getColumnData($result, COLUMN_USER_ACCOUNT);
                $bankCode   = $this -> getColumnData($result, COLUMN_RECEIPT_BANK_NAME);
                $language   = $this -> getColumnData($result, COLUMN_LANGUAGE);
                
                if(strcasecmp($this -> transactionKey, $this -> getColumnData($result, "api_key")) === 0){
                    $param = [];
                    
                    if($this -> memberCode == $memberCode){
                        $param[] = $this -> transactionNum;
                        $param[] = $response.'Bank_code:'.$bankCode;
                        
                        switch($this -> status){
                            case "000":
                                //update withdraw
                                $param[] = VAL_INT_2;
                                $this -> accessModifyCommon('UPDATE_WITHDRAW_H2P_STATUS', $param);
                                $this -> accessModifyCommon('UPDATE_WITHDRAW_H2P_TEMP_STATUS', $param);
                                 
                                $this -> sendMailByTmp(
                                    "{$language}/withdraw_h2p_success.xml",
                                    $this -> emailParams($this -> status, $result),
                                    $this -> getUserEMailCommon($memberCode),
                                    VAR_CS_MAIL_ADDRESS
                                );
                                
                                error_log(
                                    date("[Y-m-d H:i:s]")."\r\nsuccess status:\r\n\r\n{$response}\r\n\r\n",
                                    VAL_INT_3,
                                    "{$this -> successLog}/Log_{$logDate}.log"
                                );
                                break;
                            case "001":
                                //update withdraw
                                $param[] = VAL_INT_5;
                                $this -> accessModifyCommon('UPDATE_WITHDRAW_H2P_STATUS', $param);
                                $this -> accessModifyCommon('UPDATE_WITHDRAW_H2P_TEMP_STATUS', $param);
                                
                                $this -> sendMailByTmp("{$language}/withdraw_h2p_fail.xml",
                                    $this -> emailParams($this -> status, $result),
                                    $this -> getUserEMailCommon($memberCode),
                                    VAR_CS_MAIL_ADDRESS
                                );
                                
                                error_log(
                                    date("[Y-m-d H:i:s]")."\r\nfail status:\r\n\r\n{$response}\r\n\r\n", 
                                    VAL_INT_3, 
                                    "{$this -> errorLog}/Log_{$logDate}.log"
                                );
                                break;
                            default:
                                //error, status not valid
                                error_log(
                                    date("[Y-m-d H:i:s]")."\r\nError status code invalid:\r\n\r\n{$response}\r\n\r\n{$this -> status}\r\n\r\n", 
                                    VAL_INT_3, 
                                    "{$this -> errorLog}/Log_{$logDate}.log"
                                );
                                break;
                        }
                    }else{
                        //error, member code not valid
                        error_log(
                            date("[Y-m-d H:i:s]")."\r\nError member code invalid: {$memberCode}\r\n\r\n",
                            VAL_INT_3,
                            "{$this -> errorLog}/Log_{$logDate}.log"
                        );
                    }   
                }else{
                    //error, status not valid
                    error_log(
                        date("[Y-m-d H:i:s]")."\r\nKey invalid:\r\n\r\n{$response}\r\n\r\n", 
                        VAL_INT_3, 
                        "{$this -> errorLog}/Log_{$logDate}.log"
                    );
                }
            }
        }
    }
}

$withdrawal = new H2PWithdrawalWebhook();
$withdrawal -> listen();