
<?php
require_once('config.php');

class APIGetNews extends System {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $signature		= NO_STRING;
	private $account		= NO_STRING;
	private $lang			= NO_STRING;

	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: パスワードの更新
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function action() {

		// 変数宣言部
		$rtn		= array();
		$base		= null;

		try {

			// パラメータの設定
			$this -> signature		= $this -> getDataPost(PARAM_SIGNATURE);
			$this -> account		= $this -> getDataPost(PARAM_USER_ACCOUNT);
			$this -> lang			= $this -> getDataPost(PARAM_LANGUAGE);

			// シグネチャのチェック（デバッグの場合は処理しない）
			if($this -> getDataPost('debug') == NO_STRING) {
				$this -> checkSignature($this -> signature, 'N' . $this -> account);
			}

			// エラーチェック
			$this -> validate();

			// 変数宣言部
			$params		= array();
			$rtn		= array();
			$rs			= null;

			// 言語指定
			if($this -> lang == 'ja') {
				$lang = NO_COUNT;
			} else if($this -> lang == 'en') {
				$lang = VAL_INT_1;
			} else {
				$lang = VAL_INT_1;
			}

			$params[] = $this -> account;	// ユーザアカウント
			$params[] = $lang;				// 言語

			// お知らせの取得
			$rs = $this -> accessSelect('LIST_NEWS_USER_ALL', $params);

			echo json_encode(array('result'		=> 'OK'
								, 'messages'	=> 'I_COMPLETE_PROCESS'
								, 'history'		=> $rs));

		} catch (Exception $e) {
			$rtn = array('result'		=> 'NG'
						, 'messages'	=> $e -> getMessage());

			echo json_encode($rtn);
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: エラーチェック
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function validate() {
	}
}

$api = new APIGetNews();
$api -> action();
?>