<?php
include_once('config.php');

// 変数宣言部
$sys		= new System();
$currencies	= null;
$base		= NO_STRING;
$cnt		= NO_COUNT;
$rates		= array();
$rate		= array();
$cName		= NO_STRING;
$rtn		= array();

// レートを取得する
// $data = file_get_contents('http://' . SITE_DOMAIN . '/test.php');
$data = file_get_contents('http://openexchangerates.org/api/latest.json?app_id=a9f574ab6cdd4be2823caf166e1051b0');
$data = json_decode($data);

$base = $data -> base;

// 通過データを取得
$currencies = $sys -> accessSelect('LIST_MST_CURRENCY_ACTIVE', array());

// 各通貨のレートを取得する
if($sys -> isLoopData($currencies)) {
	for($cnt = NO_COUNT; $cnt < count($currencies); $cnt++) {

		$row = $currencies[$cnt];

		$cName	= $sys -> getColumnData($row, COLUMN_CURRENCY_NAME);
		$rate	= array();

		// 通貨データを設定していく
		$rate['rate'] = $data -> rates -> {$cName};

		$rates[$cName] = $rate;
	}
}

// データ履歴を取る
$sys -> accessModify('INSERT_EXCHANGE_RATE_HISTORY', array(), false);

// データの一旦削除
$sys -> accessModify('DELETE_EXCHANGE_RATE', array(), false);

// 各通貨のレートを設定する
foreach($rates as $name => $val) {

	foreach($rates as $nameSub => $valSub){
		$r = array();

		$r['from']		= $nameSub;
		$r['to']		= $name;
		$r['rate']		= $val['rate'] / $valSub['rate'];
		$r['original']	= $r['rate'];

		// スプレッド追加（とりあえず固定値）
		if($r['rate'] > VAL_INT_1) {
			$r['rate'] *= 0.975;
		}

		if($r['rate'] < VAL_INT_1) {
			$r['rate'] *= 0.975;
		}

		$rtn[$nameSub][]	= $r;

		// データの登録
		$sys -> accessModify('INSERT_EXCHANGE_RATE', array($r['from']
															, $r['to']
															, $r['rate']
															, $r['original'])
							, false);
	}
}

print_r($rtn);
?>