<?php

/**
 *
 * load classes and traits dynamically.
 *
 */
function loadModules(){
    $focusedDir = __DIR__;
    
    loopDir("{$focusedDir}/config", function($confs) use ($focusedDir){
        if($confs == 'config.php'){
            if(!defined("BI_CONFIG"))
                define("BI_CONFIG", require_once("{$focusedDir}/config/{$confs}"));
        }
    });
    
    loopDir("{$focusedDir}/traits", function($traits) use ($focusedDir){
        include_once("{$focusedDir}/traits/{$traits}");
    });
    
    loopDir("{$focusedDir}/parent", function($parent) use ($focusedDir){
       include_once("{$focusedDir}/parent/{$parent}");
    });
    
    loopDir("{$focusedDir}/open", function($openClass) use ($focusedDir){
        include_once("{$focusedDir}/open/{$openClass}");
    });
        
    loopDir($focusedDir, function($entry) use ($focusedDir){
        switch($entry){
            case "traits":
            case "config":
            case "open":
            case "parent":
            case "loader.php":
                return;
        }
        
        include_once("{$entry}");
        
    });
}

/**
 *
 * Just a tool to loop the files from a specified dir.
 *
 * @param String $dirPath
 * @param String $callback
 */
function loopDir($dirPath, $callback){
    if(!is_dir($dirPath))
        return;
           
    $dirFiles = array_diff(scandir($dirPath), array('.', '..'));
    
    foreach($dirFiles as $file){
        $callback($file);
    }
}

/**
 *
 *
 * listener
 */
function listen(){
    $mngr = new TransactionManager();
    $mngr -> fetchResults();
}
