<?php
require_once(SITE_LOGICS . 'settlement/logic.php');

class ControlSettlement extends LogicSettlement {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/

	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: コントロールパネルシステム動画データ編集ロジック（各クラス共通）
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function action() {
		try {
		    $this -> checkAvailability("site", function(){
		        require_once $this -> getUserHTML('TEMPLATE_MAINTENANCE_MODE_SITE_PATH');
		        exit();
		    });
		    
			// アクション実行
			$this -> logic();
			
			switch($this -> getType()){
			    case TYPE_SETTLEMENT_EXPRESS_API:
			        require_once($this -> getUserHTML('TEMPLATE_SETTLEMENT_API_PATH'));
			        break;
			    case TYPE_SETTLEMENT_EXPRESS_CHECK:
			        $this -> echoValidationResult();
			        break;
			    case TYPE_FAIL:
			        require_once($this -> getUserHTML('TEMPLATE_SETTLEMENT_FAIL_PATH'));
			        break;
			}

		} catch (Exception $e) {
            header("Location: /{$this -> getLangage()}");
		}
	}
}
?>