<?php

/**
 * 
 * @author antonio
 *
 */
trait ValidationExpression {
    
    public function getCheckerValues(ParamHolder $holder) : Array {
        $sys = $holder -> getSource();
        
        $conditions = [];
        if($sys instanceof System){
            $conditions = [
                [
                    "notvalid" => !$holder -> open && strcasecmp($holder -> requestMethod, "post") != 0,
                    "message" => "Invalid Request Method [{$holder -> requestMethod}].",
                    "code" => 1
                ],
                [
                    "notvalid" => !$holder -> open && empty($holder -> contentType),
                    "message" => "Content-type not defined.",
                    "code" => 2
                ],
                [
                    "notvalid" => !$holder -> open && $holder -> contentType != "application/x-www-form-urlencoded",
                    "message" => "Invalid content-type.",
                    "code" => 3
                ],
                [
                    "notvalid" => !BI_CONFIG["accessible"],
                    "message" => "This API cannot produce a result as of now.",
                    "code" => 4
                ],
                [
                    "notvalid" => !$this -> isIpAddressWhitelisted($holder -> ipAddress),
                    "message" => "Invalid IP Address [{$holder -> ipAddress}]",
                    "code" => 5
                ],
                [
                    "notvalid" => !$this -> checkView($holder -> view),
                    "message" => "Unknown View [{$holder -> view}]",
                    "code" => 6
                ],
                [
                    "notvalid" => !$holder -> open && $holder -> view == "userBalance" && empty($holder -> userAccount),
                    "message" => "[User Balance Result]: Account No. is required",
                    "code" => 7
                ],
                [
                    "notvalid" => !$holder -> open && $holder -> view == "userBalance" 
                        && count($sys -> getAccountCommon($holder -> userAccount)) === 0,
                    "message" => "[User Balance Result]: Account No. doesn't exist [{$holder -> userAccount}]",
                    "code" => 8
                ]
          ];
      }
        
      return $conditions;
    }
    
    private function checkView(String $view) : bool{
        switch($view){
            case "userBalance":
            case "processingHistory":
            case "withdrawalTotal":
            case "withdrawalTransList":
            case "userList":
            case "userTransactions":
            case "overallTransactions":
            case "withdrawalListOpen":
            case "withdrawalTotalOpen":
            case "userBalancesOpen":
            case "userAllBalanceApi":
                return true;
            default:
                return false;
        }
    }
    
    private function isIpAddressWhitelisted(String $ipAddress) : bool {
        foreach(BI_CONFIG["ipAddresses"] as $ip){
            if($ip == $ipAddress)
                return true;
        }
        
        return false;
    }
}