<?php
require_once(SITE_LOGICS . 'settlement/logic.php');

class ControlSettlement extends LogicSettlement {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/

	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: コントロールパネルシステム動画データ編集ロジック（各クラス共通）
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function action() {

		// 変数宣言部
		$result = NO_STRING;

		try {

			// アクション実行
			$result = $this -> logic();

// 			return NO_STRING;

			if($this -> getType() == CONTROL_NAME_LOGIN) {			// 決済前ログイン
				require_once($this -> getUserHTML('TEMPLATE_SETTLEMENT_LOGIN_PATH', $this -> dispHTML()));

			} else if($this -> getType() == TYPE_INPUT) {			// 決済情報入力
				require_once($this -> getUserHTML('TEMPLATE_SETTLEMENT_INPUT_PATH', $this -> dispHTML()));

			} else if($this -> getType() == TYPE_CONFIRM) {			// 決済情報確認
				require_once($this -> getUserHTML('TEMPLATE_SETTLEMENT_CONFIRM_PATH', $this -> dispHTML()));

			} else if($this -> getType() == TYPE_COMPLETE) {		// 決済情報完了
				require_once($this -> getUserHTML('TEMPLATE_SETTLEMENT_COMPLETE_PATH', $this -> dispHTML()));

			} else if($this -> getType() == TYPE_FAIL) {			// 決済情報エラー
				require_once($this -> getUserHTML('TEMPLATE_SETTLEMENT_FAIL_PATH', $this -> dispHTML()));

			} else if($this -> getType() == TYPE_REQUEST_SESSION_EXPIRED) {			// 決済情報エラー
				require_once($this -> getUserHTML('TEMPLATE_SETTLEMENT_REQUEST_EXPIRED_PATH', $this -> dispHTML()));

			} else {												// 決済情報エラー
// 				require_once($this -> getUserHTML('TEMPLATE_SETTLEMENT_LOGIN_PATH', $this -> dispHTML()));
				require_once($this -> getUserHTML('TEMPLATE_SETTLEMENT_FAIL_PATH', $this -> dispHTML()));
			}

		} catch (Exception $e) {

			if($e -> getMessage() != NO_STRING) {
				require_once($this -> getUserHTML('TEMPLATE_TMP_PROCESS_INVALID_PATH', $this -> dispHTML()));
			} else {
				require_once($this -> getUserHTML('TEMPLATE_SETTLEMENT_LOGIN_PATH', $this -> dispHTML()));
			}
		}
	}
}
?>