<?php
require_once(SITE_LOGICS . 'history/model.php');

class LogicHistory extends HistoryModelClass {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $htmlStr = NO_STRING;	// 表示用HTML文字列

	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: ロジック（各クラス共通）
	* @parameter	: なし
	* @return		: TRUE:ロジック成功、FALSE:ロジック失敗
	-------------------------------------------------------------------------*/
	function logic() {

		try {

			// 初期データ処理
			$this -> init();

			$this -> lists();
            if($this -> getType() == TYPE_EXPORT_COMMON) {	// エクスポート(共通)
				$this -> export();

			}

		} catch (Exception $e) {
			throw $e;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: データの取得
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function lists() {
		$this -> setResult($this -> accessSelect('LIST_USER_TRANSACTION', $this -> getUserAccountData()));

		$this -> setBalance($this -> accessSelect('LIST_USER_BALANCE_FROM_CURRENCY_DATE', $this -> getBalanceParams()));
	}

	/*-------------------------------------------------------------------------
	* @function_name: ページ出力文字列取得関数
	* @parameter	: なし
	* @return		: HTML文字列
	-------------------------------------------------------------------------*/
	function getDisplay() {
		return $this -> htmlStr;
	}

    /*-------------------------------------------------------------------------
	* @function_name: 失敗ファイルのエクスポート
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function export() {

		// データの作成
		$this -> makeExportData();
	}
}
?>