<?php
$page_title = "Transfer Agency Service (Japan) Application";
include_once('template/base_head.php');
?>
			<!-- サイドバー -->
			<aside id="colLeft">
				<h1><a href="/en/menu"><img src="../img/logo.png" alt="iWallet"></a></h1>
<?php include_once('template/base_sidebar.php'); ?>
			</aside>
			<!-- /サイドバー -->
			<!-- メインカラム -->
			<div id="colMain">
				<div class="mainIn">
<?php include_once('template/base_nav.php'); ?>
					<article>
						<div class="article-heading">
							<h2><?php echo $page_title; ?></h2>
						</div>
						<div class="mb10"><?php $this -> echoMessage(); ?></div>
						<form id="acForm" action="" method="post">

							<table class="table col bdr default odd withdrawT fontM mb20 ma90sp">
								<tr>
									<th>Transaction History</th>
									<td class="clr">
										<select id="withdraw_history" name="withdraw_history" class="w100p">
											<option>Choose from History</option>
											<?php $this -> dispWithdarawHistory(); ?>
										</select>
									</td>
								</tr>
								<tr>
									<th>Debit Currency</th>
									<td class="clr selectC">
										<?php $this -> dispBalances(); ?>
									</td>
								</tr>
								<tr>
									<th>Amount</th>
									<td>
                                        <input type="text" id="currency" name="currency" value="JPY" class="px70" readonly>
										<input type="text" id="amount" name="amount" value="<?php $this -> echoAmount(); ?>" class="px180 ralign">
									</td>
								</tr>
								<tr>
									<th>Account Number or IBAN</th>
									<td><input type="text" id="account_number" name="account_number" value="<?php $this -> echoAccountNumber(); ?>" class="w50p" maxlength="7"></td>
								</tr>
								<tr>
									<th>Beneficiary Name <br> (Lastname, Firstname)</th>
									<td><input type="text" id="account_name" name="account_name" placeholder="Lastname, Firstname" value="<?php $this -> echoAccountName(); ?>" class="w80p"></td>
								</tr>
								<tr>
									<th>Beneficiary Country</th>
									<td>
                                        <span class="w80p">Japan</span>
                                        <input type="hidden" id="receipt_country" name="receipt_country" class="w80p" value="JP">
									</td>
								</tr>
								<tr>
									<th>Bank Name</th>
									<td class="checkselected">
										<select id="receipt_bank_name" name="receipt_bank_name">
											<option value="" code="" disabled selected>Select Bank</option>
											<?php $this -> echoFlat3BankList(); ?>
											<option value="others" code="others">Other</option>
										</select>
										<div id="receipt_bank_name" name="receipt_bank_name" class="other_bank_container">
											<input type="text" placeholder="Please enter Bank Name" name="other_receipt_bank_name" id="receipt_bank_name" value="<?php $this -> echoReceiptBankName(); ?>" class="receipt_bank_name w80p">
										</div>
									</td>
								</tr>
								<tr>
									<th>Bank Code</th>
									<td><input type="text" id="receipt_bank_code" name="receipt_bank_code" value="<?php $this -> echoReceiptBankCode(); ?>" class="px180" maxlength="4"></td>
								</tr>
								<tr>
									<th>Bank Country</th>
									<td>
                                        <span class="w80p">Japan</span>
                                        <input type="hidden" id="receipt_bank_country" name="receipt_bank_country" class="w80p" value="JP">
									</td>
								</tr>
								<tr id="receiptBranch" style="display:none;" class="checkselected receiptBranchName">
									<th>Branch Name</th>
									<td>
										<select id="receipt_branch_name" name="receipt_branch_name">
										</select>
										<div id="receipt_branch_name" name="receipt_branch_name" class="other_bank_container">
											<input type="text" placeholder="Please enter Branch Name" name="other_receipt_branch_name" id="other_receipt_branch_name" value="<?php $this -> echoReceiptBranchName(); ?>" class="receipt_branch_name w80p">
										</div>
									</td>
								</tr>
								<tr id="receiptBranchCode" style="display:none;">
									<th>Branch Code</th>
									<td><input type="text" id="receipt_branch_code" name="receipt_branch_code" value="<?php $this -> echoReceiptBranchCode(); ?>" class="px100" maxlength="3" readonly></td>
								</tr>
								<tr>
									<th>Message</th>
									<td>
                                        <span class="w80p">Transfer Agency Service (Japan)</span>
                                        <input type="hidden" id="receipt_message" name="receipt_message" value="Transfer Agency Service (Japan)" class="w100p"/>
                                    </td>
								</tr>
							</table>

							<input type="hidden" value="" id="type" name="type" />
							<input type="hidden" value="en" id="lang" name="lang" />
						</form>
                        <strong>Note:</strong>
                        <ol class="ol_list ml50">
                            <li>Name must be written in Katakana characters.</li>
                            <li>This service only supports "Savings Account".</li>
                            <li>For non-savings bank account type or incorrect bank details, your request will be cancelled and a refund fee will be applied.</li>
                            <li>If the funds are not reflected in your bank account after 3 business days, please contact our customer support along with the transaction number.</li>
                            <li>Please enter your bank name and branch name by the official local names. <br> ※example) 三菱UFJ銀行→〇　三菱ユーエフジェイ銀行→×</li>
                        </ol>
						<p class=""><input type="button" id="btnFlat3Confirm" value="Confirm" class="btn bg-grad px180 calign"></p>
					</article>
				</div>
			</div>
			<!-- /メインカラム -->
		</div>
<?php include_once('template/base_foot.php'); ?>
	</div>
	<script src="../js/withdraw.js"></script>
</body>
</html>
