<?php
class CommonBase {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	public $cfgFile;	// 設定ファイルデータの配列
	public $messages;	// メッセージクラス

	/*-------------------------------------------------------------------------
	* @function_name: 共通基底クラスコンストラクタ
	* @detail		: 設定ファイルを読込みます
					  メッセージファイルを取得します
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {

		// 変数宣言部
		$workArr;	// 設定ファイルのデータ配列

		try {

			$workArr = parse_ini_file(CONFIGRATION_FILE_PATH, TRUE);  // セクションをパースする

			if($workArr == FALSE) { // 読み込み失敗
				throw new Exception("" , -1);
			}

			// メンバ変数へ取得データを格納する
			$this -> cfgFile = $workArr;

			// 多言語対応
			$uri = explode('/', $_SERVER['REQUEST_URI']);

			if(count($uri) >= 2) {

				// メッセージファイルが存在した場合そのファイルを利用する
				$messagePath = LIBRARIES . 'message_' . $uri[count($uri) - 2] . '.xml';


				if(file_exists($messagePath)) {		// 多言語
					$this -> messages = new Message($messagePath);		// 多言語

				} else {							// その他（デフォルト日本語）
					$this -> messages = new Message(LIBRARIES . $this -> getConfigValue(SECTION_DIR_PATH, 'MESSAGE_FILE_NAME'));		// 日本語ファイル
				}

			} else {
				$this -> messages = new Message(LIBRARIES . $this -> getConfigValue(SECTION_DIR_PATH, 'MESSAGE_FILE_NAME'));			// 日本語ファイル
			}

			// スローされなかったので、メッセージクラスを取得します
// 			$this -> messages = new Message(LIBRARIES . $this -> getConfigValue(SECTION_DIR_PATH, 'MESSAGE_FILE_NAME'));

		} catch(Exception $e) {
			throw new Exception('error message file load!' , -1);
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: メンバのファイル配列より、データを取得します
	* @detail		: 設定ファイルの値を取得します
	* @parameter	: $section[セクション値], $key[キー値]
	* @return		: 設定ファイルに対応する値（存在しない場合は空白文字）
	-------------------------------------------------------------------------*/
	function getConfigValue($section, $key) {

		// 変数宣言部
		$rtn = NO_STRING;

		if(isset($this -> cfgFile[$section][$key])) {
			$rtn = $this -> cfgFile[$section][$key];
		}

		// 設定値の返却
		return $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: メッセージの取得
	* @detail		: 対象のメッセージを取得を取得します
	* @parameter	: $level[エラーレベル], $key[キー値]
	* @return		: メッセージに対応する値（存在しない場合は空白文字）
	-------------------------------------------------------------------------*/
	function getMessage($level, $key, $elmArr) {

		// 設定値の返却
		return $this -> messages -> getMessageValue($level, $key, $elmArr);
	}

	/*-------------------------------------------------------------------------
	* @function_name: データがループを回せるデータか確認する
	* @parameter	: チェックデータ
	* @return		: ループデータ：TRUE、その他：FALSE
	-------------------------------------------------------------------------*/
	public function isLoopData($d) {

		// ループデータか判定する
		if(is_array($d)
			&& count($d) > NO_COUNT) {

			return TRUE;
		} else {
			return FALSE;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: 提示文言多语言设置
	* @parameter	: 
	* @return		: 
	-------------------------------------------------------------------------*/
	public function newMessage($uri){
		if ($uri == "ja") {
			$this -> messagePath = LIBRARIES . 'message.xml';
		}else{
			$this -> messagePath = LIBRARIES . 'message_' . $uri . '.xml';
		}
		$this -> messages = new Message($this -> messagePath);		// 多言語
	}
}

?>