<?php
date_default_timezone_set('Asia/Tokyo');
class DepositModelClass extends ModelClassEx {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $account		= null;
	private $method			= NO_STRING;
	private $amount			= NO_STRING;
	private $tAmount		= NO_STRING;
	private $payment		= NO_STRING;
	private $currency		= NO_STRING;
	private $referenceNo	= NO_STRING;	// リファレンス番号
	private $fee			= NO_STRING;	// 手数料

	/*-------------------------------------------------------------------------
	* @function_name: コントロールパネルシステムindexモデルクラスコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		// スーパークラスコンストラクタ呼び出し
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: 初期設定関数
	* @parameter	: なし
	* @return		: 成功:success、失敗:error
	-------------------------------------------------------------------------*/
	public function init() {

		try {

			// パラメータの設定
			$this -> setParameter();

			// チェック
			$this -> validate();

			// 決済金額の計算
			$this -> calculate();

			return true;

		} catch (Exception $e) {
// 			throw new Exception(NO_STRING);
			return false;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: パラメータの設定
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function setParameter() {
		$this -> method			= $this -> getDataPost(PARAM_METHOD);
		$this -> amount			= $this -> getDataPost(PARAM_AMOUNT);
		$this -> currency 		= $this -> getDataPost(PARAM_CURRENCY);
		$this -> message 		= $this -> getDataPost(PARAM_MESSAGE);
		$this -> depoistmoney 	= $this -> getDataPost('depositmoney');
		/*$this -> method			= $this -> getDataPost(PARAM_METHOD);

		$this -> tAmount		= $this -> getDataPost(PARAM_T_AMOUNT);
		$this -> referenceNo	= $this -> getDataGet('rn');			// 新ファイル名


		if($this -> method == 'INSTANTBANKTRANSFER') {	// 銀行送金の場合は金額の切り替え
			$this -> amount		= $this -> tAmount;
			$this -> currency	= JPY;
		} else {
			$this -> currency	= VAR_GPAYSAFE_CARD_CURRENCY;
		}*/

		if($this -> method == VAL_STR_VSMS_METHOD){
			$this -> setType(CASHFLOW_DEPOSIT_INPUT);
		}else if($this -> method == CASHFLOW_DEPOSIT_CONFIRM){
			$this -> setType(CASHFLOW_DEPOSIT_CONFIRM);
		}else if($this -> method == CASHFLOW_DEPOSIT_SEND){
			$this -> setType(CASHFLOW_DEPOSIT_SEND);
		}else if($this -> method == TYPE_CUP){
			$this -> setType(TYPE_CUP_INPUT);
		}else if($this -> method == TYPE_CUP_INPUT){
			$this -> setType(TYPE_CUP_CONFIRM);
		}else if($this -> method == TYPE_CUP_CONFIRM){
			$this -> setType(TYPE_CUP_CONFIRM);
		}

		// ユーザ情報の取得
		$this -> account = $this -> getRowData($this -> getAccountCommon($this -> getUserData(PARAM_USER_ACCOUNT)));
	}

	/*-------------------------------------------------------------------------
	* @function_name: サーバ側データチェック
	* @parameter	: なし
	* @return		: TRUE:成功、FALSE:失敗
	-------------------------------------------------------------------------*/
	public function validate() {

		// 変数宣言部
		$rtn		= true;
		$fee		= NO_COUNT;
		$commission	= NO_COUNT;
		$errType 	= NO_COUNT;
		if($this -> getType()		== TYPE_SUCCESS
			|| $this -> getType()	== TYPE_PENDING
			|| $this -> getType()	== TYPE_FAIL) {
			return true;
		}

		// ログインチェック
		if(!$this -> checkSiteUserLogin()) {
			throw new Exception(NO_STRING);
		}

		if($this -> getType()	== TYPE_COMPLETE
			&& $this -> method	!= NO_STRING) {

			// リミットチェック
			if(!$this -> checkGPSLimit($this -> getUserData(PARAM_USER_ACCOUNT), $this -> method, $errType)) {

				$this -> setType();

				if($errType == VAL_INT_1) {
					$this -> popUpSessionMessage(ERROR, 'E_DEPOSIT_PERMISSION', array());
				} else {
					$this -> popUpSessionMessage(ERROR, 'E_DEPOSIT_GPS_LIMIT', array());
				}

				$this -> setType(NO_STRING);
				return false;
			}
		} else if($this -> getType() == TYPE_CUP_INPUT ||
			$this -> getType() == TYPE_CUP_CONFIRM ||
			$this -> getType() == TYPE_CUP_PAYMENTSUCCESS ||
			$this -> getType() == TYPE_CUP_PAYMENTFAILURE
		) {
			$list = $this -> CheckPaymentKind();
			if($list[VAL_INT_3] == NO_COUNT){
				$this -> setType(NO_STRING);
				$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_CUPKINDCHECK_VERTIFY', array());
				return;
			}
			if($this -> getType() == TYPE_CUP_INPUT){
				//进入cashflow并进行输入时
				$account_Category = '';		//设定账号默认类别

				//为了统一，这里normal代码kYC非认证用户，vip代表KYC认证用户
				if(!$this -> checkUnlimitedStatus($this -> getUserData(PARAM_USER_ACCOUNT))) {
					$account_Category = 'normal';
				}else {
					$account_Category = 'vip';
				}

				//将账户类别保存到SESSION中
				$_SESSION['account_Category'] = $account_Category;

				// 不正防止のため、成功失敗関係なく1時間に5回まで、決済することができる。
				if(!$this -> checkCUPDeposit1Hour($this -> getUserData(PARAM_USER_ACCOUNT))) {
					$this -> popUpSessionMessage(ERROR, 'E_LIMIT_DEPOSIT_SOME_TIMES_1_HOUR', array());
					$rtn = false;
					if(!$rtn) {
						$this -> setType(NO_STRING);
						return;
					}
				}


				// 24時間以内決済成功は限制回まで。過去24時間にVIP 6回決済，Normal 3回したユーザーは、4回目エラーメッセージを表示
				if(!$this -> checkDepositByCUP24Hour($this -> getUserData(PARAM_USER_ACCOUNT))) {
					if($account_Category == 'vip'){
						$this -> popUpSessionMessage(ERROR, 'E_LIMIT_DEPOSIT_SOME_TIMES_VIP', array());
					}else if($account_Category == 'normal'){
						$this -> popUpSessionMessage(ERROR, 'E_LIMIT_DEPOSIT_SOME_TIMES_NORMAL', array());
					}

					$rtn = false;
					if(!$rtn) {
						$this -> setType(NO_STRING);
						return;
					}
				}

				/*// 30日間の決済成功累積額上限は、Normal CNY30,000まで,Vip CNY 60,000まで
				if(!$this -> checkDepositByCUP1Days($this -> getUserData(PARAM_USER_ACCOUNT))) {
					$this -> popUpSessionMessage(ERROR, 'E_LIMIT_DEPOSIT_AMOUNT', array());
					$rtn = false;
					if(!$rtn) {
						$this -> setType(NO_STRING);
						return;
					}
				}*/
			}

			if($this -> getType() == TYPE_CUP_CONFIRM){
				//确认页对输入的信息进行校验,并计算fee等信息

				//判断是个人还是法人账户
				$accounttype = $this -> getColumnData($this -> account,'account_type');

				//查看必要用户信息是否已填写，没有通知先完善用户信息
				if($accounttype == 1){
					$firstName = $this -> CallUserData(PARAM_CEO_FIRST_NAME);
					$lastName = $this -> CallUserData(PARAM_CEO_LAST_NAME);
					if(empty($firstName) || empty($lastName)){
						$this -> popUpSessionMessage(ERROR, 'E_LIMIT_CASHFLOW_DEPOSIT_INFO', array());
						$this -> setType(NO_STRING);
						return;
					}
				}

				//查看必要用户信息是否已填写，没有通知先完善用户信息
				if(!$this -> checkUserProfile()){
					$this -> popUpSessionMessage(ERROR, 'E_LIMIT_CASHFLOW_DEPOSIT_INFO', array());
					$this -> setType(NO_STRING);
					return;
				}

				//查看金额是否为空
				if(!$this -> checkNull($this -> amount)){
					$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_AMOUNT));
					$rtn = false;
					if(!$rtn) {
						$this -> setType(TYPE_CUP_INPUT);
						return;
					}
				}

				//查看入金金额是否符合规范
				if(!$this -> checkCurrencyNumber($this -> amount)){
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_VALUE_PREG', array(VAL_STR_AMOUNT));
					$rtn = false;
					if(!$rtn) {
						$this -> setType(TYPE_CUP_INPUT);
						return;
					}
				}

				//查看入金金额是否在范围内
				if($_SESSION['account_Category'] == 'vip'){
					if(($this -> amount < 200) || ($this -> amount > 60000)){
						$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE_VERTIFY', array(VAL_STR_AMOUNT));
						$rtn = false;
						if(!$rtn) {
							$this -> setType(TYPE_CUP_INPUT);
							return;
						}
					}
				}else if($_SESSION['account_Category'] == 'normal'){
					if(($this -> amount < 200) || ($this -> amount > 30000)){
						$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE_NOVERTIFY', array(VAL_STR_AMOUNT));
						$rtn = false;
						if(!$rtn) {
							$this -> setType(TYPE_CUP_INPUT);
							return;
						}
					}
				}


				// メッセージの正規表現チェック
				if(!$this -> checkStringMessage($this -> message)) {
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_REGULAR_MESSAGE', array());
					$rtn = false;
					if(!$rtn) {
						$this -> setType(TYPE_CUP_INPUT);
						return;
					}
				}

				//判断message长度是否规范
				if(!$this -> checkLength($this -> message , 0 , 250)){
					$this -> popUpSessionMessage(ERROR, 'E_LIMIT_DEPOSIT_MESSAGE', array());
					$rtn = false;
					if(!$rtn) {
						$this -> setType(TYPE_CUP_INPUT);
						return;
					}
				}

				//检查入金金额是否超限
				/*if(!$this -> checkCUPMoneyInExceed($this -> amount , $this -> currency)){
					$this -> popUpSessionMessage(ERROR, 'E_LIMIT_DEPOSIT_AMOUNT', array());
					$rtn = false;
					if(!$rtn) {
						$this -> setType(TYPE_CUP_INPUT);
						return;
					}
				}*/

				include $_SERVER['DOCUMENT_ROOT'].DIRECTORY_SEPARATOR.'system'.DIRECTORY_SEPARATOR.'lib'.DIRECTORY_SEPARATOR.'core'.DIRECTORY_SEPARATOR.'CUP_config.php';
				$commission		= $this -> intToCurrency(($this -> amount * $CUP['Transaction']['fee']),PERCENT);
				$this -> fee    = $commission + $CUP['Transaction']['transactionfee'];
				$_SESSION['CUP_Data']['user_account'] = $this -> getColumnData($this -> account, PARAM_USER_ACCOUNT);
				$_SESSION['CUP_Data']['Country'] 	= $this -> getColumnData($this -> account,PARAM_COUNTRY);
				$_SESSION['CUP_Data']['firstName'] 	= $accounttype == 1 ? $this -> getColumnData($this -> account,PARAM_CEO_FIRST_NAME) : $this -> getColumnData($this -> account,PARAM_LAST_NAME);
				$_SESSION['CUP_Data']['lastName'] 	= $accounttype == 1 ? $this -> getColumnData($this -> account,PARAM_CEO_LAST_NAME) : $this -> getColumnData($this -> account,PARAM_FIRST_NAME);
				$_SESSION['CUP_Data']['mail'] 		= $this -> getColumnData($this -> account,PARAM_MAIL);
				$_SESSION['CUP_Data']['state'] 		= $this -> getColumnData($this -> account,PARAM_STATE);
				$_SESSION['CUP_Data']['city'] 		= $this -> getColumnData($this -> account,PARAM_CITY);
				$_SESSION['CUP_Data']['address'] 	= $this -> getColumnData($this -> account,PARAM_ADDRESS);
				$_SESSION['CUP_Data']['zip'] 		= $this -> getColumnData($this -> account,PARAM_ZIP_CODE);
				$_SESSION['CUP_Data']['tel'] 		= $this -> getColumnData($this -> account,PARAM_TEL);
				$_SESSION['CUP_Data']['amount'] 	= $this -> amount;
				$_SESSION['CUP_Data']['currency'] 	= 'CNY';
				$_SESSION['CUP_Data']['Actual'] 	= $this -> amount + $this -> fee;
				$_SESSION['CUP_Data']['fee'] 		= $this -> fee;
				$_SESSION['CUP_Data']['message'] 	= $this -> message;
				$_SESSION['CUP_Data']['method'] 	= TYPE_CUP;
				$_SESSION['CUP_Data']['lang']		= $this -> getLangage();
				$this -> fee = sprintf("%.2f",$this -> fee);
				$this -> amount = sprintf("%.2f",$this -> amount);
				$this -> currency = CNY;
			}

			if($this -> getType() == TYPE_CUP_PAYMENTSUCCESS ||
				$this -> getType()	== TYPE_CUP_PAYMENTFAILURE
			){
				$this -> transationNumber = $this -> getColumnData($_SESSION,'transaction_number');
				//$transationNumber = CUBITS_TRANSACTION_NUM.$this -> transationNumber;
				$this -> setDeposit($this -> getRowData($this -> accessSelect('SELECT_DEPOSIT_BY_TRANSACTION_NUMBER', array($this -> transationNumber))));
				$this -> currency = 'CNY';


				if($this -> isSendMail != VAL_INT_1){
					if($this -> getType() == TYPE_CUP_PAYMENTSUCCESS){
						$this -> sendCUPSuccessMail();
						$this -> accessModifyCommon('UPDATE_DEPOSIT_ISSENDMAIL',array($this -> transationNumber));
					}else if($this -> getType() == TYPE_CUP_PAYMENTFAILURE){
						$this -> sendCUPFailMail();
						$this -> accessModifyCommon('UPDATE_DEPOSIT_ISSENDMAIL',array($this -> transationNumber));
					}
				}
			}
		}else if($this -> getType() == CASHFLOW_DEPOSIT_INPUT ||
			$this -> getType() == CASHFLOW_DEPOSIT_CONFIRM ||
			$this -> getType() == CASHFLOW_DEPOSIT_SUCCESS ||
			$this -> getType() == CASHFLOW_DEPOSIT_FAILURE ||
			$this -> getType() == CASHFLOW_DEPOSIT_SEND
		){
			$list = $this -> CheckPaymentKind();
			if($list[VAL_INT_4] == NO_COUNT){
				$this -> setType(NO_STRING);
				$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VISAKINDCHECK_VERTIFY', array());
				return;
			}
			//确认为CashFlow支付分支，进行提交检索
			if($this -> getType() == CASHFLOW_DEPOSIT_INPUT){
				//进入cashflow并进行输入时
				$account_Category = '';		//设定账号默认类别
				//判断是否是KYC认证用户
				// 通常会員不可！無制限会員のみOK

				if(!$this -> checkUnlimitedStatus($this -> getUserData(PARAM_USER_ACCOUNT))) {
					$this -> setType(TYPE_NOTICE_KYC);
					return;
				}else {
					$this -> setType(CASHFLOW_DEPOSIT_INPUT);
				}

				// 不正防止のため、成功失敗関係なく1時間に5回まで、決済することができる。
				if(!$this -> checkCashFlowDeposit1Hour($this -> getUserData(PARAM_USER_ACCOUNT))) {
					$this -> popUpSessionMessage(ERROR, 'E_LIMIT_DEPOSIT_SOME_TIMES_1_HOUR', array());
					$rtn = false;
					if(!$rtn) {
						$this -> setType(NO_STRING);
						return;
					}
				}



				//如果为认证会员，获取会员的type,vip还是normal
				if($this -> checkVIPStatus($this -> getUserData(PARAM_USER_ACCOUNT))) {
					$account_Category = 'vip';
				}else{
					$account_Category = 'normal';
				}

				//将账户类别保存到SESSION中
				$_SESSION['account_Category'] = $account_Category;


				// 24時間以内決済成功は限制回まで。過去24時間にVIP 10回決済，Normal 3回したユーザーは、4回目エラーメッセージを表示
				if(!$this -> checkDepositByCard24Hour($this -> getUserData(PARAM_USER_ACCOUNT))) {
					if($account_Category == 'vip'){
						$this -> popUpSessionMessage(ERROR, 'E_LIMIT_DEPOSIT_SOME_TIMES_VIP', array());
					}else if($account_Category == 'normal'){
						$this -> popUpSessionMessage(ERROR, 'E_LIMIT_DEPOSIT_SOME_TIMES_NORMAL', array());
					}

					$rtn = false;
					if(!$rtn) {
						$this -> setType(NO_STRING);
						return;
					}
				}

				// 30日間の決済成功累積額上限は、Normal USD20,000まで,Vip USD20,000まで
				if(!$this -> checkDepositByCard30Days($this -> getUserData(PARAM_USER_ACCOUNT))) {
					$this -> popUpSessionMessage(ERROR, 'E_LIMIT_DEPOSIT_AMOUNT', array());
					$rtn = false;
					if(!$rtn) {
						$this -> setType(NO_STRING);
						return;
					}
				}



			}

			if($this -> getType() == CASHFLOW_DEPOSIT_CONFIRM){
				//确认页对输入的信息进行校验,并计算fee等信息

				//判断是个人还是法人账户
				$accounttype = $this -> getColumnData($this -> account,'account_type');

				//查看必要用户信息是否已填写，没有通知先完善用户信息
				if($accounttype == 1){
					$firstName = $this -> CallUserData(PARAM_CEO_FIRST_NAME);
					$lastName = $this -> CallUserData(PARAM_CEO_LAST_NAME);
					if(empty($firstName) || empty($lastName)){
						$this -> popUpSessionMessage(ERROR, 'E_LIMIT_CASHFLOW_DEPOSIT_INFO', array());
						$this -> setType(NO_STRING);
						return;
					}
				}

				//查看必要用户信息是否已填写，没有通知先完善用户信息
				$ZipCode 	= $this -> CallUserData(PARAM_ZIP_CODE);
				$Address 	= $this -> CallUserData(PARAM_ADDRESS);
				$City 		= $this -> CallUserData(PARAM_CITY);
				$Phone 		= $this -> CallUserData(PARAM_TEL);

				if(empty($ZipCode) ||
					empty($Address) ||
					empty($City ) ||
					empty($Phone)
				){
					$this -> popUpSessionMessage(ERROR, 'E_LIMIT_CASHFLOW_DEPOSIT_INFO', array());
					$this -> setType(NO_STRING);
					return;
				}

				//查看金额是否为空
				if(!$this -> checkNull($this -> amount)){
					$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_AMOUNT));
					$rtn = false;
					if(!$rtn) {
						$this -> setType(CASHFLOW_DEPOSIT_INPUT);
						return;
					}
				}

				//判断自定义金额是否为空，不为空对金额做出判断,以及有效入金限制
				if($this -> checkNull($this -> depoistmoney)){
					if($this -> currency == 'JPY'){
						if(($this -> amount < 50000) || ($this -> amount >100000)){
							$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE_JP', array(VAL_STR_AMOUNT));
							$rtn = false;
						}
						if(!$this -> checkStringIntOnly($this -> amount)){
							$this -> popUpSessionMessage(ERROR, 'E_ERROR_VALUE_PREG', array(VAL_STR_AMOUNT));
							$rtn = false;
						}
						if(!$rtn) {
							$this -> setType(CASHFLOW_DEPOSIT_INPUT);
							return;
						}
					}else{
						if(($this -> amount < 500) || ($this -> amount >1000)){
							$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE_OTHER', array(VAL_STR_AMOUNT));
							$rtn = false;
						}
						if(!$this -> checkCurrencyNumber($this -> amount)){
							$this -> popUpSessionMessage(ERROR, 'E_ERROR_VALUE_PREG', array(VAL_STR_AMOUNT));
							$rtn = false;
						}
						if(!$rtn) {
							$this -> setType(CASHFLOW_DEPOSIT_INPUT);
							return;
						}
					}
					if(!$rtn) {
						$this -> setType(CASHFLOW_DEPOSIT_INPUT);
						return;
					}
				}

				// メッセージの正規表現チェック
				if(!$this -> checkStringMessage($this -> message)) {
					$this -> popUpSessionMessage(ERROR, 'E_ERROR_REGULAR_MESSAGE', array());
					$rtn = false;
					if(!$rtn) {
						$this -> setType(CASHFLOW_DEPOSIT_INPUT);
						return;
					}
				}

				if(!$this -> checkLength($this -> message , 0 , 128)){
					$this -> popUpSessionMessage(ERROR, 'E_LIMIT_DEPOSIT_MESSAGE', array());
					$rtn = false;
					if(!$rtn) {
						$this -> setType(CASHFLOW_DEPOSIT_INPUT);
						return;
					}
				}


				if(!$this -> checkMoneyInExceed($this -> amount , $this -> currency)){
					$this -> popUpSessionMessage(ERROR, 'E_LIMIT_DEPOSIT_AMOUNT', array());
					$rtn = false;
					if(!$rtn) {
						$this -> setType(CASHFLOW_DEPOSIT_INPUT);
						return;
					}
				}



				// 手数料の取得
				$fee = $this -> getFeeCommon(VAR_DEPOSIT
										, $this -> amount
										, $this -> currency
										, $this -> getUserData(PARAM_USER_ACCOUNT));

				$this -> fee = $this -> getColumnData($fee, $this -> currency . VAL_INT_1);

				// 上乗せ分対応
				if($this -> currency == USD){
					$markup = CASHFLOW_RISK_FEE_USD;
				}else if($this -> currency == EUR){
					$markup 	= CASHFLOW_RISK_FEE_EUR;
				}else if($this -> currency == GBP){
					$markup 	= CASHFLOW_RISK_FEE_GBP;
				}else if($this -> currency == JPY){
					$markup 	= CASHFLOW_RISK_FEE_JPY;
				}

				$commission		= $this -> intToCurrency(($this -> amount * VAL_STR_VSMS_FEE),PERCENT);
				$this -> fee	+= $commission;
				$this -> fee 	+= $markup;

				$this -> setFeeEx($this -> fee);

				if($this -> currency == 'JPY'){
					$this -> fee    = ceil($this -> fee);
				}

				$_SESSION['cashflow']['Country'] 	= $this -> getColumnData($this -> account,PARAM_COUNTRY);
				$_SESSION['cashflow']['firstName'] 	= $accounttype == 1 ? $this -> getColumnData($this -> account,PARAM_CEO_FIRST_NAME) : $this -> getColumnData($this -> account,PARAM_LAST_NAME);
				$_SESSION['cashflow']['lastName'] 	= $accounttype == 1 ? $this -> getColumnData($this -> account,PARAM_CEO_LAST_NAME) : $this -> getColumnData($this -> account,PARAM_FIRST_NAME);
				$_SESSION['cashflow']['mail'] 		= $this -> getColumnData($this -> account,PARAM_MAIL);
				$_SESSION['cashflow']['state'] 		= $this -> getColumnData($this -> account,PARAM_STATE);
				$_SESSION['cashflow']['city'] 		= $this -> getColumnData($this -> account,PARAM_CITY);
				$_SESSION['cashflow']['address'] 	= $this -> getColumnData($this -> account,PARAM_ADDRESS);
				$_SESSION['cashflow']['zip'] 		= $this -> getColumnData($this -> account,PARAM_ZIP_CODE);
				$_SESSION['cashflow']['tel'] 		= $this -> getColumnData($this -> account,PARAM_TEL);
				$_SESSION['cashflow']['amount'] 	= $this -> amount;
				$_SESSION['cashflow']['currency'] 	= $this -> currency;
				$_SESSION['cashflow']['Actual'] 	= $this -> amount + $this -> fee;
				$_SESSION['cashflow']['fee'] 		= $this -> fee;
				$_SESSION['cashflow']['message'] 	= $this -> message;
				$_SESSION['cashflow']['lang']		= $this -> getLangage();
				if($this -> currency != 'JPY'){
					$this -> fee = sprintf("%.2f",$this -> fee);
					$this -> amount = sprintf("%.2f",$this -> amount);
				}
			}

			if($this -> getType() == CASHFLOW_DEPOSIT_SEND){
				include $_SERVER['DOCUMENT_ROOT'].DIRECTORY_SEPARATOR.'system'.DIRECTORY_SEPARATOR.'lib'.DIRECTORY_SEPARATOR.'core'.DIRECTORY_SEPARATOR.'cashflow.php';
				$this -> transaction_number = $this -> getTransactionNumberCommon(VAR_TRANSACTION_DEPOSIT);
				//$this -> transaction_number = trim(trim(date('YmdHis',time())).mt_rand(10000,99999));

				$Amount     		= $this -> getColumnData($_SESSION['cashflow'],'Actual');
				$Currency   		= $this -> getColumnData($_SESSION['cashflow'],'currency');
				$Street     		= $this -> getColumnData($_SESSION['cashflow'],'address');
				$City       		= $this -> getColumnData($_SESSION['cashflow'],'city');
				$ZIP        		= $this -> getColumnData($_SESSION['cashflow'],'zip');
				$Country    		= $this -> getColumnData($_SESSION['cashflow'],'Country');
				$this -> language   = $this -> getColumnData($_SESSION['cashflow'],'lang');
				$this -> lang      	= isset($arrLan[$this -> language]) ? $arrLan[$this -> language] : 'en';
				$first_name 		= $this -> getColumnData($_SESSION['cashflow'],'firstName');
				$last_name  		= $this -> getColumnData($_SESSION['cashflow'],'lastName');
				$mail       		= $this -> getColumnData($_SESSION['cashflow'],'mail');
				$IP 				= $_SERVER['REMOTE_ADDR'];
				//发送的Data
				$data = "authentication.entityId=".CASHFLOW_ENTITY_ID .
				   "&authentication.userId=".CASHFLOW_USER_ID .
				   "&authentication.password=".CASHFLOW_PASSWORD .
				   "&paymentType=".CASHFLOW_TRANS_TYPE .
				   "&merchantTransactionId=" .$this -> transaction_number.
				   "&amount=" .sprintf("%.2f",$Amount).
				   "&currency=".$Currency.
				   "&customer.givenName=".$first_name.
				   "&customer.surname=".$last_name.
				   "&billing.street1=".$Street.
				   "&billing.city=".$City.
				   "&billing.postcode=".$ZIP.
				   "&billing.country=".$Country.
				   "&customer.email=".$mail.
				   "&customer.ip=".$IP;

				//CURL 模拟POST
				$ch = curl_init();
				curl_setopt($ch, CURLOPT_URL, CASHFLOW_TOKEN_URL);
				curl_setopt($ch, CURLOPT_POST, 1);
				curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
				curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);// this should be set to true in production
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
				$responseData = curl_exec($ch);
				if(curl_errno($ch)) {
				  return curl_error($ch);
				}
				curl_close($ch);
				$arr_token = json_decode($responseData);

				$this -> token = $arr_token->id;
				//创建cashflow数据表的数据Model
				$CASHFLOW['Model']['transaction_number'] = $this -> transaction_number;
				$CASHFLOW['Model']['user_account'] = $this -> getColumnData($_SESSION['site_user_data'],'user_account');
				$CASHFLOW['Model']['amount'] = $Currency != 'JPY' ? $this -> getColumnData($_SESSION['cashflow'],'amount')*100 : $this -> getColumnData($_SESSION['cashflow'],'amount');
				$CASHFLOW['Model']['currency'] = $Currency;
				$CASHFLOW['Model']['method'] = 'CASHFLOWVM';
				$CASHFLOW['Model']['deposit_bank'] = 'CASHFLOWVM';
				$CASHFLOW['Model']['deposit_date'] = date("Y-m-d H:i:s");
				$CASHFLOW['Model']['fee'] = '';
				$CASHFLOW['Model']['message'] = $this -> getColumnData($_SESSION['cashflow'],'message');
				$CASHFLOW['Model']['comment'] = '';
				$CASHFLOW['Model']['create_time'] = date("Y-m-d H:i:s");
				$CASHFLOW['Model']['process_user'] = '9999';
				$CASHFLOW['Model']['type'] = '0';
				$CASHFLOW['Model']['err_flg'] = '0';

				$sqlObject = new mysql($this->getConfigValue(SECTION_DB,HOST_NAME)
										, $this->getConfigValue(SECTION_DB,USER_NAME)
										, $this->getConfigValue(SECTION_DB,LOGIN_PASS)
										, $this->getConfigValue(SECTION_DB,TARGET_DB_NAME),'','UTF8');

				$sql = "insert into t_deposit_cashflow_temporary ";
				//进deposit表的sql方法
				$strsql = $sqlObject->Insertsql($CASHFLOW['Model']);
				$sql .= $strsql;
echo $sql;
				$sqlObject->query($sql);
			}

			if($this -> getType() == CASHFLOW_DEPOSIT_SUCCESS ||
				$this -> getType()	== CASHFLOW_DEPOSIT_FAILURE
			){
				//返回结果，对结果判断
				$this -> transationNumber = $this -> getColumnData($_SESSION,'transaction_number');
				$this -> setDeposit($this -> getRowData($this -> accessSelect('SELECT_DEPOSIT_BY_TRANSACTION_NUMBER', array($this -> transationNumber))));
				if($this -> isSendMail != VAL_INT_1){
					if($this -> getType() == CASHFLOW_DEPOSIT_SUCCESS){
						$this -> sendCashFlowSuccessMail();
						$this -> accessModifyCommon('UPDATE_DEPOSIT_ISSENDMAIL',array($this -> transationNumber));
					}else if($this -> getType() == CASHFLOW_DEPOSIT_FAILURE){
						$this -> sendCashFlowFailMail();
						$this -> accessModifyCommon('UPDATE_DEPOSIT_ISSENDMAIL',array($this -> transationNumber));
					}
				}
			}

		} else if($this -> getType()	== TYPE_APPLY) {	// カード決済前

			$json = null;

			if($this -> method	== NO_STRING) {
				echo json_encode(array(PARAM_RESULT =>ERROR, PARAM_MESSAGE => 'パラメータが不足しています'));
			}

			// リミットチェック
			if(!$this -> checkGPSLimit($this -> getUserData(PARAM_USER_ACCOUNT), $this -> method, $errType)) {

				if($errType == VAL_INT_1) {

					echo json_encode(array(PARAM_RESULT =>ERROR, PARAM_MESSAGE => $this -> getMessage(ERROR, 'E_DEPOSIT_PERMISSION', array())));
				} else {
					echo json_encode(array(PARAM_RESULT =>ERROR, PARAM_MESSAGE => $this -> getMessage(ERROR, 'E_DEPOSIT_GPS_LIMIT', array())));
				}

			} else {
				echo json_encode(array(PARAM_RESULT => INFO, PARAM_MESSAGE => ''));
			}
		}

		return true;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 決済金額の計算
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	public function calculate() {

		// 変数宣言部
		$parcent	= NO_COUNT;
		$fix		= NO_COUNT;

		if($this -> method		== 'VISA'
			|| $this -> method	== 'GIFTCARD') {				// VISA、MASTERの場合

			$parcent	= 1.055;
			$fix		= 50;

			$this -> payment = intval(($this -> amount * $parcent) + $fix);

		} else if($this -> method == ''){

		} else if($this -> method == 'INSTANTBANKTRANSFER') {	// 銀行送金の場合

			$parcent	= 1.06;
			$fix		= 600;

			$this -> payment = ($this -> amount * $parcent) + $fix;

			// この場合はオリジナルレートで計算する
			$oRate = $this -> getRowData($this -> accessSelect('SELECT_ORIGINAL_RATE', array(EUR, JPY)));

			// オリジナルレート * 2%（最後に桁落とし）
			$this -> payment = $this -> intToCurrency(($this -> payment * $this -> getColumnData($oRate, COLUMN_ORIGINAL_RATE)) * 1.02, VAR_GPAYSAFE_CARD_CURRENCY);

			// 桁丸め
			$this -> payment = floor($this -> payment) + VAL_INT_1;
		} else {
			$this -> payment = $this -> amount;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: 入金メソッドの取得
	* @parameter	: なし
	* @return		: 入金メソッド
	-------------------------------------------------------------------------*/
	public function getMethod() {
		return $this -> method;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 入金メソッドの取得
	* @parameter	: なし
	* @return		: 入金メソッド
	-------------------------------------------------------------------------*/
	public function echoMethod() {
		echo $this -> method;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: ユーザデータの取得
	 * @parameter	: 取得パラメータ
	 * @return		: ユーザデータ
	 -------------------------------------------------------------------------*/
	public function getCurrency() {
		return $this -> currency;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 取引時間の取得
	 * @parameter	: なし
	 * @return		: 取引時間
	 -------------------------------------------------------------------------*/
	public function echoDepositAmountNatural() {
		echo $this -> formatCurrency(($this -> amount + $this -> fee), $this -> currency);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 処理時間の取得
	* @parameter	: なし
	* @return		: 処理時間
	-------------------------------------------------------------------------*/
	public function echoCreateTime() {
		echo $this -> createTime;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 取引時間の取得
	 * @parameter	: なし
	 * @return		: 取引時間
	 -------------------------------------------------------------------------*/
	public function echoAmountString() {
		echo $this -> getAmountString($this -> amount, $this -> currency);
		//echo $this -> getAmountString($this -> amount, $this -> currency);
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 取引時間の取得
	 * @parameter	: なし
	 * @return		: 取引時間
	 -------------------------------------------------------------------------*/
	public function returnDepositAmountNatural() {
		return $this -> getAmountString($this -> amount + $this -> fee, $this -> currency);
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 取引番号の取得
	 * @parameter	: なし
	 * @return		: 取引番号
	 -------------------------------------------------------------------------*/
	public function echoTransactionNumber() {
		echo $this -> transationNumber;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 入金データの設定
	 * @parameter	: 入金データ
	 * @return		: なし
	 -------------------------------------------------------------------------*/
	public function setDeposit($deposit) {
		$this -> deposit 	= $deposit;
		$Comment = $this -> getColumnData($this -> deposit, COLUMN_COMMENT);

		if(!empty($Comment)){
			$CommentResult = json_decode($Comment,true);
		}
		if($this -> getType() == CASHFLOW_DEPOSIT_SUCCESS ||
			$this -> getType() == CASHFLOW_DEPOSIT_FAILURE
		){
			if(isset($CommentResult)){
				$this -> currency   = $CommentResult['currency'];
				if($this -> currency == 'JPY'){
					$this -> payamount  = $CommentResult['amount'];
				}else{
					$this -> payamount  = $CommentResult['amount']*100;
				}
				$this -> amount		= $this -> getColumnData($this -> deposit, COLUMN_AMOUNT);
				$this -> fee		= $this -> payamount - $this -> amount;
			}
		}else if($this -> getType() == TYPE_CUP_PAYMENTSUCCESS ||
			$this -> getType() == TYPE_CUP_PAYMENTFAILURE
		){
			if(isset($CommentResult)){
				$this -> payamount  = $CommentResult['amount'];
				$this -> amount		= $this -> getColumnData($this -> deposit, COLUMN_AMOUNT);
				$this -> fee		= $this -> payamount - $this -> amount;
			}
		}else{
			$this -> amount		= $this -> getColumnData($this -> deposit, COLUMN_AMOUNT);
			$this -> fee		= $this -> getColumnData($this -> deposit, COLUMN_FEE);
		}

		$this -> createTime	= $this -> getColumnData($this -> deposit, COLUMN_CREATE_TIME_STRING);
		$this -> currency 	= $this -> getColumnData($this -> deposit, COLUMN_CURRENCY);
		$this -> isSendMail	= $this -> getColumnData($this -> deposit, 'isSendMail');
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 入金成功時のメール送信パラメータ
	 * @parameter	: なし
	 * @return		: パラメータ
	 -------------------------------------------------------------------------*/
	private function getSendCashFlowSuccessData() {
		// 変数宣言部
		$rtn		= array();
		$account	= $this -> getColumnData($this -> deposit, COLUMN_USER_ACCOUNT);

		// パラメータの設定
		$rtn[]	= $account;															// 口座番号（1）
		$rtn[]	= $this -> getNameCommon($account);									// 氏名（2）
		$rtn[]	= $this -> transationNumber;										// 取引番号（3）
		$rtn[]	= $this -> createTime;												// 取引時刻（4）
		$rtn[]	= $this -> currency;																// 決済通貨（5）
		$rtn[]	= $this -> getAmountString($this -> amount, $this -> currency);					// 決済金額（6）
		$rtn[]	= $this -> currency;																// 反映通貨（7）
		$rtn[]	= $this -> getAmountString(($this -> amount + $this -> fee), $this -> currency);	// 反映金額（8）


		return $rtn;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 入金失败時のメール送信パラメータ
	 * @parameter	: なし
	 * @return		: パラメータ
	 -------------------------------------------------------------------------*/
	function getSendCUPFailData() {
		// 変数宣言部
		$rtn		= array();
		$account	= $this -> getColumnData($this -> deposit, COLUMN_USER_ACCOUNT);
		// パラメータの設定
		$rtn[]	= $account;															// 口座番号（1）
		$rtn[]	= $this -> getNameCommon($account);									// 氏名（2）
		$rtn[]	= $this -> createTime;												// 取引時刻（4）
		$rtn[]	= $this -> currency;												// 決済通貨（5）
		$rtn[]	= $this -> getAmountString(($this -> amount - $this -> fee), $this -> currency);		// 決済金額（6）
		$rtn[]	= $this -> getColumnData($this -> deposit, COLUMN_MESSAGE);			// 反映通貨（7）
		return $rtn;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 入金成功時のメール送信パラメータ
	 * @parameter	: なし
	 * @return		: パラメータ
	 -------------------------------------------------------------------------*/
	private function getSendCUPSuccessData() {
		// 変数宣言部
		$rtn		= array();
		$account	= $this -> getColumnData($this -> deposit, COLUMN_USER_ACCOUNT);
		// パラメータの設定
		$rtn[]	= $account;															// 口座番号（1）
		$rtn[]	= $this -> getNameCommon($account);									// 氏名（2）
		$rtn[]	= $this -> transationNumber;										// 取引番号（3）
		$rtn[]	= $this -> createTime;												// 取引時刻（4）
		$rtn[]	= $this -> currency;												// 決済通貨（5）
		$rtn[]	= $this -> getAmountString(($this -> amount - $this -> fee), $this -> currency);		// 決済金額（6）
		$rtn[]	= $this -> getColumnData($this -> deposit, COLUMN_MESSAGE);			// 反映通貨（7）
		return $rtn;
	}

	private function sendCUPSuccessMail(){
		$params = '';
		// 変数宣言部
		$params = $this -> getSendCUPSuccessData();
		// メールを送信（ユーザ）
		$this -> sendMailByTmp('cup_deposit_info.xml'
								, $params
								, $this -> getEMailCommon($this -> getColumnData($params, NO_COUNT))
								, VAR_CS_MAIL_ADDRESS
								, $this -> getLangage());
	}

	private function sendCUPFailMail(){
		$params = '';
		// 変数宣言部
		$params = $this -> getSendCUPFailData();

		// メールを送信（ユーザ）
		$this -> sendMailByTmp('cup_deposit_failure.xml'
								, $params
								, $this -> getEMailCommon($this -> getColumnData($params, NO_COUNT))
								, VAR_CS_MAIL_ADDRESS
								, $this -> getLangage());
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 入金失败時のメール送信パラメータ
	 * @parameter	: なし
	 * @return		: パラメータ
	 -------------------------------------------------------------------------*/
	function getSendCashFlowFailData() {
		// 変数宣言部
		$rtn		= array();
		$rtn[]	= $this -> getUserData(PARAM_USER_ACCOUNT);							// 口座番号
		$rtn[]	= $this -> getNameCommon($this -> getUserData(PARAM_USER_ACCOUNT));	// 氏名
		return $rtn;
	}


	private function sendCashFlowSuccessMail(){
		$params = '';
		// 変数宣言部
		$params = $this -> getSendCashFlowSuccessData();
		// メールを送信（ユーザ）
		$this -> sendMailByTmp('cashflow_deposit_info.xml'
								, $params
								, $this -> getEMailCommon($this -> getColumnData($params, NO_COUNT))
								, VAR_CS_MAIL_ADDRESS
								, $this -> getLangage());
	}

	private function sendCashFlowFailMail(){
		$params = '';
		// 変数宣言部
		$params = $this -> getSendCashFlowFailData();
		// メールを送信（ユーザ）
		$this -> sendMailByTmp('cashflow_deposit_failure.xml'
								, $params
								, $this -> getEMailCommon($this -> getColumnData($params, NO_COUNT))
								, VAR_CS_MAIL_ADDRESS
								, $this -> getLangage());
	}

	/*-------------------------------------------------------------------------
	* @function_name: 入金メソッドの取得
	* @parameter	: なし
	* @return		: 入金メソッド
	-------------------------------------------------------------------------*/
	public function echoMethodString() {
		if($this -> method == 'GIFTCARD') {
			echo 'MASTERCARD';
		} else {
			echo $this -> method;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: 入金メソッドの取得
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	public function dispMethod() {
		$result = '';
		$result = $this -> getDepositMethodListCommon();
		return $result;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座番号の取得
	* @parameter	: なし
	* @return		: 口座番号
	-------------------------------------------------------------------------*/
	public function echoAccount() {
		echo $this -> getUserData(PARAM_USER_ACCOUNT);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 金額の取得
	* @parameter	: なし
	* @return		: 金額
	-------------------------------------------------------------------------*/
	public function dispAmount() {
		echo $this -> getAmountString($this -> amount, $this -> currency);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 決済金額の取得
	* @parameter	: なし
	* @return		: 決済金額
	-------------------------------------------------------------------------*/
	public function dispPayment() {
		echo $this -> getAmountString($this -> payment, $this -> currency);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 金額の取得
	* @parameter	: なし
	* @return		: 金額
	-------------------------------------------------------------------------*/
	public function echoAmount() {
		echo $this -> amount;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 決済金額の取得
	* @parameter	: なし
	* @return		: 決済金額
	-------------------------------------------------------------------------*/
	public function echoPayment() {
		echo $this -> payment;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 決済金額の取得
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	public function dispAmountList() {

		// 変数宣言部
		$list = array();

// 		$list[] = array(PARAM_DATA_KEY		=> '100'
// 						, PARAM_DATA_VALUE	=> '€1');
		$list[] = array(PARAM_DATA_KEY		=> '500'
						, PARAM_DATA_VALUE	=> '€5');
		$list[] = array(PARAM_DATA_KEY		=> '2000'
						, PARAM_DATA_VALUE	=> '€20');
		$list[] = array(PARAM_DATA_KEY		=> '5000'
						, PARAM_DATA_VALUE	=> '€50');
		$list[] = array(PARAM_DATA_KEY		=> '10000'
						, PARAM_DATA_VALUE	=> '€100');
		$list[] = array(PARAM_DATA_KEY		=> '30000'
						, PARAM_DATA_VALUE	=> '€300');

		echo $this -> dispListOption($list, $this -> amount);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 決済金額の取得
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	public function dispTransferAmountList() {

		// 変数宣言部
		$list = array();

// 		$list[] = array(PARAM_DATA_KEY		=> '100'
// 						, PARAM_DATA_VALUE	=> '€1');
		$list[] = array(PARAM_DATA_KEY		=> '500'
						, PARAM_DATA_VALUE	=> '€5');
		$list[] = array(PARAM_DATA_KEY		=> '5000'
						, PARAM_DATA_VALUE	=> '€50');
		$list[] = array(PARAM_DATA_KEY		=> '10000'
						, PARAM_DATA_VALUE	=> '€100');
		$list[] = array(PARAM_DATA_KEY		=> '30000'
						, PARAM_DATA_VALUE	=> '€300');

		echo $this -> dispListOption($list, $this -> tAmount);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 氏名の取得
	* @parameter	: なし
	* @return		: 氏名
	-------------------------------------------------------------------------*/
	public function echoName() {
		echo $this -> getUserData(PARAM_NAME);
	}

	/*-------------------------------------------------------------------------
	* @function_name: HTML表示用のデータ取得関数
	* @parameter	: なし
	* @return		: HTML表示用データ配列
	-------------------------------------------------------------------------*/
	public function dispHTML() {
		return array();
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座種別の取得
	* @parameter	: なし
	* @return		: 口座種別
	-------------------------------------------------------------------------*/
	public function getAccountType() {
		return $this -> accountType;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 姓の取得
	* @parameter	: なし
	* @return		: 姓
	-------------------------------------------------------------------------*/
	public function getLastName() {
		return $this -> lastName;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 名の取得
	* @parameter	: なし
	* @return		: 名
	-------------------------------------------------------------------------*/
	public function getFirstName() {
		return $this -> firstName;
	}

	/*-------------------------------------------------------------------------
	* @function_name: メールアドレスの取得
	* @parameter	: なし
	* @return		: メールアドレス
	-------------------------------------------------------------------------*/
	public function getEMail() {
		return $this -> email;
	}

	/*-------------------------------------------------------------------------
	* @function_name: パスワードの取得
	* @parameter	: なし
	* @return		: パスワード
	-------------------------------------------------------------------------*/
	public function getPassword() {
		return $this -> password;
	}

	/*-------------------------------------------------------------------------
	* @function_name: パスワード（再入力）の取得
	* @parameter	: なし
	* @return		: パスワード（再入力）
	-------------------------------------------------------------------------*/
	public function getPasswordConfirm() {
		return $this -> passwordConfirm;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 生年月日（年）の取得
	* @parameter	: なし
	* @return		: 生年月日（年）
	-------------------------------------------------------------------------*/
	public function getBirthYear() {
		return $this -> birthYear;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 生年月日（月）の取得
	* @parameter	: なし
	* @return		: 生年月日（月）
	-------------------------------------------------------------------------*/
	public function getBirthMonth() {
		return $this -> birthMonth;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 生年月日（日）の取得
	* @parameter	: なし
	* @return		: 生年月日（日）
	-------------------------------------------------------------------------*/
	public function getBirthDay() {
		return $this -> birthDay;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 国の取得
	* @parameter	: なし
	* @return		: 国
	-------------------------------------------------------------------------*/
	public function getCountry() {
		return $this -> country;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 都道府県の取得
	* @parameter	: なし
	* @return		: 都道府県
	-------------------------------------------------------------------------*/
	public function getState() {
		return $this -> state;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 市の取得
	* @parameter	: なし
	* @return		: 市
	-------------------------------------------------------------------------*/
	public function getCity() {
		return $this -> city;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 郵便番号の取得
	* @parameter	: なし
	* @return		: 郵便番号
	-------------------------------------------------------------------------*/
	public function getZipCode() {
		return $this -> zipCode;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 番地の取得
	* @parameter	: なし
	* @return		: 番地
	-------------------------------------------------------------------------*/
	public function getAddress() {
		return $this -> address;
	}
	/*-------------------------------------------------------------------------
	* @function_name: 電話番号の取得
	* @parameter	: なし
	* @return		: 電話番号
	-------------------------------------------------------------------------*/
	public function getTel() {
		return $this -> tel;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 姓の取得
	* @parameter	: なし
	* @return		: 姓
	-------------------------------------------------------------------------*/
	public function echoLastName() {
		echo $this -> lastName;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 名の取得
	* @parameter	: なし
	* @return		: 名
	-------------------------------------------------------------------------*/
	public function echoFirstName() {
		echo $this -> firstName;
	}

	/*-------------------------------------------------------------------------
 	* @function_name: メールアドレスの取得
	* @parameter	: なし
	* @return		: メールアドレス
	-------------------------------------------------------------------------*/
	public function echoEMail() {
		echo $this -> email;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 確認用口座種別の取得
	* @parameter	: なし
	* @return		: 確認用口座種別
	-------------------------------------------------------------------------*/
	public function dispAccountType() {

		if($this -> getAccountType() == VAL_INT_1) {
			return VAL_STR_PERSONAL;
		} else if($this -> getAccountType() == VAL_INT_2) {
			return VAL_STR_CORPORATE;
		} else {
			return VAL_STR_PERSONAL;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: 表示用口座種別の取得
	* @parameter	: なし
	* @return		: 表示用HTML文字列
	-------------------------------------------------------------------------*/
	public function echoAccountType() {
		echo $this -> dispAccountTypeList($this -> getAccountType());
	}

	/*-------------------------------------------------------------------------
	* @function_name: ユーザデータの取得
	* @parameter	: 取得パラメータ
	* @return		: ユーザデータ
	-------------------------------------------------------------------------*/
	public function echoUserData($param) {
		echo $this -> getColumnData($this -> account, $param);
	}

	public function CallUserData($param) {
		return $this -> getColumnData($this -> account, $param);
	}

	/*-------------------------------------------------------------------------
	* @function_name: ユーザデータの取得
	* @parameter	: 取得パラメータ
	* @return		: ユーザデータ
	-------------------------------------------------------------------------*/
	public function echoCountryName() {
		echo $this -> dispCountryCommon($this -> getColumnData($this -> account, PARAM_COUNTRY));
	}

	/*-------------------------------------------------------------------------
	* @function_name: ユーザデータの取得
	* @parameter	: 取得パラメータ
	* @return		: ユーザデータ
	-------------------------------------------------------------------------*/
	public function dispCurrency() {
		echo $this -> currency;
	}

	/*-------------------------------------------------------------------------
	* @function_name: ユーザデータの取得
	* @parameter	: 取得パラメータ
	* @return		: ユーザデータ
	-------------------------------------------------------------------------*/
	public function echoResultMessage() {

		if($this -> getType() == TYPE_SUCCESS) {	// 成功
			echo $this -> getMessage(INFO, 'I_DEPOSIT_COMPLETE_GPS', array());
		} else {									// 失敗
			echo $this -> getMessage(ERROR, 'E_DEPOSIT_ERROR_GPS', array());
		}

	}

	/*-------------------------------------------------------------------------
	* @function_name: 請求名称の取得
	* @parameter	: なし
	* @return		: 請求名称
	-------------------------------------------------------------------------*/
	public function echoInvoiceName() {
		echo $this -> getValueByList($this -> getDepositInvoiceNameListCommon(), $this -> method);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 回数制限の取得
	* @parameter	: なし
	* @return		: 回数制限
	-------------------------------------------------------------------------*/
	public function echoDailyCountLimit() {
		echo $this -> getGPSCountLimit($this -> method, $this -> getColumnData($this -> account, COLUMN_GPS_ACCOUNT_FLG));
	}

	/*-------------------------------------------------------------------------
	* @function_name: 金額制限の取得
	* @parameter	: なし
	* @return		: 金額制限
	-------------------------------------------------------------------------*/
	public function echoAmountLimit() {
		echo number_format($this -> getGPSAmountLimit($this -> method, $this -> getColumnData($this -> account, COLUMN_GPS_ACCOUNT_FLG)));
	}

	/*-------------------------------------------------------------------------
	* @function_name: 金額制限の期間の取得
	* @parameter	: なし
	* @return		: 金額制限の期間
	-------------------------------------------------------------------------*/
	public function echoBetweenDate() {

		// 変数宣言部
		$rtn = NO_STRING;

		if($this -> method == PARAM_GPS_VISA) {								// VISAの場合
			$rtn = VAL_INT_30;

		} else if($this -> method == PARAM_GPS_GIFTCARD) {					// MASTERCARDの場合
			$rtn = VAL_INT_30;

		} else if($this -> method == PARAM_GPS_VAL_INSTANTBANKTRANSFER) {	// 銀行送金の場合
			$rtn = VAL_INT_15;
		}

		echo $rtn;
	}

	/*-------------------------------------------------------------------------
	* @function_name: 結果再確認のURL
	* @parameter	: なし
	* @return		: 結果再確認のURL
	-------------------------------------------------------------------------*/
	public function echoReconfirmUrl() {
		echo 'https://test.api.iwl.world/Complete_Gpaysafe?rn=' . $this -> referenceNo;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 結果再確認のURL
	 * @parameter	: なし
	 * @return		: 結果再確認のURL
	 -------------------------------------------------------------------------*/
	public function getRefarenceNo() {
		return $this -> referenceNo;
	}

	//检查必要信息是否已经填写
	private function checkUserProfile(){
		$rtn = True;
		//查看必要用户信息是否已填写，没有通知先完善用户信息
		$ZipCode 	= $this -> CallUserData(PARAM_ZIP_CODE);
		$Address 	= $this -> CallUserData(PARAM_ADDRESS);
		$City 		= $this -> CallUserData(PARAM_CITY);
		$Phone 		= $this -> CallUserData(PARAM_TEL);

		if(empty($ZipCode) ||
			empty($Address) ||
			empty($City ) ||
			empty($Phone)
		){
			$rtn = False;
			return $rtn;
		}
		return $rtn;
	}

	private function CheckPaymentKind(){
		$gpsPayments = $this -> getColumnData($this -> account, COLUMN_GPS_KIND_OF_PAYMENT);	// GPS決済種別
		$list	= $this -> makeArrayByPowerCommon($gpsPayments);
		return $list;
	}

	//class End

}
?>