<?php
include_once $_SERVER['DOCUMENT_ROOT'].DIRECTORY_SEPARATOR.'config.php';

class help2PayAPI {
	private $callback_url		= H2P_CALLBACKURL;
	private $ip   				= SYSTEM_IP;
	private $merchant_code		= H2P_MERCHANT_CODE;
	private $security_code		= H2P_SECURITY_CODE;


    /*-------------------------------------------------------------------------
     * @function_name: generateRequestData
     * "@description : generates the request data
     * @parameter    : data and key
     * @return       : array
    -------------------------------------------------------------------------*/
    public function generateRequestData($data,$key){
		$requestData = array(
			'Key'					=> $key,
			'ClientIP'				=> $this -> ip,
			'ReturnURI'				=> $this -> callback_url,
			'MerchantCode'			=> $this -> merchant_code,
			'TransactionID'			=> $data['TransactionID'],
			'CurrencyCode'			=> $data['CurrencyCode'],
			'MemberCode'			=> $data['MemberCode'],
			'Amount'				=> $data['Amount'],
			'TransactionDateTime'	=> $data['TransactionDateTime2'],
			'BankCode'				=> $data['BankCode'],
			'toBankAccountName'		=> $data['toBankAccountName'],
			'toBankAccountNumber'	=> $data['toBankAccountNumber'],
		);


        return $requestData;
    }

	/*-------------------------------------------------------------------------
	 * @function_name: generateKey
	 * "@description : Generates key for the request data
	 * @parameter    : $data array
	 * @return       : key string
	-------------------------------------------------------------------------*/

	public function generateKey($data){
			$strKey=NO_STRING;

			$transaction_id			= $data['TransactionID'];
			$member_code			= $data['MemberCode'];
			$amount					= $data['Amount'];
			$currency				= $data['CurrencyCode'];
			$transaction_date_time	= $data['TransactionDateTime'];
			$bank_account_number	= $data['toBankAccountNumber'];

			$strKey = $this -> merchant_code.$transaction_id.$member_code.$amount.$currency.$transaction_date_time.$bank_account_number.$this -> security_code;

			$key = md5($strKey);

		return $key;
	}
    /*-------------------------------------------------------------------------
     * @function_name: submitPayoutRequest
     * "@description : Submits the request to Help2Pay
     * @parameter    : generated data array from generateRequestData function
     * @return       : array response data ; bool - false (if creation is successful, returns response data else returns false)
    -------------------------------------------------------------------------*/
    public function submitPayoutRequest($data){

        //set curl parameters
        $ch = curl_init('https://app.racethewind.net/merchantpayout/M0103'); //请求的URL地址
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
		curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $responseData = curl_exec($ch);

        //check if curl failed
        if(curl_errno($ch)) {
            return false;
	    }
        curl_close($ch);

        //$responseData = json_decode($responseData,true);

        if(count($responseData) > 0) {
            return $responseData;
        } else {
            return false;
        }
    }

	/*-------------------------------------------------------------------------
	 * @function_name: verifyCallbackKey
	 * "@description : Generates key for the the callback verification
	 * @parameter    : $key, $transaction_id, $member_code, $amount, $currency, $status from db table
	 * @return       : key string
	-------------------------------------------------------------------------*/

	public function verifyCallbackKey($key, $transaction_id, $member_code, $amount, $currency, $status){
			$strKey=NO_STRING;

			$upperKey= strtoupper($key);

			$amount = number_format((float)$amount, 2, '.', '');

			$strKey = $this -> merchant_code.$transaction_id.$member_code.$amount.$currency.$status.$this -> security_code;

			$veriKey = md5($strKey);

			return $veriKey;

	}
}
