<?php
include_once('../system/lib/config.php');
$sys = new System();

// 変数宣言部
$rtn		= array();
$params		= array();
$rsStatus	= NO_STRING;
$result		= NO_STRING;
$ip 		= NO_STRING;
$referer 	= NO_STRING;

// POSTデータ
$pNum			= $sys -> getDataPost('p_num');
$amount			= $sys -> getDataPost('amount');
$fromAccount	= $sys -> getDataPost('from_account');
$toAccount		= $sys -> getDataPost('to_account');
$debitCurrency	= $sys -> getDataPost('debit_currency');
$currency		= $sys -> getDataPost('currency');
$message		= $sys -> getDataPost('message');
$signature		= $sys -> getDataPost('signature');
$debitAmount	= NO_COUNT;

// 取得データの生成
if(isset($_SERVER['REMOTE_ADDR'])) {
	$ip = $_SERVER['REMOTE_ADDR'];
}
if(isset($_SERVER['HTTP_REFERER'])) {
	$referer = $_SERVER['HTTP_REFERER'];
}
$post = http_build_query($_POST, '', '&');

// APIチェック用データ
// シグネチャ生成用のデータを取得する
$row			= $sys -> getRowData($sys -> accessSelect('SELECT_API_SIGNATURE_BY_A_ID', array($pNum)));
$apiPassword	= $sys -> getColumnData($row, COLUMN_PASSWORD);
$apiUserAccount	= $sys -> getColumnData($row, COLUMN_USER_ACCOUNT);



$checkPassword = $apiUserAccount
				. $apiPassword
				. $pNum
				. $amount;

$sha = hash('sha256', $checkPassword);

// POSTのログを取る
$sys -> logPost();

//check if request is sent to self
if(($fromAccount != "" && $toAccount != "") && ($fromAccount == $toAccount)){
    $rsStatus = 'REJECTED';

	// 返却値生成
	$rtn[PARAM_RESULT] = sprintf('%02d', VAL_INT_93);
	$rtn[PARAM_STATUS] = $rsStatus;
}
else{
    if($sys -> checkSettlementIpAddress($pNum)) {
    	// シグネチャとコチラのデータが一致したら、処理続行
    	if($signature == $sha) {

    		// 各パラメータのチェックを行う
    		$result = $sys -> checkTransfer($fromAccount
    										, $toAccount
    										, $currency
    										, $amount
    										, $debitCurrency);

    		if($result[PARAM_RESULT] == NO_COUNT) {
    			$debitAmount = $sys -> getColumnData($result, PARAM_AMOUNT);

    			// 取引番号の生成
    			$transactionNum = $sys -> getTransactionNumberCommon(VAR_TRANSACTION_TRANSFER_DEPOSIT);

				//to fee
				$toFee = $sys -> currencyToInt($sys -> getColumnData($result, PARAM_TO_FEE), $currency);

    			// 送金実行
    			$params[] = $fromAccount;																			// 送金元口座番号
    			$params[] = $fromAccount;																			// 送金元口座番号
    			$params[] = $debitCurrency;																			// 送金通貨
    			$params[] = $sys -> currencyToInt($sys -> getColumnData($result, PARAM_FROM_FEE), $debitCurrency);	// 口座元手数料
    			$params[] = $toAccount;																				// 送金先口座番号
    			$params[] = $currency;																				// 送金元通貨
    			$params[] = $toFee;			// 送金先手数料
    			$params[] = $amount;																				// 入力金額
    			$params[] = NO_COUNT;																				// 送金方法
    			$params[] = $message;																				// メッセージ
    			$params[] = $debitCurrency;																			// 出金通貨
    			$params[] = $sys -> currencyToInt($debitAmount, $debitCurrency);									// 出金金額
    			$params[] = $currency;																				// 送金通貨
    			$params[] = $sys -> currencyToInt($amount, $currency);												// 送金金額
    			$params[] = $sys -> getColumnData($result, PARAM_RATE);												// レート
    			$params[] = NO_COUNT;																				// 処理種別
    			$params[] = NO_STRING;																				// 管理者ID
    			$params[] = VAL_INT_2;																				// 処理ステータス
    			$params[] = $transactionNum;																		// 取引番号
    			$params[] = date("Y-m-d H:i:s");																	// 取引番号

    			$res = $sys -> accessModify('INSERT_TRANSFER', $params, false);
    			if(!$res){
    				$rsStatus = 'REJECTED';
    				// 返却値生成
    				$rtn[PARAM_RESULT] = sprintf('%02d', VAL_INT_99);
    				$rtn[PARAM_STATUS] = $rsStatus;
    				echo json_encode($rtn);
    				// 登録用パラメータ
    				$sys -> accessModifyCommon('INSERT_LOG_POST', array($ip,$referer,'[INSERT_DB_ERR]'.json_encode($params)));
    				exit();
    			} else {
    				// 登録用パラメータ
    				$sys -> accessModifyCommon('INSERT_LOG_POST', array($ip,$referer,'[INSERT_DB]'.json_encode($params)));

					//send email to reciever
					$emailParams = array();
					$emailParams = getSendDataTo($fromAccount, $toAccount, $toFee, $amount, $currency, $debitCurrency, $message, $transactionNum);
					$toAccountData = $sys -> getAccountCommon($toAccount);
					$language = $sys -> getColumnData($sys -> getRowData($toAccountData), COLUMN_USE_LANGUAGE);
					$sys -> sendMailByTmp($language.DIRECTORY_SEPARATOR.'transfer_receive_user.xml'
											, $emailParams
											, $emailParams[VAL_INT_11]
											, VAR_CS_MAIL_ADDRESS);
    			}

    			// 通貨が違う場合は、為替コミッションの発生
    			if($debitCurrency != $currency) {

    				// 着金額指定の場合
    				$sys -> registCommisionExchange($fromAccount
    												, $currency
    												, $debitCurrency
    												, $sys -> currencyToInt($debitAmount, $debitCurrency));
    			}

    // echo $fromAccount . ' : ' . $debitCurrency . ' : ' . $sys -> getColumnData($result, PARAM_FROM_FEE) . '<br/>';
    // echo $toAccount . ' : ' . $currencyromAccount . ' : ' . $sys -> getColumnData($result, PARAM_TO_FEE) . '<br/>';

    			// コミッションの集計（送金元）
    			$sys -> registCommision(VAR_TRANSFER
    									, null
    									, $fromAccount
    									, $debitCurrency
    									, $sys -> getColumnData($result, PARAM_FROM_FEE));

    			// コミッションの集計（送金先）
    			$sys -> registCommision(VAR_TRANSFER
    									, null
    									, $toAccount
    									, $currency
    									, $sys -> getColumnData($result, PARAM_TO_FEE)
    									, PARAM_TO);

    			$rsStatus = 'OK';

    			// 返却値生成(成功時)
    			$rtn[PARAM_RESULT]				= sprintf('%02d', NO_COUNT);
    			$rtn[PARAM_STATUS]				= $rsStatus;
    			$rtn[PARAM_TRANSACTION_NUMBER]	= $transactionNum;
    			$rtn[PARAM_CURRENCY]			= $debitCurrency;
    			$rtn[PARAM_AMOUNT]				= $debitAmount;
    			$rtn[PARAM_FEE]					= $sys -> getColumnData($result, PARAM_FROM_FEE);
    			
    			// will include account # within API callback - anton
    			$rtn[PARAM_FROM_ACCOUNT]		= $fromAccount;
    			$rtn[PARAM_TO_ACCOUNT]			= $toAccount;
    		} else {

    			$rsStatus = 'ERROR(CODE:' . sprintf('%02d', $result[PARAM_RESULT]) . ')';

    			// 返却値生成
    			$rtn[PARAM_RESULT] = sprintf('%02d', $result[PARAM_RESULT]);
    			$rtn[PARAM_STATUS] = $rsStatus;
    		}
    	} else {
    		$rsStatus = 'REJECTED';

    		// 返却値生成
    		$rtn[PARAM_RESULT] = sprintf('%02d', VAL_INT_90);
    		$rtn[PARAM_STATUS] = $rsStatus;

    	}
    } else {
    	$rsStatus = 'REJECTED';

    	// 返却値生成
    	$rtn[PARAM_RESULT] = sprintf('%02d', VAL_INT_92);
    	$rtn[PARAM_STATUS] = $rsStatus;
    }
}

// 登録用パラメータ
$sys -> accessModifyCommon('INSERT_LOG_POST', array($ip,$referer,'[SUCCESSFUL]'.json_encode($rtn)));
echo json_encode($rtn);


//**************************FUNCTIONS****************************************//

/*-------------------------------------------------------------------------
 * @function_name: メール送信用のデータを取得（送金先ユーザ）
* @parameter	: なし
* @return		: メール送信用データ
-------------------------------------------------------------------------*/
function getSendDataTo($fromAccount, $toAccount, $toFee, $amount, $currency, $debitCurrency, $message, $transactionNum) {
	global $sys;

	// 変数宣言部
	$rtn	= array();
	$data	= $sys -> getAccountCommon($fromAccount);
	$row	= $sys -> getRowData($data);
	$data2	= $sys -> getAccountCommon($toAccount);
	$row2	= $sys -> getRowData($data2);

	$rtn[] = $fromAccount;															// ユーザ口座番号
	$rtn[] = $sys -> getColumnData($row2, COLUMN_FIRST_NAME)
				. DELIMIT_SPACE . $sys -> getColumnData($row2, COLUMN_LAST_NAME);			// ユーザ名
	$rtn[] = $sys -> getUserData(PARAM_USER_ACCOUNT);										// 送金先口座番号
	$rtn[] = $sys -> getColumnData($row, COLUMN_FIRST_NAME)
				. DELIMIT_SPACE . $sys -> getColumnData($row, COLUMN_LAST_NAME);			// ユーザ名（送金元）
	$rtn[] = $sys -> getCurrentTimeCommon();												// 現在時刻
	$rtn[] = $currency;																// 通貨
	$rtn[] = $sys -> formatCurrency($amount, $currency);					// 金額
	$rtn[] = $debitCurrency;														// 手数料通貨
	$rtn[] = $sys -> formatCurrency($toFee, $currency);					// 手数料
	$rtn[] = $message;																	// メッセージ
	$rtn[] = $transactionNum;													// 取引番号
	$rtn[] = $sys -> getColumnData($row2, COLUMN_MAIL);									// メールアドレス

	return $rtn;
}


/*
// コールバック
$data = array('MerchantTransactionId'	=> $fromAccount
				, 'Result'				=> $rsStatus
);

$data = http_build_query($data, '', '&');

$header = array(
		"Content-Type: application/x-www-form-urlencoded",
		"Content-Length: ".strlen($data)
);

$opts = array(
		'http' =>array('method'	=> 'POST'
				, 'header'  	=> implode("\r\n", $header)
				, 'content'		=> $data
		)
);

$context = stream_context_create($opts);

if($callbackUrl == NO_STRING) {
	echo 'OK';
} else {
	$file = file_get_contents($callbackUrl, false, $context);
}



// 最終の遷移
if($rsStatus == 'OK') {					// 処理成功時

	if($successUrl == NO_STRING) {
		echo $rsStatus;
	} else {
		header('Location: ' . $successUrl);
	}

} else if($rsStatus = 'ERROR') {		// エラー時

	if($errorUrl == NO_STRING) {
		echo $rsStatus;
	} else {
		header('Location: ' . $errorUrl);
	}
} else if($rsStatus = 'REJECTED') {

	if($rejectUrl == NO_STRING) {
		echo $rsStatus;
	} else {
		header('Location: ' . $rejectUrl);
	}
}
*/
?>
