<?php
$page_title = "卡-輸入資訊";
include_once('site_config.php');
include_once('template/base_site_head.php');
?>
	<!-- メインエリア -->
	<div id="main" class="container">
		<ol class="breadcrumb">
			<li><a href="<?php echo $home_url; ?>">首頁</a></li>
			<li class="active"><?php echo $page_title; ?></li>
		</ol>
		<div class="progress">
			<div class="progress-bar progress-bar-striped active w80p" role="progressbar" aria-valuenow="20" aria-valuemin="0" aria-valuemax="100"><span class="visible-xs">第1步</span><span class="hidden-xs">輸入卡片資訊</span></div>
		</div>
		<h2><?php echo $page_title; ?></h2>
		<form id="acForm" action="" method="post">
			<?php $this -> dispMessagesCommon(); ?>
			<table class="table table-bordered c_th mb05">
				<colgroup>
					<col class="w40p">
					<col class="w60p">
				</colgroup>
				<tbody>
					<tr>
						<th>出生日期</th>
						<td>
							<select name="year" class="select">
								<?php $this -> dispYear(); ?>
							</select>
							<span class="spcr-br">年</span>
							<select name="month" class="select">
								<?php $this -> dispMonth(); ?>
							</select>
							<span class="spcr-br">月</span>
							<select name="day" class="select">
								<?php $this -> dispDay(); ?>
							</select>
							<span>日</span>
						</td>
					</tr>
					<tr>
						<th>卡號</th>
						<td><input type="text" id="card_number" name="card_number" value="<?php $this -> echoCardNumber(); ?>" /></td>
					</tr>
				</tbody>
			</table>
			<p class="red font12 mb20">
				注意事項<br/>
				※請保管好您的密碼，不要告訴任何人。<br/>
				※請注意，如果您在同一讀卡機上連續三次密碼輸入錯誤的話您的卡將會被凍結。
			</p>
			<p class="text-center"><input type="button" id="btnConfirm" value="已閱讀注意事項" class="btn btn-primary btn-lg"></p>
			<input type="hidden" id="type" name="type" value="" />
		</form>
	</div>
	<script src="../js/card_pin.js"></script>
     <!-- /メインエリア -->
<?php
	include_once('template/base_site_foot.php');
	echo $endscripts;
?>
</body>
</html>