<?php 
include_once('config.php');

require_once(SYSTEM_LOGICS . 'kyc/model.php');

class LogicKYC extends KYCModelClass {
	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $htmlStr = NO_STRING;	// 表示用HTML文字列

	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}


	/*-------------------------------------------------------------------------
	* @function_name: ロジック（各クラス共通）
	* @parameter	: なし
	* @return		: TRUE:ロジック成功、FALSE:ロジック失敗
	-------------------------------------------------------------------------*/
	function logic() {

		// 変数宣言部
		$result	= NO_COUNT;
		$on		= NO_COUNT;
		$off	= NO_COUNT;
		$other	= NO_COUNT;
		$basename = basename($_SERVER['REQUEST_URI']);

		/*var_dump($basename);
		exit();*/
		try {
			// 初期データ処理
			if($this -> init()) {
				if($this -> getType() == TYPE_DETAIL) {			// データ詳細
					$this -> select();
				} else if($this -> getType() == TYPE_EXPORT_COMMON){
					$this -> lists();
					$this -> export();
				} else if($this -> getType() == TYPE_UPDATE_ALL){
					$this -> insertActivity();
					$this -> updateAll();
					$this -> lists();
				} else if($this -> getType() == TYPE_VERTIFY){
					$this -> insertActivity();
					$this -> updateUserStatus();
					// 入金フラグの変更
					$this -> updateDepositFlg();
					// メールの送信
					$this -> send();
					$this -> setType(TYPE_DETAIL);
					$this -> select();
				} else if($this -> getType() == TYPE_SAVE_DETAIL){
					$this -> insertActivity();
					$this -> updateDetail();
					$this -> setType(TYPE_DETAIL);
					$this -> select();
				} else if($this -> getType() == TYPE_SAVE_IMAGE){
					$this -> insertActivity();
					$this -> updateImages();
					$this -> setType(TYPE_DETAIL);
					$this -> select();
				} else if($this -> getType() == TYPE_DELETE_IMAGE){
					$this -> insertActivity();
					$this -> deleteImages();
					$this -> setType(TYPE_DETAIL);
					$this -> select();
					if(empty($this -> rs)){
						header('Location:'.$basename);
						exit();
					}
				} else if($this -> getType() == TYPE_DOWNLOAD_IMAGE) {	// ステータス更新
					//下载	
					$this -> setType(TYPE_DETAIL);
					$this -> select();
					$this -> downloadImage();
				} else {
					$this -> lists();
				}
				
			}

		} catch (Exception $e) {
			throw $e;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: 本人確認詳細の取得
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function select() {
		$this -> setResult($this -> accessSelect('SELECT_KYC_ADMIN', array($this -> getUserAccount())));
	}

	/*-------------------------------------------------------------------------
	* @function_name: 本人確認リストの取得
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function lists() {
	    $countData = $this -> getRowData($this -> accessSelect('COUNT_KYC_ADMIN', $this -> getWhere()));
	    
	    $this -> setCount($this -> getColumnData($countData, COLUMN_COUNTER));
		$this -> setResult($this -> accessSelect('LIST_KYC_ADMIN', $this -> getWhere(true)));
	}

	/*-------------------------------------------------------------------------
	* @function_name: 本人確認リストの取得
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function updateAll() {	
		if($this -> getConidition()){
			$this -> accessModifyCommon('UPDATE_KYC_ADMIN_ALL_STATUS', $this -> getConidition());
			$this -> popUpSessionMessage(INFO, 'I_COMPLETE_PROCESS', array());
		}			
	}

	/*-------------------------------------------------------------------------
	* @function_name: 本人確認リストの取得
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function updateDetail() {	
		$this -> accessModifyCommon('UPDATE_KYC_ADMIN_DETAIL_STATUS', $this -> getDetailCondition());
		$this -> popUpSessionMessage(INFO, 'I_KYC_ADMIN_PROCESS', array());
	}


	/*-------------------------------------------------------------------------
	* @function_name: 本人確認リストの取得
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function updateImages() {
		$result	= NO_COUNT;
		$on		= NO_COUNT;
		$off	= NO_COUNT;
		$other	= NO_COUNT;

		foreach($this -> getDataPost(PARAM_STATUS) as $row){
			$result = $this -> updateImagesStatus($row);
		}
		$this -> updateUserKYCStatus();
		$this -> popUpSessionMessage(INFO, 'I_KYC_ADMIN_PROCESS', array());
	}

	/*-------------------------------------------------------------------------
	* @function_name: 本人確認リストの取得
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function deleteImages() {
		$result	= NO_COUNT;
		$on		= NO_COUNT;
		$off	= NO_COUNT;
		$other	= NO_COUNT;

		foreach($this -> getDataPost(PARAM_STATUS) as $row){
			$result = $this -> deleteImage($row);
		}
		$this -> updateUserKYCStatus();
		$this -> popUpSessionMessage(INFO, 'I_KYC_ADMIN_PROCESS', array());
	}


	/*-------------------------------------------------------------------------
	* @function_name: ユーザのKYCステータスを更新する
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function updateUserKYCStatus() {
		$this -> accessModifyCommon('UPDATE_KYC_FLG', $this -> updateKYCFlg());
	}

	/*-------------------------------------------------------------------------
	* @function_name: ユーザのステータスを更新する（無制限へ）
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function updateUserStatus() {
		$this-> updateUserLiftDate($this -> getUserAccount());
		$this -> accessModifyCommon('UPDATE_USER_STATUS', $this -> updateUserFlg());
	}

	function updateUserLiftDate($userAccount){
		$res = $this -> getRowData($this -> accessSelect('SELECT_USER_STATUS', array($userAccount)));
		$currStatus = $this -> getColumnData($res, 'status');
		if($currStatus == VAL_INT_6 || $currStatus == VAL_INT_4){
				$this -> accessModify('UPDATE_USER_LIFT_DATE', array($userAccount));		//update lift_date
		}
	}

	/*-------------------------------------------------------------------------
	 * @function_name: メールの送信（無制限会員）
	 * @parameter	: なし
	 * @return		: なし
	 -------------------------------------------------------------------------*/
	function updateDepositFlg() {
		$this -> updateDepositStatusCommon($this -> getUserAccount(), $this -> getDepostFlgs());
		$this -> popUpSessionMessage(INFO, 'I_KYC_ADMIN_PROCESS', array());
	}


	/*-------------------------------------------------------------------------
	* @function_name: 失敗ファイルのエクスポート
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function export() {
		// データの作成
		$this -> makeExportData();
	}

	/*-------------------------------------------------------------------------
	* @function_name: メールの送信（無制限会員）
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function send() {

		// 変数宣言部
		$params = array();

		// 送信用パラメータを取得する
		$params = $this -> getSendParams();

		// メールの送信（管理者側）

		$this -> sendMailByTmpAndWL($this -> getUserAccount()
									, 'kyc_verification_for_user.xml'
									, $params
									, $params[VAL_INT_2]
									, 'cs@');
	}

	function insertActivity(){
		$this -> accessModify('INSERT_ACTIVITY', $this -> getActivity(), false);
	}

	//Class End
}

?>