<?php
class TransferModelClass extends ModelClassEx {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $toAccount			= null;			// 送金先口座
	private $fromCurrency		= NO_STRING;	// 送金元通貨
	private $toCurrency			= NO_STRING;	// 送金先通貨
	private $amount				= NO_COUNT;		// 金額
	private $transferType		= NO_COUNT;		// 送金方法
	private $message			= NO_STRING;	// メッセージ
	private $name				= NO_STRING;	// 送金先名前
	private $account			= NO_STRING;	// 履歴アカウント
	private $fromFee			= NO_COUNT;		// 手数料
	private $toFee				= NO_COUNT;		// 手数料（送金先）
	private $rate 				= NO_STRING;	// レート
	private $debitAmount		= NO_COUNT;		// 出金金額
	private $debitCurrency		= NO_STRING;	// 出金通貨
	private $transferAmount		= NO_COUNT;		// 送金金額
	private $transferCurrency	= NO_STRING;	// 送金通貨
	private $transactionNumber	= NO_STRING;	// 取引番号

	/*-------------------------------------------------------------------------
	* @function_name: コントロールパネルシステムindexモデルクラスコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		// スーパークラスコンストラクタ呼び出し
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: 初期設定関数
	* @parameter	: なし
	* @return		: 成功:success、失敗:error
	-------------------------------------------------------------------------*/
	public function init() {

		try {

			// パラメータの設定
			$this -> setParameter();

			// チェック
			$this -> validate();

		} catch (Exception $e) {
			throw $e;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: パラメータの設定
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function setParameter() {

		$this -> toAccount			= $this -> purifyInput($this -> getDataPost(PARAM_TRANSFER_TO_ACCOUNT));		// 送金口座
		$this -> fromCurrency		= $this -> purifyInput($this -> getDataPost(PARAM_TRANSFER_FROM_CURRENCY));	// 送金元通貨
		$this -> toCurrency			= $this -> purifyInput($this -> getDataPost(PARAM_TRANSFER_TO_CURRENCY));		// 送金先通貨
		$this -> amount				= $this -> purifyInput($this -> getDataPost(PARAM_AMOUNT));					// 金額
		$this -> transferType		= $this -> purifyInput($this -> getDataPost(PARAM_TRANSFER_TYPE));			// 送金タイプ
		$this -> message			= $this -> purifyInput($this -> getDataPost(PARAM_MESSAGE));					// メッセージ
		$this -> name				= $this -> purifyInput($this -> getDataPost(PARAM_NAME));						// 名前
		$this -> fromFee			= $this -> purifyInput($this -> getDataPost(PARAM_FROM_FEE));					// 手数料
		$this -> toFee				= $this -> purifyInput($this -> getDataPost(PARAM_TO_FEE));					// 手数料（送金先）
		$this -> rate				= $this -> purifyInput($this -> getDataPost(PARAM_RATE));						// レート
		$this -> debitAmount		= $this -> purifyInput($this -> getDataPost(PARAM_DEBIT_AMOUNT));				// 出金金額
		$this -> debitCurrency		= $this -> purifyInput($this -> getDataPost(PARAM_DEBIT_CURRENCY));			// 出金通貨
		$this -> transferAmount 	= $this -> purifyInput($this -> getDataPost(PARAM_TRANSFER_AMOUNT));			// 送金金額
		$this -> transferCurrency	= $this -> purifyInput($this -> getDataPost(PARAM_TRANSFER_CURRENCY));		// 送金通貨


		
		// 履歴からの場合は切り替える
		if($this -> getDataPost(PARAM_ACCOUNT) != NO_STRING) {
			$this -> toAccount = $this -> getDataPost(PARAM_ACCOUNT);
		}

	}

	/*-------------------------------------------------------------------------
	* @function_name: サーバ側データチェック
	* @parameter	: なし
	* @return		: TRUE:成功、FALSE:失敗
	-------------------------------------------------------------------------*/
	public function validate() {

		// 変数宣言部
		$rtn = true;

		// ログインチェック
		if(!$this -> checkSiteUserLogin()) {
			throw new Exception(NO_STRING);
		}

		// 送金元の口座ステータスチェック
		if(!$this -> checkAccountStatus($this -> getUserData(PARAM_USER_ACCOUNT), VAR_TRANSACTION_TRANSFER_WITHDRAW)) {
			throw new Exception(VAL_INT_99);
		}

		// 入力の場合
		if($this -> getType() == TYPE_INPUT) {
			//check if user is high risk - Mikko 2019 0313
			$from = $this -> getRowData($this -> getAccountCommon($this -> getUserData(PARAM_USER_ACCOUNT)));
    		if($this -> getColumnData($from, COLUMN_RISK_LEVEL) == VAL_INT_1){
               $this -> popUpSessionMessage(ERROR, 'E_ERROR_WITHDRAW_HIGH_RISK', array());
               $this->setType();
               return;
            }

			// 送金口座の入力チェック
			if(!$this -> checkNull($this -> toAccount)) {
				$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_TRANSFER_TO_ACCOUNT));
				$rtn = false;
			}

			// 入力状態に変更
			if(!$rtn) {
				$this -> setType(CONTROL_ACTION);
				return $rtn;
			}

			// 正規表現チェック（半角）
			if(strlen($this -> toAccount) != mb_strlen($this -> toAccount)) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_REGULAR_ASCII', array(VAL_STR_TRANSFER_TO_ACCOUNT));
				$rtn = false;
			}

			// 入力状態に変更
			if(!$rtn) {
				$this -> setType(CONTROL_ACTION);
				return $rtn;
			}

			// 同一口座チェック（口座番号）

			if($this -> checkSelfTransfer()) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_SAME_ACCOUNT_NUMBER', array());
				$rtn = false;
			}

			// 入力状態に変更
			if(!$rtn) {
				$this -> setType(CONTROL_ACTION);
				return $rtn;
			}

			// 送金先口座のステータスチェック
			if(!$this -> checkAccountStatus($this -> toAccount, VAR_TRANSACTION_TRANSFER_DEPOSIT)) {
				$this -> popUpSessionMessage(ERROR, 'E_DONT_TRANSFER_WITHDRAW_ACCOUNT', array());
				$rtn = false;
			}

			// 送金先口座の存在チェック（口座番号）
			$ac = $this -> checkExistAccountFromMailAddress($this -> toAccount);

			if($ac[COLUMN_USER_ACCOUNT] == NO_STRING) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_NOT_EXIST_ACCOUNT_NUMBER', array());
				$rtn = false;
			}elseif(!$this -> checkTransferBlock($ac[COLUMN_USER_ACCOUNT])){//check if incoming transfer is blocked
            	$this -> popUpSessionMessage(ERROR, 'E_ERROR_CANT_TRANSFER', array());
				$this->setType();
                return;
            } else {
				$this -> toAccount 	 = $ac[COLUMN_USER_ACCOUNT];
				$this -> name		 = $ac[COLUMN_USER_NAME];
			}

			// 入力状態に変更
			if(!$rtn) {
				$this -> setType(CONTROL_ACTION);
				return $rtn;
			}

			//create session variable for 2favalidated
			$_SESSION['2fa_validated'] = 'not validated';

		// 確認の場合
		} else if($this -> getType() == TYPE_CONFIRM) {

			// 変数宣言部
			$balance	= null;
			$tCurrency 	= NO_STRING;
			$tAmount	= NO_COUNT;
			$lowLimit	= NO_COUNT;

			// 入力状態に変更
			if(!$rtn) {
				$this -> setType(TYPE_INPUT);
				return $rtn;
			}

			if($this -> checkSelfTransfer()) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_SAME_ACCOUNT_NUMBER', array());
				$rtn = false;
			}

			// 入力状態に変更
			if(!$rtn) {
				$this -> setType(CONTROL_ACTION);
				return $rtn;
			}

			// 送金金額の入力チェック
			if(!$this -> checkNull($this -> amount)) {
				$this -> popUpSessionMessage(ERROR, 'E_REQUIRED_VALUE', array(VAL_STR_AMOUNT));
				$rtn = false;
			// 正規表現チェック（半角数字）
			} else if(!$this -> checkStringNumber($this -> amount)) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_REGULAR_NUMBER', array(VAL_STR_AMOUNT));
				$rtn = false;
			}

			// メッセージの正規表現
			if(!$this -> checkStringMessage($this -> message)) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_REGULAR_MESSAGE', array(VAL_STR_AMOUNT));
				$rtn = false;
			}

			// 入力状態に変更
			if(!$rtn) {
				$this -> setType(TYPE_INPUT);
				return $rtn;
			}

			// 小数点チェック
			$loc = explode(DELIMIT_DOT, $this -> amount);
			if(strpos($this -> amount, DELIMIT_DOT)) {
				if($this -> transferType == NO_COUNT) {
					if($this -> fromCurrency == JPY || $this -> fromCurrency == PHP || $this -> fromCurrency == IDR || $this -> fromCurrency == MYR || $this -> fromCurrency == THB || $this -> fromCurrency == VND){
						$this -> popUpSessionMessage(ERROR, 'E_MINIMUM', array(VAL_STR_AMOUNT, VAL_INT_1));
						$rtn = false;
					}
				} else if($this -> transferType == VAL_INT_1) {
					if($this -> toCurrency == JPY || $this -> toCurrency == PHP || $this -> toCurrency == IDR || $this -> toCurrency == MYR || $this -> toCurrency == THB || $this -> toCurrency == VND){
						$this -> popUpSessionMessage(ERROR, 'E_MINIMUM', array(VAL_STR_AMOUNT, VAL_INT_1));
						$rtn = false;
					}
				} else if(strlen($loc[VAL_INT_1]) > 2) {
					$this -> popUpSessionMessage(ERROR, 'E_NOT_NUMBER_POINT', array());
					$rtn = false;
				}
			}


			// 入力状態に変更
			if(!$rtn) {
				$this -> setType(TYPE_INPUT);
				return $rtn;
			}

			// 送金、出金通貨設定
			$this -> debitCurrency 		= $this -> fromCurrency;	// 出金通貨
			$this -> transferCurrency	= $this -> toCurrency;		// 送金通貨
			
			// 送金、出金金額設定
			if($this -> transferType == NO_COUNT) {
				$exchange	= $this -> getExchangeCommon($this -> amount, $this -> debitCurrency, $this -> transferCurrency, 
						true, false, NO_STRING, $this -> getUserData(PARAM_USER_ACCOUNT));
				
				$this -> debitAmount 		= $this -> amount;												// 出金金額

				if($this -> debitCurrency == $this -> transferCurrency) {
					$this -> transferAmount 	= $this -> amount;											// 送金金額
				} else {
					$this -> transferAmount 	= $exchange[PARAM_AMOUNT];										// 送金金額
				}

				$debitlowLimit				= VAL_INT_1 / ($this -> getDigit($this -> debitCurrency));		// 出金最低金額
				$transferlowLimit			= VAL_INT_1 / ($this -> getDigit($this -> transferCurrency));	// 送金最低金額

				// 金額の最低金額チェック
				if($this -> debitAmount < $debitlowLimit) {
					$this -> popUpSessionMessage(ERROR, 'E_MINIMUM', array(VAL_STR_AMOUNT, $debitlowLimit));
					$rtn = false;
				}

				// 出金額が最低金額以下になる場合は最低金額を設定
				if($this-> debitAmount < $debitlowLimit) {
					$this -> debitAmount = $debitlowLimit;
				}

				// 送金額調整
				if($this -> transferAmount > ($this -> debitAmount * $exchange[PARAM_RATE])) {
					$this -> transferAmount = NO_COUNT;
				}

			} else if($this -> transferType == VAL_INT_1){
				$exchange	= $this -> getExchangeCommon($this -> amount, $this -> transferCurrency, $this -> debitCurrency, 
						true, true, NO_STRING, $this -> getUserData(PARAM_USER_ACCOUNT));
				
				$this -> transferAmount 	= $this -> amount;												// 送金金額

				if($this -> transferCurrency == $this -> debitCurrency) {
					$this -> debitAmount 	= $this -> amount;											// 送金金額
				} else {
					$this -> debitAmount 	= $exchange[PARAM_AMOUNT];										// 出金金額
				}
				
				$debitlowLimit				= VAL_INT_1 / ($this -> getDigit($this -> debitCurrency));		// 出金最低金額
				$transferlowLimit			= VAL_INT_1 / ($this -> getDigit($this -> transferCurrency));	// 送金最低金額

				// 金額の最低金額チェック
				if($this -> transferAmount < $transferlowLimit) {
					$this -> popUpSessionMessage(ERROR, 'E_MINIMUM', array(VAL_STR_AMOUNT, $transferlowLimit));
					$rtn = false;
				}

				// IWalletが損しない為の処理
				if($this -> transferAmount > ($this -> debitAmount / $exchange[PARAM_RATE])) {
					$this -> debitAmount += $debitlowLimit;
				}
			}
			
			// レートの取得
			$this -> rate	= $this -> getRateCommon($this -> debitCurrency, $this -> transferCurrency, 
					$originalt, NO_STRING, $this -> getUserData(PARAM_USER_ACCOUNT));


			// 制限口座のチェック
			if(!$this -> checkWithdrawLimit($this -> getUserData(PARAM_USER_ACCOUNT)
											, $this -> debitCurrency
											, $this -> currencyToInt($this -> debitAmount, $this -> debitCurrency))) {
				$this -> popUpSessionMessage(ERROR, 'E_LIMIT_WITHDRAW', array());
				$rtn = false;
			}

			// 入力状態に変更
			if(!$rtn) {
				$this -> setType(TYPE_INPUT);
				return $rtn;
			}

            //set fee
            $this -> setFee();
            
			// 残高取得
			$balance	= $this -> getBalanceCommon($this -> getUserData(PARAM_USER_ACCOUNT), $this -> debitCurrency);

			// 残高チェック
			if($balance < ($this -> debitAmount + $this -> fromFee)) {
				$this -> popUpSessionMessage(ERROR, 'E_INSUFFICIENT_FUNDS', array($this -> debitCurrency, $this -> formatCurrency(($this -> debitAmount + $this -> fromFee), $this -> debitCurrency)));
				$rtn = false;
			}

			// メッセージの入力文字数チェック
			if(!$this -> checkLength($this -> message, NO_COUNT, VAL_INT_500)) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_STRING_LENGTH_ANY_2', array(VAL_STR_MESSAGE, VAL_INT_500));
				$rtn = false;
			}

			// 入力状態に変更
			if(!$rtn) {
				$this -> setType(TYPE_INPUT);
				return $rtn;
			}
			
            //set transfer session data
            $this -> setTransferSessionData();

			//create session variable for 2favalidated
			$_SESSION['2fa_validated'] = 'not validated';

		// 登録の場合
		} else if($this -> getType() == TYPE_COMPLETE) {

			//check if 2fa is enabled
			if($this -> check2FAEnabled($this -> getUserData(PARAM_USER_ACCOUNT), 'transfer')){
				//cehck if 2fa validated
				if(!$this -> checkIs2FAValidated()) {
					$this -> setType(TYPE_INPUT);
					return false;
				}
			}

            //get transfer session data
            $this -> getTransferSessionData();


			if($this -> checkSelfTransfer()) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_SAME_ACCOUNT_NUMBER', array());
				$rtn = false;
			}

			// 入力状態に変更
			if(!$rtn) {
				$this -> setType(CONTROL_ACTION);
				return $rtn;
			}

			// 変数宣言部
			$balance	= null;

            //set fee
            $this -> setFee();
            
			// 残高取得
			$balance	= $this -> getBalanceCommon($this -> getUserData(PARAM_USER_ACCOUNT), $this -> debitCurrency);

			// 残高チェック
			if($balance < ($this -> debitAmount + $this -> fromFee)) {
				$this -> popUpSessionMessage(ERROR, 'E_INSUFFICIENT_FUNDS', array($this -> debitCurrency, $this -> formatCurrency(($this -> debitAmount + $this -> fromFee), $this -> debitCurrency)));
				$rtn = false;
			}

			// 入力状態に変更
			if(!$rtn) {
				$this -> setType(TYPE_INPUT);
				return $rtn;
			}

            // 制限口座のチェック
			if(!$this -> checkWithdrawLimit($this -> getUserData(PARAM_USER_ACCOUNT)
											, $this -> debitCurrency
											, $this -> currencyToInt($this -> debitAmount, $this -> debitCurrency))) {
				$this -> popUpSessionMessage(ERROR, 'E_LIMIT_WITHDRAW', array());
				$rtn = false;
			}

            // 制限口座のチェック
			if(!$this -> checkWithdrawLimit($this -> getUserData(PARAM_USER_ACCOUNT)
											, $this -> debitCurrency
											, $this -> currencyToInt($this -> transferAmount, $this -> debitCurrency))) {
				$this -> popUpSessionMessage(ERROR, 'E_LIMIT_WITHDRAW', array());
				$rtn = false;
			}

			// 入力状態に変更
			if(!$rtn) {
				$this -> setType(TYPE_INPUT);
				return $rtn;
			}

		} else {
			//二次认证判断
			if (!$this -> get2FaValue(array($this -> getUserData(PARAM_USER_ACCOUNT),'transfer_status','transfer_update_time'))) {
				$this -> popUpSessionMessage(ERROR, 'E_ERROR_2FA_24TRANSFER_LOCK', array());
				$this -> setType(TYPE_2FA_DISABLE_ONE);
				return false;
			}
		}

		return true;
	}

	/*-------------------------------------------------------------------------
	* @function_name: HTML表示用のデータ取得関数
	* @parameter	: なし
	* @return		: HTML表示用データ配列
	-------------------------------------------------------------------------*/
	public function dispHTML() {
		return array();
	}

	/*-------------------------------------------------------------------------
	* @function_name: 登録用のデータを取得
	* @parameter	: なし
	* @return		: 登録用データ
	-------------------------------------------------------------------------*/
	public function getRegistData() {

		// 変数宣言部
		$rtn = array();

		// 取引番号取得
		$this -> transactionNumber = $this -> getTransactionNumberCommon(VAR_TRANSACTION_TRANSFER_DEPOSIT);

		// メッセージのエスケープ処理
		$this -> message = addslashes($this -> message);
		$this -> message = str_replace("\'", "'", $this -> message);

		$rtn[] = $this -> getUserData(PARAM_USER_ACCOUNT);										// 送金元口座番号
		$rtn[] = $this -> getUserData(PARAM_USER_ACCOUNT);										// 送金元口座番号
		$rtn[] = $this -> debitCurrency;														// 送金通貨
		$rtn[] = $this -> currencyToInt($this -> fromFee, $this -> debitCurrency);				// 口座元手数料
		$rtn[] = $this -> toAccount;															// 送金先口座番号
		$rtn[] = $this -> transferCurrency;														// 送金元通貨
		$rtn[] = $this -> currencyToInt($this -> toFee, $this -> transferCurrency);				// 送金元手数料
		$rtn[] = $this -> amount;																// 入力金額
		$rtn[] = $this -> transferType;															// 送金方法
		$rtn[] = $this -> message;																// メッセージ
		$rtn[] = $this -> debitCurrency;														// 出金通貨
		$rtn[] = $this -> currencyToInt($this -> debitAmount, $this -> debitCurrency);			// 出金金額
		$rtn[] = $this -> transferCurrency;														// 送金通貨
		$rtn[] = $this -> currencyToInt($this -> transferAmount, $this -> transferCurrency);	// 送金金額
		$rtn[] = $this -> rate;																	// レート
		$rtn[] = NO_COUNT;																		// 処理種別
		$rtn[] = NO_STRING;																		// 管理者ID
		$rtn[] = NO_COUNT;																		// 処理ステータス
		$rtn[] = $this -> transactionNumber;													// トランザクションナンバー
		$rtn[] = date("Y-m-d H:i:s");															// トランザクションナンバー

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: コミッションの登録
	 * @parameter	: なし
	 * @return		: なし
	 -------------------------------------------------------------------------*/
	public function transferRegistCommision() {

		// 送金元口座情報の取得
		$from = $this -> getRowData($this -> getAccountCommon($this -> getUserData(PARAM_USER_ACCOUNT)));

		// コミッションの集計（送金元）
		$this -> registCommision(VAR_TRANSFER
				, $this -> getColumnData($from, COLUMN_PARENT_AGENT_CODE)
				, $this -> getUserData(PARAM_USER_ACCOUNT)
				, $this -> debitCurrency
				, $this -> fromFee);

		// 送金先口座情報の取得
		$to = $this -> getRowData($this -> getAccountCommon($this -> toAccount));

		// コミッションの集計（送金先）
		$this -> registCommision(VAR_TRANSFER
				, $this -> getColumnData($to, COLUMN_PARENT_AGENT_CODE)
				, $this -> toAccount
				, $this -> transferCurrency
				, $this -> toFee
				, PARAM_TO);
	}

	/*-------------------------------------------------------------------------
	 * @function_name: メール送信用のデータを取得（送金元ユーザ）
	 * @parameter	: なし
	 * @return		: メール送信用データ
	 -------------------------------------------------------------------------*/
	public function getSendDataFrom() {

		// 変数宣言部
		$rtn	= array();
		$data	= $this -> getAccountCommon($this -> getUserData(PARAM_USER_ACCOUNT));
		$row	= $this -> getRowData($data);
		$data2	= $this -> getAccountCommon($this -> toAccount);
		$row2	= $this -> getRowData($data2);

		$rtn[] = $this -> getUserData(PARAM_USER_ACCOUNT);										// ユーザ口座番号
		$rtn[] = $this -> getColumnData($row, COLUMN_FIRST_NAME)
				. DELIMIT_SPACE . $this -> getColumnData($row, COLUMN_LAST_NAME);				// ユーザ名
		$rtn[] = $this -> toAccount;															// 送金先口座番号
		$rtn[] = $this -> getColumnData($row2, COLUMN_FIRST_NAME)
				. DELIMIT_SPACE . $this -> getColumnData($row2, COLUMN_LAST_NAME);				// ユーザ名（送金先）
		$rtn[] = $this -> getCurrentTimeCommon();												// 現在時刻
		$rtn[] = $this -> transferCurrency;														// 通貨
		$rtn[] = $this -> formatCurrency($this -> transferAmount, $this -> transferCurrency);	// 金額
		$rtn[] = $this -> debitCurrency;														// 手数料通貨
		$rtn[] = $this -> formatCurrency($this -> fromFee, $this -> debitCurrency);				// 手数料
		$rtn[] = $this -> message;																// メッセージ
		$rtn[] = $this -> transactionNumber;													// 取引番号
		$rtn[] = $this -> getColumnData($row, COLUMN_MAIL);										// メールアドレス

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: メール送信用のデータを取得（送金先ユーザ）
	 * @parameter	: なし
	 * @return		: メール送信用データ
	 -------------------------------------------------------------------------*/
	public function getSendDataTo() {

		// 変数宣言部
		$rtn	= array();
		$data	= $this -> getAccountCommon($this -> getUserData(PARAM_USER_ACCOUNT));
		$row	= $this -> getRowData($data);
		$data2	= $this -> getAccountCommon($this -> toAccount);
		$row2	= $this -> getRowData($data2);

		$rtn[] = $this -> toAccount;															// ユーザ口座番号
		$rtn[] = $this -> getColumnData($row2, COLUMN_FIRST_NAME)
				. DELIMIT_SPACE . $this -> getColumnData($row2, COLUMN_LAST_NAME);				// ユーザ名
		$rtn[] = $this -> getUserData(PARAM_USER_ACCOUNT);										// 送金先口座番号
		$rtn[] = $this -> getColumnData($row, COLUMN_FIRST_NAME)
				. DELIMIT_SPACE . $this -> getColumnData($row, COLUMN_LAST_NAME);				// ユーザ名（送金元）
		$rtn[] = $this -> getCurrentTimeCommon();												// 現在時刻
		$rtn[] = $this -> transferCurrency;														// 通貨
		$rtn[] = $this -> formatCurrency($this -> transferAmount, $this -> transferCurrency);	// 金額
		$rtn[] = $this -> transferCurrency;														// 手数料通貨
		$rtn[] = $this -> formatCurrency($this -> toFee, $this -> transferCurrency);			// 手数料
		$rtn[] = $this -> message;																// メッセージ
		$rtn[] = $this -> transactionNumber;													// 取引番号
		$rtn[] = $this -> getColumnData($row2, COLUMN_MAIL);									// メールアドレス

		return $rtn;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 出金金額の取得
	 * @parameter	: なし
	 * @return		: 出金金額
	 -------------------------------------------------------------------------*/
	function getRegistDebitAmount() {
		return $this -> debitAmount - $this -> fromFee;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 送金方法の取得
	 * @parameter	: なし
	 * @return		: 送金方法
	 -------------------------------------------------------------------------*/
	function getTransferType() {
		return $this -> transferType;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 出金通貨の取得
	 * @parameter	: なし
	 * @return		: 出金通貨
	 -------------------------------------------------------------------------*/
	function getDebitCurrency() {
		return $this -> debitCurrency;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 出金金額の取得
	 * @parameter	: なし
	 * @return		: 出金金額
	 -------------------------------------------------------------------------*/
	function getDebitAmount() {
		return $this -> debitAmount;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 送金通貨の取得
	 * @parameter	: なし
	 * @return		: 送金通貨
	 -------------------------------------------------------------------------*/
	function getTransferCurrency() {
		return $this -> transferCurrency;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 送金金額の取得
	 * @parameter	: なし
	 * @return		: 送金金額
	 -------------------------------------------------------------------------*/
	function getTransferAmount() {
		return $this -> transferAmount;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 送金通貨の取得
	 * @parameter	: なし
	 * @return		: 送金通貨
	 -------------------------------------------------------------------------*/
	function getRegistFromFee() {
		return $this -> fromFee;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 出金金額の取得
	 * @parameter	: なし
	 * @return		: 出金金額
	 -------------------------------------------------------------------------*/
	function getRegistTransferAmount() {
		return $this -> transferAmount;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 送金通貨の取得
	 * @parameter	: なし
	 * @return		: 送金通貨
	 -------------------------------------------------------------------------*/
	function getRegistToFee() {
		return $this -> toFee;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 送金先口座の取得
	 * @parameter	: なし
	 * @return		: 送金先口座
	 -------------------------------------------------------------------------*/
	function getRegistToAccount() {
		return $this -> toAccount;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 送金先の取得
	 * @parameter	: なし
	 * @return		: 口座名義
	 -------------------------------------------------------------------------*/
	function echoAccountList() {

		// 変数宣言部
		$rtn	= NO_STRING;
		$rs 	= $this -> getTransferHistoryData($this -> getUserData(PARAM_USER_ACCOUNT));

		$rtn .= '<option value="">' . $this -> getMessage(INFO, 'I_SELECT_HISTORY', array()) . '</option>';

		if($this -> isLoopData($rs)) {
			foreach ($rs as $row) {
				if($row[COLUMN_TO_ACCOUNT] == $this -> toAccount) {
					$rtn .= '<option value="' . $row[COLUMN_TO_ACCOUNT] . '" selected>' . $row[COLUMN_TO_ACCOUNT] . '</option>';
				} else {
					$rtn .= '<option value="' . $row[COLUMN_TO_ACCOUNT] . '">' . $row[COLUMN_TO_ACCOUNT] . '</option>';;
				}
			}
		}
		return $rtn;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 送金先の取得
	 * @parameter	: なし
	 * @return		: 口座名義
	 -------------------------------------------------------------------------*/
	function echoAccountNumber() {
		echo $this -> toAccount;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 送金先名前の取得
	 * @parameter	: なし
	 * @return		: 送金先名前
	 -------------------------------------------------------------------------*/
	function echoName() {
		echo $this -> name;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 金額の取得
	 * @parameter	: なし
	 * @return		: 金額
	 -------------------------------------------------------------------------*/
	function echoAmount() {
		echo $this -> amount;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: メッセージの取得
	 * @parameter	: なし
	 * @return		: メッセージ
	 -------------------------------------------------------------------------*/
	function echoTMessage() {
		echo $this -> message;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: メッセージの取得
	 * @parameter	: なし
	 * @return		: メッセージ
	 -------------------------------------------------------------------------*/
	function echoSMessage() {
		echo nl2br($this -> message);
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 送金方法チェック状態の取得
	 * @parameter	: なし
	 * @return		: HTML文字列
	 -------------------------------------------------------------------------*/
	function echoTransferTypeChecked($type) {
		if($type == $this -> transferType) {
			echo 'checked';
		}
		return;
	}
	/*-------------------------------------------------------------------------
	 * @function_name: 送金方法の取得
	 * @parameter	: なし
	 * @return		: 送金方法
	 -------------------------------------------------------------------------*/
	function echoTransferType() {
		echo $this -> transferType;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 送金元通貨の取得
	 * @parameter	: なし
	 * @return		: 送金元通貨
	 -------------------------------------------------------------------------*/
	function echoFromCurrency() {
		echo $this -> fromCurrency;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 送金先通貨の取得
	 * @parameter	: なし
	 * @return		: 送金先通貨
	 -------------------------------------------------------------------------*/
	function echoToCurrency() {
		echo $this -> toCurrency;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 手数料の取得
	 * @parameter	: なし
	 * @return		: 手数料
	 -------------------------------------------------------------------------*/
	function echoFromFee() {
		echo $this -> fromFee;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 手数料の取得（送金先）
	 * @parameter	: なし
	 * @return		: 手数料
	 -------------------------------------------------------------------------*/
	function echoToFee() {
		echo $this -> toFee;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: レートの取得
	 * @parameter	: なし
	 * @return		: レート
	 -------------------------------------------------------------------------*/
	function echoRate() {
		echo $this -> rate;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: レートの取得（表示用）
	 * @parameter	: なし
	 * @return		: レート
	 -------------------------------------------------------------------------*/
	function echoDispRate() {
// 		echo $this -> formatCurrency($this -> rate, $this -> transferCurrency);
		echo $this -> rate;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 送金金額の取得
	 * @parameter	: なし
	 * @return		: 送金金額
	 -------------------------------------------------------------------------*/
	function echoDebitAmount() {
		echo $this -> debitAmount;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 送金通貨の取得
	 * @parameter	: なし
	 * @return		: 送金通貨
	 -------------------------------------------------------------------------*/
	function echoDebitCurrency() {
		echo $this -> debitCurrency;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 送金金額の取得
	 * @parameter	: なし
	 * @return		: 送金金額
	 -------------------------------------------------------------------------*/
	function echoDispDebitAmount() {
		echo number_format($this -> debitAmount);
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 送金金額の取得
	 * @parameter	: なし
	 * @return		: 送金金額
	 -------------------------------------------------------------------------*/
	function echoTransferAmount() {
		echo $this -> transferAmount;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 送金通貨の取得
	 * @parameter	: なし
	 * @return		: 送金通貨
	 -------------------------------------------------------------------------*/
	function echoTransferCurrency() {
		echo $this -> transferCurrency;
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 送金金額の取得
	 * @parameter	: なし
	 * @return		: 送金金額
	 -------------------------------------------------------------------------*/
	function echoDispTotal() {
		echo number_format($this -> debitAmount);
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 通貨一覧の取得（送金元）
	 * @parameter	: なし
	 * @return		: 通貨一覧
	 -------------------------------------------------------------------------*/
	public function echoFromCurrencyList() {
		echo $this -> dispCurrencyOptionList($this -> fromCurrency, false);
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 通貨一覧の取得（送金先）
	 * @parameter	: なし
	 * @return		: 通貨一覧
	 -------------------------------------------------------------------------*/
	public function echoToCurrencyList() {
		echo $this -> dispCurrencyOptionList($this -> toCurrency, false);
	}

	/*-------------------------------------------------------------------------
	 * @function_name: 送金金額の取得
	 * @parameter	: なし
	 * @return		: 送金金額
	 -------------------------------------------------------------------------*/
	public function echoDebitAmountNumber() {
		$number = number_format($this -> debitAmount, 2);
		echo preg_replace("/\.?0+$/","",$number);

	}

	/*-------------------------------------------------------------------------
	 * @function_name: 受取金額の取得
	 * @parameter	: なし
	 * @return		: 受取金額
	 -------------------------------------------------------------------------*/
	public function echoTransferAmountNumber() {
		$number = number_format($this -> transferAmount, 2);
		echo preg_replace("/\.?0+$/","",$number);
	}

	public function checkSelfTransfer() {
		$rtn = false;
		// 同一口座チェック（口座番号）
		if($this -> toAccount == $this -> getUserData(PARAM_USER_ACCOUNT)) {
			$rtn = true;
		}
		// 同一口座チェック（メールアドレス）
		if($this -> toAccount == $this -> getUserData(PARAM_MAIL)) {
			$rtn = true;
		}
		return $rtn;
	}
    /*-------------------------------------------------------------------------
	 * @function_name: setFee
	 * @parameter	:
	 * @return		:
	 -------------------------------------------------------------------------*/
    public function setFee(){
        // 手数料取得
        $fee		= $this -> getFeeCommon(VAR_TRANSFER
                                            , $this -> debitAmount
                                            , $this -> debitCurrency
                                            , $this -> getUserData(PARAM_USER_ACCOUNT)
                                            , $this -> toAccount
                                            , $this -> transferCurrency
                                            , $this -> transferAmount);
        
        // 送金元手数料設定
        if($fee[$this -> debitCurrency . VAL_INT_1] > NO_COUNT) {

// 				// 送金元の手数料を出金通貨に両替
// 				$exchangeFromFee = 	$this -> getExchangeCommon($fee[$this -> transferCurrency . VAL_INT_1]
// 																, $this -> transferCurrency
// 																, $this -> debitCurrency);

            // 小数点を桁数で切り捨て
            $digit				= $this -> getDigit($this -> debitCurrency);
            $this -> fromFee 	= floor(bcmul($fee[$this -> debitCurrency . VAL_INT_1], $digit, 2));
            $this -> fromFee	= bcdiv($this -> fromFee, $digit, 4);

            // 最小金額を算出
            $low				= VAL_INT_1 / $digit;

            // 0の場合は最低金額を設定
            if($this -> fromFee < $low) {
                $this -> fromFee = VAL_INT_1 / $digit;
            }
        } else {
            $this -> fromFee = NO_COUNT;
        }

        // 送金先手数料設定
        if($fee[$this -> transferCurrency . VAL_INT_2] > NO_COUNT) {

            // 小数点を桁数で切り捨て
            $digit			= $this -> getDigit($this -> transferCurrency);
            $this -> toFee 	= floor(bcmul($fee[$this -> transferCurrency . VAL_INT_2], $digit, 2));
            $this -> toFee	= bcdiv($this -> toFee, $digit, 4);

            // 最小金額を算出
            $low				= VAL_INT_1 / $digit;

            // 0の場合は最低金額を設定
            if($this -> toFee < $low) {
                $this -> toFee = VAL_INT_1 / $digit;
            }
        } else {
            $this -> toFee = NO_COUNT;
        }
    }

    /*-------------------------------------------------------------------------
	 * @function_name: setTransferSessionData
	 * @parameter	:
	 * @return		:
	 -------------------------------------------------------------------------*/
    public function setTransferSessionData(){
        $_SESSION['Transfer'] = array();
        $_SESSION['Transfer']['toAccount']          = $this -> toAccount;
		$_SESSION['Transfer']['fromCurrency']       = $this -> fromCurrency;
		$_SESSION['Transfer']['toCurrency']         = $this -> toCurrency;
		$_SESSION['Transfer']['amount']             = $this -> amount;
		$_SESSION['Transfer']['transferType']       = $this -> transferType;
		$_SESSION['Transfer']['message']            = $this -> message;
		$_SESSION['Transfer']['name']               = $this -> name;
		$_SESSION['Transfer']['fromFee']            = $this -> fromFee;
		$_SESSION['Transfer']['toFee']              = $this -> toFee;
		$_SESSION['Transfer']['rate']               = $this -> rate;
		$_SESSION['Transfer']['debitAmount']        = $this -> debitAmount;
		$_SESSION['Transfer']['debitCurrency']      = $this -> debitCurrency;
		$_SESSION['Transfer']['transferAmount']     = $this -> transferAmount;
		$_SESSION['Transfer']['transferCurrency']   = $this -> transferCurrency;
    }

    /*-------------------------------------------------------------------------
	 * @function_name: setTransferSessionData
	 * @parameter	:
	 * @return		:
	 -------------------------------------------------------------------------*/
    public function getTransferSessionData(){
        if(isset($_SESSION['Transfer'])){
            $this -> toAccount        = $_SESSION['Transfer']['toAccount'];
    		$this -> fromCurrency     = $_SESSION['Transfer']['fromCurrency'];
    		$this -> toCurrency       = $_SESSION['Transfer']['toCurrency'];
    		$this -> amount           = $_SESSION['Transfer']['amount'];
    		$this -> transferType     = $_SESSION['Transfer']['transferType'];
    		$this -> message          = $_SESSION['Transfer']['message'];
    		$this -> name             = $_SESSION['Transfer']['name'];
    		$this -> fromFee          = $_SESSION['Transfer']['fromFee'];
    		$this -> toFee            = $_SESSION['Transfer']['toFee'];
    		$this -> rate             = $_SESSION['Transfer']['rate'];
    		$this -> debitAmount      = $_SESSION['Transfer']['debitAmount'];
    		$this -> debitCurrency    = $_SESSION['Transfer']['debitCurrency'];
    		$this -> transferAmount   = $_SESSION['Transfer']['transferAmount'];
    		$this -> transferCurrency = $_SESSION['Transfer']['transferCurrency'];
        }
    }
}
?>