<?php
require_once(SYSTEM_LOGICS . 'total/model.php');

class LogicTotal extends TotalModelClass {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $htmlStr = NO_STRING;	// 表示用HTML文字列

	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: ロジック（各クラス共通）
	* @parameter	: なし
	* @return		: TRUE:ロジック成功、FALSE:ロジック失敗
	-------------------------------------------------------------------------*/
	function logic() {

		try {

			// 初期データ処理
			if($this -> init()) {

				if($this -> getType() == TYPE_DETAIL) {
					$this -> detail();
				} else if($this -> getType() == TYPE_CONFIRM) {
					$this -> detailDateCurrencyType();
				} else {
					$this -> lists();
				}

			}
		} catch (Exception $e) {
			throw $e;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: 集計一覧の取得
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function lists() {

		// エージェントデータ
		$this -> setResult($this -> accessSelect('LIST_TOTAL', array($this -> getWhere())));
	}

	/*-------------------------------------------------------------------------
	* @function_name: 集計（日付）の取得
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function detail() {

		// エージェントデータ
		$this -> setResult($this -> accessSelect('LIST_TOTAL_BY_DATE', $this -> getWhereByDate()));
	}

	/*-------------------------------------------------------------------------
	* @function_name: 集計（日付、通貨、処理タイプ）の取得
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function detailDateCurrencyType() {

		// 変数宣言部
		$type	= NO_STRING;
		$rs		= array();

		// 検索タイプの取得
		$type = $this -> getTransactionType();

		// 取得タイプによってデータ取得SQL変更
		switch($type) {
			case COLUMN_DEPOSIT_COUNT:			// 入金
				$rs = $this -> accessSelect('LIST_TOTAL_BY_DATE_CURRENCY_DEPOSIT', $this -> getWhereByDateCurrencyType());
				break;

			case COLUMN_WITHDRAW_APPLY_COUNT:	// 出金申請
				$rs = $this -> accessSelect('LIST_TOTAL_BY_DATE_CURRENCY_WITHDRAW_APPLY', $this -> getWhereByDateCurrencyType());
				break;

			case COLUMN_WITHDRAW_COUNT:			// 出金
				$rs = $this -> accessSelect('LIST_TOTAL_BY_DATE_CURRENCY_WITHDRAW', $this -> getWhereByDateCurrencyType());
				break;

			case COLUMN_TRANSFER_COUNT:			// 口座振替
				$rs = $this -> accessSelect('LIST_TOTAL_BY_DATE_CURRENCY_TRANSFER', $this -> getWhereByDateCurrencyType());
				break;

			case COLUMN_FEE_COUNT:				// 手数料
				$rs = $this -> accessSelect('LIST_TOTAL_BY_DATE_CURRENCY_FEE', $this -> getWhereByDateCurrencyType());
				break;

			case COLUMN_EXCHANGE_COUNT:			// 通貨両替
				$rs = $this -> accessSelect('LIST_TOTAL_BY_DATE_CURRENCY_EXCHANGE', $this -> getWhereByDateCurrencyType());
				break;
			default:
				break;
		}

		// データの設定
		$this -> setResult($rs);
	}
}
?>