<?php
require_once(SITE_LOGICS . 'setting/model.php');

class LogicSetting extends SettingModelClass {

	/*-------------------------------------------------------------------------
	* @ メンバ変数
	-------------------------------------------------------------------------*/
	private $htmlStr		= NO_STRING;	// 表示用HTML文字列
	private $accountType	= NO_STRING;	// 口座種別

	/*-------------------------------------------------------------------------
	* @function_name: ロジックのコンストラクタ
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	function __construct() {
		parent::__construct();
	}

	/*-------------------------------------------------------------------------
	* @function_name: ロジック（各クラス共通）
	* @parameter	: なし
	* @return		: TRUE:ロジック成功、FALSE:ロジック失敗
	-------------------------------------------------------------------------*/
	function logic() {

		try {

			// 初期データ処理
			$this -> init();

			// ロジック実行
			$this -> biz();

		} catch (Exception $e) {
			throw $e;
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: ロジックの実行
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function biz() {
		// ロジックの振り分け
		if($this -> getAction()				== NO_STRING
			&& $this -> getType()			== TYPE_COMPLETE) {			// プロフィール登録
			$this -> updateProfile();
		} else if($this -> getAction()		== CONTROL_SETTING_KYC
					&& $this -> getType()	== TYPE_SAVE) {				// KYC登録（個人）
			$this -> load();
			$this -> loadImageKycPerson();
			$this -> updateKycValidateStatus();
			$this -> listKYC();
			
			header('Location: /' . $this ->  getLangage() . '/setting?type=settting_kyc&loaded=1');
		} else if($this -> getAction()		== CONTROL_SETTING_KYC
					&& $this -> getType()	== TYPE_COMPLETE) {			// KYC登録（法人）
			$this -> loadImageKycCorp();
			$this -> updateKycValidateStatus();
			$this -> listKYC();
			
			header('Location: /' . $this ->  getLangage() . '/setting?type=settting_kyc&loaded=1');
		} else if($this -> getAction()		== CONTROL_SETTING_KYC
					&& $this -> getType()	== TYPE_EXPORT) {			// KYC書類ダウンロード
			$this -> download();
		} else if($this -> getAction()		== CONTROL_SETTING_CHANGE_PASSWORD
					&& $this -> getType()	== TYPE_COMPLETE) {			// パスワード変更

			//check if 2fa is enabled
			if($this -> check2FAEnabled($this -> getUserData(PARAM_USER_ACCOUNT), 'password')){
				//cehck if 2fa validated
				if(!$this -> checkIs2FAValidated()) {
					$this -> setType(CONTROL_SETTING_CHANGE_PASSWORD);
					return;
				}
			}

			$this -> updatePassword();

			//create session variable for 2favalidated
			$_SESSION['2fa_validated'] = 'not validated';
			
		} else if($this -> getAction()		== CONTROL_SETTING_CHANGE_MAIL
					&& $this -> getType()	== TYPE_CONFIRM) {			// メール送信（変更申請）

			//check if 2fa is enabled
			if($this -> check2FAEnabled($this -> getUserData(PARAM_USER_ACCOUNT), 'mail')){
				//cehck if 2fa validated
				if(!$this -> checkIs2FAValidated()) {
					$this -> setType(CONTROL_SETTING_CHANGE_MAIL);
					return;
				}
			}

			$this -> load();
			$this -> send();

			//create session variable for 2favalidated
			$_SESSION['2fa_validated'] = 'not validated';
			
		}else if($this -> getType() 		== TYPE_TRANSFER_FLAG_SAVE 
					&& $this -> getAction() == TYPE_TRANSFER_SETTING) {			
			$this -> updateTransferFlg();
			header('Location: /' . $this ->  getLangage() . '/setting?type=TransferSettings');
			
		} else if($this -> getType()		== CONTROL_SETTING_KYC) {	// アカウントタイプによって振り分け
			$this -> setAccountType();
			$this -> load();
			$this -> listKYC();
			
			if($this->getDataGet("loaded")){
			    AWSMangos3Bucket::getInstance()->deleteLocalDirectory($this->getKycDirectory($this->getUserData(PARAM_USER_ACCOUNT)));
			}
		} else {
			$this -> load();
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: データのロード
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function load() {
		$this -> setUser($this -> accessSelect('SELECT_USER_BY_ACCOUNT', array($this -> getUserData(PARAM_USER_ACCOUNT))));

		$this -> restore();
	}

	/*-------------------------------------------------------------------------
	* @function_name: KYCデータの取得
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function listKYC() {
		$this -> setKYCS($this -> accessSelect('SELECT_KYC_ADMIN', array($this -> getUserData(PARAM_USER_ACCOUNT))));
		$this -> restore();
	}


	/*-------------------------------------------------------------------------
	* @function_name: ユーザプロフィールの更新
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function updateProfile() {

		// 変数宣言部
		$rs			= null;
		$row		= null;
		$params		= null;
		$sendParams	= array();

		// メール送信用にデータを取得しておく
		$rs		= $this -> getAccountCommon($this -> getUserData(PARAM_USER_ACCOUNT));
		$row	= $this -> getRowData($rs);
		
		$params = $this -> getUpdateDataProfile();

		// データの登録
		$userUpdate = $this -> accessModify('UPDATE_USER_PROFILE', $params);
		
		if(!$userUpdate)
		    return;
		
		$this -> notifyChangesToSlack($row, $params);
		
		// 旧データの取得
		$sendParams[] = $params[NO_COUNT];															// 口座番号
		$sendParams[] = $this -> getColumnData($row, COLUMN_LAST_NAME)
						. DELIMIT_SPACE . $this -> getColumnData($row, COLUMN_FIRST_NAME);			// 氏名
		$sendParams[] = $this -> dispCountryCommon($params[VAL_INT_7]);								// 新国
		$sendParams[] = $params[VAL_INT_1];															// 新州・都道府県
		$sendParams[] = $params[VAL_INT_2];															// 新市区町村
		$sendParams[] = $params[VAL_INT_4];															// 新住所
		$sendParams[] = $params[VAL_INT_3];															// 新郵便番号
		$sendParams[] = $params[VAL_INT_6];															// 新電話番号
		$sendParams[] = $this -> getCurrentTimeCommon();											// 現在時刻
		$sendParams[] = $this -> dispCountryCommon($this -> getColumnData($row, COLUMN_COUNTRY));	// 旧国
		$sendParams[] = $this -> getColumnData($row, COLUMN_STATE);									// 州・都道府県
		$sendParams[] = $this -> getColumnData($row, COLUMN_CITY);									// 市区町村
		$sendParams[] = $this -> getColumnData($row, COLUMN_ADDRESS);								// 住所
		$sendParams[] = $this -> getColumnData($row, COLUMN_ZIP_CODE);								// 郵便番号
		$sendParams[] = $this -> getColumnData($row, COLUMN_TEL);									// 電話番号
        
		// CRM連携（更新）
		$this -> crmUpdateRecords($this -> getUpdateDataCRM());


		// メールの送信（ユーザ側）
		$this -> sendMailByTmp('change_profile_for_user.xml'
								, $sendParams
								, $this -> getColumnData($row, COLUMN_MAIL)
								, VAR_CS_MAIL_ADDRESS);

		// メールの送信（管理者側）
		$this -> sendMailByTmp('change_profile_for_admin.xml'
								, $sendParams
								, VAR_NOTICE_MAIL_ADDRESS
								, VAR_NOTICE_MAIL_ADDRESS);
	}

	private function notifyChangesToSlack($previous, $changes){
	    $changes = [
	        "Country" => [
	            "old" => $previous[PARAM_COUNTRY],
	            "new" => $changes[VAL_INT_7]
	        ],
	        "State" => [
	            "old" => $previous[PARAM_STATE],
	            "new" => $changes[VAL_INT_1]
	        ],
	        "City" => [
	            "old" => $previous[PARAM_CITY],
	            "new" => $changes[VAL_INT_2]
	        ],
	        "Address" => [
	            "old" => $previous[PARAM_ADDRESS],
	            "new" => $changes[VAL_INT_4]
	        ],
	        "Zip Code" => [
	            "old" => $previous[PARAM_ZIP_CODE],
	            "new" => $changes[VAL_INT_3]
	        ],
	        "Tel. No" => [
	            "old" => $previous[PARAM_TEL],
	            "new" => $changes[VAL_INT_6]
	        ]
	    ];
	    
	    $fullName = "{$previous[PARAM_FIRST_NAME]} {$previous[PARAM_LAST_NAME]}";
	    $updateDetails = "User-Profile Updated: ({$fullName} - {$previous[PARAM_USER_ACCOUNT]})\n\n";
	    
	    foreach($changes as $key => $change){
	        $indication = ($change["old"] == $change["new"] 
	            ? "Same" 
	            : "{$change["old"]} -> {$change["new"]}");
	        
	        $updateDetails .= "{$key}: {$indication}\n";
	    }
	    
	    $message = ["text" => $updateDetails];
	    
	    $slackChannels = $this -> getSettingConfiguration("slack_notif_channel");
	    
	    $handle = curl_init();
	    
	    curl_setopt_array($handle, [
	        CURLOPT_URL => $slackChannels -> user_details_channel,
	        CURLOPT_RETURNTRANSFER => true,
	        CURLOPT_FOLLOWLOCATION => true,
	        CURLOPT_ENCODING => "utf8",
	        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
	        CURLOPT_POSTFIELDS => json_encode($message),
	        CURLOPT_CUSTOMREQUEST => "POST",
	        CURLOPT_HTTPHEADER => [
	            "Content-type: application/json",
            ]
        ]);
	    
	    curl_exec($handle);
	    
	    if($err = curl_error($handle))
	        echo $err;
	    
	    curl_close($handle);
	}
	
	/*-------------------------------------------------------------------------
	* @function_name: ユーザプロフィール画像のアップロード
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function loadImageProfile() {

		// 変数宣言部
		$path = NO_STRING;

		$path = SYSTEM_DOCUMENT_PROFILE . $this -> getUserData(PARAM_USER_ACCOUNT);

		// 該当ディレクトリの確認
		if(!file_exists(SYSTEM_DOCUMENT_PROFILE . $this -> getUserData(PARAM_USER_ACCOUNT))) {
			mkdir($path, 0755);
		}

		// 画像の存在確認
		if(is_uploaded_file($_FILES[PARAM_PRO_IMG][PARAM_TMP_NAME])) {

			// 画像の移動
			if(move_uploaded_file($_FILES[PARAM_PRO_IMG][PARAM_TMP_NAME], $path . DELIMIT_SLASH . basename($_FILES[PARAM_PRO_IMG][PARAM_NAME]))) {}
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: KYC画像のアップロード（個人用）
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function loadImageKycPerson() {

		// 変数宣言部
		$path		= NO_STRING;
		$saveName	= NO_STRING;
		$flg		= false;
		$oldName	= NO_STRING;
		$imgFlg		= NO_STRING;
		$uploads	= array();

		$rs		= $this -> accessSelect('SELECT_USER_BY_ACCOUNT', array($this -> getUserData(PARAM_USER_ACCOUNT)));
		$row	= $this -> getRowData($rs);

		// KYCディレクトリの確認・対応
		if(!file_exists(SYSTEM_DOCUMENT_KYC)) {
			$this -> popUpSessionMessage(ERROR, 'E_NOT_FOUND_KYC_ROOT', array());
			return ;
		}

		// ルートディレクトリを取得する
		$path = $this -> getKycDirectory($this -> getUserData(PARAM_USER_ACCOUNT));

		// 該当ディレクトリの確認
		if(!file_exists($path)) {
			mkdir($path, 0777);
		} else {
			chmod($path, 0777);
		}


		// 画像1の存在確認
		if($this -> isUpload(PARAM_IMG1)) {

			// 保存ファイル名
			$info		= new SplFileInfo($_FILES[PARAM_IMG1][PARAM_NAME]);
			$saveName	= $this -> createUId() . DELIMIT_DOT . $info->getExtension();

			// 画像の移動
			if(move_uploaded_file($_FILES[PARAM_IMG1][PARAM_TMP_NAME], $path . DELIMIT_SLASH . $saveName)) {

				// アップロードファイル名
				$oldName	= basename($_FILES[PARAM_IMG1][PARAM_NAME]);
				$imgFlg		= $this -> getImg1Flg();

				// ファイルパーミッションの変更
				chmod($path . DELIMIT_SLASH . $saveName, 0777);

				// データの登録
				$this -> accessModify('INSERT_KYC', array($this -> getUserData(PARAM_USER_ACCOUNT)
															, $oldName
															, $saveName
															, $imgFlg
															, NO_COUNT
															, NO_COUNT
															, $this -> getColumnData($row, COLUMN_STATUS_UPDATE_COUNTER))
									, false);
				$flg = true;

				if($this -> getColumnData($uploads, $imgFlg) == NO_STRING) {
					$uploads[$imgFlg] = array($oldName);
				} else {
					$uploads[$imgFlg][] = $oldName;
				}
			}
		}

		// 画像2の存在確認
		if($this -> isUpload(PARAM_IMG2)) {

			// 保存ファイル名
			$info		= new SplFileInfo($_FILES[PARAM_IMG2][PARAM_NAME]);
			$saveName	= $this -> createUId() . DELIMIT_DOT . $info->getExtension();

			// 画像の移動
			if(move_uploaded_file($_FILES[PARAM_IMG2][PARAM_TMP_NAME], $path . DELIMIT_SLASH . $saveName)) {

				// アップロードファイル名
				$oldName	= basename($_FILES[PARAM_IMG2][PARAM_NAME]);
				$imgFlg		= $this -> getImg2Flg();

				// ファイルパーミッションの変更
				chmod($path . DELIMIT_SLASH . $saveName, 0777);

				// データの登録
				$this -> accessModify('INSERT_KYC', array($this -> getUserData(PARAM_USER_ACCOUNT)
															, $oldName
															, $saveName
															, $imgFlg
															, NO_COUNT
															, NO_COUNT
															, $this -> getColumnData($row, COLUMN_STATUS_UPDATE_COUNTER))
									, false);
				$flg = true;

				if($this -> getColumnData($uploads, $imgFlg) == NO_STRING) {
					$uploads[$imgFlg] = array($oldName);
				} else {
					$uploads[$imgFlg][] = $oldName;
				}
			}
		}

		// 画像3の存在確認
		if($this -> isUpload(PARAM_IMG3)) {

			// 保存ファイル名
			$info		= new SplFileInfo($_FILES[PARAM_IMG3][PARAM_NAME]);
			$saveName	= $this -> createUId() . DELIMIT_DOT . $info->getExtension();

			// 画像の移動
			if(move_uploaded_file($_FILES[PARAM_IMG3][PARAM_TMP_NAME], $path . DELIMIT_SLASH . $saveName)) {

				// アップロードファイル名
				$oldName	= basename($_FILES[PARAM_IMG3][PARAM_NAME]);
				$imgFlg		= $this -> getImg3Flg();

				// ファイルパーミッションの変更
				chmod($path . DELIMIT_SLASH . $saveName, 0777);

				// データの登録
				$this -> accessModify('INSERT_KYC', array($this -> getUserData(PARAM_USER_ACCOUNT)
															, $oldName
															, $saveName
															, $imgFlg
															, NO_COUNT
															, NO_COUNT
															, $this -> getColumnData($row, COLUMN_STATUS_UPDATE_COUNTER))
									, false);
				$flg = true;

				if($this -> getColumnData($uploads, $imgFlg) == NO_STRING) {
					$uploads[$imgFlg] = array($oldName);
				} else {
					$uploads[$imgFlg][] = $oldName;
				}
			}
		}

		// 画像4の存在確認
		if($this -> isUpload(PARAM_IMG4)) {

			// 保存ファイル名
			$info		= new SplFileInfo($_FILES[PARAM_IMG4][PARAM_NAME]);
			$saveName	= $this -> createUId() . DELIMIT_DOT . $info->getExtension();

			// 画像の移動
			if(move_uploaded_file($_FILES[PARAM_IMG4][PARAM_TMP_NAME], $path . DELIMIT_SLASH . $saveName)) {

				// アップロードファイル名
				$oldName	= basename($_FILES[PARAM_IMG4][PARAM_NAME]);
				$imgFlg		= $this -> getImg4Flg();

				// ファイルパーミッションの変更
				chmod($path . DELIMIT_SLASH . $saveName, 0777);

				// データの登録
				$this -> accessModify('INSERT_KYC', array($this -> getUserData(PARAM_USER_ACCOUNT)
															, $oldName
															, $saveName
															, $imgFlg
															, NO_COUNT
															, NO_COUNT
															, $this -> getColumnData($row, COLUMN_STATUS_UPDATE_COUNTER))
									, false);
				$flg = true;

				if($this -> getColumnData($uploads, $imgFlg) == NO_STRING) {
					$uploads[$imgFlg] = array($oldName);
				} else {
					$uploads[$imgFlg][] = $oldName;
				}
			}
		}

		// 画像5の存在確認
		if($this -> isUpload(PARAM_IMG5)) {

			// 保存ファイル名
			$info		= new SplFileInfo($_FILES[PARAM_IMG5][PARAM_NAME]);
			$saveName	= $this -> createUId() . DELIMIT_DOT . $info->getExtension();

			// 画像の移動
			if(move_uploaded_file($_FILES[PARAM_IMG5][PARAM_TMP_NAME], $path . DELIMIT_SLASH . $saveName)) {

				// アップロードファイル名
				$oldName	= basename($_FILES[PARAM_IMG5][PARAM_NAME]);
				$imgFlg		= $this -> getImg5Flg();

				// ファイルパーミッションの変更
				chmod($path . DELIMIT_SLASH . $saveName, 0777);

				// データの登録
				$this -> accessModify('INSERT_KYC', array($this -> getUserData(PARAM_USER_ACCOUNT)
															, $oldName
															, $saveName
															, $imgFlg
															, NO_COUNT
															, NO_COUNT
															, $this -> getColumnData($row, COLUMN_STATUS_UPDATE_COUNTER))
									, false);
				$flg = true;

				if($this -> getColumnData($uploads, $imgFlg) == NO_STRING) {
					$uploads[$imgFlg] = array($oldName);
				} else {
					$uploads[$imgFlg][] = $oldName;
				}
			}
		}

		// 画像6の存在確認
		if($this -> isUpload(PARAM_IMG6)) {

			// 保存ファイル名
			$info		= new SplFileInfo($_FILES[PARAM_IMG6][PARAM_NAME]);
			$saveName	= $this -> createUId() . DELIMIT_DOT . $info->getExtension();

			// 画像の移動
			if(move_uploaded_file($_FILES[PARAM_IMG6][PARAM_TMP_NAME], $path . DELIMIT_SLASH . $saveName)) {

				// アップロードファイル名
				$oldName	= basename($_FILES[PARAM_IMG6][PARAM_NAME]);
				$imgFlg		= $this -> getImg6Flg();

				// ファイルパーミッションの変更
				chmod($path . DELIMIT_SLASH . $saveName, 0777);

				// データの登録
				$this -> accessModify('INSERT_KYC', array($this -> getUserData(PARAM_USER_ACCOUNT)
															, $oldName
															, $saveName
															, $imgFlg
															, NO_COUNT
															, NO_COUNT
															, $this -> getColumnData($row, COLUMN_STATUS_UPDATE_COUNTER))
									, false);
				$flg = true;

				if($this -> getColumnData($uploads, $imgFlg) == NO_STRING) {
					$uploads[$imgFlg] = array($oldName);
				} else {
					$uploads[$imgFlg][] = $oldName;
				}
			}
		}

		// アップロードファイルが存在したらメールを送信する
		if($this -> isLoopData($uploads)) {

			// 送信用パラメータの作成
			$imgs		= array();
			$params		= array();
			$params[]	= $this -> getUserData(PARAM_USER_ACCOUNT);
			$params[]	= $this -> getCurrentTimeCommon();
			$dest		= NO_STRING;

			// アップロードファイルのリスト化
			foreach($uploads as $key => $val) {

				$str	= $this -> dispIdentityTypeCommon($key);
				$imgs	= array();

				foreach($val as $val) {
					$imgs[] = $val;
				}

				$dest .=	"\n" . $str . DELIMIT_COLON . DELIMIT_SPACE
						 	. implode(DELIMIT_COMMA . DELIMIT_SPACE, $imgs);
			}

			$params[]	= $dest;

			// メールの送信（管理者側）
			$this -> sendMailByTmp('kyc_upload_for_admin.xml'
									, $params
									, VAR_NOTICE_MAIL_ADDRESS
									, VAR_NOTICE_MAIL_ADDRESS);
		}

		// アップロードが完了したら一旦認証フラグを落とす
		if($flg) {
			$this -> accessModify('UPDATE_KYC_FLG', array($this -> getUserData(PARAM_USER_ACCOUNT), NO_COUNT), false);
		}
		
		// syncing to bucket
		AWSMangos3Bucket::getInstance()->uploadDirectory($path);
	}

	/*-------------------------------------------------------------------------
	 * @function_name: KYC画像のアップロード（法人用）
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function loadImageKycCorp() {

		// 変数宣言部
		$path		= NO_STRING;
		$saveName	= NO_STRING;
		$flg		= false;
		$oldName	= NO_STRING;
		$uploads	= array();

		$path = $this -> getKycDirectory($this -> getUserData(PARAM_USER_ACCOUNT));

		// 該当ディレクトリの確認
		if(!file_exists($path)) {
			mkdir($path, 0777);
		} else {
			chmod($path, 0777);
		}

		// 画像1の存在確認
		if($this -> isUpload(PARAM_IMG1)) {

			// 保存ファイル名
			$info		= new SplFileInfo($_FILES[PARAM_IMG1][PARAM_NAME]);
			$saveName	= $this -> createUId() . DELIMIT_DOT . $info->getExtension();

			// 画像の移動
			if(move_uploaded_file($_FILES[PARAM_IMG1][PARAM_TMP_NAME], $path . DELIMIT_SLASH . $saveName)) {

				// アップロードファイル名
				$oldName	= basename($_FILES[PARAM_IMG1][PARAM_NAME]);
				$imgFlg		= $this -> getImg1Flg();

				// ファイルパーミッションの変更
				chmod($path . DELIMIT_SLASH . $saveName, 0777);

				// データの登録
				$this -> accessModify('INSERT_KYC', array($this -> getUserData(PARAM_USER_ACCOUNT)
															, $oldName
															, $saveName
															, $imgFlg
															, NO_COUNT
															, NO_COUNT
															, NO_COUNT)
									, false);
				$flg = true;

				if($this -> getColumnData($uploads, NO_COUNT) == NO_STRING) {
					$uploads[NO_COUNT] = array($oldName);
				} else {
					$uploads[NO_COUNT][] = $oldName;
				}
			}
		}

		// 画像2の存在確認
		if($this -> isUpload(PARAM_IMG2)) {

			// 保存ファイル名
			$info		= new SplFileInfo($_FILES[PARAM_IMG2][PARAM_NAME]);
			$saveName	= $this -> createUId() . DELIMIT_DOT . $info->getExtension();

			// 画像の移動
			if(move_uploaded_file($_FILES[PARAM_IMG2][PARAM_TMP_NAME], $path . DELIMIT_SLASH . $saveName)) {

				// アップロードファイル名
				$oldName	= basename($_FILES[PARAM_IMG2][PARAM_NAME]);
				$imgFlg		= $this -> getImg2Flg();

				// ファイルパーミッションの変更
				chmod($path . DELIMIT_SLASH . $saveName, 0777);

				// データの登録
				$this -> accessModify('INSERT_KYC', array($this -> getUserData(PARAM_USER_ACCOUNT)
															, $oldName
															, $saveName
															, $imgFlg
															, NO_COUNT
															, NO_COUNT
															, NO_COUNT)
									, false);
				$flg = true;

				if($this -> getColumnData($uploads, NO_COUNT) == NO_STRING) {
					$uploads[NO_COUNT] = array($oldName);
				} else {
					$uploads[NO_COUNT][] = $oldName;
				}
			}
		}

		// 画像3の存在確認
		if($this -> isUpload(PARAM_IMG3)) {

			// 保存ファイル名
			$info		= new SplFileInfo($_FILES[PARAM_IMG3][PARAM_NAME]);
			$saveName	= $this -> createUId() . DELIMIT_DOT . $info->getExtension();

			// 画像の移動
			if(move_uploaded_file($_FILES[PARAM_IMG3][PARAM_TMP_NAME], $path . DELIMIT_SLASH . $saveName)) {

				// アップロードファイル名
				$oldName	= basename($_FILES[PARAM_IMG3][PARAM_NAME]);
				$imgFlg		= $this -> getImg3Flg();

				// ファイルパーミッションの変更
				chmod($path . DELIMIT_SLASH . $saveName, 0777);

				// データの登録
				$this -> accessModify('INSERT_KYC', array($this -> getUserData(PARAM_USER_ACCOUNT)
															, $oldName
															, $saveName
															, $imgFlg
															, NO_COUNT
															, NO_COUNT
															, NO_COUNT)
									, false);
				$flg = true;

				if($this -> getColumnData($uploads, NO_COUNT) == NO_STRING) {
					$uploads[NO_COUNT] = array($oldName);
				} else {
					$uploads[NO_COUNT][] = $oldName;
				}
			}
		}

		// 画像4の存在確認
		if($this -> isUpload(PARAM_IMG4)) {

			// 保存ファイル名
			$info		= new SplFileInfo($_FILES[PARAM_IMG4][PARAM_NAME]);
			$saveName	= $this -> createUId() . DELIMIT_DOT . $info->getExtension();

			// 画像の移動
			if(move_uploaded_file($_FILES[PARAM_IMG4][PARAM_TMP_NAME], $path . DELIMIT_SLASH . $saveName)) {

				// アップロードファイル名
				$oldName	= basename($_FILES[PARAM_IMG4][PARAM_NAME]);
				$imgFlg		= $this -> getImg4Flg();

				// ファイルパーミッションの変更
				chmod($path . DELIMIT_SLASH . $saveName, 0777);

				// データの登録
				$this -> accessModify('INSERT_KYC', array($this -> getUserData(PARAM_USER_ACCOUNT)
															, $oldName
															, $saveName
															, $imgFlg
															, NO_COUNT
															, NO_COUNT
															, NO_COUNT)
									, false);
				$flg = true;

				if($this -> getColumnData($uploads, VAL_INT_1) == NO_STRING) {
					$uploads[VAL_INT_1] = array($oldName);
				} else {
					$uploads[VAL_INT_1][] = $oldName;
				}
			}
		}

		// 画像5の存在確認
		if($this -> isUpload(PARAM_IMG5)) {

			// 保存ファイル名
			$info		= new SplFileInfo($_FILES[PARAM_IMG5][PARAM_NAME]);
			$saveName	= $this -> createUId() . DELIMIT_DOT . $info->getExtension();

			// 画像の移動
			if(move_uploaded_file($_FILES[PARAM_IMG5][PARAM_TMP_NAME], $path . DELIMIT_SLASH . $saveName)) {

				// アップロードファイル名
				$oldName	= basename($_FILES[PARAM_IMG5][PARAM_NAME]);
				$imgFlg		= $this -> getImg5Flg();

				// ファイルパーミッションの変更
				chmod($path . DELIMIT_SLASH . $saveName, 0777);

				// データの登録
				$this -> accessModify('INSERT_KYC', array($this -> getUserData(PARAM_USER_ACCOUNT)
															, $oldName
															, $saveName
															, $imgFlg
															, NO_COUNT
															, NO_COUNT
															, NO_COUNT)
									, false);
				$flg = true;

				if($this -> getColumnData($uploads, VAL_INT_1) == NO_STRING) {
					$uploads[VAL_INT_1] = array($oldName);
				} else {
					$uploads[VAL_INT_1][] = $oldName;
				}
			}
		}

		// 画像6の存在確認
		if($this -> isUpload(PARAM_IMG6)) {

			// 保存ファイル名
			$info		= new SplFileInfo($_FILES[PARAM_IMG6][PARAM_NAME]);
			$saveName	= $this -> createUId() . DELIMIT_DOT . $info->getExtension();

			// 画像の移動
			if(move_uploaded_file($_FILES[PARAM_IMG6][PARAM_TMP_NAME], $path . DELIMIT_SLASH . $saveName)) {

				// アップロードファイル名
				$oldName	= basename($_FILES[PARAM_IMG6][PARAM_NAME]);
				$imgFlg		= $this -> getImg6Flg();

				// ファイルパーミッションの変更
				chmod($path . DELIMIT_SLASH . $saveName, 0777);

				// データの登録
				$this -> accessModify('INSERT_KYC', array($this -> getUserData(PARAM_USER_ACCOUNT)
															, $oldName
															, $saveName
															, $imgFlg
															, NO_COUNT
															, NO_COUNT
															, NO_COUNT)
									, false);
				$flg = true;

				if($this -> getColumnData($uploads, VAL_INT_1) == NO_STRING) {
					$uploads[VAL_INT_1] = array($oldName);
				} else {
					$uploads[VAL_INT_1][] = $oldName;
				}
			}
		}

		// 画像7の存在確認
		if($this -> isUpload(PARAM_IMG7)) {

			// 保存ファイル名
			$info		= new SplFileInfo($_FILES[PARAM_IMG7][PARAM_NAME]);
			$saveName	= $this -> createUId() . DELIMIT_DOT . $info->getExtension();

			// 画像の移動
			if(move_uploaded_file($_FILES[PARAM_IMG7][PARAM_TMP_NAME], $path . DELIMIT_SLASH . $saveName)) {

				// アップロードファイル名
				$oldName	= basename($_FILES[PARAM_IMG7][PARAM_NAME]);
				$imgFlg		= $this -> getImg7Flg();

				// ファイルパーミッションの変更
				chmod($path . DELIMIT_SLASH . $saveName, 0777);

				// データの登録
				$this -> accessModify('INSERT_KYC', array($this -> getUserData(PARAM_USER_ACCOUNT)
															, $oldName
															, $saveName
															, $imgFlg
															, NO_COUNT
															, NO_COUNT
															, NO_COUNT)
									, false);
				$flg = true;

				if($this -> getColumnData($uploads, VAL_INT_2) == NO_STRING) {
					$uploads[VAL_INT_2] = array($oldName);
				} else {
					$uploads[VAL_INT_2][] = $oldName;
				}
			}
		}

		// 画像8の存在確認
		if($this -> isUpload(PARAM_IMG8)) {

			// 保存ファイル名
			$info		= new SplFileInfo($_FILES[PARAM_IMG8][PARAM_NAME]);
			$saveName	= $this -> createUId() . DELIMIT_DOT . $info->getExtension();

			// 画像の移動
			if(move_uploaded_file($_FILES[PARAM_IMG8][PARAM_TMP_NAME], $path . DELIMIT_SLASH . $saveName)) {

				// アップロードファイル名
				$oldName	= basename($_FILES[PARAM_IMG8][PARAM_NAME]);
				$imgFlg		= $this -> getImg8Flg();

				// ファイルパーミッションの変更
				chmod($path . DELIMIT_SLASH . $saveName, 0777);

				// データの登録
				$this -> accessModify('INSERT_KYC', array($this -> getUserData(PARAM_USER_ACCOUNT)
															, $oldName
															, $saveName
															, $imgFlg
															, NO_COUNT
															, NO_COUNT
															, NO_COUNT)
									, false);
				$flg = true;

				if($this -> getColumnData($uploads, VAL_INT_3) == NO_STRING) {
					$uploads[VAL_INT_3] = array($oldName);
				} else {
					$uploads[VAL_INT_3][] = $oldName;
				}
			}
		}

		// 画像9の存在確認
		if($this -> isUpload(PARAM_IMG9)) {

			// 保存ファイル名
			$info		= new SplFileInfo($_FILES[PARAM_IMG9][PARAM_NAME]);
			$saveName	= $this -> createUId() . DELIMIT_DOT . $info->getExtension();

			// 画像の移動
			if(move_uploaded_file($_FILES[PARAM_IMG9][PARAM_TMP_NAME], $path . DELIMIT_SLASH . $saveName)) {

				// アップロードファイル名
				$oldName	= basename($_FILES[PARAM_IMG9][PARAM_NAME]);
				$imgFlg		= $this -> getImg9Flg();

				// ファイルパーミッションの変更
				chmod($path . DELIMIT_SLASH . $saveName, 0777);

				// データの登録
				$this -> accessModify('INSERT_KYC', array($this -> getUserData(PARAM_USER_ACCOUNT)
															, $oldName
															, $saveName
															, $imgFlg
															, NO_COUNT
															, NO_COUNT
															, NO_COUNT)
									, false);
				$flg = true;

				if($this -> getColumnData($uploads, VAL_INT_4) == NO_STRING) {
					$uploads[VAL_INT_4] = array($oldName);
				} else {
					$uploads[VAL_INT_4][] = $oldName;
				}
			}
		}

		// 画像10の存在確認
		if($this -> isUpload(PARAM_IMG10)) {

			// 保存ファイル名
			$info		= new SplFileInfo($_FILES[PARAM_IMG10][PARAM_NAME]);
			$saveName	= $this -> createUId() . DELIMIT_DOT . $info->getExtension();

			// 画像の移動
			if(move_uploaded_file($_FILES[PARAM_IMG10][PARAM_TMP_NAME], $path . DELIMIT_SLASH . $saveName)) {

				// アップロードファイル名
				$oldName	= basename($_FILES[PARAM_IMG10][PARAM_NAME]);
				$imgFlg		= $this -> getImg10Flg();

				// ファイルパーミッションの変更
				chmod($path . DELIMIT_SLASH . $saveName, 0777);

				// データの登録
				$this -> accessModify('INSERT_KYC', array($this -> getUserData(PARAM_USER_ACCOUNT)
															, $oldName
															, $saveName
															, $imgFlg
															, NO_COUNT
															, NO_COUNT
															, NO_COUNT)
									, false);

				$flg = true;

				if($this -> getColumnData($uploads, VAL_INT_5) == NO_STRING) {
					$uploads[VAL_INT_5] = array($oldName);
				} else {
					$uploads[VAL_INT_5][] = $oldName;
				}
			}
		}

		// 画像11の存在確認
		if($this -> isUpload(PARAM_IMG11)) {

			// 保存ファイル名
			$info		= new SplFileInfo($_FILES[PARAM_IMG11][PARAM_NAME]);
			$saveName	= $this -> createUId() . DELIMIT_DOT . $info->getExtension();

			// 画像の移動
			if(move_uploaded_file($_FILES[PARAM_IMG11][PARAM_TMP_NAME], $path . DELIMIT_SLASH . $saveName)) {

				// アップロードファイル名
				$oldName	= basename($_FILES[PARAM_IMG11][PARAM_NAME]);
				$imgFlg		= $this -> getImg11Flg();

				// ファイルパーミッションの変更
				chmod($path . DELIMIT_SLASH . $saveName, 0777);

				// データの登録
				$this -> accessModify('INSERT_KYC', array($this -> getUserData(PARAM_USER_ACCOUNT)
															, $oldName
															, $saveName
															, $imgFlg
															, NO_COUNT
															, NO_COUNT
															, NO_COUNT)
									, false);
				$flg = true;

				if($this -> getColumnData($uploads, VAL_INT_6) == NO_STRING) {
					$uploads[VAL_INT_6] = array($oldName);
				} else {
					$uploads[VAL_INT_6][] = $oldName;
				}
			}
		}

		// アップロードが完了したら一旦認証フラグを落とす
		if($flg) {
			$this -> accessModify('UPDATE_KYC_FLG', array($this -> getUserData(PARAM_USER_ACCOUNT), NO_COUNT), false);
		}

		// アップロードファイルが存在したらメールを送信する
		if($this -> isLoopData($uploads)) {

			// 送信用パラメータの作成
			$imgs		= array();
			$params		= array();
			$params[]	= $this -> getUserData(PARAM_USER_ACCOUNT);
			$params[]	= $this -> getCurrentTimeCommon();
			$dest		= NO_STRING;

			// アップロードファイルのリスト化
			foreach($uploads as $key => $val) {

				$str	= $this -> dispIdentityTypeCommon($key);
				$imgs	= array();

				foreach($val as $val) {
					$imgs[] = $val;
				}

				$dest .=	"\n" . $str . DELIMIT_COLON . DELIMIT_SPACE
						 	. implode(DELIMIT_COMMA . DELIMIT_SPACE, $imgs);
			}

			$params[]	= $dest;

			// メールの送信（管理者側）
			$this -> sendMailByTmp('kyc_upload_for_admin.xml'
									, $params
									, VAR_NOTICE_MAIL_ADDRESS
									, VAR_NOTICE_MAIL_ADDRESS);
			
			// syncing to bucket
			AWSMangos3Bucket::getInstance()->uploadDirectory($path);
		}
	}


	/*-------------------------------------------------------------------------
	* @function_name: パスワードの更新
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function updatePassword() {
		if($this -> accessModify('UPDATE_USER_PASSWORD', $this -> getUpdateDataPassword())) {
			$this -> sendPasswordComplete();
		}
	}

	/*-------------------------------------------------------------------------
	* @function_name: パスワードの更新
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function updateKycValidateStatus() {
		$date = date("Y-m-d H:i:s");
		$this -> accessModifyCommon('UPDATE_USER_VALIDATE_STATUS', array( $date,$this->getUserData(PARAM_USER_ACCOUNT) ));
	}


	/*-------------------------------------------------------------------------
	* @function_name: メールアドレス変更メール送信
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function send() {

		// 変数宣言部
		$params = array();

		// メール送信用のパラメータ設定
		$params[] = $this -> createUId();												// 設定ID
		$params[] = $this -> getUserData(PARAM_USER_ACCOUNT);							// 口座番号
		$params[] = $this -> getMail();													// 変更後メールアドレス
		$params[] = $this -> getNameCommon($this -> getUserData(PARAM_USER_ACCOUNT));	// お客様名
		$params[] = $this -> getEMailCommon($this -> getUserData(PARAM_USER_ACCOUNT));	// お客様メールアドレス
		$params[] = $this -> getLastName() . DELIMIT_SPACE . $this -> getFirstName();	// 氏名

		// 変更前メールアドレスへ送信（変更前）
// 		$this -> sendMailById('change_mail_confirm.xml', $params, $this -> getUserData(PARAM_USER_ACCOUNT));

		// 変更前メールアドレスへ送信（変更後）
		$this -> sendMailByTmp('change_mail_confirm.xml'
								, $params
								, $this -> getMail()
								, VAR_CS_MAIL_ADDRESS);

		$this -> accessModify('INSERT_CHANGE_MAIL', $params, false);
	}

	/*-------------------------------------------------------------------------
	* @function_name: パスワード変更メール送信
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function sendPasswordComplete() {

		// 変数宣言部
		$params = array();

		// メール送信用のパラメータ設定
		$params[] = $this -> getUserData(PARAM_USER_ACCOUNT);							// 口座番号
		$params[] = $this -> getNameCommon($this -> getUserData(PARAM_USER_ACCOUNT));	// お客様名

		// パスワード変更完了メール（ユーザ側）
		$this -> sendMailById('change_password_complete.xml'
								, $params
								, $this -> getUserData(PARAM_USER_ACCOUNT)
								, VAR_CS_MAIL_ADDRESS);
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座種別を設定する
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function setAccountType() {

		// 変数宣言部
		$rs		= null;
		$row	= null;

		$rs		= $this -> accessSelect('SELECT_USER_BY_ACCOUNT', array($this -> getUserData(PARAM_USER_ACCOUNT)));
		$row	= $this -> getRowData($rs);
		$this -> accountType = intval($this -> getColumnData($row, COLUMN_ACCOUNT_TYPE));

	}

	/*-------------------------------------------------------------------------
	* @function_name: ダウンロード処理
	* @parameter	: なし
	* @return		: なし
	-------------------------------------------------------------------------*/
	private function download() {

		// 変数宣言部
		$rs		= null;
		$row	= null;

		// データの取得
		$rs		= $this -> accessSelect('SELECT_KYC_BY_K_ID', array($this -> getKId()));
		$row	= $this -> getRowData($rs);

		// 旧ファイル名の設定
		$this -> setOldFileName($this -> getColumnData($row, COLUMN_OLD_FILENAME));
		$this -> setPath(SYSTEM_DOCUMENT_KYC . $this -> getUserData(PARAM_USER_ACCOUNT) . DELIMIT_SLASH . $this -> getColumnData($row, COLUMN_SAVE_FILENAME));
	}

	/*-------------------------------------------------------------------------
	* @function_name: 口座種別を取得する
	* @parameter	: なし
	* @return		: 口座種別
	-------------------------------------------------------------------------*/
	function getAccountType() {
		return $this -> accountType;
	}

	/*-------------------------------------------------------------------------
	* @function_name: ページ出力文字列取得関数
	* @parameter	: なし
	* @return		: HTML文字列
	-------------------------------------------------------------------------*/
	function getDisplay() {
		return $this -> htmlStr;
	}

	/*-------------------------------------------------------------------------
	* @function_name: updateTransferFlg
	* @parameter	: 
	* @return		: 
	-------------------------------------------------------------------------*/
	function updateTransferFlg() {
		$this -> accessModify('UPDATE_USER_TRANSFER_FLG', $this -> getUpdateTransferFlg());
	}
}
?>